import os

if __name__ == '__main__':
    for community in range(8, 9):
        model_name = ['gpt2', 'llama'][0]
        mp = 1
        gpu = '0'
        mem = {'gpt2': '16GB', 'llama': '64GB'}[model_name]
        gpu_type = {'gpt2': 'v100', 'llama': 'a40'}[model_name]
        time = '4:00:00'
        n_workers = 8

        command = f'python evaluator.py ' \
                  f'--model_name={model_name} ' \
                  f'--community={community} ' \
                  f'--mp={mp} ' \
                  f'--gpu={gpu} ' \
                  f'--n_workers={n_workers}'
        print(command)
        # os.system(command)

        n_gpus = len(gpu.split(','))
        script = f"""#!/bin/bash
#SBATCH --partition=gpu
#SBATCH --cpus-per-task={n_workers}
#SBATCH --gres=gpu:{gpu_type}:{n_gpus}
#SBATCH --mem={mem}
#SBATCH --time={time}

{command}
                """
        with open(f'run_slurm_eval.sh', 'w') as f:
            f.write(script)
        print()
        print('This is the script.')
        print(script)
        os.system(f'sbatch run_slurm_eval.sh')