import numpy as np
import ipdb

def sample_noise(shape, scale, size, n):
    # args: shape of distribution, scale of distribution
    gamma = np.random.gamma(shape, scale=scale, size=None)
    samples = sample_hypersphere(size, n)
    #ipdb.set_trace()    
    return gamma * samples

def sample_hypersphere(size, n):
    """
    args:
        size: number of samples to draw
        n: dimension
    """
    # https://stackoverflow.com/questions/5408276/sampling-uniformly-distributed-random-points-inside-a-spherical-volume/23785326
    x = np.random.normal(size=(size, n)) 
    x /= np.linalg.norm(x, axis=1)[:, np.newaxis]
    return x


#sample_noise(768, 1/175.0, 4, 768)
