DISCODOP_VENV ?= venv/bin/activate
SUPERTAGGER_PATH ?= ../Supertagging
SUPERTAGGER_VENV ?= $(SUPERTAGGER_PATH)/venv/bin/activate

#SUPERTAGGER_PATH ?= ../supertagger
#SUPERTAGGER_VENV ?= $(DISCODOP_VENV)

# TODO check that they are set
RES_PATH ?= negra-h0
EXPERIMENT ?= $(RES_PATH)-dev

TRAINCORPUS ?= $(RES_PATH)/traincorpus
TESTCORPUS ?= $(RES_PATH)/testcorpus
DEVCORPUS ?= $(RES_PATH)/devcorpus

EVALCORPUS != [ -f $(DEVCORPUS) ] && echo $(DEVCORPUS) || echo $(TESTCORPUS)

$(EXPERIMENT)/%.eval: $(EVALCORPUS) $(EXPERIMENT)/%.parsed
	. $(DISCODOP_VENV) && discodop eval $^ proper.prm > $@

$(EXPERIMENT)/%.parsed: $(EXPERIMENT)/%.supertags $(TRAINCORPUS).pickle $(EVALCORPUS).sent
	. $(DISCODOP_VENV) && discodop superparse --stats $(TRAINCORPUS).pickle $(EVALCORPUS).sent $(EXPERIMENT)/$*.{pos,preterms,supertags,supertags.prob} -k $* > $@

%.pickle %.sent: %
	. $(DISCODOP_VENV) && discodop lexcorpus $< $<

%.sents: %.sent
	cp $< $@

$(EXPERIMENT)/%.supertags: $(EVALCORPUS).sents
	. $(SUPERTAGGER_VENV) && python $(SUPERTAGGER_PATH)/Python/lex_test.py $(EVALCORPUS) $(RES_PATH)/dict true $* 1 1 [] $(EXPERIMENT)/$* $(RES_PATH)/outputs/
	#. $(SUPERTAGGER_VENV) && python $(SUPERTAGGER_PATH)/test.py --traincorpus $(TRAINCORPUS).pickle --testcorpus $(EVALCORPUS).pickle --outfilename $(EXPERIMENT)/$* -k $* $(RES_PATH)/supertagger-config
	#. $(SUPERTAGGER_VENV) && python $(SUPERTAGGER_PATH)/test.py --outfilename $(EXPERIMENT)/$* -k $* $(RES_PATH)/supertagger-config

.SECONDARY:
