/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ScrollPaneLayout;
import org.apache.batik.swing.JSVGCanvas;

public class PostEditor {
    private final String postEditedPath;
    private final JFrame svgFrame;
    private final JFrame parallelSentenceFrame;
    private final List<TranslatedDocument> translatedDocuments;
    private final JSVGCanvas svgCanvas;
    private Integer sentenceNumber = 0;
    private Integer documentNumber;
    private final JMenuBar menuBar;
    private final JMenu fileMenu;
    private final JMenuItem nextDocument;
    private final JMenuItem previousDocument;
    private final JMenuItem saveDocument;
    private final JMenuItem gotoDocument;
    private final JMenuItem displayParse;
    private final JPanel parallelSentencesPanel;

    public PostEditor(String postEditedPath, String sourcePath, String targetPath, String alignmentsPath, String svgListPath, int startingDocumentNumber) throws FileNotFoundException {
        this.translatedDocuments = TranslatedDocument.collateTranslatedDocuments(postEditedPath, sourcePath, targetPath, alignmentsPath, svgListPath);
        this.postEditedPath = postEditedPath;
        this.documentNumber = startingDocumentNumber - 1;
        this.svgFrame = new JFrame("Dependency Parse");
        this.parallelSentenceFrame = new JFrame("Aligned Translations");
        this.parallelSentenceFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                PostEditor.this.saveDocument();
                System.exit(0);
            }

            @Override
            public void windowClosed(WindowEvent arg0) {
                PostEditor.this.saveDocument();
                System.exit(0);
            }
        });
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.saveDocument = new JMenuItem("Save");
        this.nextDocument = new JMenuItem("Next Document");
        this.previousDocument = new JMenuItem("Previous Document");
        this.gotoDocument = new JMenuItem("Go to Document...");
        this.displayParse = new JMenuItem("Display Parse");
        this.nextDocument.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.previousDocument.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.saveDocument.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.gotoDocument.setAccelerator(KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.displayParse.setAccelerator(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.fileMenu.add(this.nextDocument);
        this.fileMenu.add(this.previousDocument);
        this.fileMenu.add(this.saveDocument);
        this.fileMenu.add(this.gotoDocument);
        this.fileMenu.add(this.displayParse);
        this.menuBar.add(this.fileMenu);
        ActionListener menuListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                block16: {
                    Object eventSource = event.getSource();
                    if (eventSource == PostEditor.this.nextDocument) {
                        if (PostEditor.this.documentNumber + 1 < PostEditor.this.translatedDocuments.size()) {
                            PostEditor postEditor = PostEditor.this;
                            postEditor.documentNumber = postEditor.documentNumber + 1;
                            PostEditor.this.sentenceNumber = 0;
                            PostEditor.this.updateDocument(true);
                            PostEditor.this.updateSentence();
                        }
                    } else if (eventSource == PostEditor.this.previousDocument) {
                        if (PostEditor.this.documentNumber >= 1) {
                            PostEditor postEditor = PostEditor.this;
                            postEditor.documentNumber = postEditor.documentNumber - 1;
                            PostEditor.this.sentenceNumber = ((TranslatedDocument)PostEditor.this.translatedDocuments.get(PostEditor.this.documentNumber)).size() - 1;
                            PostEditor.this.updateDocument(true);
                            PostEditor.this.updateSentence();
                        }
                    } else if (eventSource == PostEditor.this.saveDocument) {
                        boolean success = PostEditor.this.saveDocument();
                        if (success) {
                            JOptionPane.showMessageDialog(PostEditor.this.parallelSentenceFrame, "Save complete!");
                        } else {
                            JOptionPane.showMessageDialog(PostEditor.this.parallelSentenceFrame, "A problem occurred while saving", "Error saving", 0);
                        }
                    } else if (eventSource == PostEditor.this.gotoDocument) {
                        String value = JOptionPane.showInputDialog("Enter document number:");
                        try {
                            int i = Integer.valueOf(value) - 1;
                            if (i >= 0 && i < PostEditor.this.translatedDocuments.size()) {
                                PostEditor.this.documentNumber = Integer.valueOf(value) - 1;
                                PostEditor.this.updateDocument(true);
                                break block16;
                            }
                            JOptionPane.showMessageDialog(PostEditor.this.parallelSentenceFrame, "\"" + value + "\" is not a valid document number.\nValid numbers are [1-" + PostEditor.this.translatedDocuments.size() + "]", "Invalid number", 0);
                        }
                        catch (NumberFormatException e) {
                            JOptionPane.showMessageDialog(PostEditor.this.parallelSentenceFrame, "\"" + value + "\" is not a valid document number.\nValid numbers are [1-" + PostEditor.this.translatedDocuments.size() + "]", "Invalid number", 0);
                        }
                    } else if (eventSource == PostEditor.this.displayParse) {
                        PostEditor.this.svgCanvas.setURI(PostEditor.this.getSVGPath());
                        PostEditor.this.svgFrame.pack();
                        Dimension svgFrameDimension = PostEditor.this.svgFrame.getPreferredSize();
                        svgFrameDimension.height *= 2;
                        PostEditor.this.svgFrame.setExtendedState(PostEditor.this.svgFrame.getExtendedState() | 6);
                        svgFrameDimension.width = ((PostEditor)PostEditor.this).svgFrame.getSize().width;
                        PostEditor.this.svgFrame.setSize(svgFrameDimension);
                        PostEditor.this.svgFrame.setVisible(true);
                    }
                }
            }
        };
        this.nextDocument.addActionListener(menuListener);
        this.previousDocument.addActionListener(menuListener);
        this.saveDocument.addActionListener(menuListener);
        this.gotoDocument.addActionListener(menuListener);
        this.displayParse.addActionListener(menuListener);
        this.parallelSentenceFrame.setJMenuBar(this.menuBar);
        this.svgCanvas = new JSVGCanvas();
        this.svgFrame.getContentPane().add(this.svgCanvas);
        this.parallelSentencesPanel = new ParallelSentencesPanel();
        this.parallelSentencesPanel.setLayout(new BoxLayout(this.parallelSentencesPanel, 3));
        JScrollPane parallelSentencesScrollPane = new JScrollPane(this.parallelSentencesPanel, 20, 30);
        parallelSentencesScrollPane.setLayout(new ScrollPaneLayout(){

            @Override
            public void layoutContainer(Container parent) {
                super.layoutContainer(parent);
                Component view = this.viewport.getView();
                if (view != null) {
                    Dimension viewPortSize = this.viewport.getSize();
                    Dimension viewSize = view.getSize();
                    if (viewPortSize.width > viewSize.width || viewPortSize.height > viewSize.height) {
                        int spaceX = (viewPortSize.width - viewSize.width) / 2;
                        if (spaceX < 0) {
                            spaceX = 0;
                        }
                        this.viewport.setLocation(spaceX, 1);
                        this.viewport.setSize(viewPortSize.width - spaceX, viewPortSize.height);
                    }
                }
            }
        });
        parallelSentencesScrollPane.getViewport().setBackground(this.parallelSentencesPanel.getBackground());
        parallelSentencesScrollPane.setBackground(this.parallelSentencesPanel.getBackground());
        this.parallelSentenceFrame.setContentPane(parallelSentencesScrollPane);
        this.parallelSentenceFrame.pack();
        this.parallelSentenceFrame.setExtendedState(this.parallelSentenceFrame.getExtendedState() | 6);
        this.parallelSentenceFrame.setVisible(true);
        this.updateDocument(false);
        this.updateSentence();
    }

    void setSentenceNumber(int sentenceNumber) {
        this.sentenceNumber = sentenceNumber;
    }

    private boolean saveDocument() {
        boolean success;
        block14: {
            success = true;
            BufferedWriter out = null;
            try {
                try {
                    out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.postEditedPath), "UTF-8"));
                    out.write("=================================");
                    out.newLine();
                    out.write("=================================");
                    out.newLine();
                    for (TranslatedDocument document : this.translatedDocuments) {
                        for (ParallelSentence parallelSentence : document) {
                            out.write(parallelSentence.getEditedTranslation());
                            out.newLine();
                        }
                        out.write("=================================");
                        out.newLine();
                        out.write("=================================");
                        out.newLine();
                    }
                }
                catch (IOException e) {
                    success = false;
                    e.printStackTrace();
                    if (out == null) break block14;
                    try {
                        out.close();
                    }
                    catch (IOException e2) {
                        success = false;
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        success = false;
                        e.printStackTrace();
                    }
                }
            }
        }
        return success;
    }

    private void updateDocument(boolean writePostEdits) {
        this.parallelSentenceFrame.setVisible(false);
        this.parallelSentenceFrame.setTitle("Document " + (this.documentNumber + 1) + " of " + this.translatedDocuments.size());
        this.parallelSentencesPanel.removeAll();
        for (ParallelSentence parallelSentence : this.translatedDocuments.get(this.documentNumber)) {
            ParallelSentencePanel parallelSentencePanel = new ParallelSentencePanel(parallelSentence, this);
            this.parallelSentencesPanel.add(parallelSentencePanel);
        }
        this.parallelSentenceFrame.setVisible(true);
        if (writePostEdits) {
            this.saveDocument();
        }
    }

    private void updateSentence() {
    }

    private String getSVGPath() {
        return "file:" + this.translatedDocuments.get((int)this.documentNumber.intValue()).get((int)this.sentenceNumber.intValue()).svgPath;
    }

    public static void main(String[] args) throws FileNotFoundException {
        if (args.length == 5) {
            new PostEditor(args[0], args[1], args[2], args[3], args[4], 1);
        } else if (args.length == 6) {
            new PostEditor(args[0], args[1], args[2], args[3], args[4], Integer.valueOf(args[5]));
        } else {
            System.err.println("Usage: PostEditor postEdit.txt source.txt mtOutput.txt alignments.txt svgList.txt (startingDocumentNumber)");
        }
    }
}

