-- This module will transliterate Dungan language text.

local export = {}

local tt = {
	['Б'] = 'B', ['П'] = 'P', ['М'] = 'M', ['Ф'] = 'F', ['В'] = 'V',
	['Д'] = 'D', ['Т'] = 'T', ['Н'] = 'N',              ['Л'] = 'L',
	['З'] = 'Z', ['Ц'] = 'C',              ['С'] = 'S',
	['Җ'] = 'Ž', ['Ч'] = 'Č',              ['Ш'] = 'Š', ['Ж'] = 'Ƶ',
	--[[  ↑  ]]  --[[  ↑  ]]               ['Щ'] = 'X',
	['Г'] = 'G', ['К'] = 'K', ['Ң'] = 'Ŋ', ['Х'] = 'H',
	                                                    ['Р'] = 'R',

	['Ы'] = 'Ь', ['Й'] = 'J', ['Ў'] = 'W', ['Ү'] = 'Y',
	--[[  ↑  ]]
	['А'] = 'A', ['Я'] = 'Ia',
	['Ә'] = 'Ə', ['Е'] = 'Iə',
	['Э'] = 'E',
	['О'] = 'O', ['Ё'] = 'Io',
	['У'] = 'U', ['Ю'] = 'Iu',

	['И'] = 'I',

	['б'] = 'b', ['п'] = 'p', ['м'] = 'm', ['ф'] = 'f', ['в'] = 'v',
	['д'] = 'd', ['т'] = 't', ['н'] = 'n',              ['л'] = 'l',
	['з'] = 'z', ['ц'] = 'c',              ['с'] = 's',
	['җ'] = 'ž', ['ч'] = 'č',              ['ш'] = 'š', ['ж'] = 'ƶ',
	--[[  ↑  ]]  --[[  ↑  ]]               ['щ'] = 'x',
	['г'] = 'g', ['к'] = 'k', ['ң'] = 'ŋ', ['х'] = 'h',
	                                                    ['р'] = 'r',

	['ы'] = 'ь', ['й'] = 'j', ['ў'] = 'w', ['ү'] = 'y',
	--[[  ↑  ]]
	['а'] = 'a', ['я'] = 'ia',
	['ә'] = 'ə', ['е'] = 'iə',
	['э'] = 'e',
	['о'] = 'o', ['ё'] = 'io',
	['у'] = 'u', ['ю'] = 'iu',

	['и'] = 'i',
};

function export.tr(text, lang, sc)
	if (sc == 'Cyrl') then
		text = mw.ustring.gsub(text, '.', tt)
		return text
	else
		return nil
	end
end

return export