local export = {}

export.vowels = {
	["Ø"]	= { "",	"",	"",	"",	"",	"" },
	[" "]	= { " ",	" ",	" ",	" ",	" ",	" " },
	["ᅡ"]	= { "ᅡ",	"a",	"a",	"a",	"a",	"a̠" },
	["ᅢ"]	= { "ᅢ",	"ae",	"ae",	"ae",	"ay",	"e̞" },
	["ᅣ"]	= { "ᅣ",	"ya",	"ya",	"ya",	"ya",	"ja̠" },
	["ᅤ"]	= { "ᅤ",	"yae",	"yae",	"yae",	"yay",	"je̞" },
	["ᅥ"]	= { "ᅥ",	"eo",	"eo",	"ŏ",	"e",	"ʌ̹" },
	["ᅦ"]	= { "ᅦ",	"e",	"e",	"e",	"ey",	"e̞" },
	["ᅧ"]	= { "ᅧ",	"yeo",	"yeo",	"yŏ",	"ye",	"jʌ̹" },
	["ᅨ"]	= { "ᅨ",	"ye",	"ye",	"ye",	"yey",	"je̞" },
	["ᅩ"]	= { "ᅩ",	"o",	"o",	"o",	"o",	"o̞" },
	["ᅪ"]	= { "ᅪ",	"wa",	"wa",	"wa",	"wa",	"wa̠" },
	["ᅫ"]	= { "ᅫ",	"wae",	"wae",	"wae",	"way",	"we̞" },
	["ᅬ"]	= { "ᅬ",	"oe",	"oe",	"oe",	"oy",	"ø̞" },
	["ᅭ"]	= { "ᅭ",	"yo",	"yo",	"yo",	"yo",	"jo" },
	["ᅮ"]	= { "ᅮ",	"u",	"u",	"u",	"wu",	"u" },
	["ᅯ"]	= { "ᅯ",	"wo",	"wo",	"wŏ",	"we",	"wʌ̹" },
	["ᅰ"]	= { "ᅰ",	"we",	"we",	"we",	"wey",	"we̞" },
	["ᅱ"]	= { "ᅱ",	"wi",	"wi",	"wi",	"wi",	"ɥi" },
	["ᅲ"]	= { "ᅲ",	"yu",	"yu",	"yu",	"yu",	"ju" },
	["ᅳ"]	= { "ᅳ",	"eu",	"eu",	"ŭ",	"u",	"ɯ" },
	["ᅴ"]	= { "ᅴ",	"ui",	"ui",	"ŭi",	"uy",	"ɰi" },
	["ᅵ"]	= { "ᅵ",	"i",	"i",	"i",	"i",	"i" },
}

export.boundary = {
	-- note: Ø represents different things when used for initials and finals.
	-- For initials, Ø = the next syllable is absent.
	-- For finals, Ø = the absence of a jongseong jamo, but the previous syllable exists.
	-- The equivalent of initial Ø is final "" (nothing).
	["Ø-Ø"] 	 = { "",	"",	"",	"",	"",	"" },
	["-Ø"] 	 = { "",	"",	"",	"",	"",	"" },
	["-ᄀ"] 	 = { "ᄀ",	"g",	"g",	"k",	"k",	"k" },
	["-ᄁ"] 	 = { "ᄁ",	"kk",	"kk",	"kk",	"kk",	"k͈" },
	["-ᄂ"] 	 = { "ᄂ",	"n",	"n",	"n",	"n",	"n" },
	["-ᄃ"] 	 = { "ᄃ",	"d",	"d",	"t",	"t",	"t" },
	["-ᄄ"] 	 = { "ᄄ",	"tt",	"tt",	"tt",	"tt",	"t͈" },
	["-ᄅ"] 	 = { "ᄅ",	"r",	"l",	"r",	"l",	"ɾ" },
	["-ᄆ"] 	 = { "ᄆ",	"m",	"m",	"m",	"m",	"m" },
	["-ᄇ"] 	 = { "ᄇ",	"b",	"b",	"p",	"p",	"p" },
	["-ᄈ"] 	 = { "ᄈ",	"pp",	"pp",	"pp",	"pp",	"p͈" },
	["-ᄉ"] 	 = { "ᄉ",	"s",	"s",	"s",	"s",	"sʰ" },
	["-ᄊ"] 	 = { "ᄊ",	"ss",	"ss",	"ss",	"ss",	"s͈" },
	["-ᄋ"] 	 = { "ᄋ",	"",	"",	"",	"",	"" },
	["-ᄌ"] 	 = { "ᄌ",	"j",	"j",	"ch",	"c",	"t͡ɕ" },
	["-ᄍ"] 	 = { "ᄍ",	"jj",	"jj",	"tch",	"cc",	"t͡ɕ͈" },
	["-ᄎ"] 	 = { "ᄎ",	"ch",	"ch",	"ch'",	"ch",	"t͡ɕʰ" },
	["-ᄏ"] 	 = { "ᄏ",	"k",	"k",	"k'",	"kh",	"kʰ" },
	["-ᄐ"] 	 = { "ᄐ",	"t",	"t",	"t'",	"th",	"tʰ" },
	["-ᄑ"] 	 = { "ᄑ",	"p",	"p",	"p'",	"ph",	"pʰ" },
	["-ᄒ"] 	 = { "ᄒ",	"h",	"h",	"h",	"h",	"h" },
	["Ø-ᄀ"] 	 = { "ᄀ",	"g",	"g",	"g",	"k",	"ɡ" },
	["Ø-ᄁ"] 	 = { "ᄁ",	"kk",	"kk",	"kk",	"kk",	"k͈" },
	["Ø-ᄂ"] 	 = { "ᄂ",	"n",	"n",	"n",	"n",	"n" },
	["Ø-ᄃ"] 	 = { "ᄃ",	"d",	"d",	"d",	"t",	"d" },
	["Ø-ᄄ"] 	 = { "ᄄ",	"tt",	"tt",	"tt",	"tt",	"t͈" },
	["Ø-ᄅ"] 	 = { "ᄅ",	"r",	"l",	"r",	"l",	"ɾ" },
	["Ø-ᄆ"] 	 = { "ᄆ",	"m",	"m",	"m",	"m",	"m" },
	["Ø-ᄇ"] 	 = { "ᄇ",	"b",	"b",	"b",	"p",	"b" },
	["Ø-ᄈ"] 	 = { "ᄈ",	"pp",	"pp",	"pp",	"pp",	"p͈" },
	["Ø-ᄉ"] 	 = { "ᄉ",	"s",	"s",	"s",	"s",	"sʰ" },
	["Ø-ᄊ"] 	 = { "ᄊ",	"ss",	"ss",	"ss",	"ss",	"s͈" },
	["Ø-ᄋ"] 	 = { "ᄋ",	"…",	"…",	"",	"",	"" },
	["Ø-ᄌ"] 	 = { "ᄌ",	"j",	"j",	"j",	"c",	"d͡ʑ" },
	["Ø-ᄍ"] 	 = { "ᄍ",	"jj",	"jj",	"tch",	"cc",	"t͡ɕ͈" },
	["Ø-ᄎ"] 	 = { "ᄎ",	"ch",	"ch",	"ch'",	"ch",	"t͡ɕʰ" },
	["Ø-ᄏ"] 	 = { "ᄏ",	"k",	"k",	"k'",	"kh",	"kʰ" },
	["Ø-ᄐ"] 	 = { "ᄐ",	"t",	"t",	"t'",	"th",	"tʰ" },
	["Ø-ᄑ"] 	 = { "ᄑ",	"p",	"p",	"p'",	"ph",	"pʰ" },
	["Ø-ᄒ"] 	 = { "ᄒ",	"h",	"h",	"h",	"h",	"ɦ" },
	["ᆨ-Ø"] 	 = { "ᆨ",	"k",	"g",	"k",	"k",	"k̚" },
	["ᆨ-ᄀ"] 	 = { "ᆨᄁ",	"kg",	"gg",	"kk",	"kqk",	"k̚k͈" },
	["ᆨ-ᄁ"] 	 = { "ᆨᄁ",	"kkk",	"gkk",	"kk",	"kkk",	"k̚k͈" },
	["ᆨ-ᄂ"] 	 = { "ᆼᄂ",	"ngn",	"gn",	"ngn",	"kn",	"ŋn" },
	["ᆨ-ᄃ"] 	 = { "ᆨᄄ",	"kd",	"gd",	"kt",	"kqt",	"k̚t͈" },
	["ᆨ-ᄄ"] 	 = { "ᆨᄄ",	"ktt",	"gtt",	"ktt",	"ktt",	"k̚t͈" },
	["ᆨ-ᄅ"] 	 = { "ᆼᄂ",	"ngn",	"gl",	"ngn",	"kl",	"ŋn" },
	["ᆨ-ᄆ"] 	 = { "ᆼᄆ",	"ngm",	"gm",	"ngm",	"km",	"ŋm" },
	["ᆨ-ᄇ"] 	 = { "ᆨᄈ",	"kb",	"gb",	"kp",	"kqp",	"k̚p͈" },
	["ᆨ-ᄈ"] 	 = { "ᆨᄈ",	"kpp",	"gpp",	"kpp",	"kpp",	"k̚p͈" },
	["ᆨ-ᄉ"] 	 = { "ᆨᄊ",	"ks",	"gs",	"ks",	"kqs",	"ks͈" },
	["ᆨ-ᄊ"] 	 = { "ᆨᄊ",	"kss",	"gss",	"kss",	"kss",	"ks͈" },
	["ᆨ-ᄋ"] 	 = { "ᄀ",	"g",	"g-",	"g",	"k.",	"ɡ" },
	["ᆨ-ᄌ"] 	 = { "ᆨᄍ",	"kj",	"gj",	"kch",	"kqc",	"k̚t͡ɕ͈" },
	["ᆨ-ᄍ"] 	 = { "ᆨᄍ",	"kjj",	"gjj",	"ktch",	"kcc",	"k̚t͡ɕ͈" },
	["ᆨ-ᄎ"] 	 = { "ᆨᄎ",	"kch",	"gch",	"kch'",	"kch",	"k̚t͡ɕʰ" },
	["ᆨ-ᄏ"] 	 = { "ᆨᄏ",	"kk",	"gk",	"kk'",	"kkh",	"k̚kʰ" },
	["ᆨ-ᄐ"] 	 = { "ᆨᄐ",	"kt",	"gt",	"kt'",	"kth",	"k̚tʰ" },
	["ᆨ-ᄑ"] 	 = { "ᆨᄑ",	"kp",	"gp",	"kp'",	"kph",	"k̚pʰ" },
	["ᆨ-ᄒ"] 	 = { "ᄏ",	"kh",	"g-h",	"kh",	"k.h",	"kʰ" },
	["ᆩ-Ø"] 	 = { "ᆨ",	"k",	"kk",	"k",	"kk",	"k̚" },
	["ᆩ-ᄀ"] 	 = { "ᆨᄁ",	"kg",	"kkg",	"kk",	"kkqk",	"k̚k͈" },
	["ᆩ-ᄁ"] 	 = { "ᆨᄁ",	"kkk",	"kkkk",	"kk",	"kkkk",	"k̚k͈" },
	["ᆩ-ᄂ"] 	 = { "ᆼᄂ",	"ngn",	"kkn",	"ngn",	"kkn",	"ŋn" },
	["ᆩ-ᄃ"] 	 = { "ᆨᄄ",	"kd",	"kkd",	"kt",	"kkqt",	"k̚t͈" },
	["ᆩ-ᄄ"] 	 = { "ᆨᄄ",	"ktt",	"kktt",	"ktt",	"kktt",	"k̚t͈" },
	["ᆩ-ᄅ"] 	 = { "ᆼᄂ",	"ngn",	"kkl",	"ngn",	"kkl",	"ŋn" },
	["ᆩ-ᄆ"] 	 = { "ᆼᄆ",	"ngm",	"kkm",	"ngm",	"kkm",	"ŋm" },
	["ᆩ-ᄇ"] 	 = { "ᆨᄈ",	"kb",	"kkb",	"kp",	"kkqp",	"k̚p͈" },
	["ᆩ-ᄈ"] 	 = { "ᆨᄈ",	"kpp",	"kkpp",	"kpp",	"kkpp",	"k̚p͈" },
	["ᆩ-ᄉ"] 	 = { "ᆨᄊ",	"ks",	"kks",	"ks",	"kkqs",	"ks͈" },
	["ᆩ-ᄊ"] 	 = { "ᆨᄊ",	"kss",	"kkss",	"kss",	"kkss",	"ks͈" },
	["ᆩ-ᄋ"] 	 = { "ᄁ",	"kk",	"kk-",	"kk",	"kk.",	"k͈" },
	["ᆩ-ᄌ"] 	 = { "ᆨᄍ",	"kj",	"kkj",	"kch",	"kkqc",	"k̚t͡ɕ͈" },
	["ᆩ-ᄍ"] 	 = { "ᆨᄍ",	"kjj",	"kkjj",	"ktch",	"kkcc",	"k̚t͡ɕ͈" },
	["ᆩ-ᄎ"] 	 = { "ᆨᄎ",	"kch",	"kkch",	"kch'",	"kkch",	"k̚t͡ɕʰ" },
	["ᆩ-ᄏ"] 	 = { "ᆨᄏ",	"kk",	"kkk",	"kk'",	"kkkh",	"k̚kʰ" },
	["ᆩ-ᄐ"] 	 = { "ᆨᄐ",	"kt",	"kkt",	"kt'",	"kkth",	"k̚tʰ" },
	["ᆩ-ᄑ"] 	 = { "ᆨᄑ",	"kp",	"kkp",	"kp'",	"kkph",	"k̚pʰ" },
	["ᆩ-ᄒ"] 	 = { "ᄏ",	"kh",	"kk-h",	"kh",	"kk.h",	"kʰ" },
	["ᆪ-Ø"] 	 = { "ᆨ",	"k",	"gs",	"k",	"ks",	"k̚" },
	["ᆪ-ᄀ"] 	 = { "ᆨᄁ",	"kg",	"gsg",	"kk",	"ksqk",	"k̚k͈" },
	["ᆪ-ᄁ"] 	 = { "ᆨᄁ",	"kkk",	"gskk",	"kk",	"kskk",	"k̚k͈" },
	["ᆪ-ᄂ"] 	 = { "ᆼᄂ",	"ngn",	"gsn",	"ngn",	"ksn",	"ŋn" },
	["ᆪ-ᄃ"] 	 = { "ᆨᄄ",	"kd",	"gsd",	"kt",	"ksqt",	"k̚t͈" },
	["ᆪ-ᄄ"] 	 = { "ᆨᄄ",	"ktt",	"gstt",	"ktt",	"kstt",	"k̚t͈" },
	["ᆪ-ᄅ"] 	 = { "ᆼᄂ",	"ngn",	"gsl",	"ngn",	"ksl",	"ŋn" },
	["ᆪ-ᄆ"] 	 = { "ᆼᄆ",	"ngm",	"gsm",	"ngm",	"ksm",	"ŋm" },
	["ᆪ-ᄇ"] 	 = { "ᆨᄈ",	"kb",	"gsb",	"kp",	"ksqp",	"k̚p͈" },
	["ᆪ-ᄈ"] 	 = { "ᆨᄈ",	"kpp",	"gspp",	"kpp",	"kspp",	"k̚p͈" },
	["ᆪ-ᄉ"] 	 = { "ᆨᄊ",	"ks",	"gss",	"ks",	"ksqs",	"ks͈" },
	["ᆪ-ᄊ"] 	 = { "ᆨᄊ",	"kss",	"gsss",	"kss",	"ksss",	"ks͈" },
	["ᆪ-ᄋ"] 	 = { "ᆨᄊ",	"ks",	"gs-",	"ks",	"ks.",	"ks͈" },
	["ᆪ-ᄌ"] 	 = { "ᆨᄍ",	"kj",	"gsj",	"kch",	"ksqc",	"k̚t͡ɕ͈" },
	["ᆪ-ᄍ"] 	 = { "ᆨᄍ",	"kjj",	"gsjj",	"ktch",	"kscc",	"k̚t͡ɕ͈" },
	["ᆪ-ᄎ"] 	 = { "ᆨᄎ",	"kch",	"gsch",	"kch'",	"ksch",	"k̚t͡ɕʰ" },
	["ᆪ-ᄏ"] 	 = { "ᆨᄏ",	"kk",	"gsk",	"kk'",	"kskh",	"k̚kʰ" },
	["ᆪ-ᄐ"] 	 = { "ᆨᄐ",	"kt",	"gst",	"kt'",	"ksth",	"k̚tʰ" },
	["ᆪ-ᄑ"] 	 = { "ᆨᄑ",	"kp",	"gsp",	"kp'",	"ksph",	"k̚pʰ" },
	["ᆪ-ᄒ"] 	 = { "ᄏ",	"kh",	"gs-h",	"kh",	"ks.h",	"kʰ" },
	["ᆫ-Ø"] 	 = { "ᆫ",	"n",	"n",	"n",	"n",	"n" },
	["ᆫ-ᄀ"] 	 = { "ᆫᄀ",	"n-g",	"ng",	"n'g",	"nk",	"nɡ" },
	["ᆫ-ᄁ"] 	 = { "ᆫᄁ",	"nkk",	"nkk",	"nkk",	"nkk",	"nk͈" },
	["ᆫ-ᄂ"] 	 = { "ᆫᄂ",	"nn",	"nn",	"nn",	"nn",	"nn" },
	["ᆫ-ᄃ"] 	 = { "ᆫᄃ",	"nd",	"nd",	"nd",	"nt",	"nd" },
	["ᆫ-ᄄ"] 	 = { "ᆫᄄ",	"ntt",	"ntt",	"ntt",	"ntt",	"nt͈" },
	["ᆫ-ᄅ"] 	 = { "ᆯᄅ",	"ll",	"nl",	"ll",	"nl",	"ɭɭ" },
	["ᆫ-ᄆ"] 	 = { "ᆫᄆ",	"nm",	"nm",	"nm",	"nm",	"nm" },
	["ᆫ-ᄇ"] 	 = { "ᆫᄇ",	"nb",	"nb",	"nb",	"np",	"nb" },
	["ᆫ-ᄈ"] 	 = { "ᆫᄈ",	"npp",	"npp",	"npp",	"npp",	"np͈" },
	["ᆫ-ᄉ"] 	 = { "ᆫᄉ",	"ns",	"ns",	"ns",	"ns",	"nsʰ" },
	["ᆫ-ᄊ"] 	 = { "ᆫᄊ",	"nss",	"nss",	"nss",	"nss",	"ns͈" },
	["ᆫ-ᄋ"] 	 = { "ᄂ",	"n",	"n-",	"n",	"n.",	"n" },
	["ᆫ-ᄌ"] 	 = { "ᆫᄌ",	"nj",	"nj",	"nj",	"nc",	"nd͡ʑ" },
	["ᆫ-ᄍ"] 	 = { "ᆫᄍ",	"njj",	"njj",	"ntch",	"ncc",	"nt͡ɕ͈" },
	["ᆫ-ᄎ"] 	 = { "ᆫᄎ",	"nch",	"nch",	"nch'",	"nch",	"nt͡ɕʰ" },
	["ᆫ-ᄏ"] 	 = { "ᆫᄏ",	"nk",	"nk",	"nk'",	"nkh",	"nkʰ" },
	["ᆫ-ᄐ"] 	 = { "ᆫᄐ",	"nt",	"nt",	"nt'",	"nth",	"ntʰ" },
	["ᆫ-ᄑ"] 	 = { "ᆫᄑ",	"np",	"np",	"np'",	"nph",	"npʰ" },
	["ᆫ-ᄒ"] 	 = { "ᆫᄒ",	"nh",	"n-h",	"nh",	"n.h",	"nɦ" },
	["ᆬ-Ø"] 	 = { "ᆫ",	"n",	"nj",	"n",	"nc",	"n" },
	["ᆬ-ᄀ"] 	 = { "ᆫᄁ",	"ng",	"njg",	"nk",	"ncqk",	"nk͈" },
	["ᆬ-ᄁ"] 	 = { "ᆫᄁ",	"nkk",	"njkk",	"nkk",	"nckk",	"nk͈" },
	["ᆬ-ᄂ"] 	 = { "ᆫᄂ",	"nn",	"njn",	"nn",	"ncn",	"nn" },
	["ᆬ-ᄃ"] 	 = { "ᆫᄄ",	"nd",	"njd",	"nt",	"ncqt",	"nt͈" },
	["ᆬ-ᄄ"] 	 = { "ᆫᄄ",	"ntt",	"njtt",	"ntt",	"nctt",	"nt͈" },
	["ᆬ-ᄅ"] 	 = { "ᆫᄂ",	"nn",	"njl",	"nn",	"ncl",	"nn" },
	["ᆬ-ᄆ"] 	 = { "ᆫᄆ",	"nm",	"njm",	"nm",	"ncm",	"nm" },
	["ᆬ-ᄇ"] 	 = { "ᆫᄈ",	"nb",	"njb",	"np",	"ncqp",	"np͈" },
	["ᆬ-ᄈ"] 	 = { "ᆫᄈ",	"npp",	"njpp",	"npp",	"ncpp",	"np͈" },
	["ᆬ-ᄉ"] 	 = { "ᆫᄊ",	"ns",	"njs",	"ns",	"ncqs",	"ns͈" },
	["ᆬ-ᄊ"] 	 = { "ᆫᄊ",	"nss",	"njss",	"nss",	"ncss",	"ns͈" },
	["ᆬ-ᄋ"] 	 = { "ᆫᄌ",	"nj",	"nj-",	"nj",	"nc.",	"nd͡ʑ" },
	["ᆬ-ᄌ"] 	 = { "ᆫᄍ",	"nj",	"njj",	"nch",	"ncqc",	"nt͡ɕ͈" },
	["ᆬ-ᄍ"] 	 = { "ᆫᄍ",	"njj",	"njjj",	"ntch",	"nccc",	"nt͡ɕ͈" },
	["ᆬ-ᄎ"] 	 = { "ᆫᄎ",	"nch",	"njch",	"nch'",	"ncch",	"nt͡ɕʰ" },
	["ᆬ-ᄏ"] 	 = { "ᆫᄏ",	"nk",	"njk",	"nk'",	"nckh",	"nkʰ" },
	["ᆬ-ᄐ"] 	 = { "ᆫᄐ",	"nt",	"njt",	"nt'",	"ncth",	"ntʰ" },
	["ᆬ-ᄑ"] 	 = { "ᆫᄑ",	"np",	"njp",	"np'",	"ncph",	"npʰ" },
	["ᆬ-ᄒ"] 	 = { "ᆫᄎ",	"nch",	"nj-h",	"nch'",	"nc.h",	"nt͡ɕʰ" },
	["ᆭ-Ø"] 	 = { "ᆫ",	"n",	"nh",	"n",	"nh",	"n" },
	["ᆭ-ᄀ"] 	 = { "ᆫᄏ",	"nk",	"nhg",	"nk'",	"nhk",	"nkʰ" },
	["ᆭ-ᄁ"] 	 = { "ᆫᄏ",	"nk",	"nhkk",	"nk'",	"nhkk",	"nkʰ" },
	["ᆭ-ᄂ"] 	 = { "ᆫᄂ",	"nn",	"nhn",	"nn",	"nhn",	"nn" },
	["ᆭ-ᄃ"] 	 = { "ᆫᄐ",	"nt",	"nhd",	"nt'",	"nht",	"ntʰ" },
	["ᆭ-ᄄ"] 	 = { "ᆫᄐ",	"nt",	"nhtt",	"nt'",	"nhtt",	"ntʰ" },
	["ᆭ-ᄅ"] 	 = { "ᆫᄂ",	"nn",	"nhl",	"nn",	"nhl",	"nn" },
	["ᆭ-ᄆ"] 	 = { "ᆫᄆ",	"nm",	"nhm",	"nm",	"nhm",	"nm" },
	["ᆭ-ᄇ"] 	 = { "ᆫᄑ",	"np",	"nhb",	"np'",	"nhp",	"npʰ" },
	["ᆭ-ᄈ"] 	 = { "ᆫᄑ",	"np",	"nhpp",	"np'",	"nhpp",	"npʰ" },
	["ᆭ-ᄉ"] 	 = { "ᆫᄊ",	"ns",	"nhs",	"nss",	"nhs",	"ns͈" },
	["ᆭ-ᄊ"] 	 = { "ᆫᄊ",	"nss",	"nhss",	"nss",	"nhss",	"ns͈" },
	["ᆭ-ᄋ"] 	 = { "ᄂ",	"n",	"nh-",	"n",	"nh.",	"n" },
	["ᆭ-ᄌ"] 	 = { "ᆫᄎ",	"nch",	"nhj",	"nch'",	"nhc",	"nt͡ɕʰ" },
	["ᆭ-ᄍ"] 	 = { "ᆫᄎ",	"nch",	"nhjj",	"nch'",	"nhcc",	"nt͡ɕʰ" },
	["ᆭ-ᄎ"] 	 = { "ᆫᄎ",	"nch",	"nhch",	"nch'",	"nhch",	"nt͡ɕʰ" },
	["ᆭ-ᄏ"] 	 = { "ᆫᄏ",	"nk",	"nhk",	"nk'",	"nhkh",	"nkʰ" },
	["ᆭ-ᄐ"] 	 = { "ᆫᄐ",	"nt",	"nht",	"nt'",	"nhth",	"ntʰ" },
	["ᆭ-ᄑ"] 	 = { "ᆫᄑ",	"np",	"nhp",	"np'",	"nhph",	"npʰ" },
	["ᆭ-ᄒ"] 	 = { "ᆫᄒ",	"nh",	"nhh",	"nh",	"nhh",	"nɦ" },
	["ᆮ-Ø"] 	 = { "ᆮ",	"t",	"d",	"t",	"t",	"t̚" },
	["ᆮ-ᄀ"] 	 = { "ᆮᄁ",	"tg",	"dg",	"tk",	"tqk",	"t̚k͈" },
	["ᆮ-ᄁ"] 	 = { "ᆮᄁ",	"tkk",	"dkk",	"tkk",	"tkk",	"t̚k͈" },
	["ᆮ-ᄂ"] 	 = { "ᆫᄂ",	"nn",	"dn",	"nn",	"tn",	"nn" },
	["ᆮ-ᄃ"] 	 = { "ᆮᄄ",	"td",	"dd",	"tt",	"tqt",	"t̚t͈" },
	["ᆮ-ᄄ"] 	 = { "ᆮᄄ",	"ttt",	"dtt",	"tt",	"ttt",	"t̚t͈" },
	["ᆮ-ᄅ"] 	 = { "ᆫᄂ",	"nn",	"dl",	"nn",	"tl",	"nn" },
	["ᆮ-ᄆ"] 	 = { "ᆫᄆ",	"nm",	"dm",	"nm",	"tm",	"nm" },
	["ᆮ-ᄇ"] 	 = { "ᆮᄈ",	"tb",	"db",	"tp",	"tqp",	"t̚p͈" },
	["ᆮ-ᄈ"] 	 = { "ᆮᄈ",	"tpp",	"dpp",	"tpp",	"tpp",	"t̚p͈" },
	["ᆮ-ᄉ"] 	 = { "ᆮᄊ",	"ts",	"ds",	"ss",	"tqs",	"t̚s͈" },
	["ᆮ-ᄊ"] 	 = { "ᆮᄊ",	"tss",	"dss",	"ss",	"tss",	"t̚s͈" },
	["ᆮ-ᄋ"] 	 = { "ᄃ",	"d",	"d-",	"d",	"t.",	"d" },
	["ᆮ-ᄌ"] 	 = { "ᆮᄍ",	"tj",	"dj",	"tch",	"tqc",	"t̚t͡ɕ͈" },
	["ᆮ-ᄍ"] 	 = { "ᆮᄍ",	"tjj",	"djj",	"tch",	"tcc",	"t̚t͡ɕ͈" },
	["ᆮ-ᄎ"] 	 = { "ᆮᄎ",	"tch",	"dch",	"tch'",	"tch",	"t̚t͡ɕʰ" },
	["ᆮ-ᄏ"] 	 = { "ᆮᄏ",	"tk",	"dk",	"tk'",	"tkh",	"t̚kʰ" },
	["ᆮ-ᄐ"] 	 = { "ᆮᄐ",	"tt",	"dt",	"tt'",	"tth",	"t̚tʰ" },
	["ᆮ-ᄑ"] 	 = { "ᆮᄑ",	"tp",	"dp",	"tp'",	"tph",	"t̚pʰ" },
	["ᆮ-ᄒ"] 	 = { "ᄐ",	"th",	"d-h",	"th",	"t.h",	"tʰ" },
	["ᆯ-Ø"] 	 = { "ᆯ",	"l",	"l",	"l",	"l",	"ɭ" },
	["ᆯ-ᄀ"] 	 = { "ᆯᄀ",	"lg",	"lg",	"lg",	"lk",	"ɭɡ" },
	["ᆯ-ᄁ"] 	 = { "ᆯᄁ",	"lkk",	"lkk",	"lkk",	"lkk",	"ɭk͈" },
	["ᆯ-ᄂ"] 	 = { "ᆯᄅ",	"ll",	"ln",	"ll",	"ln",	"ɭɭ" },
	["ᆯ-ᄃ"] 	 = { "ᆯᄃ",	"ld",	"ld",	"ld",	"lt",	"ɭd" },
	["ᆯ-ᄄ"] 	 = { "ᆯᄄ",	"ltt",	"ltt",	"ltt",	"ltt",	"ɭt͈" },
	["ᆯ-ᄅ"] 	 = { "ᆯᄅ",	"ll",	"ll",	"ll",	"ll",	"ɭɭ" },
	["ᆯ-ᄆ"] 	 = { "ᆯᄆ",	"lm",	"lm",	"lm",	"lm",	"ɭm" },
	["ᆯ-ᄇ"] 	 = { "ᆯᄇ",	"lb",	"lb",	"lb",	"lp",	"ɭb" },
	["ᆯ-ᄈ"] 	 = { "ᆯᄈ",	"lpp",	"lpp",	"lpp",	"lpp",	"ɭp͈" },
	["ᆯ-ᄉ"] 	 = { "ᆯᄉ",	"ls",	"ls",	"ls",	"ls",	"ɭsʰ" },
	["ᆯ-ᄊ"] 	 = { "ᆯᄊ",	"lss",	"lss",	"lss",	"lss",	"ɭs͈" },
	["ᆯ-ᄋ"] 	 = { "ᄅ",	"r",	"l-",	"r",	"l.",	"ɾ" },
	["ᆯ-ᄌ"] 	 = { "ᆯᄌ",	"lj",	"lj",	"lj",	"lc",	"ɭd͡ʑ" },
	["ᆯ-ᄍ"] 	 = { "ᆯᄍ",	"ljj",	"ljj",	"ltch",	"lcc",	"ɭt͡ɕ͈" },
	["ᆯ-ᄎ"] 	 = { "ᆯᄎ",	"lch",	"lch",	"lch'",	"lch",	"ɭt͡ɕʰ" },
	["ᆯ-ᄏ"] 	 = { "ᆯᄏ",	"lk",	"lk",	"lk'",	"lkh",	"ɭkʰ" },
	["ᆯ-ᄐ"] 	 = { "ᆯᄐ",	"lt",	"lt",	"lt'",	"lth",	"ɭtʰ" },
	["ᆯ-ᄑ"] 	 = { "ᆯᄑ",	"lp",	"lp",	"lp'",	"lph",	"ɭpʰ" },
	["ᆯ-ᄒ"] 	 = { "ᆯᄒ",	"lh",	"l-h",	"rh",	"l.h",	"ɾɦ" },
	["ᆰ-Ø"] 	 = { "ᆨ",	"k",	"lg",	"k",	"lk",	"k̚" },
	["ᆰ-ᄀ"] 	 = { "ᆯᄁ",	"lg",	"lgg",	"lg",	"lkqk",	"ɭk͈" },
	["ᆰ-ᄁ"] 	 = { "ᆯᄁ",	"lkk",	"lgkk",	"lkk",	"lkkk",	"ɭk͈" },
	["ᆰ-ᄂ"] 	 = { "ᆼᄂ",	"ngn",	"lgn",	"ngn",	"lkn",	"ŋn" },
	["ᆰ-ᄃ"] 	 = { "ᆨᄄ",	"kd",	"lgd",	"kt",	"lkqt",	"k̚t͈" },
	["ᆰ-ᄄ"] 	 = { "ᆨᄄ",	"ktt",	"lgtt",	"ktt",	"lktt",	"k̚t͈" },
	["ᆰ-ᄅ"] 	 = { "ᆼᄂ",	"ngn",	"lgl",	"ngn",	"lkl",	"ŋn" },
	["ᆰ-ᄆ"] 	 = { "ᆼᄆ",	"ngm",	"lgm",	"ngm",	"lkm",	"ŋm" },
	["ᆰ-ᄇ"] 	 = { "ᆨᄈ",	"kb",	"lgb",	"kp",	"lkqp",	"k̚p͈" },
	["ᆰ-ᄈ"] 	 = { "ᆨᄈ",	"kpp",	"lgpp",	"kpp",	"lkpp",	"k̚p͈" },
	["ᆰ-ᄉ"] 	 = { "ᆨᄊ",	"ks",	"lgs",	"ks",	"lkqs",	"ks͈" },
	["ᆰ-ᄊ"] 	 = { "ᆨᄊ",	"kss",	"lgss",	"kss",	"lkss",	"ks͈" },
	["ᆰ-ᄋ"] 	 = { "ᆯᄀ",	"lg",	"lg-",	"lg",	"lk.",	"ɭɡ" },
	["ᆰ-ᄌ"] 	 = { "ᆨᄍ",	"kj",	"lgj",	"kch",	"lkqc",	"k̚t͡ɕ͈" },
	["ᆰ-ᄍ"] 	 = { "ᆨᄍ",	"kjj",	"lgjj",	"ktch",	"lkcc",	"k̚t͡ɕ͈" },
	["ᆰ-ᄎ"] 	 = { "ᆨᄎ",	"kch",	"lgch",	"kch'",	"lkch",	"k̚t͡ɕʰ" },
	["ᆰ-ᄏ"] 	 = { "ᆯᄏ",	"lk",	"lgk",	"lk'",	"lkkh",	"ɭkʰ" },
	["ᆰ-ᄐ"] 	 = { "ᆨᄐ",	"kt",	"lgt",	"kt'",	"lkth",	"k̚tʰ" },
	["ᆰ-ᄑ"] 	 = { "ᆨᄑ",	"kp",	"lgp",	"kp'",	"lkph",	"k̚pʰ" },
	["ᆰ-ᄒ"] 	 = { "ᆯᄏ",	"lk",	"lg-h",	"lk'",	"lk.h",	"ɭkʰ" },
	["ᆱ-Ø"] 	 = { "ᆷ",	"m",	"lm",	"m",	"lm",	"m" },
	["ᆱ-ᄀ"] 	 = { "ᆷᄀ",	"mg",	"lmg",	"mg",	"lmqk",	"mɡ" },
	["ᆱ-ᄁ"] 	 = { "ᆷᄁ",	"mkk",	"lmkk",	"mkk",	"lmkk",	"mk͈" },
	["ᆱ-ᄂ"] 	 = { "ᆷᄂ",	"mn",	"lmn",	"mn",	"lmn",	"mn" },
	["ᆱ-ᄃ"] 	 = { "ᆷᄄ",	"md",	"lmd",	"mt",	"lmt",	"mt͈" },
	["ᆱ-ᄄ"] 	 = { "ᆷᄄ",	"mtt",	"lmtt",	"mtt",	"lmtt",	"mt͈" },
	["ᆱ-ᄅ"] 	 = { "ᆷᄂ",	"mn",	"lml",	"mn",	"lml",	"mn" },
	["ᆱ-ᄆ"] 	 = { "ᆷᄆ",	"mm",	"lmm",	"mm",	"lmm",	"mm" },
	["ᆱ-ᄇ"] 	 = { "ᆷᄇ",	"mb",	"lmb",	"mb",	"lmqp",	"mb" },
	["ᆱ-ᄈ"] 	 = { "ᆷᄈ",	"mpp",	"lmpp",	"mpp",	"lmpp",	"mp͈" },
	["ᆱ-ᄉ"] 	 = { "ᆷᄉ",	"ms",	"lms",	"ms",	"lmqs",	"msʰ" },
	["ᆱ-ᄊ"] 	 = { "ᆷᄊ",	"mss",	"lmss",	"mss",	"lmss",	"ms͈" },
	["ᆱ-ᄋ"] 	 = { "ᆯᄆ",	"lm",	"lm-",	"lm",	"lm.",	"ɭm" },
	["ᆱ-ᄌ"] 	 = { "ᆷᄌ",	"mj",	"lmj",	"mj",	"lmqc",	"md͡ʑ" },
	["ᆱ-ᄍ"] 	 = { "ᆷᄍ",	"mjj",	"lmjj",	"mtch",	"lmcc",	"mt͡ɕ͈" },
	["ᆱ-ᄎ"] 	 = { "ᆷᄎ",	"mch",	"lmch",	"mch'",	"lmch",	"mt͡ɕʰ" },
	["ᆱ-ᄏ"] 	 = { "ᆷᄏ",	"mk",	"lmk",	"mk'",	"lmkh",	"mkʰ" },
	["ᆱ-ᄐ"] 	 = { "ᆷᄐ",	"mt",	"lmt",	"mt'",	"lmth",	"mtʰ" },
	["ᆱ-ᄑ"] 	 = { "ᆷᄑ",	"mp",	"lmp",	"mp'",	"lmph",	"mpʰ" },
	["ᆱ-ᄒ"] 	 = { "ᆯᄒ",	"mh",	"lm-h",	"mh",	"lm.h",	"ɾɦ" },
	["ᆲ-Ø"] 	 = { "ᆯ",	"l",	"lb",	"l",	"lp",	"ɭ" },
	["ᆲ-ᄀ"] 	 = { "ᆯᄁ",	"lg",	"lbg",	"lk",	"lpqk",	"ɭk͈" },
	["ᆲ-ᄁ"] 	 = { "ᆯᄁ",	"lkk",	"lbkk",	"lkk",	"lpkk",	"ɭk͈" },
	["ᆲ-ᄂ"] 	 = { "ᆯᄅ",	"ll",	"lbn",	"ll",	"lpn",	"ɭɭ" },
	["ᆲ-ᄃ"] 	 = { "ᆯᄄ",	"ld",	"lbd",	"lt",	"lpqt",	"ɭt͈" },
	["ᆲ-ᄄ"] 	 = { "ᆯᄄ",	"ltt",	"lbtt",	"ltt",	"lptt",	"ɭt͈" },
	["ᆲ-ᄅ"] 	 = { "ᆯᄅ",	"ll",	"lbl",	"ll",	"lpl",	"ɭɭ" },
	["ᆲ-ᄆ"] 	 = { "ᆯᄆ",	"lm",	"lbm",	"lm",	"lpm",	"ɭm" },
	["ᆲ-ᄇ"] 	 = { "ᆯᄈ",	"lb",	"lbb",	"lp",	"lpqp",	"ɭp͈" },
	["ᆲ-ᄈ"] 	 = { "ᆯᄈ",	"lpp",	"lbpp",	"lpp",	"lppp",	"ɭp͈" },
	["ᆲ-ᄉ"] 	 = { "ᆯᄊ",	"ls",	"lbs",	"ls",	"lpqs",	"ɭs͈" },
	["ᆲ-ᄊ"] 	 = { "ᆯᄊ",	"lss",	"lbss",	"lss",	"lpss",	"ɭs͈" },
	["ᆲ-ᄋ"] 	 = { "ᆯᄇ",	"lb",	"lb-",	"lb",	"lp.",	"ɭb" },
	["ᆲ-ᄌ"] 	 = { "ᆯᄍ",	"lj",	"lbj",	"lch",	"lpqc",	"ɭt͡ɕ͈" },
	["ᆲ-ᄍ"] 	 = { "ᆯᄍ",	"ljj",	"lbjj",	"ltch",	"lpcc",	"ɭt͡ɕ͈" },
	["ᆲ-ᄎ"] 	 = { "ᆯᄎ",	"lch",	"lbch",	"lch'",	"lpch",	"ɭt͡ɕʰ" },
	["ᆲ-ᄏ"] 	 = { "ᆯᄏ",	"lk",	"lbk",	"lk'",	"lpkh",	"ɭkʰ" },
	["ᆲ-ᄐ"] 	 = { "ᆯᄐ",	"lt",	"lbt",	"lt'",	"lpth",	"ɭtʰ" },
	["ᆲ-ᄑ"] 	 = { "ᆯᄑ",	"lp",	"lbp",	"lp'",	"lpph",	"ɭpʰ" },
	["ᆲ-ᄒ"] 	 = { "ᆯᄑ",	"lph",	"lb-h",	"lp'",	"lp.h",	"ɭpʰ" },
	["ᆳ-Ø"] 	 = { "ᆯ",	"l",	"ls",	"l",	"ls",	"ɭ" },
	["ᆳ-ᄀ"] 	 = { "ᆯᄀ",	"lg",	"lsg",	"lg",	"lsk",	"ɭɡ" },
	["ᆳ-ᄁ"] 	 = { "ᆯᄁ",	"lkk",	"lskk",	"lkk",	"lskk",	"ɭk͈" },
	["ᆳ-ᄂ"] 	 = { "ᆯᄂ",	"ln",	"lsn",	"ln",	"lsn",	"ɭn" },
	["ᆳ-ᄃ"] 	 = { "ᆯᄃ",	"ld",	"lsd",	"ld",	"lst",	"ɭd" },
	["ᆳ-ᄄ"] 	 = { "ᆯᄄ",	"ltt",	"lstt",	"ltt",	"lstt",	"ɭt͈" },
	["ᆳ-ᄅ"] 	 = { "ᆯᄂ",	"ln",	"lsl",	"ln",	"lsl",	"ɭn" },
	["ᆳ-ᄆ"] 	 = { "ᆯᄆ",	"lm",	"lsm",	"lm",	"lsm",	"ɭm" },
	["ᆳ-ᄇ"] 	 = { "ᆯᄇ",	"lb",	"lsb",	"lb",	"lsp",	"ɭb" },
	["ᆳ-ᄈ"] 	 = { "ᆯᄈ",	"lpp",	"lspp",	"lpp",	"lspp",	"ɭp͈" },
	["ᆳ-ᄉ"] 	 = { "ᆯᄉ",	"ls",	"lss",	"ls",	"lss",	"ɭsʰ" },
	["ᆳ-ᄊ"] 	 = { "ᆯᄊ",	"lss",	"lsss",	"lss",	"lsss",	"ɭs͈" },
	["ᆳ-ᄋ"] 	 = { "ᆯᄊ",	"ls",	"ls-",	"ls",	"ls.",	"ɭs͈" },
	["ᆳ-ᄌ"] 	 = { "ᆯᄌ",	"lj",	"lsj",	"lj",	"lsc",	"ɭd͡ʑ" },
	["ᆳ-ᄍ"] 	 = { "ᆯᄍ",	"ljj",	"lsjj",	"ltch",	"lscc",	"ɭt͡ɕ͈" },
	["ᆳ-ᄎ"] 	 = { "ᆯᄎ",	"lch",	"lsch",	"lch'",	"lsch",	"ɭt͡ɕʰ" },
	["ᆳ-ᄏ"] 	 = { "ᆯᄏ",	"lk",	"lsk",	"lk'",	"lskh",	"ɭkʰ" },
	["ᆳ-ᄐ"] 	 = { "ᆯᄐ",	"lt",	"lst",	"lt'",	"lsth",	"ɭtʰ" },
	["ᆳ-ᄑ"] 	 = { "ᆯᄑ",	"lp",	"lsp",	"lp'",	"lsph",	"ɭpʰ" },
	["ᆳ-ᄒ"] 	 = { "ᆯᄊ",	"lh",	"lsh",	"lh",	"lsh",	"ɭs͈" },
	["ᆴ-Ø"] 	 = { "ᆯ",	"l",	"lt",	"l",	"lth",	"ɭ" },
	["ᆴ-ᄀ"] 	 = { "ᆯᄁ",	"lg",	"ltg",	"lk",	"lthqk",	"ɭk͈" },
	["ᆴ-ᄁ"] 	 = { "ᆯᄁ",	"lkk",	"ltkk",	"lkk",	"lthkk",	"ɭk͈" },
	["ᆴ-ᄂ"] 	 = { "ᆯᄅ",	"ll",	"ltn",	"ll",	"lthn",	"ɭɭ" },
	["ᆴ-ᄃ"] 	 = { "ᆯᄄ",	"ld",	"ltd",	"lt",	"lthqt",	"ɭt͈" },
	["ᆴ-ᄄ"] 	 = { "ᆯᄄ",	"ltt",	"lttt",	"ltt",	"lthtt",	"ɭt͈" },
	["ᆴ-ᄅ"] 	 = { "ᆯᄅ",	"ll",	"ltl",	"ll",	"lthl",	"ɭɭ" },
	["ᆴ-ᄆ"] 	 = { "ᆯᄆ",	"lm",	"ltm",	"lm",	"lthm",	"ɭm" },
	["ᆴ-ᄇ"] 	 = { "ᆯᄈ",	"lb",	"ltb",	"lp",	"lthqp",	"ɭp͈" },
	["ᆴ-ᄈ"] 	 = { "ᆯᄈ",	"lpp",	"ltpp",	"lpp",	"lthpp",	"ɭp͈" },
	["ᆴ-ᄉ"] 	 = { "ᆯᄊ",	"ls",	"lts",	"ls",	"lthqs",	"ɭs͈" },
	["ᆴ-ᄊ"] 	 = { "ᆯᄊ",	"lss",	"ltss",	"lss",	"lthss",	"ɭs͈" },
	["ᆴ-ᄋ"] 	 = { "ᆯᄐ",	"lt",	"lt-",	"lt",	"lth.",	"ɭtʰ" },
	["ᆴ-ᄌ"] 	 = { "ᆯᄍ",	"lj",	"ltj",	"lch",	"lthqc",	"ɭt͡ɕ͈" },
	["ᆴ-ᄍ"] 	 = { "ᆯᄍ",	"ljj",	"ltjj",	"ltch",	"lthcc",	"ɭt͡ɕ͈" },
	["ᆴ-ᄎ"] 	 = { "ᆯᄎ",	"lch",	"ltch",	"lch'",	"lthch",	"ɭt͡ɕʰ" },
	["ᆴ-ᄏ"] 	 = { "ᆯᄏ",	"lk",	"ltk",	"lk'",	"lthkh",	"ɭkʰ" },
	["ᆴ-ᄐ"] 	 = { "ᆯᄐ",	"lt",	"ltt",	"lt'",	"lthth",	"ɭtʰ" },
	["ᆴ-ᄑ"] 	 = { "ᆯᄑ",	"lp",	"ltp",	"lp'",	"lthph",	"ɭpʰ" },
	["ᆴ-ᄒ"] 	 = { "ᆯᄐ",	"lh",	"lt-h",	"lh",	"lth.h",	"ɭtʰ" },
	["ᆵ-Ø"] 	 = { "ᆸ",	"p",	"lp",	"p",	"lph",	"p̚" },
	["ᆵ-ᄀ"] 	 = { "ᆸᄁ",	"pg",	"lpg",	"pk",	"lphqk",	"p̚k͈" },
	["ᆵ-ᄁ"] 	 = { "ᆸᄁ",	"pkk",	"lpkk",	"pkk",	"lphkk",	"p̚k͈" },
	["ᆵ-ᄂ"] 	 = { "ᆷᄂ",	"mn",	"lpn",	"mn",	"lphn",	"mn" },
	["ᆵ-ᄃ"] 	 = { "ᆸᄄ",	"pd",	"lpd",	"pt",	"lphqt",	"p̚t͈" },
	["ᆵ-ᄄ"] 	 = { "ᆸᄄ",	"ptt",	"lptt",	"ptt",	"lphtt",	"p̚t͈" },
	["ᆵ-ᄅ"] 	 = { "ᆷᄂ",	"mn",	"lpl",	"mn",	"lphl",	"mn" },
	["ᆵ-ᄆ"] 	 = { "ᆷᄆ",	"mm",	"lpm",	"mm",	"lphm",	"mm" },
	["ᆵ-ᄇ"] 	 = { "ᆸᄈ",	"pb",	"lpb",	"pp",	"lphqp",	"p̚p͈" },
	["ᆵ-ᄈ"] 	 = { "ᆸᄈ",	"ppp",	"lppp",	"pp",	"lphpp",	"p̚p͈" },
	["ᆵ-ᄉ"] 	 = { "ᆸᄊ",	"ps",	"lps",	"ps",	"lphqs",	"ps͈" },
	["ᆵ-ᄊ"] 	 = { "ᆸᄊ",	"pss",	"lpss",	"pss",	"lphss",	"ps͈" },
	["ᆵ-ᄋ"] 	 = { "ᆯᄑ",	"lp",	"lp-",	"lp",	"lph.",	"ɭpʰ" },
	["ᆵ-ᄌ"] 	 = { "ᆸᄍ",	"pj",	"lpj",	"pch",	"lphqc",	"p̚t͡ɕ͈" },
	["ᆵ-ᄍ"] 	 = { "ᆸᄍ",	"pjj",	"lpjj",	"ptch",	"lphcc",	"p̚t͡ɕ͈" },
	["ᆵ-ᄎ"] 	 = { "ᆸᄎ",	"pch",	"lpch",	"pch'",	"lphch",	"p̚t͡ɕʰ" },
	["ᆵ-ᄏ"] 	 = { "ᆸᄏ",	"pk",	"lpk",	"pk'",	"lphkh",	"p̚kʰ" },
	["ᆵ-ᄐ"] 	 = { "ᆸᄐ",	"pt",	"lpt",	"pt'",	"lphth",	"p̚tʰ" },
	["ᆵ-ᄑ"] 	 = { "ᆸᄑ",	"pp",	"lpp",	"pp'",	"lphph",	"p̚pʰ" },
	["ᆵ-ᄒ"] 	 = { "ᆯᄑ",	"ph",	"lp-h",	"ph",	"lph.h",	"ɭpʰ" },
	["ᆶ-Ø"] 	 = { "ᆯ",	"l",	"lh",	"l",	"lh",	"ɭ" },
	["ᆶ-ᄀ"] 	 = { "ᆯᄏ",	"lk",	"lhg",	"lk'",	"lhk",	"ɭkʰ" },
	["ᆶ-ᄁ"] 	 = { "ᆯᄏ",	"lk",	"lhkk",	"lk'",	"lhkk",	"ɭkʰ" },
	["ᆶ-ᄂ"] 	 = { "ᆯᄅ",	"ll",	"lhn",	"ll",	"lhn",	"ɭɭ" },
	["ᆶ-ᄃ"] 	 = { "ᆯᄐ",	"lt",	"lhd",	"lt'",	"lht",	"ɭtʰ" },
	["ᆶ-ᄄ"] 	 = { "ᆯᄐ",	"lt",	"lhtt",	"lt'",	"lhtt",	"ɭtʰ" },
	["ᆶ-ᄅ"] 	 = { "ᆯᄅ",	"ll",	"lhl",	"ll",	"lhl",	"ɭɭ" },
	["ᆶ-ᄆ"] 	 = { "ᆯᄆ",	"lm",	"lhm",	"lm",	"lhm",	"ɭm" },
	["ᆶ-ᄇ"] 	 = { "ᆯᄑ",	"lp",	"lhb",	"lp'",	"lhp",	"ɭpʰ" },
	["ᆶ-ᄈ"] 	 = { "ᆯᄑ",	"lp",	"lhpp",	"lp'",	"lhpp",	"ɭpʰ" },
	["ᆶ-ᄉ"] 	 = { "ᆯᄊ",	"ls",	"lhs",	"lss",	"lhs",	"ɭs͈" },
	["ᆶ-ᄊ"] 	 = { "ᆯᄊ",	"lss",	"lhss",	"lss",	"lhss",	"ɭs͈" },
	["ᆶ-ᄋ"] 	 = { "ᄅ",	"r",	"lh-",	"r",	"lh.",	"ɾ" },
	["ᆶ-ᄌ"] 	 = { "ᆯᄎ",	"lch",	"lhj",	"lch'",	"lhc",	"ɭt͡ɕʰ" },
	["ᆶ-ᄍ"] 	 = { "ᆯᄎ",	"lch",	"lhjj",	"lch'",	"lhcc",	"ɭt͡ɕʰ" },
	["ᆶ-ᄎ"] 	 = { "ᆯᄎ",	"lch",	"lhch",	"lch'",	"lhch",	"ɭt͡ɕʰ" },
	["ᆶ-ᄏ"] 	 = { "ᆯᄏ",	"lk",	"lhk",	"lk'",	"lhkh",	"ɭkʰ" },
	["ᆶ-ᄐ"] 	 = { "ᆯᄐ",	"lt",	"lht",	"lt'",	"lhth",	"ɭtʰ" },
	["ᆶ-ᄑ"] 	 = { "ᆯᄑ",	"lp",	"lhp",	"lp'",	"lhph",	"ɭpʰ" },
	["ᆶ-ᄒ"] 	 = { "ᆯᄒ",	"lh",	"lhh",	"lh",	"lhh",	"ɾɦ" },
	["ᆷ-Ø"] 	 = { "ᆷ",	"m",	"m",	"m",	"m",	"m" },
	["ᆷ-ᄀ"] 	 = { "ᆷᄀ",	"mg",	"mg",	"mg",	"mk",	"mɡ" },
	["ᆷ-ᄁ"] 	 = { "ᆷᄁ",	"mkk",	"mkk",	"mkk",	"mkk",	"mk͈" },
	["ᆷ-ᄂ"] 	 = { "ᆷᄂ",	"mn",	"mn",	"mn",	"mn",	"mn" },
	["ᆷ-ᄃ"] 	 = { "ᆷᄃ",	"md",	"md",	"md",	"mt",	"md" },
	["ᆷ-ᄄ"] 	 = { "ᆷᄄ",	"mtt",	"mtt",	"mtt",	"mtt",	"mt͈" },
	["ᆷ-ᄅ"] 	 = { "ᆷᄂ",	"mn",	"ml",	"mn",	"ml",	"mn" },
	["ᆷ-ᄆ"] 	 = { "ᆷᄆ",	"mm",	"mm",	"mm",	"mm",	"mm" },
	["ᆷ-ᄇ"] 	 = { "ᆷᄇ",	"mb",	"mb",	"mb",	"mp",	"mb" },
	["ᆷ-ᄈ"] 	 = { "ᆷᄈ",	"mpp",	"mpp",	"mpp",	"mpp",	"mp͈" },
	["ᆷ-ᄉ"] 	 = { "ᆷᄉ",	"ms",	"ms",	"ms",	"ms",	"msʰ" },
	["ᆷ-ᄊ"] 	 = { "ᆷᄊ",	"mss",	"mss",	"mss",	"mss",	"ms͈" },
	["ᆷ-ᄋ"] 	 = { "ᄆ",	"m",	"m-",	"m",	"m.",	"m" },
	["ᆷ-ᄌ"] 	 = { "ᆷᄌ",	"mj",	"mj",	"mj",	"mc",	"md͡ʑ" },
	["ᆷ-ᄍ"] 	 = { "ᆷᄍ",	"mjj",	"mjj",	"mtch",	"mcc",	"mt͡ɕ͈" },
	["ᆷ-ᄎ"] 	 = { "ᆷᄎ",	"mch",	"mch",	"mch'",	"mch",	"mt͡ɕʰ" },
	["ᆷ-ᄏ"] 	 = { "ᆷᄏ",	"mk",	"mk",	"mk'",	"mkh",	"mkʰ" },
	["ᆷ-ᄐ"] 	 = { "ᆷᄐ",	"mt",	"mt",	"mt'",	"mth",	"mtʰ" },
	["ᆷ-ᄑ"] 	 = { "ᆷᄑ",	"mp",	"mp",	"mp'",	"mph",	"mpʰ" },
	["ᆷ-ᄒ"] 	 = { "ᆷᄒ",	"mh",	"mh",	"mh",	"mh",	"mɦ" },
	["ᆸ-Ø"] 	 = { "ᆸ",	"p",	"b",	"p",	"p",	"p̚" },
	["ᆸ-ᄀ"] 	 = { "ᆸᄁ",	"pg",	"bg",	"pk",	"pqk",	"p̚k͈" },
	["ᆸ-ᄁ"] 	 = { "ᆸᄁ",	"pkk",	"bkk",	"pkk",	"pkk",	"p̚k͈" },
	["ᆸ-ᄂ"] 	 = { "ᆷᄂ",	"mn",	"bn",	"mn",	"pn",	"mn" },
	["ᆸ-ᄃ"] 	 = { "ᆸᄄ",	"pd",	"bd",	"pt",	"pqt",	"p̚t͈" },
	["ᆸ-ᄄ"] 	 = { "ᆸᄄ",	"ptt",	"btt",	"ptt",	"ptt",	"p̚t͈" },
	["ᆸ-ᄅ"] 	 = { "ᆷᄂ",	"mn",	"bl",	"mn",	"pl",	"mn" },
	["ᆸ-ᄆ"] 	 = { "ᆷᄆ",	"mm",	"bm",	"mm",	"pm",	"mm" },
	["ᆸ-ᄇ"] 	 = { "ᆸᄈ",	"pb",	"bb",	"pp",	"pqp",	"p̚p͈" },
	["ᆸ-ᄈ"] 	 = { "ᆸᄈ",	"ppp",	"bpp",	"pp",	"ppp",	"p̚p͈" },
	["ᆸ-ᄉ"] 	 = { "ᆸᄊ",	"ps",	"bs",	"ps",	"pqs",	"ps͈" },
	["ᆸ-ᄊ"] 	 = { "ᆸᄊ",	"pss",	"bss",	"pss",	"pss",	"ps͈" },
	["ᆸ-ᄋ"] 	 = { "ᄇ",	"b",	"b-",	"b",	"p.",	"b" },
	["ᆸ-ᄌ"] 	 = { "ᆸᄍ",	"pj",	"bj",	"pch",	"pqc",	"p̚t͡ɕ͈" },
	["ᆸ-ᄍ"] 	 = { "ᆸᄍ",	"pjj",	"bjj",	"ptch",	"pcc",	"p̚t͡ɕ͈" },
	["ᆸ-ᄎ"] 	 = { "ᆸᄎ",	"pch",	"bch",	"pch'",	"pch",	"p̚t͡ɕʰ" },
	["ᆸ-ᄏ"] 	 = { "ᆸᄏ",	"pk",	"bk",	"pk'",	"pkh",	"p̚kʰ" },
	["ᆸ-ᄐ"] 	 = { "ᆸᄐ",	"pt",	"bt",	"pt'",	"pth",	"p̚tʰ" },
	["ᆸ-ᄑ"] 	 = { "ᆸᄑ",	"pp",	"bp",	"pp'",	"pph",	"p̚pʰ" },
	["ᆸ-ᄒ"] 	 = { "ᄑ",	"ph",	"b-h",	"ph",	"p.h",	"pʰ" },
	["ᆹ-Ø"] 	 = { "ᆸ",	"p",	"bs",	"p",	"ps",	"p̚" },
	["ᆹ-ᄀ"] 	 = { "ᆸᄁ",	"pg",	"bsg",	"pk",	"psqk",	"p̚k͈" },
	["ᆹ-ᄁ"] 	 = { "ᆸᄁ",	"pkk",	"bskk",	"pkk",	"pskk",	"p̚k͈" },
	["ᆹ-ᄂ"] 	 = { "ᆷᄂ",	"mn",	"bsn",	"mn",	"psn",	"mn" },
	["ᆹ-ᄃ"] 	 = { "ᆸᄄ",	"pd",	"bsd",	"pt",	"psqt",	"p̚t͈" },
	["ᆹ-ᄄ"] 	 = { "ᆸᄄ",	"ptt",	"bstt",	"ptt",	"pstt",	"p̚t͈" },
	["ᆹ-ᄅ"] 	 = { "ᆷᄂ",	"mn",	"bsl",	"mn",	"psl",	"mn" },
	["ᆹ-ᄆ"] 	 = { "ᆷᄆ",	"mm",	"bsm",	"mm",	"psm",	"mm" },
	["ᆹ-ᄇ"] 	 = { "ᆸᄈ",	"pb",	"bsb",	"pp",	"psqp",	"p̚p͈" },
	["ᆹ-ᄈ"] 	 = { "ᆸᄈ",	"ppp",	"bspp",	"pp",	"pspp",	"p̚p͈" },
	["ᆹ-ᄉ"] 	 = { "ᆸᄊ",	"ps",	"bss",	"ps",	"psqs",	"ps͈" },
	["ᆹ-ᄊ"] 	 = { "ᆸᄊ",	"pss",	"bsss",	"pss",	"psss",	"ps͈" },
	["ᆹ-ᄋ"] 	 = { "ᆸᄊ",	"ps",	"bs-",	"ps",	"ps.",	"ps͈" },
	["ᆹ-ᄌ"] 	 = { "ᆸᄍ",	"pj",	"bsj",	"pch",	"psqc",	"p̚t͡ɕ͈" },
	["ᆹ-ᄍ"] 	 = { "ᆸᄍ",	"pjj",	"bsjj",	"ptch",	"pscc",	"p̚t͡ɕ͈" },
	["ᆹ-ᄎ"] 	 = { "ᆸᄎ",	"pch",	"bsch",	"pch'",	"psch",	"p̚t͡ɕʰ" },
	["ᆹ-ᄏ"] 	 = { "ᆸᄏ",	"pk",	"bsk",	"pk'",	"pskh",	"p̚kʰ" },
	["ᆹ-ᄐ"] 	 = { "ᆸᄐ",	"pt",	"bst",	"pt'",	"psth",	"p̚tʰ" },
	["ᆹ-ᄑ"] 	 = { "ᆸᄑ",	"pp",	"bsp",	"pp'",	"psph",	"p̚pʰ" },
	["ᆹ-ᄒ"] 	 = { "ᄑ",	"ph",	"bsh",	"ph",	"psh",	"pʰ" },
	["ᆺ-Ø"] 	 = { "ᆮ",	"t",	"s",	"t",	"s",	"t̚" },
	["ᆺ-ᄀ"] 	 = { "ᆮᄁ",	"tg",	"sg",	"tk",	"sqk",	"t̚k͈" },
	["ᆺ-ᄁ"] 	 = { "ᆮᄁ",	"tkk",	"skk",	"tkk",	"skk",	"t̚k͈" },
	["ᆺ-ᄂ"] 	 = { "ᆫᄂ",	"nn",	"sn",	"nn",	"sn",	"nn" },
	["ᆺ-ᄃ"] 	 = { "ᆮᄄ",	"td",	"sd",	"tt",	"sqt",	"t̚t͈" },
	["ᆺ-ᄄ"] 	 = { "ᆮᄄ",	"ttt",	"stt",	"tt",	"stt",	"t̚t͈" },
	["ᆺ-ᄅ"] 	 = { "ᆫᄂ",	"nn",	"sl",	"nn",	"sl",	"nn" },
	["ᆺ-ᄆ"] 	 = { "ᆫᄆ",	"nm",	"sm",	"nm",	"sm",	"nm" },
	["ᆺ-ᄇ"] 	 = { "ᆮᄈ",	"tb",	"sb",	"tp",	"sqp",	"t̚p͈" },
	["ᆺ-ᄈ"] 	 = { "ᆮᄈ",	"tpp",	"spp",	"tpp",	"spp",	"t̚p͈" },
	["ᆺ-ᄉ"] 	 = { "ᆮᄊ",	"ts",	"ss",	"ss",	"sqs",	"t̚s͈" },
	["ᆺ-ᄊ"] 	 = { "ᆮᄊ",	"tss",	"sss",	"ss",	"sss",	"t̚s͈" },
	["ᆺ-ᄋ"] 	 = { "ᄉ",	"s",	"s-",	"s",	"s.",	"sʰ" },
	["ᆺ-ᄌ"] 	 = { "ᆮᄍ",	"tj",	"sj",	"tch",	"sqc",	"t̚t͡ɕ͈" },
	["ᆺ-ᄍ"] 	 = { "ᆮᄍ",	"tjj",	"sjj",	"tch",	"scc",	"t̚t͡ɕ͈" },
	["ᆺ-ᄎ"] 	 = { "ᆮᄎ",	"tch",	"sch",	"tch'",	"sch",	"t̚t͡ɕʰ" },
	["ᆺ-ᄏ"] 	 = { "ᆮᄏ",	"tk",	"sk",	"tk'",	"skh",	"t̚kʰ" },
	["ᆺ-ᄐ"] 	 = { "ᆮᄐ",	"tt",	"st",	"tt'",	"sth",	"t̚tʰ" },
	["ᆺ-ᄑ"] 	 = { "ᆮᄑ",	"tp",	"sp",	"tp'",	"sph",	"t̚pʰ" },
	["ᆺ-ᄒ"] 	 = { "ᄐ",	"th",	"sh",	"th",	"sh",	"tʰ" },
	["ᆻ-Ø"] 	 = { "ᆮ",	"t",	"ss",	"t",	"ss",	"t̚" },
	["ᆻ-ᄀ"] 	 = { "ᆮᄁ",	"tg",	"ssg",	"tk",	"ssqk",	"t̚k͈" },
	["ᆻ-ᄁ"] 	 = { "ᆮᄁ",	"tkk",	"sskk",	"tkk",	"sskk",	"t̚k͈" },
	["ᆻ-ᄂ"] 	 = { "ᆫᄂ",	"nn",	"ssn",	"nn",	"ssn",	"nn" },
	["ᆻ-ᄃ"] 	 = { "ᆮᄄ",	"td",	"ssd",	"tt",	"ssqt",	"t̚t͈" },
	["ᆻ-ᄄ"] 	 = { "ᆮᄄ",	"ttt",	"sstt",	"tt",	"sstt",	"t̚t͈" },
	["ᆻ-ᄅ"] 	 = { "ᆫᄂ",	"nn",	"ssl",	"nn",	"ssl",	"nn" },
	["ᆻ-ᄆ"] 	 = { "ᆫᄆ",	"nm",	"ssm",	"nm",	"ssm",	"nm" },
	["ᆻ-ᄇ"] 	 = { "ᆮᄈ",	"tb",	"ssb",	"tp",	"ssqp",	"t̚p͈" },
	["ᆻ-ᄈ"] 	 = { "ᆮᄈ",	"tpp",	"sspp",	"tpp",	"sspp",	"t̚p͈" },
	["ᆻ-ᄉ"] 	 = { "ᆮᄊ",	"ts",	"sss",	"ss",	"ssqs",	"t̚s͈" },
	["ᆻ-ᄊ"] 	 = { "ᆮᄊ",	"tss",	"ssss",	"ss",	"ssss",	"t̚s͈" },
	["ᆻ-ᄋ"] 	 = { "ᄊ",	"ss",	"ss-",	"ss",	"ss.",	"s͈" },
	["ᆻ-ᄌ"] 	 = { "ᆮᄍ",	"tj",	"ssj",	"tch",	"ssqc",	"t̚t͡ɕ͈" },
	["ᆻ-ᄍ"] 	 = { "ᆮᄍ",	"tjj",	"ssjj",	"tch",	"sscc",	"t̚t͡ɕ͈" },
	["ᆻ-ᄎ"] 	 = { "ᆮᄎ",	"tch",	"ssch",	"tch'",	"ssch",	"t̚t͡ɕʰ" },
	["ᆻ-ᄏ"] 	 = { "ᆮᄏ",	"tk",	"ssk",	"tk'",	"sskh",	"t̚kʰ" },
	["ᆻ-ᄐ"] 	 = { "ᆮᄐ",	"tt",	"sst",	"tt'",	"ssth",	"t̚tʰ" },
	["ᆻ-ᄑ"] 	 = { "ᆮᄑ",	"tp",	"ssp",	"tp'",	"ssph",	"t̚pʰ" },
	["ᆻ-ᄒ"] 	 = { "ᄐ",	"th",	"ss-h",	"th",	"ss.h",	"tʰ" },
	["ᆼ-Ø"] 	 = { "ᆼ",	"ng",	"ng",	"ng",	"ng",	"ŋ" },
	["ᆼ-ᄀ"] 	 = { "ᆼᄀ",	"ngg",	"ngg",	"ngg",	"ngk",	"ŋɡ" },
	["ᆼ-ᄁ"] 	 = { "ᆼᄁ",	"ngkk",	"ngkk",	"ngkk",	"ngkk",	"ŋk͈" },
	["ᆼ-ᄂ"] 	 = { "ᆼᄂ",	"ngn",	"ngn",	"ngn",	"ngn",	"ŋn" },
	["ᆼ-ᄃ"] 	 = { "ᆼᄃ",	"ngd",	"ngd",	"ngd",	"ngt",	"ŋd" },
	["ᆼ-ᄄ"] 	 = { "ᆼᄄ",	"ngtt",	"ngtt",	"ngtt",	"ngtt",	"ŋt͈" },
	["ᆼ-ᄅ"] 	 = { "ᆼᄂ",	"ngn",	"ngl",	"ngn",	"ngl",	"ŋn" },
	["ᆼ-ᄆ"] 	 = { "ᆼᄆ",	"ngm",	"ngm",	"ngm",	"ngm",	"ŋm" },
	["ᆼ-ᄇ"] 	 = { "ᆼᄇ",	"ngb",	"ngb",	"ngb",	"ngp",	"ŋb" },
	["ᆼ-ᄈ"] 	 = { "ᆼᄈ",	"ngpp",	"ngpp",	"ngpp",	"ngpp",	"ŋp͈" },
	["ᆼ-ᄉ"] 	 = { "ᆼᄉ",	"ngs",	"ngs",	"ngs",	"ngs",	"ŋsʰ" },
	["ᆼ-ᄊ"] 	 = { "ᆼᄊ",	"ngss",	"ngss",	"ngss",	"ngss",	"ŋs͈" },
	["ᆼ-ᄋ"] 	 = { "ᆼᄋ",	"ng-",	"ng-",	"ng",	"ng.",	"ŋ" },
	["ᆼ-ᄌ"] 	 = { "ᆼᄌ",	"ngj",	"ngj",	"ngj",	"ngc",	"ŋd͡ʑ" },
	["ᆼ-ᄍ"] 	 = { "ᆼᄍ",	"ngjj",	"ngjj",	"ngtch",	"ngcc",	"ŋt͡ɕ͈" },
	["ᆼ-ᄎ"] 	 = { "ᆼᄎ",	"ngch",	"ngch",	"ngch'",	"ngch",	"ŋt͡ɕʰ" },
	["ᆼ-ᄏ"] 	 = { "ᆼᄏ",	"ngk",	"ngk",	"ngk'",	"ngkh",	"ŋkʰ" },
	["ᆼ-ᄐ"] 	 = { "ᆼᄐ",	"ngt",	"ngt",	"ngt'",	"ngth",	"ŋtʰ" },
	["ᆼ-ᄑ"] 	 = { "ᆼᄑ",	"ngp",	"ngp",	"ngp'",	"ngph",	"ŋpʰ" },
	["ᆼ-ᄒ"] 	 = { "ᆼᄒ",	"ngh",	"ngh",	"ngh",	"ngh",	"ŋɦ" },
	["ᆽ-Ø"] 	 = { "ᆮ",	"t",	"j",	"t",	"c",	"t̚" },
	["ᆽ-ᄀ"] 	 = { "ᆮᄁ",	"tg",	"jg",	"tk",	"cqk",	"t̚k͈" },
	["ᆽ-ᄁ"] 	 = { "ᆮᄁ",	"tkk",	"jkk",	"tkk",	"ckk",	"t̚k͈" },
	["ᆽ-ᄂ"] 	 = { "ᆫᄂ",	"nn",	"jn",	"nn",	"cn",	"nn" },
	["ᆽ-ᄃ"] 	 = { "ᆮᄄ",	"td",	"jd",	"tt",	"cqt",	"t̚t͈" },
	["ᆽ-ᄄ"] 	 = { "ᆮᄄ",	"ttt",	"jtt",	"tt",	"ctt",	"t̚t͈" },
	["ᆽ-ᄅ"] 	 = { "ᆫᄂ",	"nn",	"jl",	"nn",	"cl",	"nn" },
	["ᆽ-ᄆ"] 	 = { "ᆫᄆ",	"nm",	"jm",	"nm",	"cm",	"nm" },
	["ᆽ-ᄇ"] 	 = { "ᆮᄈ",	"tb",	"jb",	"tp",	"cqp",	"t̚p͈" },
	["ᆽ-ᄈ"] 	 = { "ᆮᄈ",	"tpp",	"jpp",	"tpp",	"cpp",	"t̚p͈" },
	["ᆽ-ᄉ"] 	 = { "ᆮᄊ",	"ts",	"js",	"ss",	"cqs",	"t̚s͈" },
	["ᆽ-ᄊ"] 	 = { "ᆮᄊ",	"tss",	"jss",	"ss",	"css",	"t̚s͈" },
	["ᆽ-ᄋ"] 	 = { "ᄌ",	"j",	"j-",	"j",	"c.",	"d͡ʑ" },
	["ᆽ-ᄌ"] 	 = { "ᆮᄍ",	"tj",	"jj",	"tch",	"cqc",	"t̚t͡ɕ͈" },
	["ᆽ-ᄍ"] 	 = { "ᆮᄍ",	"tjj",	"jjj",	"tch",	"ccc",	"t̚t͡ɕ͈" },
	["ᆽ-ᄎ"] 	 = { "ᆮᄎ",	"tch",	"jch",	"tch'",	"cch",	"t̚t͡ɕʰ" },
	["ᆽ-ᄏ"] 	 = { "ᆮᄏ",	"tk",	"jk",	"tk'",	"ckh",	"t̚kʰ" },
	["ᆽ-ᄐ"] 	 = { "ᆮᄐ",	"tt",	"jt",	"tt'",	"cth",	"t̚tʰ" },
	["ᆽ-ᄑ"] 	 = { "ᆮᄑ",	"tp",	"jp",	"tp'",	"cph",	"t̚pʰ" },
	["ᆽ-ᄒ"] 	 = { "ᄎ",	"ch",	"j-h",	"ch'",	"c.h",	"t͡ɕʰ" },
	["ᆾ-Ø"] 	 = { "ᆮ",	"t",	"ch",	"t",	"ch",	"t̚" },
	["ᆾ-ᄀ"] 	 = { "ᆮᄁ",	"tg",	"chg",	"tk",	"chqk",	"t̚k͈" },
	["ᆾ-ᄁ"] 	 = { "ᆮᄁ",	"tkk",	"chkk",	"tkk",	"chkk",	"t̚k͈" },
	["ᆾ-ᄂ"] 	 = { "ᆫᄂ",	"nn",	"chn",	"nn",	"chn",	"nn" },
	["ᆾ-ᄃ"] 	 = { "ᆮᄄ",	"td",	"chd",	"tt",	"chqt",	"t̚t͈" },
	["ᆾ-ᄄ"] 	 = { "ᆮᄄ",	"ttt",	"chtt",	"tt",	"chtt",	"t̚t͈" },
	["ᆾ-ᄅ"] 	 = { "ᆫᄂ",	"nn",	"chl",	"nn",	"chl",	"nn" },
	["ᆾ-ᄆ"] 	 = { "ᆫᄆ",	"nm",	"chm",	"nm",	"chm",	"nm" },
	["ᆾ-ᄇ"] 	 = { "ᆮᄈ",	"tb",	"chb",	"tp",	"chqp",	"t̚p͈" },
	["ᆾ-ᄈ"] 	 = { "ᆮᄈ",	"tpp",	"chpp",	"tpp",	"chpp",	"t̚p͈" },
	["ᆾ-ᄉ"] 	 = { "ᆮᄊ",	"ts",	"chs",	"ss",	"chqs",	"t̚s͈" },
	["ᆾ-ᄊ"] 	 = { "ᆮᄊ",	"tss",	"chss",	"ss",	"chss",	"t̚s͈" },
	["ᆾ-ᄋ"] 	 = { "ᄎ",	"ch",	"ch-",	"ch",	"ch.",	"t͡ɕʰ" },
	["ᆾ-ᄌ"] 	 = { "ᆮᄍ",	"tj",	"chj",	"tch",	"chqc",	"t̚t͡ɕ͈" },
	["ᆾ-ᄍ"] 	 = { "ᆮᄍ",	"tjj",	"chjj",	"tch",	"chcc",	"t̚t͡ɕ͈" },
	["ᆾ-ᄎ"] 	 = { "ᆮᄎ",	"tch",	"chch",	"tch'",	"chch",	"t̚t͡ɕʰ" },
	["ᆾ-ᄏ"] 	 = { "ᆮᄏ",	"tk",	"chk",	"tk'",	"chkh",	"t̚kʰ" },
	["ᆾ-ᄐ"] 	 = { "ᆮᄐ",	"tt",	"cht",	"tt'",	"chth",	"t̚tʰ" },
	["ᆾ-ᄑ"] 	 = { "ᆮᄑ",	"tp",	"chp",	"tp'",	"chph",	"t̚pʰ" },
	["ᆾ-ᄒ"] 	 = { "ᄎ",	"th",	"ch-h",	"th",	"ch.h",	"t͡ɕʰ" },
	["ᆿ-Ø"] 	 = { "ᆨ",	"k",	"k",	"k",	"kh",	"k̚" },
	["ᆿ-ᄀ"] 	 = { "ᆨᄁ",	"kg",	"kg",	"kk",	"khqk",	"k̚k͈" },
	["ᆿ-ᄁ"] 	 = { "ᆨᄁ",	"kkk",	"kkk",	"kk",	"khkk",	"k̚k͈" },
	["ᆿ-ᄂ"] 	 = { "ᆼᄂ",	"ngn",	"kn",	"ngn",	"khn",	"ŋn" },
	["ᆿ-ᄃ"] 	 = { "ᆨᄄ",	"kd",	"kd",	"kt",	"khqt",	"k̚t͈" },
	["ᆿ-ᄄ"] 	 = { "ᆨᄄ",	"ktt",	"ktt",	"ktt",	"khtt",	"k̚t͈" },
	["ᆿ-ᄅ"] 	 = { "ᆼᄂ",	"ngn",	"kl",	"ngn",	"khl",	"ŋn" },
	["ᆿ-ᄆ"] 	 = { "ᆼᄆ",	"ngm",	"km",	"ngm",	"khm",	"ŋm" },
	["ᆿ-ᄇ"] 	 = { "ᆨᄈ",	"kb",	"kb",	"kp",	"khqp",	"k̚p͈" },
	["ᆿ-ᄈ"] 	 = { "ᆨᄈ",	"kpp",	"kpp",	"kpp",	"khpp",	"k̚p͈" },
	["ᆿ-ᄉ"] 	 = { "ᆨᄊ",	"ks",	"ks",	"ks",	"khqs",	"ks͈" },
	["ᆿ-ᄊ"] 	 = { "ᆨᄊ",	"kss",	"kss",	"kss",	"khss",	"ks͈" },
	["ᆿ-ᄋ"] 	 = { "ᄏ",	"k",	"k-",	"k'",	"kh.",	"kʰ" },
	["ᆿ-ᄌ"] 	 = { "ᆨᄍ",	"kj",	"kj",	"kch",	"khqc",	"k̚t͡ɕ͈" },
	["ᆿ-ᄍ"] 	 = { "ᆨᄍ",	"kjj",	"kjj",	"ktch",	"khcc",	"k̚t͡ɕ͈" },
	["ᆿ-ᄎ"] 	 = { "ᆨᄎ",	"kch",	"kch",	"kch'",	"khch",	"k̚t͡ɕʰ" },
	["ᆿ-ᄏ"] 	 = { "ᆨᄏ",	"kk",	"kk",	"kk'",	"khkh",	"k̚kʰ" },
	["ᆿ-ᄐ"] 	 = { "ᆨᄐ",	"kt",	"kt",	"kt'",	"khth",	"k̚tʰ" },
	["ᆿ-ᄑ"] 	 = { "ᆨᄑ",	"kp",	"kp",	"kp'",	"khph",	"k̚pʰ" },
	["ᆿ-ᄒ"] 	 = { "ᄏ",	"kh",	"k-h",	"kh",	"kh.h",	"kʰ" },
	["ᇀ-Ø"] 	 = { "ᆮ",	"t",	"t",	"t",	"th",	"t̚" },
	["ᇀ-ᄀ"] 	 = { "ᆮᄁ",	"tg",	"tg",	"tk",	"thqk",	"t̚k͈" },
	["ᇀ-ᄁ"] 	 = { "ᆮᄁ",	"tkk",	"tkk",	"tkk",	"thkk",	"t̚k͈" },
	["ᇀ-ᄂ"] 	 = { "ᆫᄂ",	"nn",	"tn",	"nn",	"thn",	"nn" },
	["ᇀ-ᄃ"] 	 = { "ᆮᄄ",	"td",	"td",	"tt",	"thqt",	"t̚t͈" },
	["ᇀ-ᄄ"] 	 = { "ᆮᄄ",	"ttt",	"ttt",	"tt",	"thtt",	"t̚t͈" },
	["ᇀ-ᄅ"] 	 = { "ᆫᄂ",	"nn",	"tl",	"nn",	"thl",	"nn" },
	["ᇀ-ᄆ"] 	 = { "ᆫᄆ",	"nm",	"tm",	"nm",	"thm",	"nm" },
	["ᇀ-ᄇ"] 	 = { "ᆮᄈ",	"tb",	"tb",	"tp",	"thqp",	"t̚p͈" },
	["ᇀ-ᄈ"] 	 = { "ᆮᄈ",	"tpp",	"tpp",	"tpp",	"thpp",	"t̚p͈" },
	["ᇀ-ᄉ"] 	 = { "ᆮᄊ",	"ts",	"ts",	"ss",	"thqs",	"t̚s͈" },
	["ᇀ-ᄊ"] 	 = { "ᆮᄊ",	"tss",	"tss",	"ss",	"thss",	"t̚s͈" },
	["ᇀ-ᄋ"] 	 = { "ᄐ",	"t",	"t-",	"t'",	"th.",	"tʰ" },
	["ᇀ-ᄌ"] 	 = { "ᆮᄍ",	"tj",	"tj",	"tch",	"thqc",	"t̚t͡ɕ͈" },
	["ᇀ-ᄍ"] 	 = { "ᆮᄍ",	"tjj",	"tjj",	"tch",	"thcc",	"t̚t͡ɕ͈" },
	["ᇀ-ᄎ"] 	 = { "ᆮᄎ",	"tch",	"tch",	"tch'",	"thch",	"t̚t͡ɕʰ" },
	["ᇀ-ᄏ"] 	 = { "ᆮᄏ",	"tk",	"tk",	"tk'",	"thkh",	"t̚kʰ" },
	["ᇀ-ᄐ"] 	 = { "ᆮᄐ",	"tt",	"tt",	"tt'",	"thth",	"t̚tʰ" },
	["ᇀ-ᄑ"] 	 = { "ᆮᄑ",	"tp",	"tp",	"tp'",	"thph",	"t̚pʰ" },
	["ᇀ-ᄒ"] 	 = { "ᄐ",	"th",	"t-h",	"th",	"th.h",	"tʰ" },
	["ᇁ-Ø"] 	 = { "ᆸ",	"p",	"p",	"p",	"ph",	"p̚" },
	["ᇁ-ᄀ"] 	 = { "ᆸᄁ",	"pg",	"pg",	"pk",	"phqk",	"p̚k͈" },
	["ᇁ-ᄁ"] 	 = { "ᆸᄁ",	"pkk",	"pkk",	"pkk",	"phkk",	"p̚k͈" },
	["ᇁ-ᄂ"] 	 = { "ᆷᄂ",	"mn",	"pn",	"mn",	"phn",	"mn" },
	["ᇁ-ᄃ"] 	 = { "ᆸᄄ",	"pd",	"pd",	"pt",	"phqt",	"p̚t͈" },
	["ᇁ-ᄄ"] 	 = { "ᆸᄄ",	"ptt",	"ptt",	"ptt",	"phtt",	"p̚t͈" },
	["ᇁ-ᄅ"] 	 = { "ᆷᄂ",	"mn",	"pl",	"mn",	"phl",	"mn" },
	["ᇁ-ᄆ"] 	 = { "ᆷᄆ",	"mm",	"pm",	"mm",	"phm",	"mm" },
	["ᇁ-ᄇ"] 	 = { "ᆸᄈ",	"pb",	"pb",	"pp",	"phqp",	"p̚p͈" },
	["ᇁ-ᄈ"] 	 = { "ᆸᄈ",	"ppp",	"ppp",	"pp",	"phpp",	"p̚p͈" },
	["ᇁ-ᄉ"] 	 = { "ᆸᄊ",	"ps",	"ps",	"ps",	"phqs",	"ps͈" },
	["ᇁ-ᄊ"] 	 = { "ᆸᄊ",	"pss",	"pss",	"pss",	"phss",	"ps͈" },
	["ᇁ-ᄋ"] 	 = { "ᄑ",	"p",	"p-",	"p'",	"ph.",	"pʰ" },
	["ᇁ-ᄌ"] 	 = { "ᆸᄍ",	"pj",	"pj",	"pch",	"phqc",	"p̚t͡ɕ͈" },
	["ᇁ-ᄍ"] 	 = { "ᆸᄍ",	"pjj",	"pjj",	"ptch",	"phcc",	"p̚t͡ɕ͈" },
	["ᇁ-ᄎ"] 	 = { "ᆸᄎ",	"pch",	"pch",	"pch'",	"phch",	"p̚t͡ɕʰ" },
	["ᇁ-ᄏ"] 	 = { "ᆸᄏ",	"pk",	"pk",	"pk'",	"phkh",	"p̚kʰ" },
	["ᇁ-ᄐ"] 	 = { "ᆸᄐ",	"pt",	"pt",	"pt'",	"phth",	"p̚tʰ" },
	["ᇁ-ᄑ"] 	 = { "ᆸᄑ",	"pp",	"pp",	"pp'",	"phph",	"p̚pʰ" },
	["ᇁ-ᄒ"] 	 = { "ᄑ",	"ph",	"p-h",	"ph",	"ph.h",	"pʰ" },
	["ᇂ-Ø"] 	 = { "ᆮ",	"",	"h",	"",	"h",	"t̚" },
	["ᇂ-ᄀ"] 	 = { "ᄏ",	"k",	"hg",	"k'",	"hk",	"kʰ" },
	["ᇂ-ᄁ"] 	 = { "ᄏ",	"k",	"hkk",	"k'",	"hkk",	"kʰ" },
	["ᇂ-ᄂ"] 	 = { "ᆫᄂ",	"nn",	"hn",	"nn",	"hn",	"nn" },
	["ᇂ-ᄃ"] 	 = { "ᄐ",	"t",	"hd",	"t'",	"ht",	"tʰ" },
	["ᇂ-ᄄ"] 	 = { "ᄐ",	"t",	"htt",	"t'",	"htt",	"tʰ" },
	["ᇂ-ᄅ"] 	 = { "ᆫᄂ",	"nn",	"hl",	"nn",	"hl",	"nn" },
	["ᇂ-ᄆ"] 	 = { "ᆷᄆ",	"nm",	"hm",	"nm",	"hm",	"mm" },
	["ᇂ-ᄇ"] 	 = { "ᄑ",	"p",	"hb",	"p'",	"hp",	"pʰ" },
	["ᇂ-ᄈ"] 	 = { "ᄑ",	"p",	"hpp",	"p'",	"hpp",	"pʰ" },
	["ᇂ-ᄉ"] 	 = { "ᄊ",	"s",	"hs",	"ss",	"hs",	"s͈" },
	["ᇂ-ᄊ"] 	 = { "ᆮᄊ",	"ss",	"hss",	"ss",	"hss",	"t̚s͈" },
	["ᇂ-ᄋ"] 	 = { "ᄋ",	"",	"h-",	"",	"h.",	"" },
	["ᇂ-ᄌ"] 	 = { "ᄎ",	"ch",	"hj",	"ch'",	"hc",	"t͡ɕʰ" },
	["ᇂ-ᄍ"] 	 = { "ᄎ",	"ch",	"hjj",	"ch'",	"hcc",	"t͡ɕʰ" },
	["ᇂ-ᄎ"] 	 = { "ᆮᄎ",	"tch",	"hch",	"tch'",	"hch",	"t̚t͡ɕʰ" },
	["ᇂ-ᄏ"] 	 = { "ᆮᄏ",	"k",	"hk",	"k'",	"hkh",	"t̚kʰ" },
	["ᇂ-ᄐ"] 	 = { "ᆮᄐ",	"t",	"ht",	"t'",	"hth",	"t̚tʰ" },
	["ᇂ-ᄑ"] 	 = { "ᆮᄑ",	"p",	"hp",	"p'",	"hph",	"t̚pʰ" },
	["ᇂ-ᄒ"] 	 = { "ᄐ",	"h",	"h-h",	"h",	"h.h",	"tʰ" },
}

return export