#ifndef MEMORY_POOL_H
#define MEMORY_POOL_H

#include "basic.h"

template < typename T, int SIZE >
class MemoryPool {
private:
    T data_[SIZE];
    int next_[SIZE];
    int free_;

public:
    MemoryPool()
    : free_(0) {
        for (int i = 1; i < SIZE; ++i)
            next_[i - 1] = i;
        next_[SIZE - 1] = -1;
    }

    bool full() { return free_ != -1; }

    T* malloc() {
        T* ptr = nullptr;
        if (free_ != -1) {
            ptr = &data_[free_];
            free_ = next_[free_];

            LOG_DEBUG(<< "Allocate #<" << TYPENAME(T) << '@'
                      << ptr - data_ << ">");
        }
        return ptr;
    }

    void free(T* ptr) {
        auto offset = ptr - data_;

        LOG_DEBUG(<< "Deallocate #<" << TYPENAME(T) << '@'
                  << offset << ">");

        if (free_ == -1)
            free_ = offset;
        else {
            next_[offset] = free_;
            free_ = offset;
        }
    }
};

#endif /* MEMORY_POOL_H */

// Local Variables:
// mode: c++
// End:
