#ifndef _RUN_H
#define _RUN_H

#include <string>

class RunBase {
public:
    virtual ~RunBase(){};

    virtual void train(const std::string& input_file,
                       const std::string& rules_file,
                       const std::string& feature_input,
                       const std::string& feature_output) const = 0;

    virtual void transduce(const std::string& input_file,
                           const std::string& output_file,
                           const std::string& rules_file,
                           const std::string& feature_file,
                           bool with_detail) const = 0;

    virtual void goldTest(const std::string& input_file,
                          const std::string& rules_file,
                          const std::string& feature_input) const = 0;

    virtual void initialize() const = 0;
};

#endif

// Local Variables:
// mode: c++
// End:
