/*
 * Decompiled with CFR 0.152.
 */
package org.ardverk.collection;

import java.io.Serializable;
import org.ardverk.collection.AbstractKeyAnalyzer;

public class CharacterKeyAnalyzer
extends AbstractKeyAnalyzer<Character>
implements Serializable {
    private static final long serialVersionUID = 5267330596735811400L;
    public static final CharacterKeyAnalyzer CHAR = new CharacterKeyAnalyzer(16);
    public static final CharacterKeyAnalyzer BYTE = new CharacterKeyAnalyzer(8);
    @Deprecated
    public static final CharacterKeyAnalyzer INSTANCE = CHAR;
    private final int size;
    private final int msb;

    private CharacterKeyAnalyzer(int n) {
        this(n, 1 << n - 1);
    }

    private CharacterKeyAnalyzer(int n, int n2) {
        this.size = n;
        this.msb = n2;
    }

    private int mask(int n) {
        return this.msb >>> n;
    }

    private char valueOf(Character c) {
        char c2 = c.charValue();
        if (this.size == 8) {
            c2 = (char)(c2 & 0xFF);
        }
        return c2;
    }

    @Override
    public int lengthInBits(Character c) {
        return this.size;
    }

    @Override
    public boolean isBitSet(Character c, int n) {
        return (c.charValue() & this.mask(n)) != 0;
    }

    @Override
    public int bitIndex(Character c, Character c2) {
        char c3 = this.valueOf(c);
        char c4 = this.valueOf(c2);
        if (c3 == '\u0000') {
            return -1;
        }
        if (c3 != c4) {
            int n = c3 ^ c4;
            for (int i = 0; i < this.size; ++i) {
                if ((n & this.mask(i)) == 0) continue;
                return i;
            }
        }
        return -2;
    }

    @Override
    public boolean isPrefix(Character c, Character c2) {
        return c.equals(c2);
    }
}

