function [ppl] = Evaluate_obj(net, forgetting_matrix, sent_ind, sent_len, para)
%
%%usage: [ppl] = Evaluate_obj(net, forgetting_matrix,  sent_ind, sent_len, para)
ppl = 0;
nLayers = length(para.NNsize);
nClass= para.NNsize(nLayers);
totalSent = length(sent_len);
%%if the sentences have N words, there are N-para.n_words models.
totalSamples = sum(sent_len) - para.n_words*totalSent;
sentPerBatch = 20;
nBatches = floor( totalSent / sentPerBatch);
numSent = nBatches * sentPerBatch;
for batch = 1 : nBatches
        x      = [];
        t      = [];
        sent_st = (batch - 1) * sentPerBatch + 1;
        for i = sent_st : sent_st + sentPerBatch -1
            cur_len= sent_len(i) - para.n_words;
            M  = forgetting_matrix(1:cur_len,1:cur_len);
            tmp_x  = [];
            for j = 1 : para.n_words
                ind = sent_ind{i}(j:cur_len+j-1)';
                tmp_x = [tmp_x M*net.codeBook(ind,:)];     
            end
            x = [x;tmp_x];
            %%target
            ind = sent_ind{i}(para.n_words+1:end)';
            t= [t; ind];
        end
        ppl = ppl + gather(Calculate_ppl(x, t, net, para));
end
if(numSent < totalSent)
    x      = [];
    t      = [];
    for i = nBatches * sentPerBatch + 1 : totalSent
        cur_len = sent_len(i) - para.n_words;
        M       = forgetting_matrix(1:cur_len,1:cur_len);
        tmp_x   = [];
        for j = 1 : para.n_words
            ind = sent_ind{i}(j:cur_len+j-1)';
            tmp_x = [tmp_x M*net.codeBook(ind,:)];    
        end
        x = [x;tmp_x];
        %%target
        ind = sent_ind{i}(para.n_words+1:end)';
        t= [t; ind];
    end
    ppl = ppl + gather(Calculate_ppl(x, t, net, para));
end
ppl = exp(-ppl/totalSamples);