/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.io;

import fig.basic.LogInfo;
import fig.basic.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class WSJReader {
    private BufferedReader inputReader;

    public WSJReader() {
    }

    public WSJReader(String file) {
        try {
            this.inputReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initReader(String file) {
        try {
            this.inputReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Pair<String, String>> readSent() {
        ArrayList<Pair<String, String>> sent = new ArrayList<Pair<String, String>>();
        boolean startRead = false;
        try {
            String line;
            while ((line = this.inputReader.readLine()) != null) {
                if ((line = line.trim()).equals("")) {
                    if (!startRead) continue;
                    break;
                }
                if (line.startsWith("====")) {
                    if (!startRead) continue;
                    break;
                }
                startRead = true;
                if (line.startsWith("[ ")) {
                    line = line.substring(2, line.length() - 2);
                }
                sent.addAll(this.extractLine(line));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sent;
    }

    public List<Pair<String, String>> extractLine(String line) {
        ArrayList<Pair<String, String>> wordPosPairs = new ArrayList<Pair<String, String>>();
        String[] wordPosArray = line.split("\\s+");
        int i = 0;
        while (i < wordPosArray.length) {
            int index = wordPosArray[i].indexOf("/");
            System.out.println(wordPosArray[i]);
            String word = wordPosArray[i].substring(0, index);
            String pos = wordPosArray[i].substring(index + 1);
            Pair<String, String> wordPosPair = new Pair<String, String>(word, pos);
            wordPosPairs.add(wordPosPair);
            ++i;
        }
        return wordPosPairs;
    }

    public List<List<Pair<String, String>>> readDirectory(String path) {
        ArrayList<List<Pair<String, String>>> sents = new ArrayList<List<Pair<String, String>>>();
        File filepath = new File(path);
        if (filepath.isDirectory()) {
            String[] files;
            String[] stringArray = files = filepath.list();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String newFilePath = stringArray[n2];
                newFilePath = String.valueOf(path) + "/" + newFilePath;
                List<List<Pair<String, String>>> childSents = this.readDirectory(newFilePath);
                if (childSents.size() != 0) {
                    sents.addAll(childSents);
                }
                ++n2;
            }
        } else {
            List<Pair<String, String>> sent;
            this.initReader(path);
            LogInfo.logs("Log file %s", path);
            while ((sent = this.readSent()).size() != 0) {
                sents.add(sent);
            }
        }
        return sents;
    }

    public void readAllSents(String path) {
        List<List<Pair<String, String>>> sents = this.readDirectory(path);
        LogInfo.logs("There are totally %d sents.", sents.size());
        int i = 0;
        while (i < 4) {
            List<Pair<String, String>> sent = sents.get(i);
            for (Pair<String, String> wordPOS : sent) {
                LogInfo.logs("%s/%s", wordPOS.getFirst(), wordPOS.getSecond());
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        WSJReader wsj = new WSJReader();
        wsj.readDirectory("eng-pos/wsj");
    }
}

