/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.dualdecomp;

import edu.pku.coli.dualdecomp.AbstractDecoder;
import edu.pku.coli.pear.dag.PredicateArgumentAdjunctDAG;
import edu.pku.coli.pear.dag.SentenceForDAGParsing;
import fig.basic.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class PredicateCentricDecoder
extends AbstractDecoder {
    private static final long serialVersionUID = 4169854071583855254L;
    int[] maxPosArg;
    boolean[][] posArcFilter;
    transient double[][][] scores;

    public PredicateCentricDecoder() {
        this.featureExtractor = new FeatureExtractor();
    }

    public PredicateCentricDecoder(int maxSib) {
        this.featureExtractor = new FeatureExtractor();
        this._maxSibling = maxSib;
    }

    @Override
    public void train(List<SentenceForDAGParsing> trainset, List<SentenceForDAGParsing> devset) {
        this.maxPosArg = new int[SentenceForDAGParsing.posIndexer.size()];
        this.posArcFilter = new boolean[SentenceForDAGParsing.posIndexer.size()][SentenceForDAGParsing.posIndexer.size()];
        if (this.prune) {
            for (SentenceForDAGParsing s : trainset) {
                PredicateArgumentAdjunctDAG dag = s.getGoldDAG();
                int i = 0;
                while (i <= s.numOfWords()) {
                    List<PredicateArgumentAdjunctDAG.ArcInfo> arcs;
                    int numOfArg;
                    int posi = s.getKthPosIndex(i);
                    if (this.maxPosArg[posi] < (numOfArg = (arcs = dag.getAdjacencyLists()[i].getOutArcs()).size())) {
                        this.maxPosArg[posi] = numOfArg;
                    }
                    for (PredicateArgumentAdjunctDAG.ArcInfo arc : arcs) {
                        int posj = s.getKthPosIndex(arc.index);
                        this.posArcFilter[posi][posj] = true;
                    }
                    ++i;
                }
            }
        } else {
            Arrays.fill(this.maxPosArg, Integer.MAX_VALUE);
            int i = 0;
            while (i < this.posArcFilter.length) {
                int j = 0;
                while (j < this.posArcFilter[i].length) {
                    this.posArcFilter[i][j] = true;
                    ++j;
                }
                ++i;
            }
        }
        System.out.println(Arrays.toString(this.maxPosArg));
        int i = 0;
        while (i < this.posArcFilter.length) {
            System.out.println(Arrays.toString(this.posArcFilter[i]));
            ++i;
        }
        super.train(trainset, devset);
    }

    @Override
    public SentenceForDAGParsing toDAGSentence(SentenceForDAGParsing sent, int[][] var) {
        int sentLen = sent.numOfWords();
        PredicateArgumentAdjunctDAG sys = new PredicateArgumentAdjunctDAG(sentLen);
        int i = 0;
        while (i <= sentLen) {
            int j = 0;
            while (j <= sentLen) {
                if (var[i][j] == 1) {
                    sys.addArc(i, j, "X");
                }
                ++j;
            }
            ++i;
        }
        sent.setPredictedDAG(sys);
        return sent;
    }

    @Override
    public int[][] toVariable(SentenceForDAGParsing sent) {
        int sentLen = sent.numOfWords();
        int[][] var = new int[sentLen + 1][sentLen + 1];
        PredicateArgumentAdjunctDAG dag = sent.getGoldDAG();
        for (Pair<Integer, Integer> arc : dag.toUnlabeledPairs()) {
            var[arc.getFirst().intValue()][arc.getSecond().intValue()] = 1;
        }
        return var;
    }

    @Override
    public int[][] decodeAfterScoring(double[][] additionalWeight) {
        SentenceForDAGParsing sent = this.curSent;
        double totalScore = 0.0;
        int sentLen = sent.numOfWords();
        int[][] var = new int[sentLen + 1][sentLen + 1];
        int i = 0;
        while (i <= sentLen) {
            double[][] scoresi = new double[sentLen + 1][];
            int j = 0;
            while (j <= sentLen) {
                scoresi[j] = Arrays.copyOf(this.scores[i][j], sentLen + 1);
                int k = j;
                while (k < sentLen) {
                    double[] dArray = scoresi[j];
                    int n = k;
                    dArray[n] = dArray[n] + additionalWeight[i][k + 1];
                    ++k;
                }
                ++j;
            }
            int posi = sent.getKthPosIndex(i);
            int maxNumOfArg = sentLen - 1;
            if (this.maxPosArg != null) {
                maxNumOfArg = Math.min(maxNumOfArg, this.maxPosArg[posi]);
            }
            double[][] table = new double[maxNumOfArg + 1][sentLen + 1];
            int[][] bp = new int[maxNumOfArg + 1][sentLen + 1];
            int k = 0;
            while (k < sentLen + 1) {
                table[0][k] = scoresi[0][k];
                ++k;
            }
            int j2 = 1;
            while (j2 <= maxNumOfArg) {
                int k2 = j2;
                while (k2 < sentLen + 1) {
                    double max = Double.NEGATIVE_INFINITY;
                    int l = j2 - 1;
                    while (l < k2) {
                        double s = table[j2 - 1][l] + scoresi[l + 1][k2];
                        if (s >= max) {
                            max = s;
                            bp[j2][k2] = l;
                        }
                        ++l;
                    }
                    table[j2][k2] = max;
                    ++k2;
                }
                ++j2;
            }
            double maxScore = Double.NEGATIVE_INFINITY;
            int nArg = -1;
            int j3 = 0;
            while (j3 <= maxNumOfArg) {
                if (table[j3][sentLen] >= maxScore) {
                    nArg = j3;
                    maxScore = table[j3][sentLen];
                }
                ++j3;
            }
            int last = bp[nArg][sentLen];
            if (nArg != 0) {
                var[i][last + 1] = 1;
                int j4 = nArg - 1;
                while (j4 > 0) {
                    last = bp[j4][last];
                    var[i][last + 1] = 1;
                    --j4;
                }
            }
            totalScore += maxScore;
            ++i;
        }
        return var;
    }

    @Override
    public void scoreFeats(final float[] param) {
        final SentenceForDAGParsing sent = this.curSent;
        final FeatureExtractor fe = (FeatureExtractor)this.featureExtractor;
        int sentLen = sent.numOfWords();
        this.scores = new double[sentLen + 1][sentLen + 1][sentLen + 1];
        int i = 0;
        while (i <= sentLen) {
            int k;
            int posi = sent.getKthPosIndex(i);
            double[][] scoresi = this.scores[i];
            ExecutorService es = Executors.newFixedThreadPool(this.threadNum);
            ExecutorCompletionService<Double> group = new ExecutorCompletionService<Double>(es);
            Future[][] results = new Future[sentLen + 1][sentLen + 1];
            int j = 0;
            while (j <= sentLen) {
                k = j;
                while (k <= sentLen) {
                    block15: {
                        block14: {
                            if (this.posArcFilter == null || j == 0 || k == sentLen) break block14;
                            int posj = sent.getKthPosIndex(j);
                            int posk = sent.getKthPosIndex(k + 1);
                            if (!this.posArcFilter[posi][posj] || !this.posArcFilter[posi][posk]) break block15;
                        }
                        final int fi = i;
                        final int fj = j;
                        final int fk = k;
                        results[j][k] = group.submit(new Callable<Double>(){

                            @Override
                            public Double call() {
                                return fe.scoreSiblings(fi, fj, fk + 1, sent, param);
                            }
                        });
                    }
                    ++k;
                }
                ++j;
            }
            es.shutdown();
            j = 0;
            while (j <= sentLen) {
                k = j;
                while (k <= sentLen) {
                    if (results[j][k] == null) {
                        scoresi[j][k] = Double.NEGATIVE_INFINITY;
                    } else {
                        try {
                            scoresi[j][k] = (Double)results[j][k].get();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        catch (ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    class FeatureExtractor
    extends AbstractDecoder.FeatureExtractor {
        private static final long serialVersionUID = -4447534434468649991L;

        FeatureExtractor() {
        }

        @Override
        List<Integer> extract(SentenceForDAGParsing sent, boolean predicted) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            int sentLen = sent.numOfWords();
            PredicateArgumentAdjunctDAG dag = sent.getGoldDAG();
            if (predicted) {
                dag = sent.getPredictedDAG();
            }
            int i = 0;
            while (i <= sentLen) {
                PredicateArgumentAdjunctDAG.PredicateArgumentAdjunctArcAdjacencyList arcs = dag.getAdjacencyLists()[i];
                List<PredicateArgumentAdjunctDAG.ArcInfo> outArcs = arcs.getOutArcs();
                if (!outArcs.isEmpty()) {
                    ret.addAll(this.siblingFeats(i, 0, outArcs.get((int)0).index, sent));
                    int j = 1;
                    while (j < outArcs.size()) {
                        ret.addAll(this.siblingFeats(i, outArcs.get((int)(j - 1)).index, outArcs.get((int)j).index, sent));
                        ++j;
                    }
                    ret.addAll(this.siblingFeats(i, outArcs.get((int)(outArcs.size() - 1)).index, sentLen + 1, sent));
                } else {
                    ret.addAll(this.siblingFeats(i, 0, sentLen + 1, sent));
                }
                ++i;
            }
            return ret;
        }

        @Deprecated
        public List<Integer> numOfSiblingFeats(int head, int numOfSibling, SentenceForDAGParsing sent) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            int n = 42;
            int headWord = sent.getKthWordIndex(head);
            int headPos = sent.getKthWordIndex(head);
            int preHeadWord = sent.getKthWordIndex(head - 1);
            int postHeadWord = sent.getKthWordIndex(head + 1);
            int preHeadPos = sent.getKthPosIndex(head - 1);
            int postHeadPos = sent.getKthPosIndex(head + 1);
            ret.add(PredicateCentricDecoder.this.hashInts(n++, numOfSibling, headWord));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, numOfSibling, headPos));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, numOfSibling, headWord, headPos));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, numOfSibling, preHeadWord));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, numOfSibling, preHeadPos));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, numOfSibling, preHeadWord, preHeadPos));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, numOfSibling, postHeadWord));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, numOfSibling, postHeadPos));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, numOfSibling, postHeadWord, postHeadPos));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, numOfSibling, headWord, headPos, preHeadWord, preHeadPos));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, numOfSibling, headWord, headPos, preHeadPos));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, numOfSibling, headPos, preHeadWord, preHeadPos));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, numOfSibling, headPos, preHeadPos));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, numOfSibling, headWord, headPos, postHeadWord, postHeadPos));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, numOfSibling, headWord, headPos, postHeadPos));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, numOfSibling, headPos, postHeadWord, postHeadPos));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, numOfSibling, headPos, postHeadPos));
            return ret;
        }

        @Deprecated
        public double scoreNumOfSibling(int head, int numOfSibling, SentenceForDAGParsing sent, float[] param) {
            return PredicateCentricDecoder.this.score(this.numOfSiblingFeats(head, numOfSibling, sent), param);
        }

        public List<Integer> siblingFeats(int head, int prev, int cur, SentenceForDAGParsing sent) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            int n = 1024;
            int headWord = sent.getKthWordIndex(head);
            int headPos = sent.getKthWordIndex(head);
            int preHeadWord = sent.getKthWordIndex(head - 1);
            int postHeadWord = sent.getKthWordIndex(head + 1);
            int preHeadPos = sent.getKthPosIndex(head - 1);
            int postHeadPos = sent.getKthPosIndex(head + 1);
            int curWord = sent.getKthWordIndex(cur);
            int curPos = sent.getKthPosIndex(cur);
            int preCurWord = sent.getKthWordIndex(cur - 1);
            int postCurWord = sent.getKthWordIndex(cur + 1);
            int preCurPos = sent.getKthPosIndex(cur - 1);
            int postCurPos = sent.getKthPosIndex(cur + 1);
            int prevWord = sent.getKthWordIndex(prev);
            int prevPos = sent.getKthPosIndex(prev);
            int prePrevWord = sent.getKthWordIndex(prev - 1);
            int postPrevWord = sent.getKthWordIndex(prev + 1);
            int prePrevPos = sent.getKthPosIndex(prev - 1);
            int postPrevPos = sent.getKthPosIndex(prev + 1);
            int distCur = PredicateCentricDecoder.this.distMap(head - cur);
            int distCurPrev = PredicateCentricDecoder.this.distMap(cur - prev);
            int distPrev = PredicateCentricDecoder.this.distMap(head - prev);
            int order = distCur > 0 ? 1 : (distPrev < 0 ? 2 : 3);
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, curPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, distCurPrev));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, distCurPrev));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prevPos, distCurPrev));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prevPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, preHeadWord, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, preHeadPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, preHeadWord, preHeadPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, preCurWord, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, preCurPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, preCurWord, preCurPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prePrevWord, distCurPrev));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prePrevPos, distCurPrev));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prePrevWord, prePrevPos, distCurPrev));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, postHeadWord, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, postHeadPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, postHeadWord, postHeadPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, postCurWord, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, postCurPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, postCurWord, postCurPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, postPrevWord, distCurPrev));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, postPrevPos, distCurPrev));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, postPrevWord, postPrevPos, distCurPrev));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, preHeadWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, preHeadPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, preHeadWord, preHeadPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, preCurWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, preCurPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, preCurWord, preCurPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prePrevWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prePrevPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prePrevWord, prePrevPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, postHeadWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, postHeadPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, postHeadWord, postHeadPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, postCurWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, postCurPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, postCurWord, postCurPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, postPrevWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, postPrevPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, postPrevWord, postPrevPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, curWord, curPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, curWord, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, curPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, curWord, curPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, curWord, curPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, curWord, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, curPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prevPos, curWord, curPos, distCurPrev));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prevPos, curWord, distCurPrev));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prevPos, curPos, distCurPrev));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, curWord, curPos, distCurPrev));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, curWord, curPos, distCurPrev));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, curWord, distCurPrev));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, curPos, distCurPrev));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, curWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, curWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, curWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prevPos, curWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prevPos, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prevPos, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, curWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, curWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, preHeadWord, preHeadPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, preHeadPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, preHeadWord, preHeadPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, preHeadPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, postHeadWord, postHeadPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, postHeadPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, postHeadWord, postHeadPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, postHeadPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, preHeadWord, preHeadPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, preHeadPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, preHeadWord, preHeadPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, preHeadPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, postHeadWord, postHeadPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, postHeadPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, postHeadWord, postHeadPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, postHeadPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, curPos, preCurWord, preCurPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, curPos, preCurPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curPos, preCurWord, preCurPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curPos, preCurPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, curPos, postCurWord, postCurPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, curPos, postCurPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curPos, postCurWord, postCurPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curPos, postCurPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, curPos, preCurWord, preCurPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, curPos, preCurPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curPos, preCurWord, preCurPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curPos, preCurPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, curPos, postCurWord, postCurPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, curPos, postCurPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curPos, postCurWord, postCurPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curPos, postCurPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, curPos, preHeadWord, preHeadPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, curPos, preHeadPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curPos, preHeadWord, preHeadPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curPos, preHeadPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, curPos, postHeadWord, postHeadPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, curPos, postHeadPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curPos, postHeadWord, postHeadPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curPos, postHeadPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, curPos, preHeadWord, preHeadPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, curPos, preHeadPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curPos, preHeadWord, preHeadPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curPos, preHeadPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, curPos, postHeadWord, postHeadPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, curPos, postHeadPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curPos, postHeadWord, postHeadPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curPos, postHeadPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, preCurWord, preCurPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, preCurPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, preCurWord, preCurPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, preCurPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, postCurWord, postCurPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, postCurPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, postCurWord, postCurPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, postCurPos, distCur));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, preCurWord, preCurPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, preCurPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, preCurWord, preCurPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, preCurPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, postCurWord, postCurPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, postCurPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, postCurWord, postCurPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, postCurPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, prevWord, prevPos, curWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, prevWord, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, prevWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, prevPos, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, prevPos, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, prevWord, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, prevWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, prevPos, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, prevPos, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, preCurWord, preCurPos, curWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, preCurWord, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, preCurWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, preCurPos, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, preCurPos, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, preCurWord, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, preCurWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, preCurPos, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, preCurPos, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, postCurWord, postCurPos, curWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, postCurWord, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, postCurWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, postCurPos, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, postCurPos, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, postCurWord, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, postCurWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, postCurPos, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, postCurPos, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, preHeadWord, preHeadPos, curWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, preHeadWord, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, preHeadWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, preHeadPos, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, preHeadPos, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, preHeadWord, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, preHeadWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, preHeadPos, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, preHeadPos, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, postHeadWord, postHeadPos, curWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, postHeadWord, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, postHeadWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, postHeadPos, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, postHeadPos, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, postHeadWord, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, postHeadWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, postHeadPos, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, postHeadPos, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prevPos, preCurWord, preCurPos, curWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, preCurWord, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, preCurWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, preCurPos, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, preCurPos, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, preCurWord, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, preCurWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, preCurPos, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, preCurPos, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prevPos, postCurWord, postCurPos, curWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, postCurWord, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, postCurWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, postCurPos, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, postCurPos, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, postCurWord, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, postCurWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, postCurPos, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, postCurPos, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prevPos, prePrevWord, prePrevPos, curWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prePrevWord, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prePrevWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prePrevPos, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prePrevPos, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, prePrevWord, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, prePrevWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, prePrevPos, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, prePrevPos, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prevPos, postPrevWord, postPrevPos, curWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, postPrevWord, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, postPrevWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, postPrevPos, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, postPrevPos, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, postPrevWord, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, postPrevWord, curPos, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, postPrevPos, curWord, order));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, postPrevPos, curPos, order));
            PredicateArgumentAdjunctDAG tree = sent.getSyntaxTree();
            if (PredicateCentricDecoder.this.usePathFeat && tree != null && !tree.isEmpty() && cur <= sent.numOfWords()) {
                char p;
                int pos;
                PredicateArgumentAdjunctDAG.ArcInfo parentArc;
                ArrayList<Integer> curToRoot = new ArrayList<Integer>();
                ArrayList<Integer> headToRoot = new ArrayList<Integer>();
                int t = cur;
                while ((parentArc = tree.getOneParent(t)) != null) {
                    curToRoot.add(t);
                    t = parentArc.index;
                }
                curToRoot.add(t);
                t = head;
                while ((parentArc = tree.getOneParent(t)) != null) {
                    headToRoot.add(t);
                    t = parentArc.index;
                }
                headToRoot.add(t);
                int leastCommonAncestor = 1;
                while (leastCommonAncestor <= curToRoot.size() && leastCommonAncestor <= headToRoot.size() && curToRoot.get(curToRoot.size() - leastCommonAncestor) == headToRoot.get(headToRoot.size() - leastCommonAncestor)) {
                    ++leastCommonAncestor;
                }
                int pathPoss = n++;
                int pathP = n++;
                int i = 0;
                while (i <= curToRoot.size() - leastCommonAncestor) {
                    pos = sent.getKthPosIndex((Integer)curToRoot.get(i));
                    p = sent.getKthPos((Integer)curToRoot.get(i)).charAt(0);
                    pathPoss = 31 * pathPoss + pos;
                    pathP = 31 * pathP + p;
                    ++i;
                }
                pathPoss = -pathPoss;
                pathP = -pathP;
                if (leastCommonAncestor > 1) {
                    int pos2 = sent.getKthPosIndex((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1));
                    char p2 = sent.getKthPos((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1)).charAt(0);
                    pathPoss = 31 * pathPoss + pos2;
                    pathPoss = 31 * pathPoss + SentenceForDAGParsing.posIndexer.size();
                    pathP = 31 * pathP + p2;
                    pathP = 31 * pathP + 255;
                }
                i = headToRoot.size() - leastCommonAncestor;
                while (i >= 0) {
                    pos = sent.getKthPosIndex((Integer)headToRoot.get(i));
                    p = sent.getKthPos((Integer)headToRoot.get(i)).charAt(0);
                    pathPoss = 31 * pathPoss + pos;
                    pathP = 31 * pathP + p;
                    --i;
                }
                ret.add(PredicateCentricDecoder.this.hashInts(pathPoss));
                ret.add(PredicateCentricDecoder.this.hashInts(pathP));
                ret.add(PredicateCentricDecoder.this.hashInts(pathPoss, distCur));
                ret.add(PredicateCentricDecoder.this.hashInts(pathP, distCur));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathPoss, headWord, headPos, curWord, curPos, distCur));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathPoss, headWord, headPos, curWord, distCur));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathPoss, headWord, headPos, curPos, distCur));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathPoss, headWord, curWord, curPos, distCur));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathPoss, headPos, curWord, curPos, distCur));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathPoss, headWord, curWord, distCur));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathPoss, headPos, curPos, distCur));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathP, headWord, headPos, curWord, curPos, distCur));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathP, headWord, headPos, curWord, distCur));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathP, headWord, headPos, curPos, distCur));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathP, headWord, curWord, curPos, distCur));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathP, headPos, curWord, curPos, distCur));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathP, headWord, curWord, distCur));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathP, headPos, curPos, distCur));
            }
            if (sent.getMoreSyntaxTrees() != null && cur <= sent.numOfWords()) {
                for (PredicateArgumentAdjunctDAG mtree : sent.getMoreSyntaxTrees()) {
                    char p;
                    int pos;
                    PredicateArgumentAdjunctDAG.ArcInfo parentArc;
                    ArrayList<Integer> curToRoot = new ArrayList<Integer>();
                    ArrayList<Integer> headToRoot = new ArrayList<Integer>();
                    ArrayList<String> stkTopToRootLabels = new ArrayList<String>();
                    ArrayList<String> queTopToRootLabels = new ArrayList<String>();
                    int t = cur;
                    while ((parentArc = mtree.getOneParent(t)) != null) {
                        curToRoot.add(t);
                        stkTopToRootLabels.add(parentArc.label);
                        t = parentArc.index;
                    }
                    curToRoot.add(t);
                    t = head;
                    while ((parentArc = mtree.getOneParent(t)) != null) {
                        headToRoot.add(t);
                        queTopToRootLabels.add(parentArc.label);
                        t = parentArc.index;
                    }
                    headToRoot.add(t);
                    int leastCommonAncestor = 1;
                    while (leastCommonAncestor <= curToRoot.size() && leastCommonAncestor <= headToRoot.size() && curToRoot.get(curToRoot.size() - leastCommonAncestor) == headToRoot.get(headToRoot.size() - leastCommonAncestor)) {
                        ++leastCommonAncestor;
                    }
                    int pathPoss = n++;
                    int pathP = n++;
                    int pathLab = n++;
                    int i = 0;
                    while (i <= curToRoot.size() - leastCommonAncestor) {
                        pos = sent.getKthPosIndex((Integer)curToRoot.get(i));
                        p = sent.getKthPos((Integer)curToRoot.get(i)).charAt(0);
                        pathPoss = 31 * pathPoss + pos;
                        pathP = 31 * pathP + p;
                        pathLab = 31 * pathLab + ((String)stkTopToRootLabels.get(i)).hashCode();
                        ++i;
                    }
                    pathPoss = -pathPoss;
                    pathP = -pathP;
                    pathLab = -pathLab;
                    if (leastCommonAncestor > 1) {
                        int pos3 = sent.getKthPosIndex((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1));
                        char p3 = sent.getKthPos((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1)).charAt(0);
                        pathPoss = 31 * pathPoss + pos3;
                        pathPoss = 31 * pathPoss + SentenceForDAGParsing.posIndexer.size();
                        pathP = 31 * pathP + p3;
                        pathP = 31 * pathP + 255;
                    }
                    i = headToRoot.size() - leastCommonAncestor;
                    while (i >= 0) {
                        pos = sent.getKthPosIndex((Integer)headToRoot.get(i));
                        p = sent.getKthPos((Integer)headToRoot.get(i)).charAt(0);
                        pathPoss = 31 * pathPoss + pos;
                        pathP = 31 * pathP + p;
                        pathLab = 31 * pathLab + ((String)queTopToRootLabels.get(i)).hashCode();
                        --i;
                    }
                    ret.add(PredicateCentricDecoder.this.hashInts(pathPoss));
                    ret.add(PredicateCentricDecoder.this.hashInts(pathP));
                    ret.add(PredicateCentricDecoder.this.hashInts(pathLab));
                    ret.add(PredicateCentricDecoder.this.hashInts(pathPoss, distCur));
                    ret.add(PredicateCentricDecoder.this.hashInts(pathP, distCur));
                    ret.add(PredicateCentricDecoder.this.hashInts(pathLab, distCur));
                    ret.add(PredicateCentricDecoder.this.hashInts(n++, pathPoss, headWord, headPos, curWord, curPos, distCur));
                    ret.add(PredicateCentricDecoder.this.hashInts(n++, pathPoss, headWord, headPos, curWord, distCur));
                    ret.add(PredicateCentricDecoder.this.hashInts(n++, pathPoss, headWord, headPos, curPos, distCur));
                    ret.add(PredicateCentricDecoder.this.hashInts(n++, pathPoss, headWord, curWord, curPos, distCur));
                    ret.add(PredicateCentricDecoder.this.hashInts(n++, pathPoss, headPos, curWord, curPos, distCur));
                    ret.add(PredicateCentricDecoder.this.hashInts(n++, pathPoss, headWord, curWord, distCur));
                    ret.add(PredicateCentricDecoder.this.hashInts(n++, pathPoss, headPos, curPos, distCur));
                    ret.add(PredicateCentricDecoder.this.hashInts(n++, pathP, headWord, headPos, curWord, curPos, distCur));
                    ret.add(PredicateCentricDecoder.this.hashInts(n++, pathP, headWord, headPos, curWord, distCur));
                    ret.add(PredicateCentricDecoder.this.hashInts(n++, pathP, headWord, headPos, curPos, distCur));
                    ret.add(PredicateCentricDecoder.this.hashInts(n++, pathP, headWord, curWord, curPos, distCur));
                    ret.add(PredicateCentricDecoder.this.hashInts(n++, pathP, headPos, curWord, curPos, distCur));
                    ret.add(PredicateCentricDecoder.this.hashInts(n++, pathP, headWord, curWord, distCur));
                    ret.add(PredicateCentricDecoder.this.hashInts(n++, pathP, headPos, curPos, distCur));
                    ret.add(PredicateCentricDecoder.this.hashInts(n++, pathLab, headWord, headPos, curWord, curPos, distCur));
                    ret.add(PredicateCentricDecoder.this.hashInts(n++, pathLab, headWord, headPos, curWord, distCur));
                    ret.add(PredicateCentricDecoder.this.hashInts(n++, pathLab, headWord, headPos, curPos, distCur));
                    ret.add(PredicateCentricDecoder.this.hashInts(n++, pathLab, headWord, curWord, curPos, distCur));
                    ret.add(PredicateCentricDecoder.this.hashInts(n++, pathLab, headPos, curWord, curPos, distCur));
                    ret.add(PredicateCentricDecoder.this.hashInts(n++, pathLab, headWord, curWord, distCur));
                    ret.add(PredicateCentricDecoder.this.hashInts(n++, pathLab, headPos, curPos, distCur));
                }
            }
            return ret;
        }

        @Deprecated
        public List<Integer> siblingFeats(int head, int numOfSibling, int prev, int cur, SentenceForDAGParsing sent) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            int n = 65536;
            int headWord = sent.getKthWordIndex(head);
            int headPos = sent.getKthWordIndex(head);
            int preHeadWord = sent.getKthWordIndex(head - 1);
            int postHeadord = sent.getKthWordIndex(head + 1);
            int preHeadPos = sent.getKthPosIndex(head - 1);
            int postHeadPos = sent.getKthPosIndex(head + 1);
            int curWord = sent.getKthWordIndex(cur);
            int curPos = sent.getKthPosIndex(cur);
            int preCurWord = sent.getKthWordIndex(cur - 1);
            int postCurWord = sent.getKthWordIndex(cur + 1);
            int preCurPos = sent.getKthPosIndex(cur - 1);
            int postCurPos = sent.getKthPosIndex(cur + 1);
            int prevWord = sent.getKthWordIndex(prev);
            int prevPos = sent.getKthPosIndex(prev);
            int prePrevWord = sent.getKthWordIndex(prev - 1);
            int postPrevWord = sent.getKthWordIndex(prev + 1);
            int prePrevPos = sent.getKthPosIndex(prev - 1);
            int postPrevPos = sent.getKthPosIndex(prev + 1);
            int distCur = head - cur;
            int distCurPrev = cur - prev;
            int distPrev = head - prev;
            int order = distCur > 0 ? 1 : (distPrev < 0 ? 2 : 3);
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, distCur, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, distCur, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, distCur, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, distCur, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curPos, distCur, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, curPos, distCur, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, distCurPrev, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, distCurPrev, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prevPos, distCurPrev, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curPos, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, curWord, curPos, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prevPos, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, curWord, curPos, distCur, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, curWord, distCur, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, curPos, distCur, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, curWord, curPos, distCur, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, curWord, curPos, distCur, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, curWord, distCur, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, curPos, distCur, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prevPos, curWord, curPos, distCurPrev, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prevPos, curWord, distCurPrev, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prevPos, curPos, distCurPrev, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, curWord, curPos, distCurPrev, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, curWord, curPos, distCurPrev, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, curWord, distCurPrev, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, curPos, distCurPrev, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, curWord, curPos, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, curWord, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, curPos, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, curWord, curPos, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, curWord, curPos, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, curWord, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, curPos, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prevPos, curWord, curPos, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prevPos, curWord, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, prevPos, curPos, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, curWord, curPos, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, curWord, curPos, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevWord, curWord, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, prevPos, curPos, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, headPos, prevWord, prevPos, curWord, curPos, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, prevWord, curWord, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, prevWord, curPos, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, prevPos, curWord, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headWord, prevPos, curPos, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, prevWord, curWord, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, prevWord, curPos, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, prevPos, curWord, order, numOfSibling));
            ret.add(PredicateCentricDecoder.this.hashInts(n++, headPos, prevPos, curPos, order, numOfSibling));
            PredicateArgumentAdjunctDAG tree = sent.getSyntaxTree();
            if (PredicateCentricDecoder.this.usePathFeat && tree != null && !tree.isEmpty() && cur <= sent.numOfWords()) {
                char p;
                int pos;
                PredicateArgumentAdjunctDAG.ArcInfo parentArc;
                ArrayList<Integer> curToRoot = new ArrayList<Integer>();
                ArrayList<Integer> headToRoot = new ArrayList<Integer>();
                int t = cur;
                while ((parentArc = tree.getOneParent(t)) != null) {
                    curToRoot.add(t);
                    t = parentArc.index;
                }
                curToRoot.add(t);
                t = head;
                while ((parentArc = tree.getOneParent(t)) != null) {
                    headToRoot.add(t);
                    t = parentArc.index;
                }
                headToRoot.add(t);
                int leastCommonAncestor = 1;
                while (leastCommonAncestor <= curToRoot.size() && leastCommonAncestor <= headToRoot.size() && curToRoot.get(curToRoot.size() - leastCommonAncestor) == headToRoot.get(headToRoot.size() - leastCommonAncestor)) {
                    ++leastCommonAncestor;
                }
                int pathPoss = n++;
                int pathP = n++;
                int i = 0;
                while (i <= curToRoot.size() - leastCommonAncestor) {
                    pos = sent.getKthPosIndex((Integer)curToRoot.get(i));
                    p = sent.getKthPos((Integer)curToRoot.get(i)).charAt(0);
                    pathPoss = 31 * pathPoss + pos;
                    pathP = 31 * pathP + p;
                    ++i;
                }
                pathPoss = -pathPoss;
                pathP = -pathP;
                if (leastCommonAncestor > 1) {
                    int pos2 = sent.getKthPosIndex((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1));
                    char p2 = sent.getKthPos((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1)).charAt(0);
                    pathPoss = 31 * pathPoss + pos2;
                    pathPoss = 31 * pathPoss + SentenceForDAGParsing.posIndexer.size();
                    pathP = 31 * pathP + p2;
                    pathP = 31 * pathP + 255;
                }
                i = headToRoot.size() - leastCommonAncestor;
                while (i >= 0) {
                    pos = sent.getKthPosIndex((Integer)headToRoot.get(i));
                    p = sent.getKthPos((Integer)headToRoot.get(i)).charAt(0);
                    pathPoss = 31 * pathPoss + pos;
                    pathP = 31 * pathP + p;
                    --i;
                }
                ret.add(PredicateCentricDecoder.this.hashInts(pathPoss, numOfSibling));
                ret.add(PredicateCentricDecoder.this.hashInts(pathP, numOfSibling));
                ret.add(PredicateCentricDecoder.this.hashInts(pathPoss, distCur, numOfSibling));
                ret.add(PredicateCentricDecoder.this.hashInts(pathP, distCur, numOfSibling));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathPoss, headWord, headPos, curWord, curPos, distCur, numOfSibling));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathPoss, headWord, headPos, curWord, distCur, numOfSibling));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathPoss, headWord, headPos, curPos, distCur, numOfSibling));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathPoss, headWord, curWord, curPos, distCur, numOfSibling));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathPoss, headPos, curWord, curPos, distCur, numOfSibling));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathPoss, headWord, curWord, distCur, numOfSibling));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathPoss, headPos, curPos, distCur, numOfSibling));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathP, headWord, headPos, curWord, curPos, distCur, numOfSibling));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathP, headWord, headPos, curWord, distCur, numOfSibling));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathP, headWord, headPos, curPos, distCur, numOfSibling));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathP, headWord, curWord, curPos, distCur, numOfSibling));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathP, headPos, curWord, curPos, distCur, numOfSibling));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathP, headWord, curWord, distCur, numOfSibling));
                ret.add(PredicateCentricDecoder.this.hashInts(n++, pathP, headPos, curPos, distCur, numOfSibling));
            }
            return ret;
        }

        @Deprecated
        public double scoreSiblings(int headWordIndex, int numOfSibling, int prev, int cur, SentenceForDAGParsing sent, float[] param) {
            return PredicateCentricDecoder.this.score(this.siblingFeats(headWordIndex, numOfSibling, prev, cur, sent), param);
        }

        public double scoreSiblings(int headWordIndex, int prev, int cur, SentenceForDAGParsing sent, float[] param) {
            return PredicateCentricDecoder.this.score(this.siblingFeats(headWordIndex, prev, cur, sent), param);
        }
    }
}

