/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;
import matetools.is2.data.SentenceData09;
import matetools.is2.util.DB;

public class CONLLWriter06 {
    public static final String DASH = "_";
    protected BufferedWriter writer;

    public CONLLWriter06() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 2) {
            String l;
            File f = new File(args[0]);
            File f2 = new File(args[1]);
            BufferedReader ir = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "ISO-8859"), 32768);
            BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f2), "UTF-8"));
            boolean found = false;
            boolean tab = false;
            while ((l = ir.readLine()) != null) {
                String x = l.trim();
                if (x.endsWith("\t")) {
                    tab = true;
                }
                br.write(x);
                br.newLine();
                if (l.equals(x)) continue;
                found = true;
            }
            ir.close();
            br.flush();
            br.close();
            if (found) {
                DB.println("found diff. found tab? " + tab);
            }
        } else if (args.length == 3) {
            File f1 = new File(args[1]);
            File f2 = new File(args[2]);
            BufferedReader ir1 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f1), "ISO-8859"), 32768);
            BufferedReader ir2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f2), "UTF-8"), 32768);
            int line = 0;
            int alltabs1 = 0;
            int alltabs2 = 0;
            while (true) {
                String l1 = ir1.readLine();
                String l2 = ir2.readLine();
                if (l1 == null && l2 != null) {
                    DB.println("files do not end at the same line ");
                }
                if (l1 != null && l2 == null) {
                    DB.println("files do not end at the same line ");
                }
                if (l1 == null) break;
                StringTokenizer t1 = new StringTokenizer(l1, "\t");
                StringTokenizer t2 = new StringTokenizer(l2, "\t");
                int tabs1 = 0;
                while (t1.hasMoreTokens()) {
                    t1.nextElement();
                    ++tabs1;
                    ++alltabs1;
                }
                int tabs2 = 0;
                while (t2.hasMoreTokens()) {
                    t2.nextElement();
                    ++tabs2;
                    ++alltabs2;
                }
                ++line;
                if (tabs1 == tabs2) continue;
                DB.println("number of tabs different in line " + line + " file1-tabs " + tabs1 + " file2-tabs " + tabs2);
                System.exit(0);
            }
            DB.println("checked lines " + line + " with tabs in fname 1 " + alltabs1 + " in file2 " + alltabs2);
        } else {
            String[] dir;
            File f = new File(args[0]);
            String[] stringArray = dir = f.list();
            int n = dir.length;
            int n2 = 0;
            while (n2 < n) {
                String l;
                String fx = stringArray[n2];
                BufferedReader ir = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(String.valueOf(args[0]) + File.separatorChar + fx), "UTF-8"), 32768);
                System.out.println("check fname " + fx);
                while ((l = ir.readLine()) != null) {
                    if (!l.endsWith("\t")) continue;
                    DB.println("found tab in fname " + fx);
                    break;
                }
                ir.close();
                ++n2;
            }
        }
    }

    public CONLLWriter06(String file) {
        try {
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CONLLWriter06(String outfile, int formatTask) {
        this(outfile);
    }

    public void write(SentenceData09 inst) throws IOException {
        int i = 0;
        while (i < inst.length()) {
            this.writer.write(Integer.toString(i + 1));
            this.writer.write(9);
            this.writer.write(inst.forms[i]);
            this.writer.write(9);
            if (inst.lemmas != null && inst.lemmas[i] != null) {
                this.writer.write(inst.lemmas[i]);
            } else {
                this.writer.write(DASH);
            }
            this.writer.write(9);
            this.writer.write(inst.gpos[i]);
            this.writer.write(9);
            this.writer.write(inst.gpos[i]);
            this.writer.write(9);
            if (inst.ofeats[i].isEmpty() || inst.ofeats[i].equals(" ")) {
                this.writer.write(DASH);
            } else {
                this.writer.write(inst.ofeats[i]);
            }
            this.writer.write(9);
            this.writer.write(Integer.toString(inst.heads[i]));
            this.writer.write(9);
            if (inst.labels[i] != null) {
                this.writer.write(inst.labels[i]);
            } else {
                this.writer.write(DASH);
            }
            this.writer.write(9);
            this.writer.write(DASH);
            this.writer.write(9);
            this.writer.write(DASH);
            this.writer.write(9);
            this.writer.newLine();
            ++i;
        }
        this.writer.newLine();
    }

    public void finishWriting() throws IOException {
        this.writer.flush();
        this.writer.close();
    }
}

