/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.IOUtils;
import fig.servlet.BasketView;
import fig.servlet.DomainView;
import fig.servlet.FieldListMap;
import fig.servlet.Item;
import fig.servlet.MyException;
import fig.servlet.MyExceptions;
import fig.servlet.UpdateQueue;
import fig.servlet.UpdateSpec;
import fig.servlet.Value;
import fig.servlet.WebState;
import java.io.File;

public class RootItem
extends Item {
    public final BasketView basketView;
    public final DomainView domainView;

    public RootItem(String varDir) {
        super(null, "ROOT", null);
        IOUtils.createNewDirIfNotExistsEasy(varDir);
        WebState.logs("RootItem: varDir = " + varDir);
        this.basketView = new BasketView(this, "baskets", new File(varDir, "baskets").toString(), true);
        this.addItem(this.basketView);
        this.domainView = new DomainView(this, "domains", new File(varDir, "domains").toString());
        this.addItem(this.domainView);
    }

    @Override
    public FieldListMap getMetadataFields() {
        FieldListMap fields = new FieldListMap();
        fields.add((String)"logUpdates", (String)"Whether to log updates").mutable = true;
        fields.add((String)"logWorkers", (String)"Whether to log requests sent by workers").mutable = true;
        fields.add((String)"verbose", (String)"Generally print out a lot of stuff").mutable = true;
        return fields;
    }

    @Override
    protected Value getIntrinsicFieldValue(String fieldName) throws MyException {
        if (fieldName.equals("logUpdates")) {
            return new Value("" + WebState.logUpdates);
        }
        if (fieldName.equals("verbose")) {
            return new Value("" + WebState.verbose);
        }
        return super.getIntrinsicFieldValue(fieldName);
    }

    @Override
    protected void changeIntrinsicFieldValue(String fieldName, String value) throws MyException {
        if (fieldName.equals("logUpdates")) {
            WebState.logUpdates = Boolean.parseBoolean(value);
        } else if (fieldName.equals("verbose")) {
            WebState.verbose = Boolean.parseBoolean(value);
        } else {
            super.changeIntrinsicFieldValue(fieldName, value);
        }
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        super.update(spec, priority);
        this.updateChildren(spec, priority);
    }

    @Override
    protected boolean isView() {
        return true;
    }

    @Override
    protected Item newItem(String name) throws MyException {
        throw MyExceptions.unsupported;
    }
}

