/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import java.io.File;
import java.io.FilenameFilter;

public class FilenameFilterBank {
    public static FilenameFilter onlyDir() {
        return new FileType(false, true);
    }

    public static FilenameFilter onlyFile() {
        return new FileType(true, false);
    }

    public static class Compose
    implements FilenameFilter {
        private FilenameFilter f1;
        private FilenameFilter f2;

        public Compose(FilenameFilter f1, FilenameFilter f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.f1.accept(dir, name) && this.f2.accept(dir, name);
        }
    }

    public static class FileType
    implements FilenameFilter {
        private boolean allowFiles;
        private boolean allowDirs;

        public FileType(boolean allowFiles, boolean allowDirs) {
            this.allowFiles = allowFiles;
            this.allowDirs = allowDirs;
        }

        @Override
        public boolean accept(File dir, String name) {
            File path = new File(dir, name);
            if (!this.allowFiles && path.isFile()) {
                return false;
            }
            return this.allowDirs || !path.isDirectory();
        }
    }

    public static class Regex
    implements FilenameFilter {
        private String match;
        private boolean positive;

        public Regex(String match, boolean positive) {
            this.match = match;
            this.positive = positive;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.matches(this.match) == this.positive;
        }
    }
}

