/*
 * Decompiled with CFR 0.152.
 */
package fig.prob;

import fig.basic.StrUtils;
import fig.prob.Distrib;
import fig.prob.ProductSuffStats;
import fig.prob.SuffStats;
import java.util.Random;

public class ProductDistrib
implements Distrib<Object[]> {
    private Distrib[] distribs;

    public ProductDistrib(Distrib[] distribs) {
        this.distribs = distribs;
    }

    public double logProb(Object[] x) {
        double sum = 0.0;
        int i = 0;
        while (i < this.dim()) {
            sum += this.distribs[i].logProbObject(x[i]);
            ++i;
        }
        return sum;
    }

    @Override
    public double logProb(SuffStats stats) {
        double sum = 0.0;
        int i = 0;
        while (i < this.dim()) {
            sum += this.distribs[i].logProb(((ProductSuffStats)stats).getComponent(i));
            ++i;
        }
        return sum;
    }

    @Override
    public double logProbObject(Object[] x) {
        return this.logProb(x);
    }

    public Object[] sample(Random random) {
        Object[] x = new Object[this.dim()];
        int i = 0;
        while (i < this.dim()) {
            x[i] = this.distribs[i].sampleObject(random);
            ++i;
        }
        return x;
    }

    @Override
    public Object[] sampleObject(Random random) {
        return this.sample(random);
    }

    @Override
    public double crossEntropy(Distrib<Object[]> _that) {
        throw new RuntimeException("unsupported");
    }

    public Distrib getComponent(int i) {
        return this.distribs[i];
    }

    public int dim() {
        return this.distribs.length;
    }

    public String toString() {
        return StrUtils.join(this.distribs);
    }
}

