/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.treeapprox;

import edu.berkeley.nlp.syntax.Tree;
import edu.pku.coli.pear.dag.PredicateArgumentAdjunctDAG;
import edu.pku.coli.pear.dag.SentenceForDAGParsing;
import edu.pku.coli.treeapprox.DAG2TreeProjectiveSimple;
import java.util.ArrayList;
import java.util.Iterator;

public class DAG2TreePhraseStructureTree {
    private static final int MAXN = 400;
    private static final int MAXT = 10000;
    Tree<String> psTree = new Tree((Object)"ROOT", new ArrayList(2));
    PredicateArgumentAdjunctDAG.PredicateArgumentAdjunctArcAdjacencyList[] map;
    PredicateArgumentAdjunctDAG projDAG;
    PredicateArgumentAdjunctDAG newDAG;
    String[] poss;
    String[] words;
    int possnumber;
    int wordsnumber;
    int number;
    int[] father = new int[10000];
    int[] realwords = new int[10000];
    boolean[] isposs = new boolean[10000];

    public String toTree(SentenceForDAGParsing sent) {
        DAG2TreeProjectiveSimple dag2tree = new DAG2TreeProjectiveSimple(false);
        this.projDAG = dag2tree.toTree(sent.getGoldDAG());
        this.map = this.projDAG.getAdjacencyLists();
        this.poss = sent.tags();
        this.words = sent.words();
        int i = 0;
        while (i < this.words.length) {
            if (this.words[i].equalsIgnoreCase("(")) {
                this.words[i] = "[";
            }
            if (this.words[i].equalsIgnoreCase(")")) {
                this.words[i] = "]";
            }
            if (this.poss[i].equalsIgnoreCase("(")) {
                this.poss[i] = "[";
            }
            if (this.poss[i].equalsIgnoreCase(")")) {
                this.poss[i] = "]";
            }
            ++i;
        }
        int len = sent.numOfWords();
        PredicateArgumentAdjunctDAG.ArcInfo rootEdge = this.projDAG.getAdjacencyLists()[0].getOutArcs().iterator().next();
        ArrayList<Tree<String>> newChildren = new ArrayList<Tree<String>>();
        if (rootEdge.index == 1) {
            if (1 <= len - 1) {
                this.psTree.setLabel((Object)"ROOTl");
            } else {
                this.psTree.setLabel((Object)"ROOTv");
            }
            newChildren.add(this.toTreeWork(0, 0, 0, 0));
            if (1 <= len - 1) {
                newChildren.add(this.toTreeWork(0, 1, len - 1, -1));
            }
        } else if (rootEdge.index == len) {
            if (len - 2 >= 0) {
                this.psTree.setLabel((Object)"ROOTr");
            } else {
                this.psTree.setLabel((Object)"ROOTv");
            }
            if (len - 2 >= 0) {
                newChildren.add(this.toTreeWork(len - 1, 0, len - 2, -1));
            }
            newChildren.add(this.toTreeWork(len - 1, len - 1, len - 1, len - 1));
        } else {
            this.psTree.setLabel((Object)"ROOTr");
            newChildren.add(this.toTreeWork(rootEdge.index - 1, 0, rootEdge.index - 2, -1));
            newChildren.add(this.toTreeWork(rootEdge.index - 1, rootEdge.index - 1, len - 1, rootEdge.index - 1));
        }
        this.psTree.setChildren(newChildren);
        Tree retTree = new Tree((Object)"S");
        ArrayList<Tree<String>> retnewChildren = new ArrayList<Tree<String>>();
        retnewChildren.add(this.psTree);
        retTree.setChildren(retnewChildren);
        return retTree.toString();
    }

    private Tree<String> toTreeWork(int fromNode, int lNode, int rNode, int headIndex) {
        if (lNode > rNode) {
            return null;
        }
        Tree tree = new Tree((Object)"");
        ArrayList<Object> newChildren = new ArrayList<Object>();
        if (headIndex == -1) {
            if (fromNode <= lNode) {
                int leftmostIndex = rNode + 1;
                String leftmostLabel = new String();
                for (PredicateArgumentAdjunctDAG.ArcInfo nowArc : this.map[fromNode + 1].getOutArcs()) {
                    if (nowArc.index > rNode + 1 || nowArc.index < lNode + 1 || nowArc.index - 1 >= leftmostIndex) continue;
                    leftmostIndex = nowArc.index - 1;
                    leftmostLabel = nowArc.label;
                }
                int cutPoint = this.goRightFarest(leftmostIndex);
                if (cutPoint + 1 <= rNode) {
                    tree.setLabel((Object)(String.valueOf(leftmostLabel) + "l"));
                } else {
                    tree.setLabel((Object)(String.valueOf(leftmostLabel) + "v"));
                }
                newChildren.add(this.toTreeWork(leftmostIndex, lNode, cutPoint, leftmostIndex));
                if (cutPoint + 1 <= rNode) {
                    newChildren.add(this.toTreeWork(fromNode, cutPoint + 1, rNode, -1));
                }
            } else {
                int rightmostIndex = lNode - 1;
                String rightmostLabel = new String();
                for (PredicateArgumentAdjunctDAG.ArcInfo nowArc : this.map[fromNode + 1].getOutArcs()) {
                    if (nowArc.index > rNode + 1 || nowArc.index < lNode + 1 || nowArc.index - 1 <= rightmostIndex) continue;
                    rightmostIndex = nowArc.index - 1;
                    rightmostLabel = nowArc.label;
                }
                int cutPoint = this.goLeftFarest(rightmostIndex);
                if (cutPoint - 1 >= lNode) {
                    tree.setLabel((Object)(String.valueOf(rightmostLabel) + "r"));
                } else {
                    tree.setLabel((Object)(String.valueOf(rightmostLabel) + "v"));
                }
                if (cutPoint - 1 >= lNode) {
                    newChildren.add(this.toTreeWork(fromNode, lNode, cutPoint - 1, -1));
                }
                newChildren.add(this.toTreeWork(rightmostIndex, cutPoint, rNode, rightmostIndex));
            }
        } else if (headIndex == lNode) {
            if (lNode == rNode) {
                tree.setLabel((Object)(String.valueOf(this.poss[lNode]) + "v"));
                newChildren.add(new Tree((Object)this.words[lNode]));
            } else {
                tree.setLabel((Object)"Blankl");
                newChildren.add(this.toTreeWork(fromNode, lNode, lNode, lNode));
                if (lNode + 1 <= rNode) {
                    newChildren.add(this.toTreeWork(fromNode, lNode + 1, rNode, -1));
                }
            }
        } else if (headIndex == rNode) {
            tree.setLabel((Object)"Blankr");
            newChildren.add(this.toTreeWork(fromNode, lNode, rNode - 1, -1));
            newChildren.add(this.toTreeWork(fromNode, rNode, rNode, rNode));
        } else {
            tree.setLabel((Object)"Blankl");
            newChildren.add(this.toTreeWork(fromNode, lNode, headIndex, headIndex));
            newChildren.add(this.toTreeWork(fromNode, headIndex + 1, rNode, -1));
        }
        tree.setChildren(newChildren);
        return tree;
    }

    int goLeftFarest(int x) {
        int ret = x + 1;
        int[] queue = new int[400];
        int open = 1;
        int closed = 0;
        queue[1] = x + 1;
        while (closed < open) {
            Iterator<PredicateArgumentAdjunctDAG.ArcInfo> iArc = this.map[queue[++closed]].getOutArcs().iterator();
            while (iArc.hasNext()) {
                queue[++open] = iArc.next().index;
                if (queue[open] >= ret) continue;
                ret = queue[open];
            }
        }
        return ret - 1;
    }

    int goRightFarest(int x) {
        int ret = x + 1;
        int[] queue = new int[400];
        int open = 1;
        int closed = 0;
        queue[1] = x + 1;
        while (closed < open) {
            Iterator<PredicateArgumentAdjunctDAG.ArcInfo> iArc = this.map[queue[++closed]].getOutArcs().iterator();
            while (iArc.hasNext()) {
                queue[++open] = iArc.next().index;
                if (queue[open] <= ret) continue;
                ret = queue[open];
            }
        }
        return ret - 1;
    }

    public SentenceForDAGParsing toDAG(char[] sent) {
        Tree<String> _tree = this.stringToTree(sent);
        Tree tree = _tree.getChild(0);
        int len = this.howmanyleaves((Tree<String>)tree);
        this.words = new String[len];
        this.poss = new String[len];
        this.newDAG = new PredicateArgumentAdjunctDAG(len);
        this.possnumber = 0;
        this.wordsnumber = 0;
        this.number = 0;
        this.toDAGPreparation((Tree<String>)tree);
        this.father[1] = 0;
        this.realwords[0] = -1;
        this.number = 0;
        this.toDAGWork((Tree<String>)tree, -1, true);
        int i = 0;
        while (i < this.words.length) {
            if (this.words[i].equalsIgnoreCase("[")) {
                this.words[i] = "(";
            }
            if (this.words[i].equalsIgnoreCase("]")) {
                this.words[i] = ")";
            }
            if (this.poss[i].equalsIgnoreCase("[")) {
                this.poss[i] = "(";
            }
            if (this.poss[i].equalsIgnoreCase("]")) {
                this.poss[i] = ")";
            }
            ++i;
        }
        DAG2TreeProjectiveSimple tree2dag = new DAG2TreeProjectiveSimple(false);
        this.projDAG = tree2dag.toDAG(this.newDAG);
        return new SentenceForDAGParsing(this.words, this.poss, this.projDAG);
    }

    Tree<String> stringToTree(char[] now) {
        Tree tree = new Tree((Object)"");
        ArrayList<Object> newChildren = new ArrayList<Object>();
        int cutPoint = 0;
        int i = 1;
        while (i < now.length) {
            if (now[i] == ' ') {
                cutPoint = i;
                break;
            }
            ++i;
        }
        String root = new String();
        int i2 = 1;
        while (i2 < cutPoint) {
            root = String.valueOf(root) + now[i2];
            ++i2;
        }
        int j = cutPoint;
        while (j < now.length) {
            if (now[j] != ' ' && now[j] != ')') {
                if (now[j] != '(') {
                    int k = j;
                    while (now[k] != ' ' && now[k] != '(' && now[k] != ')') {
                        ++k;
                    }
                    String tmp = new String();
                    int i3 = j;
                    while (i3 < k) {
                        tmp = String.valueOf(tmp) + now[i3];
                        ++i3;
                    }
                    newChildren.add(new Tree((Object)tmp));
                    j = k;
                    continue;
                }
                int leftBracket = 1;
                int rightBracket = 0;
                int k = j + 1;
                while (leftBracket != rightBracket) {
                    if (now[k] == '(') {
                        ++leftBracket;
                    }
                    if (now[k] == ')') {
                        ++rightBracket;
                    }
                    ++k;
                }
                char[] oneChild = new char[k - j];
                int i4 = 0;
                while (i4 < k - j) {
                    oneChild[i4] = now[i4 + j];
                    ++i4;
                }
                newChildren.add(this.stringToTree(oneChild));
                j = k;
                continue;
            }
            ++j;
        }
        tree.setLabel((Object)root);
        tree.setChildren(newChildren);
        return tree;
    }

    int howmanyleaves(Tree<String> tree) {
        int ret = 0;
        if (tree.isLeaf()) {
            ret = 1;
        } else {
            for (Tree child : tree.getChildren()) {
                ret += this.howmanyleaves((Tree<String>)child);
            }
        }
        return ret;
    }

    int toDAGPreparation(Tree<String> tree) {
        ++this.number;
        int ret = this.number;
        int realnumber = this.number;
        this.isposs[realnumber] = false;
        if (tree.isLeaf()) {
            ret = this.wordsnumber;
            this.words[this.wordsnumber++] = (String)tree.getLabel();
        } else {
            char[] label = ((String)tree.getLabel()).toCharArray();
            char symbol = label[label.length - 1];
            String truelabel = new String();
            int i = 0;
            while (i < label.length - 1) {
                truelabel = String.valueOf(truelabel) + label[i];
                ++i;
            }
            if (symbol == 'v') {
                Tree Child = tree.getChild(0);
                this.father[this.number + 1] = realnumber;
                ret = this.toDAGPreparation((Tree<String>)Child);
                if (Child.isLeaf()) {
                    this.poss[this.possnumber++] = truelabel;
                    this.isposs[realnumber] = true;
                }
            } else {
                Tree leftChild = tree.getChild(0);
                Tree rightChild = tree.getChild(1);
                this.father[this.number + 1] = realnumber;
                int leftret = this.toDAGPreparation((Tree<String>)leftChild);
                this.father[this.number + 1] = realnumber;
                int rightret = this.toDAGPreparation((Tree<String>)rightChild);
                ret = symbol == 'l' ? leftret : rightret;
                if (symbol == 'l' && leftChild.isLeaf()) {
                    this.poss[this.possnumber++] = truelabel;
                    this.isposs[realnumber] = true;
                } else if (symbol == 'r' && rightChild.isLeaf()) {
                    this.poss[this.possnumber++] = truelabel;
                    this.isposs[realnumber] = true;
                }
            }
        }
        this.realwords[realnumber] = ret;
        return ret;
    }

    void toDAGWork(Tree<String> tree, int fromNode, boolean headWord) {
        ++this.number;
        if (!tree.isLeaf()) {
            String truelabel = ((String)tree.getLabel()).substring(0, ((String)tree.getLabel()).length() - 1);
            if (!truelabel.equalsIgnoreCase("Blank") && !this.isposs[this.number]) {
                this.newDAG.addArc(fromNode + 1, this.realwords[this.number] + 1, truelabel);
                if (fromNode == -1 && this.number != 1) {
                    this.newDAG.removeArc(fromNode + 1, this.realwords[this.number] + 1);
                }
            }
            char symbol = ((String)tree.getLabel()).toCharArray()[((String)tree.getLabel()).length() - 1];
            if (!headWord) {
                if (symbol == 'v') {
                    this.toDAGWork((Tree<String>)tree.getChild(0), this.realwords[this.number], true);
                }
                if (symbol == 'l') {
                    this.toDAGWork((Tree<String>)tree.getChild(0), this.realwords[this.number], true);
                    this.toDAGWork((Tree<String>)tree.getChild(1), fromNode, false);
                }
                if (symbol == 'r') {
                    this.toDAGWork((Tree<String>)tree.getChild(0), fromNode, false);
                    this.toDAGWork((Tree<String>)tree.getChild(1), this.realwords[this.number], true);
                }
            } else {
                if (symbol == 'v') {
                    this.toDAGWork((Tree<String>)tree.getChild(0), this.realwords[this.number], true);
                }
                if (symbol == 'l') {
                    this.toDAGWork((Tree<String>)tree.getChild(0), this.realwords[this.number], true);
                    this.toDAGWork((Tree<String>)tree.getChild(1), this.realwords[this.number], false);
                }
                if (symbol == 'r') {
                    this.toDAGWork((Tree<String>)tree.getChild(0), this.realwords[this.number], false);
                    this.toDAGWork((Tree<String>)tree.getChild(1), this.realwords[this.number], true);
                }
            }
        }
    }
}

