/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.pear.dag;

import edu.berkeley.nlp.util.IOUtils;
import edu.pku.coli.io.CCGPARGWriter;
import edu.pku.coli.io.DAGSentenceReader;
import edu.pku.coli.io.FileFilters;
import edu.pku.coli.pear.dag.Evaluator;
import edu.pku.coli.pear.dag.PredicateArgumentAdjunctDAG;
import edu.pku.coli.pear.dag.SentenceForDAGParsing;
import fig.basic.Option;
import fig.basic.Pair;
import fig.exec.Execution;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DAGCombiner
implements Runnable {
    @Option(gloss="threshold for adding arc")
    public double threshold = 0.5;
    @Option(gloss="weight file, each line contains a string and a double, seperated by space. If filename contains the string, then the weight is set to the double (default = 1.0).")
    public String weightFile;
    @Option(required=true)
    public String in;
    @Option
    public String out;
    @Option
    public String gold;
    @Option
    public String format = "conll08";
    @Option(gloss="file suffix, used in filefilter")
    public String suffix = "";
    private Map<String, Double> weights = new LinkedHashMap<String, Double>();
    private List<Double> weightList = new ArrayList<Double>();
    private double sumOfWeight;

    public static void main(String[] args) {
        Execution.run(args, new DAGCombiner());
    }

    @Override
    public void run() {
        Object conllFile;
        Object[] objectArray;
        File sourceDir = new File(this.in);
        Object[] sources = sourceDir.listFiles(FileFilters.nameSuffixFileFilter(this.suffix));
        System.out.println("\nCombining " + sources.length + " files:");
        System.out.println(Arrays.toString(sources));
        Arrays.sort(sources);
        ArrayList<Iterator<SentenceForDAGParsing>> sentIters = new ArrayList<Iterator<SentenceForDAGParsing>>();
        CCGPARGWriter writer = new CCGPARGWriter(this.out);
        if (this.weightFile != null) {
            BufferedReader br = IOUtils.openInEasy((String)this.weightFile);
            try {
                String line = br.readLine();
                while (line != null) {
                    String[] w = line.trim().split("\\s+");
                    this.weights.put(w[0], Double.parseDouble(w[1]));
                    line = br.readLine();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.weights.put("dfs", 2.0);
            this.weights.put("projective", 2.0);
            this.weights.put("nonprojective", 2.0);
        }
        System.out.println("Using weight: " + this.weights);
        System.out.println("Threshold = " + this.threshold);
        try {
            objectArray = sources;
            int e = sources.length;
            int line = 0;
            while (line < e) {
                conllFile = objectArray[line];
                double w = 1.0;
                for (Map.Entry<String, Double> entry : this.weights.entrySet()) {
                    if (!((File)conllFile).getName().contains(entry.getKey())) continue;
                    w = entry.getValue();
                }
                this.weightList.add(w);
                this.sumOfWeight += w;
                if (this.format.equalsIgnoreCase("conll08")) {
                    sentIters.add(DAGSentenceReader.dagsReaderFromCoNLL08((File)conllFile, false).iterator());
                } else if (this.format.equalsIgnoreCase("sdp")) {
                    sentIters.add(DAGSentenceReader.dagsReaderFromSDP((File)conllFile).iterator());
                } else if (this.format.equalsIgnoreCase("sdp15")) {
                    sentIters.add(DAGSentenceReader.dagsReaderFromSDP15((File)conllFile).iterator());
                } else {
                    System.err.println("Format unsupported.");
                    System.exit(-1);
                }
                ++line;
            }
            if (sentIters.isEmpty()) {
                return;
            }
            Iterator iter0 = (Iterator)sentIters.get(0);
            Iterator<SentenceForDAGParsing> goldIt = null;
            if (this.threshold * this.sumOfWeight < 1.0 && this.gold != null) {
                if (this.format.equalsIgnoreCase("conll")) {
                    goldIt = DAGSentenceReader.dagsReaderFromCoNLL08(this.gold, false).iterator();
                } else if (this.format.equalsIgnoreCase("sdp")) {
                    goldIt = DAGSentenceReader.dagsReaderFromSDP(this.gold).iterator();
                } else if (this.format.equalsIgnoreCase("sdp15")) {
                    goldIt = DAGSentenceReader.dagsReaderFromSDP15(this.gold).iterator();
                }
            }
            while (iter0.hasNext()) {
                SentenceForDAGParsing sent0 = (SentenceForDAGParsing)iter0.next();
                ArrayList<PredicateArgumentAdjunctDAG> dags = new ArrayList<PredicateArgumentAdjunctDAG>();
                dags.add(sent0.getGoldDAG());
                int i = 1;
                while (i < sentIters.size()) {
                    dags.add(((SentenceForDAGParsing)((Iterator)sentIters.get(i)).next()).getGoldDAG());
                    ++i;
                }
                PredicateArgumentAdjunctDAG combined = this.combine(dags);
                if (goldIt != null) {
                    PredicateArgumentAdjunctDAG gld = goldIt.next().getGoldDAG();
                    for (Pair pair : combined.toUnlabeledPairs()) {
                        int to;
                        int from = (Integer)pair.getFirst();
                        if (!gld.containsArc(from, to = ((Integer)pair.getSecond()).intValue())) continue;
                        String goldLab = gld.getArcLabel(from, to);
                        HashSet<String> labs = new HashSet<String>();
                        for (PredicateArgumentAdjunctDAG dag : dags) {
                            if (!dag.containsArc(from, to)) continue;
                            labs.add(dag.getArcLabel(from, to));
                        }
                        if (!labs.contains(goldLab)) continue;
                        combined.setArcLabel(from, to, goldLab);
                    }
                }
                if (this.format.equalsIgnoreCase("conll08")) {
                    writer.printOneSentenceCoNLL08(combined, Arrays.asList(sent0.words()), Arrays.asList(sent0.tags()));
                    continue;
                }
                if (this.format.equalsIgnoreCase("sdp")) {
                    writer.printOneSentenceSDP(combined, Arrays.asList(sent0.words()), Arrays.asList(sent0.lemmas()), Arrays.asList(sent0.tags()), sent0.id());
                    continue;
                }
                if (!this.format.equalsIgnoreCase("sdp15")) continue;
                writer.printOneSentenceSDP15(combined, Arrays.asList(sent0.words()), Arrays.asList(sent0.lemmas()), Arrays.asList(sent0.tags()), null, sent0.id());
            }
            System.out.println("Done.");
        }
        finally {
            writer.close();
        }
        if (this.gold != null) {
            Evaluator e = new Evaluator();
            e.dataFormat = this.format;
            e.goldCoNLL = this.gold;
            e.sysCoNLL = this.out;
            e.run();
        } else {
            this.gold = this.out;
        }
        objectArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            conllFile = objectArray[n2];
            Evaluator e = new Evaluator();
            e.dataFormat = this.format;
            e.goldCoNLL = this.gold;
            e.sysCoNLL = ((File)conllFile).toString();
            e.run();
            ++n2;
        }
    }

    private PredicateArgumentAdjunctDAG combine(List<PredicateArgumentAdjunctDAG> dags) {
        int numOfDAGs = dags.size();
        PredicateArgumentAdjunctDAG dag0 = dags.get(0);
        int sentLen = dag0.sentenceLength();
        PredicateArgumentAdjunctDAG combined = new PredicateArgumentAdjunctDAG(sentLen);
        int i = 0;
        while (i <= sentLen) {
            int j = 0;
            while (j <= sentLen) {
                ArrayList<String> labs = new ArrayList<String>();
                double w = 0.0;
                int k = 0;
                while (k < dags.size()) {
                    PredicateArgumentAdjunctDAG dag = dags.get(k);
                    if (dag.containsArc(i, j)) {
                        labs.add(dag.getArcLabel(i, j));
                        w += this.weightList.get(k).doubleValue();
                    }
                    ++k;
                }
                if (w >= this.threshold * this.sumOfWeight) {
                    String combinedLab = this.combineLabel(labs);
                    combined.addArc(i, j, combinedLab);
                }
                ++j;
            }
            ++i;
        }
        return combined;
    }

    private String combineLabel(List<String> labs) {
        HashMap<String, Double> labelWeight = new HashMap<String, Double>();
        int i = 0;
        while (i < labs.size()) {
            String lab = labs.get(i);
            double w = labelWeight.containsKey(lab) ? (Double)labelWeight.get(lab) + this.weightList.get(i) : this.weightList.get(i);
            labelWeight.put(lab, w);
            ++i;
        }
        String most = null;
        double mostWeight = 0.0;
        for (Map.Entry e : labelWeight.entrySet()) {
            if (!((Double)e.getValue() > mostWeight)) continue;
            mostWeight = (Double)e.getValue();
            most = (String)e.getKey();
        }
        return most;
    }
}

