/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.io;

import edu.pku.coli.io.DAGSentenceReader;
import edu.pku.coli.pear.dag.SentenceForDAGParsing;
import fig.basic.IOUtils;
import fig.basic.Pair;
import java.io.PrintWriter;

public class DAGSent2XML {
    private int ROOT_OFFSET = 0;
    private PrintWriter _writer;
    private int _s_id;

    public DAGSent2XML(String path) {
        this._writer = IOUtils.openOutEasy(path);
        this._s_id = 0;
        this._writer.println("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n<viewer>");
    }

    public void printOneSentence(SentenceForDAGParsing sent) {
        this._writer.println("  <sentence id = \"" + ++this._s_id + "\">");
        String[] poss = sent.tags();
        String[] words = sent.words();
        this._writer.println("  <wordlist length = \"" + (words.length - this.ROOT_OFFSET) + "\">");
        int i = this.ROOT_OFFSET;
        while (i < words.length) {
            this._writer.println("    <tok id=\"" + (i - this.ROOT_OFFSET) + "\" pos=\"" + poss[i] + "\" head=\"" + words[i] + "\" />");
            ++i;
        }
        this._writer.println("  </wordlist>");
        this._writer.println("  <deepdep>");
        for (Pair<Pair<Integer, Integer>, String> arc : sent.getGoldDAG().toLabeledPairs()) {
            this._writer.println("    (" + (arc.getFirst().getFirst() - 1 - this.ROOT_OFFSET) + ", " + (arc.getFirst().getSecond() - 1 - this.ROOT_OFFSET) + ", " + arc.getSecond() + ")");
        }
        this._writer.println("  </deepdep>");
        this._writer.println("  </sentence>");
    }

    public void close() {
        this._writer.println("</viewer>");
        this._writer.close();
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: <input conll08 File> <output File> [anything to denote explict root]");
            System.exit(-1);
        }
        DAGSentenceReader reader = DAGSentenceReader.dagsReaderFromCoNLL08(args[0]);
        DAGSent2XML writer = new DAGSent2XML(args[1]);
        if (args.length == 3) {
            writer.ROOT_OFFSET = 1;
        }
        for (SentenceForDAGParsing sent : reader) {
            writer.printOneSentence(sent);
        }
        writer.close();
    }
}

