/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.basic.IntRef;
import fig.basic.ListUtils;
import fig.basic.StrUtils;
import fig.record.AbstractRecordNode;
import fig.record.AllMatcher;
import fig.record.CombineCommandNode;
import fig.record.CommandEnv;
import fig.record.CommandNode;
import fig.record.ExactMatcher;
import fig.record.FilterCommandNode;
import fig.record.FuncCommandNode;
import fig.record.GlobalEnv;
import fig.record.Matcher;
import fig.record.NumMatcher;
import fig.record.OrMatcher;
import fig.record.RecordNode;
import fig.record.RecordNodeMatcher;
import fig.record.RegexMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class CommandUtils {
    public static CommandNode parse(String line, CommandEnv cmdEnv) {
        line = CommandUtils.substituteMacro(line, cmdEnv.getGlobalEnv());
        if ((line = line.replaceAll("\\s+", " ").trim()).equals("")) {
            return FuncCommandNode.noOpCmd;
        }
        CommandNode cmd = CommandUtils.parseDefineMacro(line);
        if (cmd != null) {
            return cmd;
        }
        cmd = CommandUtils.parseRecordCommand(line);
        if (cmd != null) {
            return cmd;
        }
        throw new RuntimeException("Can't parse: " + line);
    }

    private static List<String> parseCall(String[] prefixes, String s, IntRef iRef) {
        int i = iRef == null ? 0 : iRef.value;
        ArrayList<String> args = new ArrayList<String>();
        String[] stringArray = prefixes;
        int n = prefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (s.substring(i).startsWith(prefix)) {
                args.add(prefix);
                i += prefix.length();
                break;
            }
            ++n2;
        }
        if (args.size() == 0) {
            return null;
        }
        int j = i;
        while (j < s.length() && Character.isLetterOrDigit(s.charAt(j))) {
            ++j;
        }
        if (i == j) {
            return null;
        }
        args.add(s.substring(i, j));
        i = j;
        int indent = 1;
        if (i < s.length() && s.charAt(i) == '(') {
            j = i;
            do {
                if ((j = StrUtils.indexOfIgnoreEscaped(s, "()", j + 1)) == -1) {
                    return null;
                }
                if (s.charAt(j) == '(') {
                    ++indent;
                    continue;
                }
                --indent;
            } while (indent > 0);
            args.addAll(StrUtils.splitIgnoreEscaped(s.substring(i + 1, j), ","));
            i = j + 1;
        }
        if (iRef != null) {
            iRef.value = i;
        }
        return args;
    }

    private static String substituteMacro(String line, GlobalEnv globalEnv) {
        int t = 0;
        while (t < 10) {
            String newLine = CommandUtils.substituteMacroOnePass(line, globalEnv);
            if (newLine.equals(line)) {
                return line;
            }
            line = newLine;
            ++t;
        }
        return line;
    }

    private static String substituteMacroOnePass(String line, GlobalEnv globalEnv) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < line.length()) {
            IntRef iRef = new IntRef(i);
            List<String> args = CommandUtils.parseCall(new String[]{"$"}, line, iRef);
            if (args != null) {
                String var = args.get(1);
                String val = globalEnv.getVar(var);
                if (val == null) {
                    throw new RuntimeException("Variable undefined: " + var);
                }
                val = CommandUtils.expandMacro(val, args.subList(2, args.size()));
                sb.append(val);
                i = iRef.value;
                continue;
            }
            sb.append(line.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    private static String expandMacro(String s, List<String> args) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (true) {
            int j;
            if ((j = s.indexOf(92, i)) == -1) {
                j = s.length();
            }
            buf.append(s.substring(i, j));
            if (j == s.length()) break;
            i = j++;
            while (j < s.length() && Character.isDigit(s.charAt(j))) {
                ++j;
            }
            if (i + 1 < j) {
                int argIndex = Integer.parseInt(s.substring(i + 1, j)) - 1;
                if (argIndex < args.size()) {
                    buf.append(args.get(argIndex));
                }
            } else {
                buf.append(s.substring(i, j));
            }
            i = j;
        }
        return buf.toString();
    }

    private static boolean isEndOfChain(String s) {
        return s.equals("}") || s.equals("/");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static CommandNode parseRecordCommand(String line) {
        tokens = StrUtils.splitIgnoreEscaped(line, " ");
        parentCmd /* !! */  = rootCmd = new CombineCommandNode(CombineCommandNode.CombineType.COMPOSE);
        pivotCmds = ListUtils.newList(new CommandNode[]{rootCmd});
        lastLabel = null;
        leafCmd = FuncCommandNode.identityCmd;
        k = 0;
        while (k < tokens.size()) {
            block20: {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    block19: {
                                        block18: {
                                            s = tokens.get(k);
                                            cmd /* !! */  = null;
                                            isEndOfChain = k + 1 == tokens.size() || CommandUtils.isEndOfChain(tokens.get(k + 1)) != false;
                                            flatten = false;
                                            m = StrUtils.match("(.)?\\{", s);
                                            if (!m.matches()) break block18;
                                            type = CombineCommandNode.parseCombineType(m.groupCount() >= 1 ? m.group(1) : null);
                                            cmd /* !! */  = new CombineCommandNode(type);
                                            pivotCmds.add(cmd /* !! */ );
                                            ** GOTO lbl79
                                        }
                                        if (!s.equals("/")) break block19;
                                        parentCmd /* !! */  = ListUtils.getLast(pivotCmds);
                                        break block20;
                                    }
                                    if (!s.equals("}")) break block21;
                                    parentCmd /* !! */  = ListUtils.removeLast(pivotCmds);
                                    break block20;
                                }
                                if (!s.equals("?")) break block22;
                                cmd /* !! */  = FuncCommandNode.childKeysCmd;
                                ** GOTO lbl79
                            }
                            if (!s.equals("..")) break block23;
                            cmd /* !! */  = FuncCommandNode.keySkeletonCmd;
                            ** GOTO lbl79
                        }
                        if (!s.equals("...")) break block24;
                        cmd /* !! */  = FuncCommandNode.identityCmd;
                        ** GOTO lbl79
                    }
                    args = CommandUtils.parseCall(new String[]{"!!", "!"}, s, null);
                    if (args == null) break block25;
                    applyToChildren = args.get(0).length() > 1;
                    i = 2;
                    while (i < args.size()) {
                        args.set(i, args.get(i));
                        ++i;
                    }
                    cmd /* !! */  = new FuncCommandNode(args.get(1), args.subList(2, args.size()), leafCmd, applyToChildren);
                    ** GOTO lbl79
                }
                m = StrUtils.match("'(.*)'", s);
                if (m.matches()) {
                    lastLabel = m.group(1);
                } else {
                    m = StrUtils.match("([^=<>]+)(<=|>=|<|>|==)(.+)", s);
                    if (m.matches()) {
                        keyMatcher = CommandUtils.getMatcher(m.group(1));
                        valueMatcher /* !! */  = new NumMatcher(m.group(2), m.group(3));
                    } else {
                        m = StrUtils.match("([^=]+)=(.+)", s);
                        if (m.matches()) {
                            keyMatcher = CommandUtils.getMatcher(m.group(1));
                            valueMatcher /* !! */  = CommandUtils.getMatcher(m.group(2));
                        } else {
                            m = StrUtils.match("=(.+)", s);
                            if (m.matches()) {
                                keyMatcher = AllMatcher.matcher;
                                valueMatcher /* !! */  = CommandUtils.getMatcher(m.group(1));
                            } else {
                                m = StrUtils.match("(.+)", s);
                                if (m.matches()) {
                                    keyMatcher = CommandUtils.getMatcher(s);
                                    valueMatcher /* !! */  = AllMatcher.matcher;
                                } else {
                                    throw new RuntimeException("Bad filter string: " + s);
                                }
                            }
                        }
                    }
                    cmd /* !! */  = new FilterCommandNode(new RecordNodeMatcher(keyMatcher, valueMatcher /* !! */ ), isEndOfChain != false ? FuncCommandNode.withoutChildrenCmd : leafCmd);
                    flatten = true;
lbl79:
                    // 6 sources

                    v0 = labelSpecified = lastLabel != null;
                    if (labelSpecified) {
                        flatten = false;
                    }
                    cmds = new ArrayList<AbstractRecordNode>();
                    cmds.add(cmd /* !! */ );
                    if (!StrUtils.isEmpty(lastLabel)) {
                        cmds.add(new FuncCommandNode("key", Collections.singletonList(lastLabel), (CommandNode)ListUtils.getLast(cmds), true));
                    }
                    if (flatten) {
                        cmds.add(new FuncCommandNode("flatten", labelSpecified != false ? Collections.singletonList("append") : Collections.EMPTY_LIST, (CommandNode)ListUtils.getLast(cmds), false));
                    }
                    if (parentCmd /* !! */  != null) {
                        cmds.add(parentCmd /* !! */ );
                    }
                    i = 1;
                    while (i < cmds.size()) {
                        if (FuncCommandNode.isImmutableCmd((CommandNode)cmds.get(i))) {
                            throw new RuntimeException("Can't add children to " + cmds.get(i));
                        }
                        ((CommandNode)cmds.get(i)).addChild((RecordNode)cmds.get(i - 1));
                        ++i;
                    }
                    parentCmd /* !! */  = (CommandNode)cmds.get(0);
                    lastLabel = null;
                }
            }
            ++k;
        }
        return CommandUtils.removeFinalFlatten(rootCmd);
    }

    private static CommandNode removeFinalFlatten(CommandNode cmd) {
        if (cmd instanceof FuncCommandNode && ((FuncCommandNode)cmd).getName().equals("flatten") && CommandUtils.numDescendentFilterNodes(cmd, new IntRef(0)) == 1) {
            return (CommandNode)((FuncCommandNode)cmd).getChild();
        }
        CommandNode newCmd = (CommandNode)cmd.withoutChildren();
        for (RecordNode childCmd : cmd.getChildren()) {
            newCmd.addChild(CommandUtils.removeFinalFlatten((CommandNode)childCmd));
        }
        return newCmd;
    }

    private static int numDescendentFilterNodes(CommandNode cmd, IntRef count) {
        if (cmd != null) {
            if (cmd instanceof FilterCommandNode) {
                ++count.value;
            }
            for (RecordNode childCmd : cmd.getChildren()) {
                CommandUtils.numDescendentFilterNodes((CommandNode)childCmd, count);
            }
        }
        return count.value;
    }

    private static Matcher getMatcher(String s) {
        if (s.equals("*")) {
            return AllMatcher.matcher;
        }
        java.util.regex.Matcher m = Pattern.compile("/([^,]+)/").matcher(s);
        if (m.matches()) {
            return new RegexMatcher(m.group(1));
        }
        m = Pattern.compile("\\{([^}]*)\\}").matcher(s);
        if (m.matches()) {
            OrMatcher matcher = new OrMatcher();
            for (String t : StrUtils.splitIgnoreEscaped(m.group(1), ",")) {
                matcher.addMatcher(CommandUtils.getMatcher(t));
            }
            return matcher;
        }
        return new ExactMatcher(s);
    }

    public static CommandNode parseDefineMacro(String line) {
        Pattern p = Pattern.compile("(\\w+)\\s*:=\\s*(.*)");
        java.util.regex.Matcher m = p.matcher(line);
        if (!m.matches()) {
            return null;
        }
        return new FuncCommandNode("define", ListUtils.newList(m.group(1), m.group(2)), FuncCommandNode.identityCmd, false);
    }
}

