/*
 * Decompiled with CFR 0.152.
 */
package LinguaView;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import javax.swing.JPanel;

public abstract class TreePanel<T>
extends JPanel {
    public Dimension area = new Dimension(0, 0);
    public static int minAreaWidth = 175;
    public static int minAreaHeight = 80;
    public ArrayList<T> treebank;
    String flatSentence;
    public int sentenceNumber;
    public int lastIndex;
    public int fontSize = 15;
    public int smallFontSize = 11;
    public int fontDescendent;
    public Font font;
    public Font smallFont;
    public FontMetrics metrics;
    public int topMargin = 60;
    public int bottomMargin = 60;
    public int leftMargin = 20;
    public int rightMargin = 20;
    public int wordSpace = 10;
    public int textTipMargin = 4;
    public int smallfontHight;
    public int fontHight;
    public int doubleFontHight;
    public int tripleFontHight;
    public double levelSize;
    public double levelSizeFactor = 2.0;

    public void loadTreebank(ArrayList<T> treebank) {
        this.treebank = treebank;
        this.lastIndex = treebank.size() - 1;
    }

    public void replaceCurrentSentence(T sent) {
        this.treebank.set(this.sentenceNumber, sent);
    }

    public abstract void init();

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public abstract void render(Graphics2D var1);

    public int sentenceNumber() {
        return this.sentenceNumber();
    }

    public int increaseFontSize() {
        return ++this.fontSize;
    }

    public int decreaseFontSize() {
        if (this.fontSize == 1) {
            return 1;
        }
        return --this.fontSize;
    }

    public int nextSentence() {
        if (this.sentenceNumber == this.lastIndex) {
            this.sentenceNumber = 0;
            return 0;
        }
        return ++this.sentenceNumber;
    }

    public int previousSentence() {
        if (this.sentenceNumber == 0) {
            this.sentenceNumber = this.lastIndex;
            return this.sentenceNumber;
        }
        return --this.sentenceNumber;
    }

    public int goToSentence(int n) {
        if (n < 0) {
            this.sentenceNumber = 0;
            return 0;
        }
        if (n > this.lastIndex) {
            this.sentenceNumber = this.lastIndex;
            return this.sentenceNumber;
        }
        this.sentenceNumber = n;
        return this.sentenceNumber;
    }

    public void loadFont() {
        this.font = new Font("SansSerif", 0, this.fontSize);
        this.smallFont = new Font("SansSerif", 1, this.smallFontSize);
        this.metrics = this.getFontMetrics(this.font);
        this.fontDescendent = this.metrics.getDescent();
        this.smallfontHight = this.metrics.getHeight();
        this.fontHight = this.metrics.getHeight();
        this.doubleFontHight = 2 * this.fontHight;
        this.tripleFontHight = 3 * this.fontHight;
        this.levelSize = (double)this.fontHight * this.levelSizeFactor;
    }

    public Dimension getDimension() {
        return this.area;
    }

    public abstract void loadSentence();
}

