/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.Position;
import javax.swing.text.View;

public class PHtmlView
extends PNode {
    private static final long serialVersionUID = 1L;
    public static final Font DEFAULT_FONT = new Font("SansSerif", 0, 12);
    public static final Color DEFAULT_TEXT_COLOR = Color.BLACK;
    public static final String PROPERTY_FONT = "font";
    public static final int PROPERTY_CODE_FONT = 0x100000;
    public static final String PROPERTY_TEXT = "text";
    public static final int PROPERTY_CODE_TEXT = 0x200000;
    public static final String PROPERTY_TEXT_COLOR = "text color";
    public static final int PROPERTY_CODE_TEXT_COLOR = 0x400000;
    private final JLabel label;
    private transient View htmlView;

    public PHtmlView() {
        this(null, DEFAULT_FONT, DEFAULT_TEXT_COLOR);
    }

    public PHtmlView(String string) {
        this(string, DEFAULT_FONT, DEFAULT_TEXT_COLOR);
    }

    public PHtmlView(String string, Font font, Color color) {
        this.label = new JLabel(string);
        this.label.setFont(font);
        this.label.setForeground(color);
        super.setBounds(0.0, 0.0, this.label.getPreferredSize().getWidth(), this.label.getPreferredSize().getHeight());
        this.update();
    }

    public String getText() {
        return this.label.getText();
    }

    public void setText(String string) {
        String string2 = this.label.getText();
        if (string2 == null && string == null) {
            return;
        }
        if (string2 == null || !string2.equals(string)) {
            this.label.setText(string);
            this.update();
            this.firePropertyChange(0x200000, PROPERTY_TEXT, string2, this.label.getText());
        }
    }

    public Font getFont() {
        return this.label.getFont();
    }

    public void setFont(Font font) {
        Font font2 = this.label.getFont();
        this.label.setFont(font);
        this.update();
        this.firePropertyChange(0x100000, PROPERTY_FONT, font2, this.label.getFont());
    }

    public Color getTextColor() {
        return this.label.getForeground();
    }

    public void setTextColor(Color color) {
        Color color2 = this.label.getForeground();
        this.label.setForeground(color);
        this.repaint();
        this.firePropertyChange(0x400000, PROPERTY_TEXT_COLOR, color2, this.label.getForeground());
    }

    private void update() {
        String string = this.label.getText();
        if (string == null) {
            string = "";
        }
        this.htmlView = BasicHTML.createHTMLView(this.label, string);
        this.fitHeightToHtmlContent();
        this.repaint();
    }

    private void fitHeightToHtmlContent() {
        if (this.getWidth() > 0.0) {
            this.htmlView.setSize((float)this.getWidth(), 0.0f);
            float f = this.htmlView.getPreferredSpan(1);
            this.label.setSize(new Dimension((int)this.getWidth(), (int)f));
            if (this.getHeight() < (double)f) {
                System.out.println(this.getHeight());
                System.out.println(f);
                super.setBounds(this.getX(), this.getY(), this.getWidth(), f);
            }
        }
    }

    public boolean setBounds(double d, double d2, double d3, double d4) {
        boolean bl = super.setBounds(d, d2, d3, d4);
        this.update();
        return bl;
    }

    public boolean setBounds(Rectangle2D rectangle2D) {
        boolean bl = super.setBounds(rectangle2D);
        this.update();
        return bl;
    }

    protected void paint(PPaintContext pPaintContext) {
        super.paint(pPaintContext);
        pPaintContext.pushClip(this.getBounds());
        Graphics2D graphics2D = pPaintContext.getGraphics();
        this.htmlView.paint(graphics2D, this.getBounds().getBounds());
        pPaintContext.popClip(this.getBounds());
    }

    public String getLinkAddressAt(Point2D point2D) {
        return this.getLinkAddressAt(point2D.getX(), point2D.getY());
    }

    public String getLinkAddressAt(double d, double d2) {
        String string;
        String string2 = this.label.getText();
        String string3 = null;
        int n = 0;
        for (int i = this.pointToModelIndex(d, d2); n < string2.length() && (n = string2.indexOf(60, n)) != -1 && i >= n; i += string.length()) {
            int n2 = n;
            int n3 = this.findTagEnd(string2, n);
            if (n3 == -1) {
                return null;
            }
            n = n3 + 1;
            string = string2.substring(n2, n);
            if (!"</a>".equals(string)) continue;
            string3 = null;
        }
        return string3;
    }

    private int pointToModelIndex(double d, double d2) {
        Position.Bias[] biasArray = new Position.Bias[1];
        return this.htmlView.viewToModel((float)d, (float)d2, this.getBounds(), biasArray);
    }

    private int findTagEnd(String string, int n) {
        int n2 = n;
        ++n2;
        while (n2 > 0 && n2 < string.length() && string.charAt(n2) != '>') {
            if (string.charAt(n2) == '\"') {
                n2 = string.indexOf(34, n2 + 1);
            } else if (string.charAt(n2) == '\'') {
                n2 = string.indexOf(39, n2 + 1);
            }
            ++n2;
        }
        if (n2 == 0 || n2 >= string.length()) {
            return -1;
        }
        return n2 + 1;
    }

    private String extractHref(String string) {
        int n = 0;
        String string2 = null;
        while (n >= 0 && n < string.length() - 1) {
            if ((n = string.indexOf(61, n + 1)) == -1 || !this.isHrefAttributeAssignment(string, n)) continue;
            return this.extractHrefValue(string, n + 1);
        }
        return string2;
    }

    private String extractHrefValue(String string, int n) {
        int n2 = n;
        if (string.charAt(n2) == '\"') {
            int n3 = n2 + 1;
            if ((n2 = string.indexOf(34, n3)) == -1) {
                return null;
            }
            return string.substring(n3, n2);
        }
        if (n2 < string.length() && string.charAt(n2) == '\'') {
            int n4 = n2 + 1;
            if ((n2 = string.indexOf(39, n4)) == -1) {
                return null;
            }
            return string.substring(n4, n2);
        }
        int n5 = n2;
        if (n2 < string.length()) {
            while (++n2 < string.length() && string.charAt(n2) != ' ' && string.charAt(n2) != '>') {
            }
        }
        return string.substring(n5, n2);
    }

    private boolean isHrefAttributeAssignment(String string, int n) {
        return string.charAt(n) == '=' && n > 4 && " href".equals(string.substring(n - 5, n));
    }
}

