#!/usr/bin/perl
use strict;

my %argHash = ();
my %senseHash = ();
my $sum = 0;
sub byTotal {$argHash{$b} <=> $argHash{$a}}

while(<STDIN>){
    chomp;
    if(m/^([^\(\)]+) \((\d+),(\d+)\): (.+)$/){
        my $argKey = join("-",sort(split / /, $1));
        my $numTypes = $2;
        my $numTokens = $3;
        $argHash{$argKey} += $numTokens;
        $sum += $numTokens;
        my $typeList = $4;
        while($typeList =~ s/\[([^ ]+) [^ ]+\]=(\d+)//){
            my $sense = $1;
            my $num = $2;
            $senseHash{$argKey."---".$sense} = $num;
        }
#        print "$argKey\n";
    }
}

#my $sumProb = 0.0;
#foreach my $key (sort byTotal keys %argHash){
#    $sumProb += ($argHash{$key} / $sum);
    #print "$key => $argHash{$key} ($sumProb)\n";
#    print "VS : $key = $argHash{$key}\n";
#}

foreach my $key (sort keys %senseHash){
    my ($cluster, $sense) = ($key =~ m/(.+)---(.+)/);
    #print "VS $cluster : $sense = $senseHash{$key}\n";
    print "Cl $sense : $cluster = $senseHash{$key}\n";
}

