# requires a G model.  can get from tmpdat.

while (<>) {
  chomp;

  if ( m/^\#/ ) { 
    next; 

  } 
  # read in P(lclc|udlce)
  elsif ( m/^M +(.*)\{(.*)\} +: +([^=]*)( = (.*))?$/ ) {
	  $P_lclcgivlce{$1}{$3}{$2} = $5;
	  #$P_lclcgivlce{"$1\{unk\} : $3"} += $5;
	  # print out later
  } 
  # read in P(x)
  elsif ( m/^HW +: +([^=]*)( = (.*))?$/ ) {
	  $P_x{$1} = $3;
	  # print out later (degenerate)
  } 
  # read in P(udlce) at root
  elsif ( m/^Gr +: +(.*)\{(.*)\}( = (.*))?$/ ) {
	  $Ppi_lce{"$1\{unk\}"} += $4;
	  # print out later
  } 
  # read in P(e|le)
  elsif ( m/^L ([^ ]*) +([^ ]*) +: +([^ ]*)( = (.*))?$/ ) {
	  $P_egivle{"$1 unk : unk"} = 1;
	  # print out later
  } 

  # read in P(x|e)
  elsif ( m/^X +(.*) +: +([^=]*)( = (.*))?$/ ) {
	  #my $model = $1; my $cond = $2; my $targ = $3; my $prob = $5;
	  $P_xgive{$1}{$2} = $4;
	  # no printout -- get rid of this model
  } 
  # read in P(e)
  elsif ( m/^E +: +([^=]*)( = (.*))?$/ ) {
	  $P_e{$1} = $3;
	  # no printout -- get rid of this model
  } 
  # read in P(udlce) everywhere
  elsif ( m/^G +: +(.*)\{(.*)\}( = (.*))?$/ ) {
	  $P_lce{$1}{$2} = $4;
	  #print "read LCE $1 $2 = $4\n";
	  # no printout -- get rid of this model
  } 
  # any other rule
  else {
	  print $_."\n";
  }

}

foreach my $udlc (keys %P_lclcgivlce) {
	foreach my $lclc (keys %{$P_lclcgivlce{$udlc}}) {
		foreach my $e (keys %{$P_lclcgivlce{$udlc}{$lclc}}) {
			#print "$udlc $lclc $e, unk version summed over $P_lclcgivlce{$udlc}{$lclc}{$e} * $P_lce{$udlc}{$e}\n";
			$P_lclcandlc{$udlc}{$lclc} += $P_lclcgivlce{$udlc}{$lclc}{$e} * $P_lce{$udlc}{$e};
			$P_lc{$udlc} += $P_lclcgivlce{$udlc}{$lclc}{$e} * $P_lce{$udlc}{$e};
		}
	}
}
foreach my $udlc (keys %P_lclcandlc) {
	foreach my $lclc (keys %{$P_lclcandlc{$udlc}}) {
		$P_lclcgivlc{"$udlc\{unk\} : $lclc"} = $P_lclcandlc{$udlc}{$lclc} / $P_lc{$udlc};
	}
}

# print out resulting models
foreach my $key (sort keys %Ppi_lce) {
	print "Gr : $key = $Ppi_lce{$key}\n";
}
foreach my $key (sort keys %P_lclcgivlc) {
	print "M $key = $P_lclcgivlc{$key}\n";
}
foreach my $key (sort keys %P_egivle) {
	print "L $key = $P_egivle{$key}\n";
}
print "HW : unk = 1.0\n";
