#!/usr/bin/ruby


class CountedG <

  # a CountedG has a G and a count to represent its popularity
  Struct.new(:g, :count)

  # a method to print out count followed by g
  def print_count_g
    printf("%d %s", count, g)
  end
  
  def print_g
    print g
  end
end

#------#
# MAIN #
#------#

#hack to run in ide
f = File.open("allG") or die "Unable to open file..."

topNumG = ARGV[0] != nil ? ARGV[0].to_i : 120

# define an array to hold the CountedG records
arr = Array.new
countedG = CountedG.new
countedG.g = ""

#while($line = gets)
f.each_line do |$line| 
  if countedG.g != $line
    if countedG.g != ""
      arr.push(countedG)
    end
    countedG = CountedG.new
    countedG.g = $line
    countedG.count = 1
  else
    countedG.count = countedG.count + 1
  end
end

# sort the data by the count
arr.sort! { |a,b| a.count <=> b.count }

# print out all the sorted records (just print to stdout)
arr.reverse.each { |p|
  p.print_g
}
