###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

#!/usr/bin/ruby

######################################################################
# pushUpPBRLabels.rb
# 
# PropBank SRL labels on the leaf node will be pushed up onto the tree. The algo.
# is to set a parent to ARGi when all of their children have ARGi.
#
# TO RUN: cat genmode/all.wsjpu.bintrees | ruby scripts/pushUpPBRLabels.rb 
#
######################################################################

require "scripts/umnlp.rb"

$ID = /ID\!pbrdelim\!/
$NON_ID = /(REL|ARG)[^\!]*\!pbrdelim\!/
$LDELIM = "!pbrdelim!"
#####
class Tree
  
  def pushUp
    #$stderr.print @head, "\n"
    if @children.size == 1 && @children[0].children.size == 0
      s = @children[0].head.match( /(.*):([^:]*)/ )
      if s.nil?
        $stderr.print $lineNum, "leaf has no arg: ", self.to_s , "\n"
        @head = "ID" + $LDELIM + @head
      else
        @children[0].head = s[1]
        @head = (s[2] == "NULL" ? "ID" : s[2]) + $LDELIM + @head
      end
    else
      @children.each { |c| c.pushUp }
      childLbl = @children[0].head.split($LDELIM)[0]
      sameLblOnChildren = true
      @children.each { |c| 
        if c.head.split($LDELIM)[0] != childLbl
          sameLblOnChildren = false
          break
        end
      }
      if sameLblOnChildren
        @head = childLbl + $LDELIM + @head
        @children.each { |c| c.head = "ID" + $LDELIM + c.head.split($LDELIM, 2)[1] }
      else
        @head = "ID" + $LDELIM + @head
      end
    end

    self
  end
  
  def pushDownUnary
    if @head.match($NON_ID) && @children.size == 1 && @children[0].head.match($ID)
      p = @head.split($LDELIM)
      @head = "ID" + $LDELIM + p[1]
      @children[0].head = p[0] + $LDELIM + @children[0].head.split($LDELIM)[1]
      children[0].pushDownUnary
    else
      @children.each { |c| c.pushDownUnary }
    end
    self
  end
  
end

##########################################

$lineNum = 0
#File.open("ttt").each_line do |line| 
while (line = STDIN.gets)
  $lineNum = $lineNum + 1
  t = Tree.new(line).pushUp.pushDownUnary
  print t.to_s, "\n"
end
