###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

#!/usr/bin/ruby

#####################################################################
# propArgs.rb
# Tim Miller
# 
# This script works on binarized trees in a top-down fashion to propagate
# argument structure, to emulate some features of lexicalization without
# requiring any changes to the parser.
# Rules of type X -> X NP will be changed to X -> X-argNP NP
# and the same with S.
#
######################################################################

require "scripts/umnlp.rb"

class Tree
  def myFunc ( tot )

    if @children.size>2
      tot += @children.size-2
    end

    @children.each { |child|
      tot = child.myFunc(tot)
    }
    
    return tot

  end
end

count = 0

while(line = gets)
  t = Tree.new(line)
  count += t.myFunc(0)
end

print count.to_s + "\n"
