

%%%%% GETTING DATA OUT

% Hypoth data constants
HypVECALL  = 1;
HypVECWORDS= 2;
HypHEADIND = 3;
HypHEADSTR = 4;
HypMIND = 5;
HypMSTR = 6;
HypMHMIND = 7;
HypMHMSTR = 8;
% Gold data constants
GldHEADVEC  = 1;
GldMHMVEC   = 2;
GldMHHMVEC  = 3;
GldMHMMVEC  = 4;
GldMHHHMVEC = 5;
% Comparisons
NUMCOMPARISONS = 17;
ALL2ADD  = 1;
ALL2MULT = 2;
ALL2HEAD = 3;
ALL2MHM = 4;
ALL2MHHM = 5;
ALL2MHMM = 6;
ALL2MHHHM = 7;
ADD2HEAD = 8;
ADD2MHM = 9;
ADD2MHHM = 10;
ADD2MHMM = 11;
ADD2MHHHM = 12;
MULT2HEAD = 13;
MULT2MHM = 14;
MULT2MHHM = 15;
MULT2MHMM = 16;
MULT2MHHHM = 17;


if ( size(hypoth{1,HypVECALL},2) ~= size(gold{1,GldHEADVEC},2) )
  disp('ERROR: hypoth and gold sizes don''t match')
end


vecsadd  = zeros(size(hypoth,1),size(hypoth{1,1},2)); % vectors from adding
vecsmult = zeros(size(hypoth,1),size(hypoth{1,1},2)); % vectors from multiplying
similarities = zeros(size(hypoth,1),NUMCOMPARISONS);               % results

for sentnum = 1:size(hypoth,1)


  %%% Calculate data piece-by-piece compositions

  % Additive
  vecsadd(sentnum,:) = sum(hypoth{sentnum,HypVECWORDS},1);
  % Multiplicative
  vecsmult(sentnum,:) = prod(hypoth{sentnum,HypVECWORDS},1);


  %%% Do comparisons
  similarities(sentnum,ALL2ADD)    = cossim( hypoth{sentnum,HypVECALL}, vecsadd(sentnum,:) );
  similarities(sentnum,ALL2MULT)   = cossim( hypoth{sentnum,HypVECALL}, vecsmult(sentnum,:) );
  similarities(sentnum,ALL2HEAD)   = cossim( hypoth{sentnum,HypVECALL}, gold{sentnum,GldHEADVEC} );
  similarities(sentnum,ALL2MHM)    = cossim( hypoth{sentnum,HypVECALL}, gold{sentnum,GldMHMVEC} );
  similarities(sentnum,ALL2MHHM)   = cossim( hypoth{sentnum,HypVECALL}, gold{sentnum,GldMHHMVEC} );
  similarities(sentnum,ALL2MHMM)   = cossim( hypoth{sentnum,HypVECALL}, gold{sentnum,GldMHMMVEC} );
  similarities(sentnum,ALL2MHHHM)  = cossim( hypoth{sentnum,HypVECALL}, gold{sentnum,GldMHHHMVEC} );
  similarities(sentnum,ADD2HEAD)   = cossim( vecsadd(sentnum,:), gold{sentnum,GldHEADVEC} );
  similarities(sentnum,ADD2MHM)    = cossim( vecsadd(sentnum,:), gold{sentnum,GldMHMVEC} );
  similarities(sentnum,ADD2MHHM)   = cossim( vecsadd(sentnum,:), gold{sentnum,GldMHHMVEC} );
  similarities(sentnum,ADD2MHMM)   = cossim( vecsadd(sentnum,:), gold{sentnum,GldMHMMVEC} );
  similarities(sentnum,ADD2MHHHM)  = cossim( vecsadd(sentnum,:), gold{sentnum,GldMHHHMVEC} );
  similarities(sentnum,MULT2HEAD)  = cossim( vecsmult(sentnum,:), gold{sentnum,GldHEADVEC} );
  similarities(sentnum,MULT2MHM)   = cossim( vecsmult(sentnum,:), gold{sentnum,GldMHMVEC} );
  similarities(sentnum,MULT2MHHM)  = cossim( vecsmult(sentnum,:), gold{sentnum,GldMHHMVEC} );
  similarities(sentnum,MULT2MHMM)  = cossim( vecsmult(sentnum,:), gold{sentnum,GldMHMMVEC} );
  similarities(sentnum,MULT2MHHHM) = cossim( vecsmult(sentnum,:), gold{sentnum,GldMHHHMVEC} );
  
  
end

