///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. //
//                                                                           //
//    ModelBlocks is free software: you can redistribute it and/or modify    //
//    it under the terms of the GNU General Public License as published by   //
//    the Free Software Foundation, either version 3 of the License, or      //
//    (at your option) any later version.                                    //
//                                                                           //
//    ModelBlocks is distributed in the hope that it will be useful,         //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          //
//    GNU General Public License for more details.                           //
//                                                                           //
//    You should have received a copy of the GNU General Public License      //
//    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
//
//  HdwdVectSemLangModel.h -- for vector semantic language model
//
////////////////////////////////////////////////////////////////////////////////

#include "nl-cpt.h"

//#ifndef USE_HDWDVECTSEMLANGMODEL
//#define USE_HDWDVECTSEMLANGMODEL
//#endif

char psX[]="";
char psComma[]=",";
char psSemi[]=";";
char psSemiSemi[]=";;";
char psColon[]=":"; //added
char psColonColon[]="::"; //added
char psDashDiamondDash[]="-<>-";
char psTilde[]="~";
char psSlash[]="/"; //added
//char psBar[]="|";
//char psOpenBrace[]="{";
//char psCloseBrace[]="}";
char psLangle[]="<";
char psRangle[]=">";
char psLbrack[]="[";
char psRbrack[]="]";
char psLbrace[]="{"; //added
char psRbrace[]="}"; //added
char psSpace[]=" "; //added

const int SEM_VECTOR_SIZE   = 2;
const double UNIFORM        = 0.000044843;// = 1/22300, the number of headwords in wsj// .5;//
const double LAMBDA_LMOD[3] = { .2, .2, .6 }; // for backoff: l1*P(m|h) + l2*P(m) + l3*1/|e|
const double LAMBDA_E       = 0.125;//0.1;//0.0;//.0000000001;//1.0;//0.5//0.75;//

//const char* BEG_STATE = "{-}S/end|end;{-}-/-|-;{-}-/-|-;{-}-/-|-;";
//const char* END_STATE = "{-}S/end|end;{-}-/-|-;{-}-/-|-;{-}-/-|-;";
const char* BEG_STATE = "{-/0::0,}S/end|end;{-/0::0,}-/-|-;{-/0::0,}-/-|-;{-/0::0,}-/-|-;";
const char* END_STATE = "{-/0::0,}S/end|end;{-/0::0,}-/-|-;{-/0::0,}-/-|-;{-/0::0,}-/-|-;";

string previousWord = "-";
bool modelsLoaded = false;

//const char* BEG_STATE = "S/end|end;-/-|-;-/-|-;-/-|-";
//const char* END_STATE = "S/end|end;-/-|-;-/-|-;-/-|-";
//#define STAN
const bool VERBOSE      = true;//false;//
const bool BACKOFF_E    = true;//false;//
const bool NORM_IS_MAX  = true;//false;//
const bool EMPTY_IS_UNK = true;//false;//   // false is not working
const bool SHOW_STRINGS = false;//true;//
const bool SHOW_VECTORS = false;//true;//
const bool FULL_BACKOFF = false;//true;//
const bool DEBUG        = false;//true;//

////////////////////////////////////////////////////////////////////////////////
//
//  Random Variables
//
////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////// Simple Variables

//// D: depth (input only, to HHMM models)...
DiscreteDomain<char> domD;
typedef DiscreteDomainRV<char,domD> D;
const D D_0("0");
const D D_1("1");
const D D_2("2");
const D D_3("3");
const D D_4("4");
const D D_5("5");


//// F: final-state...
DiscreteDomain<char> domF;
typedef DiscreteDomainRV<char,domF> F;
const F F_0("0");
const F F_1("1");

typedef DiscreteDomainRV<char,domF> IP;
const IP IP_0("0");
const IP IP_1("1");

//// L: relation label...
DiscreteDomain<int> domL;
typedef DiscreteDomainRV<int,domL> L;
const L L_NONE("-");
const L L_HEHM("HEHM");
const L L_HEMH("HEMH");
const L L_HM("HM");
const L L_MH("MH");
const L L_HE("HE");
const L L_COPY("COPY");

const char* NONE_string = "-";
const char* UNIF_string = "eT";
const char* TOP_string  = "TOP";

DiscreteDomain<int> domHW;
typedef DiscreteDomainRV<int,domHW> HW;
const HW HW_NONE(NONE_string);
const HW HW_UNIF(UNIF_string);



//class Ref2DModel;    // matrix, to be defined later
//class IdentityModel; // diagonal, to be defined later

//// Model of HW and HW (joint), the Referent Probability Model from WSJPARSE headword data
class Ref1DModel : public CPT1DModel<HW,Prob> {
 public:
  //static Prob MAX_E_UNIF;
  //static bool firstTime;
  typedef CPT1DModel<HW,Prob>::IterVal IterVal;
  /*
  Prob max ( ) {
    if (Ref1DModel::firstTime) {
      Prob maximum;
      Ref1DModel::firstTime = false;
      Ref1DModel::IterVal hw;
      for ( bool b=setFirst(hw); b; b=setNext(hw) ) {
	maximum = (getProb(hw)>maximum) ? getProb(hw) : maximum;
      }
      Ref1DModel::MAX_E_UNIF = maximum;
    }
    return Ref1DModel::MAX_E_UNIF;
  }
  bool setFirst (IterVal i ) { return mRef1DModel.setFirst(i); }
  bool setNext (IterVal i )  { return mRef1DModel.setNext(i); }
  Prob getProb (IterVal i )  { return mRef1DModel.getProb(i); }
  bool contains (HW hw )     { return mRef1DModel.contains(hw); }

  friend pair<StringInput,Ref1DModel*> operator>> ( StringInput si, Ref1DModel& m ) { return pair<StringInput,Ref1DModel*>(si,&m); }
  friend StringInput operator>> ( pair<StringInput,Ref1DModel*> delimbuff, const char* psD ) {
    StringInput si,si1,si2;
    String str;
    CPT1DModel<HW,Prob> tmpRef1DModel;
    si1 = delimbuff.first;
    si = delimbuff.first>>tmpRef1DModel>>psD;

    if ( si1!=NULL ) { si1>>delimbuff.second->mRef1DModel>>psD; } else return StringInput(NULL);

    Ref1DModel::IterVal hw;
    // should only have one new value, but loop anyways
    for (bool b=tmpRef1DModel.setFirst(hw); b; b=tmpRef1DModel.setNext(hw)) {
      //cerr<<" got hw "<<hw<<"= "<<tmpRef1DModel.getProb(hw)<<" vs. "<<Ref1DModel::MAX_E_UNIF<<endl;
      if ( tmpRef1DModel.getProb(hw)>Ref1DModel::MAX_E_UNIF ) { //&& mHW.getProb(hw)<Prob(1.0) ) {
	//cerr<<" got hw "<<hw<<"= "<<tmpRef1DModel.getProb(hw)<<" > "<<Ref1DModel::MAX_E_UNIF<<endl;
	Ref1DModel::MAX_E_UNIF = tmpRef1DModel.getProb(hw);
      } // else, don't change
    }
    return ( si!=NULL ) ? si : StringInput(NULL);
  }
  */
};
//Prob Ref1DModel::MAX_E_UNIF  = Prob();
//bool Ref1DModel::firstTime = true;

class Ref2DModelTranspose : public CPT2DModel<HW,HW,Prob> {
 public:
  //Ref2DModelTranspose ( ) : CPT2DModel<HW,HW,Prob>( ) { }
  typedef CPT2DModel<HW,HW,Prob>::IterVal IterVal;
};

typedef CPT2DModel<HW,HW,Prob> Ref2DModel;
class IdentityModel { };
class HeadModel     { };
class MarginalizeModel { };

class LModel {
 public:
  static Ref2DModel LMod;   //L relation for a Modifier
  static Ref1DModel mHW;    //marginal distribution of headwords
  static Ref2DModelTranspose LpMod;  //L' relation for a Modifier
  static const IdentityModel LHead;
  static const HeadModel     LpHead;
  static const MarginalizeModel LAll;

  typedef HW RVType;
  static Prob max;
  static Prob min;

  // this is the max probability in the eT vector. used for expansion eT evaluation in NORM_IS_MAX
  static Prob getMaxHW ( ) {
    if (LModel::max == Prob() && modelsLoaded) { // finding this max occurs based on global var, after models are loaded
      Ref1DModel::IterVal hw;
      if (mHW.setFirst(hw)) {
	for ( bool b=mHW.setFirst(hw); b; b=mHW.setNext(hw) ) {
	  if ( mHW.getProb(hw)>max ) max = mHW.getProb(hw);
	}
      }
    }
    return max;
  }
  static Prob getMinHW ( ) {
    if (LModel::min == Prob(1.0) && modelsLoaded) {
      Ref1DModel::IterVal hw;
      for ( bool b=mHW.setFirst(hw); b; b=mHW.setNext(hw) ) {
	if ( mHW.getProb(hw)<min ) min = mHW.getProb(hw);
      }
    }
    return min;
  }

  friend pair<StringInput,LModel*> operator>> ( StringInput si, LModel& m ) { return pair<StringInput,LModel*>(si,&m); }
  friend StringInput operator>> ( pair<StringInput,LModel*> delimbuff, const char* psD ) {
    StringInput si;
    if ( (si=delimbuff.first>>"HD ">>delimbuff.second->mHW>>psD)!=NULL ||
	 (si=delimbuff.first>>"LM  ">>delimbuff.second->LMod>>psD)!=NULL ||
	 (si=delimbuff.first>>"LpM "  >>delimbuff.second->LpMod>>psD)!=NULL ) {
      modelsLoaded = true;
      return si;
    } else {
      return StringInput(NULL);
    }
  }
};
Ref1DModel LModel::mHW   = Ref1DModel();
Ref2DModel LModel::LMod  = Ref2DModel();
Ref2DModelTranspose LModel::LpMod = Ref2DModelTranspose();
const IdentityModel LModel::LHead  = IdentityModel();
const HeadModel     LModel::LpHead = HeadModel();
const MarginalizeModel LModel::LAll   = MarginalizeModel();
Prob LModel::max = Prob();
Prob LModel::min = Prob(1.0);




//// Eleft: headword referent already recognized on this stack level...
typedef HW Eleft;
Eleft El_NONE(NONE_string);
Eleft El_UNIF(UNIF_string);
Eleft El_TOP(TOP_string);

//// Eright: vector headword referent built by matrix composition; sparse if Eleft == nil
class Eright {
 private:
  SimpleHash<HW,Prob> mHWvect;
 public:
  const static int NUM_VARS = 1;
  typedef SimpleHash<HW,Prob>::const_iterator iter;
  enum ProbType { EMPTY, UNIF, NORMAL, TOP };
  enum ProbType probType;
  Prob probNorm;
  Prob min;
  Eright ( ) 		{ probType = EMPTY; probNorm = Prob(1.0);}
  Eright ( int i )	{ SimpleHash<HW,Prob> mHWvect(i); }
  Eright ( string a )   {
    if (a.compare(TOP_string)==0) {
      probType = TOP; probNorm = Prob(1.0);
    }
    else if (a.compare(UNIF_string)==0) {
      probType = UNIF;
      probNorm = (NORM_IS_MAX) ? LModel::getMaxHW() : Prob(1.0);
      min = LModel::getMinHW();
    }
    else if (a.compare(NONE_string)==0) {
      probType = EMPTY;
      probNorm = Prob(1.0);
    }
    else
      set( HW(a.c_str()), Prob(1.0) );
  }
  Eright ( string a, Prob p )   {
    if (a.compare(TOP_string)==0) { probType = TOP; probNorm = p; }
    else set( HW(a.c_str()), p );
  }
  bool operator== ( const Eright& eright ) const {
    if (eright.probType!=probType || eright.probNorm!=probNorm) {
      return false;
    } else {
      for ( iter i = mHWvect.begin(); i!= mHWvect.end(); i++ ) {
	if ( eright.mHWvect.get(i->first) != mHWvect.get(i->first) ) {
	  return false;
	}
      }
      // necessary to check the other way around?
    }
    return true;
  }
  size_t getHashKey   ( ) const { size_t k=0;
    for(iter i = mHWvect.begin(); i!= mHWvect.end(); i++) {
      HW w = i->first;
      rotLeft(k,3); k^=LogProb(get(w)).getHashKey(); //k++; //
    }
    rotLeft(k,3); k^=probType;
    rotLeft(k,3); k^=int(probNorm);
    return k;
  }

  void set ( const HW hw, const Prob pr ) {
    if ( hw==HW_NONE ) { // careful: any "-" referent will cause all 0 probabilities to appear
      probType = EMPTY;
      probNorm  = Prob(1.0);
    } else if (hw==HW_UNIF) { // careful: any "eT" referent will cause all UNIF probabilities to appear
      probType = UNIF;
      probNorm  =  ( NORM_IS_MAX ? LModel::getMaxHW() : Prob(1.0) );//Prob(1.0);//
    } else {
      if (probType != NORMAL) {
	probNorm  = Prob(0.0);
	probType = NORMAL;
      }
      if (pr>Prob()) {
	probNorm = updateNorm(probNorm,pr);
	min = updateMin(probNorm,pr);
	mHWvect.set( hw ) = pr;
      }
    }
  }
  Prob  get ( const HW hw ) const {
    if ( hw==HW_NONE ) { // careful: any "-" referent will cause all 0 probabilities to appear
      return Prob();
    } else if (hw==HW_UNIF) { // careful: any "eT" referent will cause all UNIF probabilities to appear
      return Prob(UNIFORM);
    } else {
      return mHWvect.get( hw );
    }
  }
  double  getProb ( const string ) const;
  iter begin ( ) const { return mHWvect.begin(); }
  iter end   ( ) const { return mHWvect.end(); }

  Prob updateNorm ( Prob pr1, const Prob pr2 ) const {
    if ( NORM_IS_MAX ) {
      return (pr2>pr1) ? pr2 : pr1;
    }
    else {
      return pr1 + pr2;
    }
  }
  Prob updateMin ( Prob pr1, const Prob pr2 ) const {
    return (pr2<pr1 && pr2>Prob()) ? pr2 : pr1;
  }

  LogProb norm ( ) const {
    //if (probType==Eright::NORMAL) {
      if (SHOW_VECTORS) {
	Prob pr = 0;
	for (iter i = begin(); i!=end(); i++) {
	  pr = updateNorm(pr,get(i->first));//pr = pr + get(i->first);//.toProb();//
	}
	if (pr != probNorm) cerr<<"\nWARNING: norm()="<<pr<<" != probNorm="<<probNorm<<endl;
	//if (VERBOSE) cerr<<" norm returning pr="<<pr<<"  =  "<<LogProb(pr)<<endl;
	return LogProb(pr);
      } else {
	LogProb tmp = LogProb(probNorm);
	return LogProb(probNorm);
      }
  }


  friend ostream& operator<< ( ostream& os, const Eright& a ) {
    /*
    if ( a.probType == EMPTY ) {
      os<<Eright::EMPTY<<psColonColon<<a.probNorm<<",";//NONE_string;
    } else if ( a.probType == UNIF ) {
      os<<Eright::UNIF<<psColonColon<<a.probNorm<<",";//UNIF_string;
    } else if ( a.probType == TOP ) {
      os<<Eright::TOP<<psColonColon<<a.probNorm<<",";//TOP_string;
    } else { //a.probType==NORMAL
      os<<Eright::NORMAL<<psColonColon<<a.probNorm<<",";
    */
      if (SHOW_VECTORS) {
	for(iter i = a.begin(); i!= a.end(); i++) {
	  HW w = i->first;
	  os<<((i==a.begin())?"":psComma)<<w<<psColon<<a.get(w);
	}
      } else {
	os<<a.norm();
      }
      //}
    return os;
  }
  friend String& operator<< ( String& str, const Eright& a ) {
    /*
    if ( a.probType == EMPTY ) {
      str<<Eright::EMPTY<<psColonColon<<a.probNorm<<",";//NONE_string;
    } else if ( a.probType == UNIF ) {
      str<<Eright::UNIF<<psColonColon<<a.probNorm<<",";//UNIF_string;
    } else if ( a.probType == TOP ) {
      str<<Eright::TOP<<psColonColon<<a.probNorm<<",";//TOP_string;
    } else { //a.probType==NORMAL
      str<<Eright::NORMAL<<psColonColon<<a.probNorm<<",";
    */
      if (SHOW_VECTORS) {
	for(iter i = a.begin(); i!= a.end(); i++) {
	  HW w = i->first;
	  str<<((i==a.begin())?"":psComma)<<w<<psColon<<a.get(w);
	}
      } else {
	str<<a.norm();
      }
      //}
    return str;
  }
  string getString() const;
  //string getNormString() const;

  friend pair<StringInput,Eright*> operator>> ( StringInput ps, Eright& h ) { return pair<StringInput,Eright*>(ps,&h); }
  friend StringInput    operator>> ( pair<StringInput,Eright*> delimbuff, const char* psPostDelim ) {
    if (StringInput(NULL)==delimbuff.first) return delimbuff.first;
    String specialptr; StringInput si;
    si=delimbuff.first>>specialptr>>psPostDelim;
    // split input string on commas and colons
    Array<char*> vectElements;
    specialptr.split(vectElements,",");
    for (unsigned int i=0; i<vectElements.size(); i++) {
      if (i==0) { // to deal with ECode, put the probType::probNorm at the beginning
	Array<char*> probTypeAndNorm;
	String sProbTypeAndNorm = vectElements.get(i);
	sProbTypeAndNorm.split(probTypeAndNorm,psColonColon);
	//set probNorm
	//delimbuff.second->probNorm = Prob( atof(probTypeAndNorm.get(1)) );

	//set probType
	switch ( atoi(probTypeAndNorm.get(0)) )  //set the probType
	  {
	  case 0: delimbuff.second->probType = Eright::EMPTY;  delimbuff.second->probNorm = Prob(1.0); break;
	  case 1: delimbuff.second->probType = Eright::UNIF;   delimbuff.second->probNorm = (NORM_IS_MAX) ? LModel::getMaxHW() : Prob(1.0); break;//Prob(1.0); break; //
	  case 2: delimbuff.second->probType = Eright::NORMAL; delimbuff.second->probNorm = Prob(0.0); break; //break;
	  case 3: delimbuff.second->probType = Eright::TOP;    delimbuff.second->probNorm = Prob(1.0); break;
	  default: delimbuff.second->probType = Eright::EMPTY; delimbuff.second->probNorm = Prob(1.0);
	    cerr<<"\nERROR: didn't understand Eright::probType = "<<vectElements.get(i)<<"\n\n"; break;
	  }
	continue;
      }

      //copy the whole hash
      string elt; HW hw; Prob pr;
      elt = vectElements.get(i);
      size_t j=elt.find(':');
      j=(string::npos==j)?0:j+1;
      hw = HW( elt.substr(0,j-1).c_str() );
      pr = Prob( atof( elt.substr(j).c_str() ) ); //if LogProb, should use atoi
      // add stuff into the hash
      //cerr<<"\n   rding in E: hw="<<hw<<", pr="<<pr;
      delimbuff.second->set(   hw,  pr   );
    }
    //cerr<<"\n reading in E: probTypeAndNorm="<<vectElements.get(0)<<", new probNorm="<<delimbuff.second->probNorm<<endl;
    return si;
  }
};
//typedef SimpleHash<HW,Prob> Eright;
Eright Er_NONE(NONE_string);
Eright Er_UNIF(UNIF_string);
Eright Er_TOP(TOP_string);

double Eright::getProb ( const string hw ) const {
  if ( hw==NONE_string ) { // careful: any "-" referent will cause all 0 probabilities to appear
    return Prob().toDouble();
  } else if (hw==UNIF_string) { // careful: any "eT" referent will cause all UNIF probabilities to appear
    return Prob(UNIFORM).toDouble();
  } else {
    return mHWvect.get( HW(hw.c_str()) ).toDouble() ;
  }
}
string Eright::getString() const {
  String str;
  str<<probType<<psColonColon<<probNorm<<",";
  if ( probType==NORMAL ) {
    for(iter i = begin(); i!= end(); i++) {
      HW w = i->first;
      str<<((i==begin())?"":psComma)<<w<<psColon<<get(w);
    }
  }
  /*
  if ( probType == EMPTY ) {
    str<<NONE_string;
  } else if ( probType == UNIF ) {
    str<<UNIF_string;
  } else if ( probType == TOP ) {
    str<<TOP_string;
  } else { //probType==NORMAL
    for(iter i = begin(); i!= end(); i++) {
      HW w = i->first;
      str<<((i==begin())?"":psComma)<<w<<psColon<<get(w);
    }
  }
  */
  return str.c_array();
}



//// E: Eleft and Eright together define whatever referent is recognized up to this point
class E : public DelimitedJoint2DRV<psX,Eleft,psSlash,Eright,psX> {
 public:
  typedef Eright::iter iter;

  E ( )                                   : DelimitedJoint2DRV<psX,Eleft,psSlash,Eright,psX>()      { }
  E ( const Eleft& el, const Eright& er ) : DelimitedJoint2DRV<psX,Eleft,psSlash,Eright,psX>(el,er) { }
  E ( char* ps )                          : DelimitedJoint2DRV<psX,Eleft,psSlash,Eright,psX>(ps)    { }

  // Extraction methods...
  bool operator==(const E& ee) const { return (first==ee.first && second==ee.second); }

  // Multiplication operators... in comments, [] denote meaning of dimensions

  // (1) Multiply E*LMod |||| in eCxKappa = (eCxIota*d(eAlpha*L'H[eAlpha,eBeta])) * LMod[eBeta,eKappa]
  E operator* ( const Ref2DModel& LMod ) const {
    Eright eKappaProbs;//(NONE_string);

    // row vector to be mult. by columns of matrix
    Ref1DModel::IterVal eKappa;
    for (iter eBeta = second.begin(); eBeta!=second.end(); eBeta++) {
      if ( eBeta!=second.begin() ) { cerr<<"\nERROR: non-singleton e in e*L_M, e="; cerr<<*this; }

      String str;
      for ( bool b=LMod.setFirst(eKappa,eBeta->first); b; b=LMod.setNext(eKappa,eBeta->first) ) {
	eKappaProbs.set( eKappa , second.get(eBeta->first)*LMod.getProb(eKappa,eBeta->first) );
      }

      // the word wasn't used as a headword anywhere.  make prob as if word was UNK
      if (eKappaProbs.norm()==LogProb() || eKappaProbs.probType==Eright::EMPTY) {
	//Ref1DModel::IterVal eKappa;
	HW eBetaSub("UNK");
	for ( bool b=LMod.setFirst(eKappa,eBetaSub); b; b=LMod.setNext(eKappa,eBetaSub) ) {
	  eKappaProbs.set( eKappa , second.get(eBetaSub)*LMod.getProb(eKappa,eBetaSub) );
	}
	if (eKappaProbs.norm()==LogProb()) { // last resort -- set to prior weighted on worst element
	  for ( bool b=LModel::mHW.setFirst(eKappa); b; b=LModel::mHW.setNext(eKappa) ) {
	    eKappaProbs.set( eKappa , LModel::mHW.getProb(eKappa) * this->second.min ); //Prob(UNIFORM) ); // extra UNIFORM to penalize for not finding the word
	  }
	}
	if (VERBOSE) cerr<<"WARNING: "<<eBeta->first<<" not found in L_M.  set a penalized prior, eKappaProbs = "<<eKappaProbs<<endl;
      }
    }
    return E( first, eKappaProbs );
  }

  // (2) Multiply E*L'M |||| in ... d( eAlpha[eIota,eAlpha] * L'M[eAlpha,eBeta]^T )...
  E operator* ( const Ref2DModelTranspose& LpMod ) const {
    if (first==El_NONE && second==Er_NONE) { return E(El_NONE,Er_NONE); } //SPECIAL CASE: E_NONE input
    //TODO: need special case for E_TOP???

    Eright eBetaProbs;
    Ref1DModel::IterVal eBeta;

    for ( bool b=LModel::mHW.setFirst(eBeta); b; b=LModel::mHW.setNext(eBeta) ) {
      eBetaProbs.set( eBeta , second.get(first) * LpMod.getProb(first,eBeta) );
    }

    if (eBetaProbs.norm()==LogProb() || eBetaProbs.probType==Eright::EMPTY) {
      // the word wasn't used as a headword anywhere.  pretend you observed UNK
      //Ref1DModel::IterVal eBeta;
      HW md("UNK");

      for ( bool b=LModel::mHW.setFirst(eBeta); b; b=LModel::mHW.setNext(eBeta) ) {
	eBetaProbs.set( eBeta , second.get(md) * LpMod.getProb(md,eBeta) * Prob(UNIFORM) );
      }
      if (VERBOSE) cerr<<"WARNING: in L'_M op, word "<<first<<" multiplies to 0 probs.  setting eBetaProbs = "<<eBetaProbs<<endl;
    }

    return E( first, eBetaProbs );
  }

  // (3) Multiply E*LHead |||| in eCxKappa = (eCxIota*d(eAlpha*L'M)) * LHead
  E operator* ( const IdentityModel& LHead ) const {
    Eright erOut;
    for ( Eright::iter eBeta = second.begin(); eBeta!= second.end(); eBeta++ ) {
      erOut.set( eBeta->first , second.get(eBeta->first) );
    }
    return E(first,erOut);
  }

  // (4) Multiply E*LpHead |||| in d( eAlpha[eIota,eAlpha] * LpHead[eAlpha,eBeta] )
  E operator* ( const HeadModel& LpHead ) const {
    if (first==El_NONE && second==Er_NONE) { return E(El_NONE,Er_NONE); } //SPECIAL CASE: E_NONE input
    HW eIota = HW( (first.getString()+"*").c_str() );
    Eright eBetaProbs;
    for ( Eright::iter eAlpha = second.begin(); eAlpha!= second.end(); eAlpha++ ) {
      Prob lph = (LModel::mHW.getProb(eAlpha->first)==Prob()) ? LModel::mHW.getProb(HW("UNK")) : LModel::mHW.getProb(eAlpha->first);
      eBetaProbs.set( eAlpha->first , second.get(eAlpha->first) / lph );
    }

    if (VERBOSE && ( eBetaProbs.norm()==LogProb()||LModel::mHW.getProb(second.begin()->first)==Prob() ) ) {
      cerr<<"  WARNING: suspect norm in E*LpH for "<<this->getString()<<".....LpH value="<<LModel::mHW.getProb(second.begin()->first);
      cerr<<" gives eBetaProbs="<<eBetaProbs<<endl;
    }

    return E( eIota,eBetaProbs );
  }

  // (5) Multiply E*E |||| in eCxIota * d(eAlpha*L'?)[eIota,eBeta]
  E operator* ( const E& eIotaxBeta ) const {
    if ( (first==El_NONE && second==Er_NONE) || (eIotaxBeta.first==El_NONE && eIotaxBeta.second==Er_NONE)) { return E(El_NONE,Er_NONE); } //SPECIAL CASE: E_NONE input
    Eleft eC;
    Eright eBetaProbs;

    // if eIotaxBeta.first has a * and Eleft is UNIF, eIotaxBeta.first should be the new Eleft!
    string eIotaStar = eIotaxBeta.first.getString();
    bool didObserveHead = false;
    bool didObserveNewHead = false;
    size_t i = eIotaStar.find('*');
    HW eIota;
    // didn't observe a head
    if (i==string::npos || i!=(eIotaStar.length()-1) ) {
      eIota = eIotaxBeta.first;
      eC = first;

      // observed a head but it won't govern the relation
    } else if ( first!=El_UNIF && first!=El_TOP && first!=El_NONE ) { // TODO: condition
      eIota = HW( eIotaStar.substr(0,eIotaStar.length()-1).c_str() );
      eC = first;
      didObserveHead = true; didObserveNewHead = false;

      // observed the head and it is the new active context!
    } else {
      eIota = HW( eIotaStar.substr(0,eIotaStar.length()-1).c_str() );
      eC = eIota;//Eleft(eIotaStar.erase(eIotaStar.length()-1,1).c_str());
      didObserveHead = true; didObserveNewHead = true;
    }

    // just saw a head
    if ( didObserveHead ) { // single point multiplication -- from recent LpHead
      if ( second.probType!=Eright::NORMAL ) { // from UNIF or TOP: use P(e)
	eBetaProbs.set( eC, eIotaxBeta.second.get(eIota) * LModel::mHW.getProb(eC) );//eIota) );
	eBetaProbs.probType = Eright::NORMAL;
	//	if (VERBOSE) cerr<<"NOTE: would rather try eIotaxBeta.second.get("<<eIota<<")="<<eIotaxBeta.second.get(eIota)<<" * eIotaProbs.min="<<second.min<<" = "<<eIotaxBeta.second.get(eIota)*second.min<<endl;
	//	if (VERBOSE) cerr<<"      instead have eIotaxBeta.second.get(eIota)="<<eIotaxBeta.second.get(eIota)<<" * E_UNIF.get(eC)="<<LModel::mHW.getProb(eC)<<" = "<<eIotaxBeta.second.get(eIota) * LModel::mHW.getProb(eC)<<endl;

      } else if ( second.get(eIota)==Prob() ) { // for other mismatches, try something different
	eBetaProbs.set( eC, eIotaxBeta.second.get(eIota) * second.min );//eIota) );
	eBetaProbs.probType = Eright::NORMAL;
	//eBetaProbs.set( eC, eIotaxBeta.second.get(eIota) * LModel::mHW.getProb(eC) );//eIota) );
	//if (VERBOSE) cerr<<"NOTE: would rather try eIotaxBeta.second.get("<<eIota<<")="<<eIotaxBeta.second.get(eIota)<<" * eIotaProbs.min="<<second.min<<" = "<<eIotaxBeta.second.get(eIota)*second.min<<endl;
	//if (VERBOSE) cerr<<"      instead have eIotaxBeta.second.get(eIota)="<<eIotaxBeta.second.get(eIota)<<" * E_UNIF.get(eC)="<<LModel::mHW.getProb(eC)<<" = "<<eIotaxBeta.second.get(eIota) * LModel::mHW.getProb(eC)<<endl;

      } else {
	eBetaProbs.set( eC, eIotaxBeta.second.get(eIota) * second.get(eIota) );
	eBetaProbs.probType = Eright::NORMAL;
	//eBetaProbs.set( eC, eIotaxBeta.second.min * second.get(eC) );
	//if (VERBOSE) cerr<<"NOTE: would rather try eIotaxBeta.second.get("<<eIota<<")="<<eIotaxBeta.second.get(eIota)<<" * eIotaProbs("<<eIota<<")="<<second.get(eIota)<<" = "<<eIotaxBeta.second.get(eIota)*second.get(eIota)<<endl;
	//if (VERBOSE) cerr<<"      instead have eIotaxBeta.second.min="<<eIotaxBeta.second.min<<" * second.get(eC)="<<second.get(eC)<<" = "<<eIotaxBeta.second.min * second.get(eC)<<endl;
      }

      // FAILSAFE: if eU and this eD have no crossover, weight one of them by the other
      if ( eBetaProbs.probNorm==Prob() || eBetaProbs.probType==Eright::EMPTY ) {
	// when eD has the real head, weigh down eD by eU (or uniform)
	if (didObserveNewHead) {
	  eBetaProbs.set( eC, eIotaxBeta.second.get(eIotaxBeta.first)*(second.probNorm==Prob(1.0)?Prob(UNIFORM):second.min) );
	  //if (VERBOSE) cerr<<"WARNING: while calculating E * (E*LHead), weighed the eD head "<<eIotaxBeta.second.get(eIotaxBeta.first)<<" with the modifier "<<second.probNorm<<" or "<<Prob(UNIFORM)<<endl;
	}
	// when eU has the real head, weigh down eU by eD (or uniform)
	else {
	  Prob eWeight = (eIotaxBeta.second.probNorm==Prob(1.0)?Prob(UNIFORM):eIotaxBeta.second.min);
	  for (iter i=second.begin(); i!=second.end(); i++) {
	    eBetaProbs.set( eC, second.get(i->first) * eWeight );
	  }
	  //if (VERBOSE) cerr<<"WARNING: while calculating E * (E*Lh), weighed the eU head "<<second<<" with the modifier "<<eIotaxBeta.second.probNorm<<" or "<<Prob(UNIFORM)<<endl;
	}
      }

      // just saw a modifier
    } else {
      if ( second.probType!=Eright::NORMAL ) {
	for (iter i = eIotaxBeta.second.begin(); i!=eIotaxBeta.second.end(); i++) {
	  eBetaProbs.set( i->first, LModel::mHW.getProb(i->first) * eIotaxBeta.second.get(i->first) );
	}

      } else {
	for (iter i = second.begin(); i!=second.end(); i++) {
	  if ( eIotaxBeta.second.get(i->first)!=Prob() && second.get(i->first)!=Prob() )
	    eBetaProbs.set( i->first, second.get(i->first) * eIotaxBeta.second.get(i->first) );
	}
      }

      // FAILSAFE: weigh down eU with eD (or uniform)
      if (eBetaProbs.probNorm==Prob() || eBetaProbs.probType==Eright::EMPTY) {
	//HW md("UNK");
	Prob eWeight = ( eIotaxBeta.second.probNorm==Prob(1.0)?Prob(UNIFORM):eIotaxBeta.second.min );
	if (second.probType!=Eright::NORMAL) {
	  Ref1DModel::IterVal hw;
	  for ( bool b=LModel::mHW.setFirst(hw); b; b=LModel::mHW.setNext(hw) ) {
	    eBetaProbs.set( hw, LModel::mHW.getProb(hw) * eWeight );
	  }
	} else {
	  for (iter i = second.begin(); i!=second.end(); i++) {
	    eBetaProbs.set( i->first, second.get(i->first) * eWeight );
	    //eBetaProbs.set( i->first, second.get(i->first) * LModel::mHW.getProb(md)*LModel::LMod.getProb(md,md) );
	  }
	}
	//if (VERBOSE) cerr<<"     while calculating E * (E*LM), weighed eU with eD (or unif) "<<eIotaxBeta.second.probNorm<<" or "<<Prob(UNIFORM)<<endl;
      }
    }
    //if ( didObserveHead && eBetaProbs.get(eIota)==Prob() )
    //eBetaProbs.set( eC, UNIFORM * eIotaxBeta.second.get(eIota) );
    //}

    //if (eBetaProbs.length()==0) { eBetaProbs = Er_NONE; }
    //eC = HW( (first.getString()+"M"+eIotaStar).c_str() );//DEBUG
    return E(eC,eBetaProbs);
  }

  // (6) Marginalize E*LAll |||| in eCxKappa = eCxIota * d( eAlpha * LpHead ) * LAll[eBeta,1]
  E operator* ( const MarginalizeModel& LAll ) {
    Prob sum = 0;
    for (iter i = second.begin(); i!=second.end(); i++) {
      sum = sum + second.get(i->first);
    }
    if (sum==Prob()) {
      if (VERBOSE) cerr<<"\n  WARNING: Would have had 0 prob for marginalizing "<<*this<<endl;
      sum = this->second.min * Prob(UNIFORM);
    }
    //else {
    //if (VERBOSE) cerr<<"\n                   have logprob="<<LogProb(sum)<<" for marginalizing "<<*this<<endl;
    //}
    Eright eAlpha; eAlpha.set( first, sum );
    return E( first, eAlpha );
  }

  LogProb norm   ( ) const { return second.norm(); }
  string getString() const;
  friend ostream& operator<< ( ostream& os, const E& rv ) { return  os<<psX<<rv.first<<psSlash<<rv.second<<psX; }
  friend String&  operator<< ( String& str, const E& rv ) { return str<<psX<<rv.first<<psSlash<<rv.second<<psX; }
  friend pair<StringInput,E*> operator>> ( StringInput ps, E& rv ) { return pair<StringInput,E*>(ps,&rv); }
  friend StringInput    operator>> ( pair<StringInput,E*> delimbuff, const char* psPostDelim ) {
    if (StringInput(NULL)==delimbuff.first) return delimbuff.first;
    return ( (psX[0]=='\0') ? delimbuff.first>>psX>>delimbuff.second->first>>psSlash>>delimbuff.second->second>>psPostDelim
	     : delimbuff.first>>psX>>delimbuff.second->first>>psSlash>>delimbuff.second->second>>psX>>psPostDelim );
  }
};
//typedef DelimitedJoint2DRV<psX,Eleft,psSlash,Eright,psX> E;
E E_NONE(El_NONE,Er_NONE);
E E_UNIF(El_UNIF,Er_UNIF);
E E_TOP(El_TOP,Er_TOP);

string E::getString() const {
  return first.getString()+"/"+second.getString();
}


//// ECode: E represented as a string -- for the codebook
DiscreteDomain<int> domECode;
class ECode : public DiscreteDomainRV<int,domECode> {
 public:
  ECode() : DiscreteDomainRV<int,domECode>() { }
  ECode( const string& s ) : DiscreteDomainRV<int,domECode>( s.c_str() ) { }
  ECode( const DiscreteDomainRV<int,domECode>& rv ) : DiscreteDomainRV<int,domECode>(rv) { }
  ECode( const char* s ) : DiscreteDomainRV<int,domECode>( s ) { }
  ECode( const E& e ) : DiscreteDomainRV<int,domECode>( e.getString().c_str() ) { }
  E toE ( ) const {
    String tmp = getString().c_str();
    StringInput si(tmp.c_array()); E e; si>>e>>psX;
    return e;
  }
  LogProb norm ( ) const {
    string vectstring = getString().c_str();
    int colons = int( vectstring.find(psColonColon) );
    int comma = int( vectstring.find(psComma,colons) );
    LogProb sum = LogProb( atof( vectstring.substr(colons+2,comma-colons-2).c_str() ) );
    //cerr<<" ECode::norm() vectstring "<<vectstring.substr(0,comma)<<" we get a norm of "<<sum.toInt();
    //cerr<<", compared to the E version "<<toE().norm()<<endl;
    return LogProb( atof( vectstring.substr(colons+2,comma-colons-2).c_str() ) );
  }
  friend ostream& operator<< ( ostream& os, const ECode& rv ) {
    if (SHOW_VECTORS) {
      E e = rv.toE();
      return os<<psX<<e<<psX;
    } else {
      size_t i = rv.getString().find(psSlash);
      string s = rv.getString().substr(0,i);
      if (VERBOSE)
	return os<<psX<<s<<"/"<<rv.norm()<<psX;
      else
	return os<<psX<<s<<psX;
    }
  }
  friend String&  operator<< ( String& str, const ECode& rv ) {
    if (SHOW_VECTORS) {
      E e = rv.toE();
      return str<<psX<<e<<psX;
    } else {
      size_t i = rv.getString().find(psSlash);
      string s = rv.getString().substr(0,i);
      if (VERBOSE)
	return str<<psX<<s<<"/"<<rv.norm()<<psX;
      else
	return str<<psX<<s<<psX;
    }
    //return str<<psX<<rv.first<<psSlash<<rv.second<<psX;
  }
};
ECode ECode_NONE(E_NONE);
ECode ECode_UNIF(E_UNIF);
ECode ECode_TOP(E_TOP);

//ECode *pECode_NONE = &ECode_NONE;
//ECode *pECode_UNIF = &ECode_UNIF;
//ECode *pECode_TOP = &ECode_TOP;


class ECodebook : public CPT4DModel<ECode,L,ECode,ECode,LogProb> { //composed variables. F is just an indicator.
};
ECodebook mCodebook;

//// G: constituent category...
DiscreteDomain<int> domG;
//typedef DiscreteDomainRV<int,domG> G;
class G : public DiscreteDomainRV<int,domG> {
 private:
  static SimpleHash<G,F> hToTerm;
  static SimpleHash<G,bool> hToHead;
  void calcDetModels ( string s ) {
    if (!hToTerm.contains(*this)) {
      hToTerm.set(*this) = ('A'<=s[0] && s[0]<='Z') ? F_0 : F_1;
    }
    if (!hToHead.contains(*this)) {
      size_t i=s.find('*');
      hToHead.set(*this) = (i!=string::npos);// ? F_1 : F_0;
    }
  }
 public:
  G ( )                : DiscreteDomainRV<int,domG> ( )    { }
  G ( const char* ps ) : DiscreteDomainRV<int,domG> ( ps ) { calcDetModels(ps); }
  //G ( string s ) : DiscreteDomainRV<int,domG> ( s )  { calcDetModels(s); }
  F getTerm ( ) const { return hToTerm.get(*this); }
  bool isHead ( ) const { return hToHead.get(*this); }
  friend pair<StringInput,G*> operator>> ( StringInput si, G& m ) { return pair<StringInput,G*>(si,&m); }
  friend StringInput operator>> ( pair<StringInput,G*> si_m, const char* psD ) {
    if ( si_m.first == NULL ) return NULL;
    StringInput si=si_m.first>>(DiscreteDomainRV<int,domG>&)*si_m.second>>psD;
    si_m.second->calcDetModels(si_m.second->getString()); return si; }
};
SimpleHash<G,F> G::hToTerm;
SimpleHash<G,bool> G::hToHead;
const G G_NIL("-");
//const G G_0("<\?\?>");


//// C: composition state resulting from right-corner reduction...
DiscreteDomain<int> domC;
//typedef DiscreteDomainRV<char,domC> C;
class C : public DiscreteDomainRV<int,domC> {
 private:
  static SimpleHash<C,F> hToSimp;
  void calcDetModels ( string s ) {
    if (!hToSimp.contains(*this)) {
      hToSimp.set(*this) = (s.find('/')==string::npos) ? F_1 : F_0;
    }
  }
 public:
  C ( )                : DiscreteDomainRV<int,domC> ( )    { }
  C ( const char* ps ) : DiscreteDomainRV<int,domC> ( ps ) { calcDetModels(ps); }
  //C ( string s ) : DiscreteDomainRV<int,domC> ( s )  { calcDetModels(s); }
  F getSimp ( ) const { return hToSimp.get(*this); }
  friend pair<StringInput,C*> operator>> ( StringInput si, C& m ) { return pair<StringInput,C*>(si,&m); }
  friend StringInput operator>> ( pair<StringInput,C*> si_m, const char* psD ) {
    if ( si_m.first == NULL ) return NULL;
    StringInput si=si_m.first>>(DiscreteDomainRV<int,domC>&)*si_m.second>>psD;
    si_m.second->calcDetModels(si_m.second->getString()); return si; }
};
SimpleHash<C,F> C::hToSimp;
const C C_NIL("-");


//// I: intermediate incomplete category state (without lookahead)...
DiscreteDomain<int> domI;
typedef DiscreteDomainRV<int,domI> I;
const I I_NIL ("-/-");


//// Q: syntactic state...
DiscreteDomain<int> domQ;
class Q : public DiscreteDomainRV<int,domQ> {
 private:
  static SimpleHash<Q,G> hToAct;
  static SimpleHash<Q,G> hToAwa;
  static SimpleHash<Q,G> hToExp;
  static SimpleHash<Q,Q> hToUp;
  void calcDetModels ( string s ) {
    if (!hToAct.contains(*this)) {
      size_t i=s.find('='); i=(string::npos==i)?0:i+1;
      size_t j=s.find('/'); j=(string::npos==i)?0:j;
      hToAct.set(*this) = G(s.substr(i,j-i).c_str());
    }
    if (!hToAwa.contains(*this)) {
      size_t i=s.find('/');
      size_t j=s.find('|');
      //if ( i!=string::npos && j!=string::npos ) { ; } else
      //hToAwa.set(*this) = G(s.substr(i+1,j-1-i).c_str());
      assert(i!=string::npos && j!=string::npos );
      hToAwa.set(*this) = G(s.substr(i+1,j-1-i).c_str());
    }
    if (!hToExp.contains(*this)) {
      size_t i=s.find('|');
      //if ( i!=string::npos ) { ; } else
      //hToExp.set(*this) = G(s.substr(i+1).c_str());
      assert(i!=string::npos);
      hToExp.set(*this) = G(s.substr(i+1).c_str());
    }
    if (!hToUp.contains(*this)) {
      size_t i=s.find('=');
      i=(string::npos==i)?0:i+1;
      hToUp.set(*this).DiscreteDomainRV<int,domQ>::operator=(s.substr(i).c_str());
    }
  }
 public:
  Q ( )                : DiscreteDomainRV<int,domQ> ( )    { }
  Q( const DiscreteDomainRV<int,domQ>& rv ) : DiscreteDomainRV<int,domQ>(rv) { }
  Q ( const char* ps ) : DiscreteDomainRV<int,domQ> ( ps ) { calcDetModels(ps); }
  //Q ( string s ) : DiscreteDomainRV<int,domQ> ( s )  { calcDetModels(s); }
  G getAct ( ) const { return hToAct.get(*this); }
  G getAwa ( ) const { return hToAwa.get(*this); }
  G getExp ( ) const { return hToExp.get(*this); }
  Q getUp  ( ) const { return hToUp. get(*this); }
  friend pair<StringInput,Q*> operator>> ( StringInput si, Q& m ) { return pair<StringInput,Q*>(si,&m); }
  friend StringInput operator>> ( pair<StringInput,Q*> si_m, const char* psD ) {
    if ( si_m.first == NULL ) return NULL;
    StringInput si=si_m.first>>(DiscreteDomainRV<int,domQ>&)*si_m.second>>psD;
    si_m.second->calcDetModels(si_m.second->getString()); return si; }
};
SimpleHash<Q,G> Q::hToAct;
SimpleHash<Q,G> Q::hToAwa;
SimpleHash<Q,G> Q::hToExp;
SimpleHash<Q,Q> Q::hToUp;
#define Q_NIL Q("-/-|-")
#define Q_TOP Q("ROOT/S|S")
//#define Q_TOP Q("S/end|end")

//////////////////////////////////////// Joint Variables

//// EF: the referential semantic language model instantiation of the HHMM `reduce' variable at each depth
typedef DelimitedJoint2DRV<psLbrace,ECode,psRbrace,F,psX> EF;

//// R: collection of syntactic variables at all depths in each `reduce' phase...
typedef DelimitedJointArrayRV<4,psSemi,EF> R;

//// EQ: the referential semantic language model instantiation of the HHMM `shift' variable at each depth
typedef DelimitedJoint2DRV<psLbrace,ECode,psRbrace,Q,psX> EQ;
//const EQ EQ_NONE(E_NONE,Q_NIL);
const EQ EQ_TOP(ECode_UNIF,Q_TOP);
//// S: collection of syntactic variables at all depths in each `shift' phase...
class S : public DelimitedJointArrayRV<4,psSemi,EQ> {
 public:
  operator G()  const { return ( ( (get(3).second!=Q_NIL) ? get(3).second :
                                   (get(2).second!=Q_NIL) ? get(2).second :
                                   (get(1).second!=Q_NIL) ? get(1).second : get(0).second ).getExp() ); }
  bool compareFinal ( const S& s ) const { return(*this==s); }
};

//// H: the set of all (marginalized) reduce and (modeled) shift variables in the HHMM...
class H : public DelimitedJoint2DRV<psX,R,psDashDiamondDash,S,psX>
{ public:
  operator R() const {return first;}
  operator S() const {return second;}
  operator D() const {return ( (first.get(3).second==F_0) ? D_4 :
                               (first.get(2).second==F_0) ? D_3 :
                               (first.get(1).second==F_0) ? D_2 :
                               (first.get(0).second==F_0) ? D_1 : D_0 );}
};


////////////////////////////////////////////////////////////////////////////////
//
//  Models
//
////////////////////////////////////////////////////////////////////////////////

//// Model of F given D and Q (from previous); assume active cat from previous = awaited cat from above
typedef HidVarCPT3DModel<F,D,Q,LogProb> FcptModel;

//// Transition model of Q given D and G (from above) and Q (from previous)
typedef HidVarCPT4DModel<Q,D,G,Q,LogProb> QtcptModel;

//// Expansion model of Q given D and Q (from above)
typedef HidVarCPT3DModel<Q,D,Q,LogProb> QecptModel;


//////////////////////////////////////// "Wrapper" models for individual RVs...

typedef HidVarCPT2DModel<ECode,ECode,LogProb> EModel;
//// Local Model of Er given F and F and L and E and E and E
class ErModel { //: public SingleFactoredModel<ECode> {
 private:
  //HWMDModel mHWMDprob;
  LModel mHWMDprob;
 public:
  typedef ECode RVType;
  //typedef EModel::IterVal IterVal;
  static EModel mEComposed;
  static EModel mE_COPY;

  LogProb setIterProb ( ECode::ArrayIterator<LogProb>& e, const D& d, const F& fD, const L& l, const ECode& eDcode, const ECode& ePcode, const ECode& eUcode, int& a ) {

    LogProb pr;

    // SPECIAL CASE: at top of stack
    if (fD!=F_0 && (eUcode.getString()==(ECode_TOP).getString()) ) {
      if ( !mE_COPY.contains(ePcode) )
	mE_COPY.setProb(ePcode,ePcode)=1.0;
      pr = mE_COPY.setIterProb(e,ePcode,a);
      return pr;
    }
    // SPECIAL CASE: 'NONE' returns lower ref
    if ( fD==F_1 && l==L_NONE ) {
      if ( !mE_COPY.contains(eDcode) )
	mE_COPY.setProb(eDcode,eDcode)=1.0;
      pr = mE_COPY.setIterProb(e,eDcode,a);
      return pr;
    }
    // SPECIAL CASE: no F-action means copy context referent
    if (l==L_COPY) {
      ECode eComposed = (eUcode.getString()==(ECode_TOP).getString()) ? ECode_UNIF : eUcode;
      if ( !mE_COPY.contains(eComposed) )
	mE_COPY.setProb(eComposed,eComposed)=1.0;
      pr = mE_COPY.setIterProb(e,eComposed,a);
      return pr;
    }

    // LOOKUP TO CODEBOOK
    ECodebook::IterVal smiter;
    if ( mCodebook.setFirst(smiter,l,eUcode,eDcode) ) {
      //pr = mCodebook.getProb(smiter,l,eUcode,eDcode);
      pr = mEComposed.setIterProb( e, smiter, a );
      return pr;
    }

    // meaning composition: all the semantics work, right here!  only do it if we absolutely have to.
    if ( fD==F_1 ) {
      E eComposed; ECode eComposedCode;
      E eD = eDcode.toE();
      E eP = ePcode.toE();
      E eU = eUcode.toE();
      LogProb norm = LogProb(1.0); //; //force this to always be 1.0, since norm will be recalculated in S step

      // see EF Model for description of cases
      if ( l==L_HEHM ) {
	E eIntermed1,eIntermed2; // 1 ends stack level, 2 in-element composes
	if (!SHOW_STRINGS) {
	  eIntermed1 = eU     * (eD        * LModel::LpHead) * LModel::LAll;
	  eIntermed2 = E_UNIF * (eIntermed1* LModel::LpHead) * LModel::LMod;
	  eComposedCode = ECode( String( (eIntermed1.getString()+psSpace+eIntermed2.getString()).c_str() ).c_array() ); //
	  //norm = LogProb( eIntermed1.norm().toProb()*.5+eIntermed2.norm().toProb()*.5 );
	  if (VERBOSE&&SHOW_VECTORS) cerr<<"   Input: eU="<<eU<<"   eD="<<eD<<"   l="<<l<<"   eInt="<<eIntermed1.getString()<<"   eCmp="<<eIntermed2.getString()<<endl;
	  //else if (VERBOSE) cerr<<"   Input: eU="<<eU<<"   eD="<<eD<<"   l="<<l<<"   eInt="<<eIntermed1<<"   eCmp="<<eIntermed2<<endl;
	  else if (VERBOSE) { cerr<<"   Input: eU="<<eU<<"   eD="<<eD<<"   l="<<l<<"1   eD*LpH="<<(eD*LModel::LpHead)<<"   eU*(eD*LpH)="<<(eU*(eD*LModel::LpHead))<<"   eInt="<<eIntermed1<<endl;
	    cerr<<"          eT="<<E_UNIF<<"   eInt="<<eIntermed1<<"   l="<<l<<"2   eInt*LpH="<<(eIntermed1*LModel::LpHead)<<"   eT*(eInt*LpH)="<<(E_UNIF*(eIntermed1*LModel::LpHead))<<"   eCmp="<<eIntermed2<<endl; }
	} else {
	  eIntermed1 = E( Eleft(( "("+eU.first.getString()+"."+eD.first.getString()+".HP.E)" ).c_str()), Er_UNIF );
	  eIntermed2 = E( Eleft(( "("+El_UNIF.getString()+"."+eIntermed1.first.getString()+".HP.M)" ).c_str()), Er_UNIF );
	  eComposedCode = ECode( String( (eIntermed1.getString()+psSpace+eIntermed2.getString()).c_str() ).c_array() ); //
	  //norm = LogProb(1.0);
	}

      } else if ( l==L_HEMH ) { // 1 ends stack level, 2 in-element composes
	E eIntermed1,eIntermed2;
	if (!SHOW_STRINGS) {
	  eIntermed1 = eU     * (eD        * LModel::LpHead) * LModel::LAll;
	  eIntermed2 = E_UNIF * (eIntermed1* LModel::LpMod ) * LModel::LHead;
	  eComposedCode = ECode( String( (eIntermed1.getString()+psSpace+eIntermed2.getString()).c_str() ).c_array() ); //
	  //norm = LogProb( eIntermed1.norm().toProb()*.5+eIntermed2.norm().toProb()*.5 );
	  if (VERBOSE&&SHOW_VECTORS) cerr<<"   Input: eU="<<eU<<"   eD="<<eD<<"   l="<<l<<"   eInt="<<eIntermed1.getString()<<"   eCmp="<<eIntermed2.getString()<<endl;
	  //else if (VERBOSE) cerr<<"   Input: eU="<<eU<<"   eD="<<eD<<"   l="<<l<<"   eInt="<<eIntermed1<<"   eCmp="<<eIntermed2<<endl;
	  else if (VERBOSE) { cerr<<"   Input: eU="<<eU<<"   eD="<<eD<<"   l="<<l<<"1   eD*LpH="<<(eD*LModel::LpHead)<<"   eU*(eD*LpH)="<<(eU*(eD*LModel::LpHead))<<"   eInt="<<eIntermed1<<endl;
	    cerr<<"          eT="<<E_UNIF<<"   eInt="<<eIntermed1<<"   l="<<l<<"2   eInt*LpM="<<(eIntermed1*LModel::LpMod)<<"   eT*(eInt*LpM)="<<(E_UNIF*(eIntermed1*LModel::LpMod))<<"   eCmp="<<eIntermed2<<endl; }
	} else {
	  eIntermed1 = E( Eleft(( "("+eU.first.getString()+"."+eD.first.getString()+".HP.E)" ).c_str()), Er_UNIF );
	  eIntermed2 = E( Eleft(( "("+El_UNIF.getString()+"."+eIntermed1.first.getString()+".MP.H)" ).c_str()), Er_UNIF );
	  eComposedCode = ECode( String( (eIntermed1.getString()+psSpace+eIntermed2.getString()).c_str() ).c_array() ); //
	  //norm = LogProb(1.0);
	}

      } else {
	if ( l==L_HM ) {
	  if (!SHOW_STRINGS) {
	    eComposed = eU     * (eD        * LModel::LpHead) * LModel::LMod;             //norm = eComposed.norm();
	    if (VERBOSE&&SHOW_VECTORS) cerr<<"   Input: eU="<<eU<<"   eD="<<eD<<"   l="<<l<<"   eCmp="<<eComposed.getString()<<endl;
	    //else if (VERBOSE) cerr<<"   Input: eU="<<eU<<"   eD="<<eD<<"   l="<<l<<"   eCmp="<<eComposed<<endl;
	    else if (VERBOSE) { cerr<<"   Input: eU="<<eU<<"   eD="<<eD<<"   l="<<l<<"   eD*LpH="<<(eD*LModel::LpHead)<<"   eU*(eD*LpH)="<<(eU*(eD*LModel::LpHead))<<"   eCmp="<<eComposed<<endl; }
	  } else {
	    eComposed = E( Eleft(( "("+eU.first.getString()+"."+eD.first.getString()+".HP.M)" ).c_str()), Er_UNIF );	//norm = LogProb(1.0);
	  }

	} else if ( l==L_MH ) {
	  if (!SHOW_STRINGS) {
	    eComposed = eU     * (eD        * LModel::LpMod ) * LModel::LHead;            //norm = eComposed.norm();
	    if (VERBOSE&&SHOW_VECTORS) cerr<<"   Input: eU="<<eU<<"   eD="<<eD<<"   l="<<l<<"   eCmp="<<eComposed.getString()<<endl;
	    //else if (VERBOSE) cerr<<"   Input: eU="<<eU<<"   eD="<<eD<<"   l="<<l<<"   eCmp="<<eComposed<<endl;
	    else if (VERBOSE) { cerr<<"   Input: eU="<<eU<<"   eD="<<eD<<"   l="<<l<<"   eD*LpM="<<(eD*LModel::LpMod)<<"   eU*(eD*LpM)="<<(eU*(eD*LModel::LpMod))<<"   eCmp="<<eComposed<<endl; }
	  } else {
	    eComposed = E( Eleft(( "("+eU.first.getString()+"."+eD.first.getString()+".MP.H)" ).c_str()), Er_UNIF );   //norm = LogProb(1.0);
	  }

	} else if ( l==L_HE ) {
	  if (!SHOW_STRINGS) {
	    eComposed = eU     * (eD        * LModel::LpHead) * LModel::LAll;             //norm = eComposed.norm();
	    if (VERBOSE&&SHOW_VECTORS) cerr<<"   Input: eU="<<eU<<"   eD="<<eD<<"   l="<<l<<"   eCmp="<<eComposed.getString()<<endl;
	    //else if (VERBOSE) cerr<<"   Input: eU="<<eU<<"   eD="<<eD<<"   l="<<l<<"   eCmp="<<eComposed<<endl;
	    else if (VERBOSE) { cerr<<"   Input: eU="<<eU<<"   eD="<<eD<<"   l="<<l<<"   eD*LpH="<<(eD*LModel::LpHead)<<"   eU*(eD*LpH)="<<(eU*(eD*LModel::LpHead))<<"   eCmp="<<eComposed<<endl; }
	  } else {
	    eComposed = E( Eleft(( "("+eU.first.getString()+"."+eD.first.getString()+".HP.E)" ).c_str()), Er_UNIF );   //norm = LogProb(1.0);
	  }
	}

	eComposedCode = ECode( eComposed );
      }

      // store probability for future use
      if ( !mEComposed.contains( eComposedCode ) )
	mEComposed.setProb( eComposedCode,eComposedCode ) = norm;
      // store in codebook
      mCodebook.setProb( eComposedCode,l,eUcode,eDcode ) = norm;

      // E( Eleft((eU.first.getString() + "&" + (eD*LModel::LpHead).first.getString() ).c_str()), Er_UNIF );// * LModel::Lmod; // for testing strings
      pr = mEComposed.setIterProb( e, eComposedCode, a );

    // copy-over case
    } else { // if ( fD!=F_1 ) {
      if ( !mE_COPY.contains(ePcode) ) mE_COPY.setProb(ePcode,ePcode)=1.0;
      pr = mE_COPY.setIterProb(e,ePcode,a);
    }
    return pr;
  }

  friend pair<StringInput,ErModel*> operator>> ( StringInput si, ErModel& m ) { return pair<StringInput,ErModel*>(si,&m); }
  friend StringInput operator>> ( pair<StringInput,ErModel*> delimbuff, const char* psD ) {
    if ( delimbuff.first == NULL ) return NULL;
    StringInput si;
    si=delimbuff.first>>delimbuff.second->mHWMDprob>>psD;
    return si;
  }
};
//LModel ErModel::mHWMDprob;
EModel ErModel::mE_COPY;
EModel ErModel::mEComposed;

//// Model of Es given F and L and Er (or) Es: Deterministically Uniform
class EsModel { //: public SingleFactoredModel<ECode> {
 public:
  static HidVarCPT1DModel<ECode,LogProb> mE_UNIF;
  static HidVarCPT1DModel<ECode,LogProb> mE_NONE;

  typedef ECode RVType;
  //typedef EModel::IterVal IterVal;//typedef Ref1DModel::IterVal IterVal;//E IterVal;
  static EModel mE_COPY;

  LogProb setIterProb ( ECode::ArrayIterator<LogProb>& e, const D& d, const L& l, const F& fD, const F& fR, const ECode& eR, const ECode& eRD, const ECode& eSU, const Q& qSU, int& a ) const {

    //TODO: check if EsModel probabilities are correct
    LogProb pr;

    //SPECIAL CASE: stack bottom
    if ( fR==F_1 && (qSU==Q_NIL||qSU.getExp().getTerm()==F_1) ) {
      pr = mE_NONE.setIterProb(e,a); return pr;
    }

    // if lower level complete, expand or transition
    if ( fD==F_1 ) {
      //mEs.clear();

      //if current level complete, expand
      if ( fR==F_1 ) {
	//referent will always be uniform -- if this is a real new stack level.  otherwise, empty.
	pr = mE_UNIF.setIterProb(e,a);
	//if ( !mE_COPY.contains(E_UNIF) ) mE_COPY.setProb(E_UNIF,E_UNIF)=1.0;
	//pr = mE_COPY.setIterProb(e,E_UNIF,a);
	//mEs.setProb( E_UNIF ) = 1.0;
	//pr = mEs.setIterProb( e,a );

	//if current level incomplete, transition
      } else { //fR==F_0
	//referent will always be a copy of the lower R node
	//pr = mE_UNIF.setIterProb(e,a);
	if ( !mE_COPY.contains(eRD) ) mE_COPY.setProb(eRD,eRD)=eRD.norm();//toE().norm();//
	pr = mE_COPY.setIterProb(e,eRD,a);
	//mEs.setProb( eRD ) = 1.0;
	//pr = mEs.setIterProb( e,a );
      }

    // no activity, just copy over (if equal)
    } else {
      if ( !mE_COPY.contains(eRD) ) mE_COPY.setProb(eRD,eRD)=eRD.norm();//toE().norm(); // eR instead of eRD? //
      pr = mE_COPY.setIterProb(e,eRD,a);
    }
    return pr;
  }

  friend pair<StringInput,EsModel*> operator>> ( StringInput si, EsModel& m ) { return pair<StringInput,EsModel*>(si,&m); }
  friend StringInput operator>> ( pair<StringInput,EsModel*> delimbuff, const char* psD ) {
    if ( delimbuff.first == NULL ) return NULL;
    StringInput si;
    //si=delimbuff.first>>delimbuff.second->mHWMDprob>>psD;
    return si;
  }
 };
EModel EsModel::mE_COPY;
HidVarCPT1DModel<ECode,LogProb> EsModel::mE_UNIF(ECode_UNIF);
HidVarCPT1DModel<ECode,LogProb> EsModel::mE_NONE(ECode_NONE);
//HidVarCPT1DModel<ECode,LogProb> EsModel::mEs;

//// Model of F given D and F and Q (from above) and Q (from previous)
class FModel {
 private:
  FcptModel mFcpt;
  static const HidVarCPT1DModel<F,LogProb> mF_0;
  static const HidVarCPT1DModel<F,LogProb> mF_1;
 public:
  static bool F_ROOT_OBS;
  //typedef FcptModel::IterVal IterVal;
  LogProb setIterProb ( F::ArrayIterator<LogProb>& f, const D& d, const F& fD, const Q& qP, const Q& qU, int& a ) const {
    //if (d==D_1 && F_ROOT_OBS==false) return mF_0.setIterProb(f,a);
    //if (d==D_1 && F_ROOT_OBS==true ) return mF_1.setIterProb(f,a);
    LogProb pr;
    if (fD==F_1 && (qU.getExp().getTerm()==F_1 || qU.getExp()==G_NIL))        pr = mF_1.setIterProb(f,a);
    else if (fD==F_1 && qU.getExp()==qP.getAct() && qP.getAwa()==qP.getExp()) pr = mFcpt.setIterProb(f,d,qP.getUp(),a);
    else                                                                      pr = mF_0.setIterProb(f,a);
    // Report error...
    if ( a<-1 && pr==LogProb() ) cerr<<"\nERROR: no condition Fr "<<d<<" "<<qP.getUp()<<"\n\n";
    //cerr<<"  "<<qU<<" "<<qU.getExp()<<" "<<qP.getAct()<<"   "<<qP<<" "<<qP.getAwa()<<" "<<qP.getExp()<<"   "<<f<<"\n";
    // Return fail if result doesn't match root observation...
    if ( a>=-1 && d==D_1 && F_ROOT_OBS!=(F_1==f) ) pr=LogProb();
    return pr;
  }
  friend pair<StringInput,FModel*> operator>> ( StringInput si, FModel& m ) { return pair<StringInput,FModel*>(si,&m); }
  friend StringInput operator>> ( pair<StringInput,FModel*> si_m, const char* psD ) { return si_m.first>>"Fr ">>si_m.second->mFcpt>>psD; }
};
const HidVarCPT1DModel<F,LogProb> FModel::mF_0(F_0);
const HidVarCPT1DModel<F,LogProb> FModel::mF_1(F_1);
bool FModel::F_ROOT_OBS = false;


//// Model of Q given D and F and F and Q(from prev) and Q(from above)
class QModel {
 private:
  QtcptModel mQtcpt;
  QecptModel mQecpt;
  static const HidVarCPT1DModel<Q,LogProb> mQ_NIL;
  static       HidVarCPT2DModel<Q,Q,LogProb> mQ_COPY;
 public:
  ////typedef QecptModel::IterVal IterVal;
  //typedef QtcptModel::IterVal IterVal;
  LogProb setIterProb ( Q::ArrayIterator<LogProb>& q, const D& d, const F& fD, const F& f, const Q& qP, const Q& qU, int& a ) const {
    LogProb pr;
    if (fD==F_1) {
      if (f==F_1) {
        if (qU.getExp().getTerm()==F_1 || qU.getExp()==G_NIL) {
          // 1 1 expansion to null:
          pr = mQ_NIL.setIterProb(q,a);
          return pr;
        }
        // 1 1 (expansion) case:
        pr = mQecpt.setIterProb(q,d,qU.getUp(),a);
        // Report error...
        if ( a<-1 && pr==LogProb() ) cerr<<"\nERROR: no condition Qe "<<d<<" "<<qU.getUp()<<"\n\n";
        return pr;
      }
      // 0 1 (transition) case:
      pr = mQtcpt.setIterProb(q,d,qU.getExp(),qP.getUp(),a);
      // Report error...
      if ( a<-1 && pr==LogProb() ) cerr<<"\nERROR: no condition Qt "<<d<<" "<<qU.getExp()<<" "<<qP.getUp()<<"\n\n";
      return pr;
    }
    // 0 0 (copy) case:
    if ( !mQ_COPY.contains(qP) )
      mQ_COPY.setProb(qP,qP)=1.0;
    pr = mQ_COPY.setIterProb(q,qP,a);
    //if ( LogProb()==pr ) { mQ_COPY.setProb(qP,qP)=1.0; pr=mQ_COPY.setIterProb(q,qP,a-c.NUM_ITERS-i.NUM_ITERS); }
    return pr;
  }
  friend pair<StringInput,QModel*> operator>> ( StringInput si, QModel& m ) { return pair<StringInput,QModel*>(si,&m); }
  friend StringInput operator>> ( pair<StringInput,QModel*> si_m, const char* psD ) {
    StringInput si;
    return ( (si=si_m.first>>"Qt ">>si_m.second->mQtcpt>>psD)!=NULL ||
             (si=si_m.first>>"Qe ">>si_m.second->mQecpt>>psD)!=NULL ) ? si : StringInput(NULL);
  }
};
const HidVarCPT1DModel<Q,LogProb> QModel::mQ_NIL(Q_NIL);
HidVarCPT2DModel<Q,Q,LogProb> QModel::mQ_COPY;


//////////////////////////////////////// Joint models...

//////////////////// Reduce phase...

//// Model of EF=E,F given EF and EQ and EQ
class EFModel : public DoubleFactoredModel<ErModel,FModel> {
  // private:
  //  static EModel mEAdjusted;
 public:
  typedef EF RVType;
  //typedef ComplexDoubleIteratedModeledRV<psLbrace,Er::ArrayIterator<LogProb>,psRbrace,F::ArrayIterator<LogProb>,psX> IterVal;

  static EModel mEAdjusted;

  LogProb setIterProb ( EF::ArrayIterator<LogProb>& ef, const D& d, EF::ArrayIterator<LogProb>& efRD, const EQ& eqP, const EQ& eqU, int& a ) const {
    ErModel mE = getM1();
    const FModel& mF = getM2();
    ECode::ArrayIterator<LogProb>&  eRD = efRD.first;
    const F&  fRD = efRD.second;
    const ECode&   eP  = eqP.first;
    const Q&   qP  = eqP.second;
    const ECode&   eU  = eqU.first;
    const Q&   qU  = eqU.second;
    ECode::ArrayIterator<LogProb>& eR  = ef.first;
    F::ArrayIterator<LogProb>& fR  = ef.second;
    //const E& eRtmp = ef.first;
    //const F& fRtmp = ef.second;

    Prob p;
    LogProb lp1,lp2;
    lp1  = mF.setIterProb ( fR, d, fRD, qP, qU, a );
    //#ifdef STAN
    //cerr<<"   Pr(f"<<d<<"="<<fR<<", "<<fRD<<") = "<<lp<<endl;
    //#endif

    // determine how previous word relates to previous context.
    L l = L_NONE;
    if (qU!=Q_NIL) {
      if ( F(fR)==0 ) { //copy from context if bottom on stack
	l = L_COPY;
      } else if ( qU.getAwa().getTerm()==F_1 ) { //pick out in-element case, where following const. has "="
	if ( qU.getAct().isHead() ) {
	  // 2 operation: L'Head LAll, then L'Head LMod
	  l = L_HEHM;
	} else {
	  // 2 operation: L'Head LAll, then L'Mod LHead
	  l = L_HEMH;
	}
      } else if ( qP==Q_NIL ) { //active level, right-branching tree
	if ( qU.getExp().isHead() ) {
	  // 1 operation: L'Head LMod
	  l = L_HM;
	} else {
	  // 1 operation: L'Mod LHead
	  l = L_MH;
	}
      } else if ( qU.getExp().getTerm()==F_0 && F(fR)==F_1 ) { //cross-element case
	if ( qU.getExp().isHead() ) {
	  // 1 operation: L'Head LMod
	  l = L_HM;
	} else {
	  // l operation: L'Mod LHead
	  l = L_MH;
	}
      }
    }

    // deal with the ambiguity of L_HE versus L_HEHM/L_HEMH in eRD --- sorta a hack-y solution
    string eRDstring = ECode(eRD).getString();
    size_t j = eRDstring.find(psSpace);
    if ( j != string::npos ) {
      LogProb lptmp;
      //cerr<<" noticed l_he vs. l_hehm/l_hemh ambiguity at d="<<d<<", picked ";
      if ( F(fR)==F_1 ) {

	// pick the HM or MH case previously assigned, to follow up (not more than 1 reduce at a time)
	ECode eRDcode = ECode( eRDstring.substr(0,j) );
	//cerr<<eRDcode<<endl;
	if ( !mEAdjusted.contains(eRDcode) ) mEAdjusted.setProb(eRDcode,eRDcode)=1.0;
	lptmp = mEAdjusted.setIterProb(eRD,eRDcode,a);

      } else {

	// pick the COPY case instead
	l = L_COPY;
	ECode eRDcode = ECode( eRDstring.substr(j+1,eRDstring.length()-j-1) );
	//cerr<<eRDcode<<endl;
	if ( !mEAdjusted.contains(eRDcode) ) mEAdjusted.setProb(eRDcode,eRDcode)=1.0;
	lptmp = mEAdjusted.setIterProb(eRD,eRDcode,a);

      }
    }

    // set the referent eR, but don't use its probability yet... do that in the S step.
    lp2 = mE.setIterProb ( eR, d, fRD, l, ECode(eRD), eP, eU, a );
    if (lp2!=LogProb()) { lp2 = LogProb(1.0); }

    //if (BACKOFF_E && lp1!=LogProb() && lp2!=LogProb()) {
    //  p = LAMBDA_E*(lp2.toProb()*lp1.toProb()) + (1-LAMBDA_E)*lp1.toProb();
    //  return LogProb(p);
    //}
    //else
      return lp1*lp2;
  }
};
EModel EFModel::mEAdjusted;


//// Model of R given S
class RModel : public SingleFactoredModel<EFModel> {
 private:
  static const HidVarCPT1DModel<F,LogProb> mF_1;
 public:
  //typedef ComplexArrayIteratedModeledRV<EF::ArrayIterator<LogProb>,psSemi,4> IterVal;
  static HidVarCPT2DModel<ECode,ECode,LogProb> mE_WORD;

  LogProb setIterProb ( R::ArrayIterator<LogProb>& r, const S& sP, int& a ) const {
    const EFModel& mEF = getM1();//.getM2();
    const EQ  eqP0 = EQ_TOP;
    const EQ& eqP1 = sP.get(0);//.second;
    const EQ& eqP2 = sP.get(1);//.second;
    const EQ& eqP3 = sP.get(2);//.second;
    const EQ& eqP4 = sP.get(3);//.second;

    const char* word = previousWord.c_str();
    if ( EMPTY_IS_UNK && !LModel::mHW.contains(HW(word)) && previousWord!="eos") word = "UNK";
    Eleft eleftWord( word );
    Eright erightWord( word, LModel::mHW.getProb(HW(word)) );
    const ECode eWord = ECode( E(eleftWord,erightWord) );
    if ( !mE_WORD.contains(eWord) )
      mE_WORD.setProb( eWord,eWord ) = 1.0;

    int aCtr;
    EF::ArrayIterator<LogProb>  ef5; mF_1.setIterProb(ef5.second,aCtr=-1); // = F_1;
                           mE_WORD.setIterProb(ef5.first,eWord,aCtr=-1); // = F_1;
    EF::ArrayIterator<LogProb>& ef4 = r.set(3);
    EF::ArrayIterator<LogProb>& ef3 = r.set(2);
    EF::ArrayIterator<LogProb>& ef2 = r.set(1);
    EF::ArrayIterator<LogProb>& ef1 = r.set(0);
    LogProb pr;
    pr  = mEF.setIterProb(ef4,4,ef5,eqP4,eqP3,a);
    pr *= mEF.setIterProb(ef3,3,ef4,eqP3,eqP2,a);
    pr *= mEF.setIterProb(ef2,2,ef3,eqP2,eqP1,a);
    pr *= mEF.setIterProb(ef1,1,ef2,eqP1,eqP0,a);
    return pr;
  }
};
const HidVarCPT1DModel<F,LogProb> RModel::mF_1(F_1);
HidVarCPT2DModel<ECode,ECode,LogProb> RModel::mE_WORD;

//////////////////// Shift phase...

//// Model of EQ given D and EF and EF and EQ and EQ
class EQModel : public DoubleFactoredModel<EsModel,QModel> {
  //private:
  //determine retroactively if what was observed in t-1 was a head
  //void hdwdbattle( L&, const Q&, const Q& ) const;

 public:
  typedef EQ RVType;
  //typedef ComplexDoubleIteratedModeledRV<psLbrace,Es::ArrayIterator<LogProb>,psRbrace,Q::ArrayIterator<LogProb>,psX> IterVal;

  LogProb setIterProb ( EQ::ArrayIterator<LogProb>& eq, const D& d, const EF::ArrayIterator<LogProb>& efRD, const EF::ArrayIterator<LogProb>& ef, const EQ& eqP, const EQ::ArrayIterator<LogProb>& eqU, int& a ) const {
    const EsModel&  mE = getM1();
    const QModel&   mQ = getM2();

    ECode::ArrayIterator<LogProb>& e = eq.first;
    Q::ArrayIterator<LogProb>& q  = eq.second;
    const ECode& eRD = ECode(efRD.first);
    const F& fRD = efRD.second;
    const ECode& eR  = ECode(ef.first);
    const F& fR  = ef.second;
    const ECode& eP  = eqP.first;
    const Q& qP  = eqP.second;
    const ECode& eU  = ECode(eqU.first);
    const Q& qU  = Q(eqU.second);

    Prob p;
    LogProb lp1,lp2;
    L l("-"); //unused here
    lp1  = mQ.setIterProb ( q, d, fRD, fR, qP, qU, a );
    lp2  = mE.setIterProb ( e, d, l, fRD, fR, eR, eRD, eU, qU, a );
    //cerr<<"probability form last time was eP.norm="<<eP.norm()<<" and this time it is lp2="<<lp2<<endl;
    if (eP.norm() != LogProb()) {  // remove previous time step's vector evaluation.  i.e. no histeresis.
      if (BACKOFF_E)
	lp2 = lp2 / LogProb( eP.norm().toProb()*LAMBDA_E + 1-LAMBDA_E ); // for linear interpolation backoff
      else
	lp2 = lp2 / eP.norm();
    }

    //if (BACKOFF_E) cerr<<"   Pr(eS"<<d<<"="<<e<<", "<<fRD<<", "<<fR<<", "<<eRD<<") = "<<p<<" = e^"<<LogProb(p)<<endl;
    //else cerr<<"   Pr(eS"<<d<<"="<<e<<", "<<fRD<<", "<<fR<<", "<<eRD<<") = "<<lp1*lp2<<endl;

    if (BACKOFF_E && lp1!=LogProb() && lp2!=LogProb()) {
      p   = LAMBDA_E*(lp2.toProb()*lp1.toProb()) + (1-LAMBDA_E)*lp1.toProb();
      return LogProb(p);
    }
    else return lp1*lp2;
  }
};
//static members included in HdwdStaticModels.h

//// Model of S given R and S
class SModel : public SingleFactoredModel<EQModel> {
 private:
  static const HidVarCPT1DModel<F,LogProb> mF_1;
  static const HidVarCPT1DModel<Q,LogProb> mQ_TOP;

 public:
  static HidVarCPT1DModel<ECode,LogProb> mE_NONE;
  static HidVarCPT1DModel<ECode,LogProb> mE_TOP;

  //typedef ComplexArrayIteratedModeledRV<EQ::ArrayIterator<LogProb>,psSemi,4> IterVal;
  LogProb setIterProb ( S::ArrayIterator<LogProb>& s, const R::ArrayIterator<LogProb>& r, const S& sP, int& a ) const {
    const EQModel& mEQ = getM1();
    const EQ&  eqP1 = sP.get(0);//.second;
    const EQ&  eqP2 = sP.get(1);//.second;
    const EQ&  eqP3 = sP.get(2);//.second;
    const EQ&  eqP4 = sP.get(3);//.second;
    int aCtr;
    EF::ArrayIterator<LogProb>   ef5; mF_1.setIterProb(ef5.second,aCtr=-1);  // EF_1;
                            mE_NONE.setIterProb(ef5.first,aCtr=-1);
    const EF::ArrayIterator<LogProb>&  ef4  = r.get(3);
    const EF::ArrayIterator<LogProb>&  ef3  = r.get(2);
    const EF::ArrayIterator<LogProb>&  ef2  = r.get(1);
    const EF::ArrayIterator<LogProb>&  ef1  = r.get(0);
    EQ::ArrayIterator<LogProb>  eq0; mQ_TOP.setIterProb(eq0.second,aCtr=-1); //= Q_TOP;
                           mE_TOP.setIterProb(eq0.first,aCtr=-1);
    EQ::ArrayIterator<LogProb>& eq1 = s.set(0);
    EQ::ArrayIterator<LogProb>& eq2 = s.set(1);
    EQ::ArrayIterator<LogProb>& eq3 = s.set(2);
    EQ::ArrayIterator<LogProb>& eq4 = s.set(3);

    #ifdef STAN
    LogProb pr[4];
    pr[0] = mEQ.setIterProb(eq1,1,ef2,ef1,eqP1,eq0,a);//Q(eq0),a);
    pr[1] = mEQ.setIterProb(eq2,2,ef3,ef2,eqP2,eq1,a);//Q(eq1),a);
    pr[2] = mEQ.setIterProb(eq3,3,ef4,ef3,eqP3,eq2,a);//Q(eq2),a);
    pr[3] = mEQ.setIterProb(eq4,4,ef5,ef4,eqP4,eq3,a);//Q(eq3),a);

    ECode eCode1 = ECode(eq1.first); E e1 = eCode1.toE(); Q q1 = Q(eq1.second);
    ECode eCode2 = ECode(eq2.first); E e2 = eCode2.toE(); Q q2 = Q(eq2.second);
    ECode eCode3 = ECode(eq3.first); E e3 = eCode3.toE(); Q q3 = Q(eq3.second);
    ECode eCode4 = ECode(eq4.first); E e4 = eCode4.toE(); Q q4 = Q(eq4.second);
    cerr<<"P(s = {"<<e1<<"}"<<q1<<";{"<<e2<<"}"<<q2<<";{"<<e3<<"}"<<q3<<";{"<<e4<<"}"<<q4<<";"<<" | r, sP = "<<sP<<") = ";
    for (int i=0; i<4; i++) {
      cerr<<pr[i]<<"+";
    }
    cerr<<"0 = "<<pr[0]*pr[1]*pr[2]*pr[3]<<endl;
    return pr[0]*pr[1]*pr[2]*pr[3];
    #else
    LogProb pr;
    pr  = mEQ.setIterProb(eq1,1,ef2,ef1,eqP1,eq0,a);//Q(eq0),a);
    pr *= mEQ.setIterProb(eq2,2,ef3,ef2,eqP2,eq1,a);//Q(eq1),a);
    pr *= mEQ.setIterProb(eq3,3,ef4,ef3,eqP3,eq2,a);//Q(eq2),a);
    pr *= mEQ.setIterProb(eq4,4,ef5,ef4,eqP4,eq3,a);//Q(eq3),a);
    return pr;
    #endif //STAN
  }

};
HidVarCPT1DModel<ECode,LogProb> SModel::mE_NONE(ECode_NONE);
HidVarCPT1DModel<ECode,LogProb> SModel::mE_TOP(ECode_TOP);
const HidVarCPT1DModel<F,LogProb> SModel::mF_1(F_1);
const HidVarCPT1DModel<Q,LogProb> SModel::mQ_TOP(Q_TOP);


//////////////////// Overall...

//// Model of H=R,S given S
class HModel : public DoubleFactoredModel<RModel,SModel> {
 public:
  static bool& F_ROOT_OBS;
  //typedef ComplexDoubleIteratedModeledRV<psLbrack,R::ArrayIterator<LogProb>,psRbrack,S::ArrayIterator<LogProb>,psX> IterVal;
  typedef H::ArrayIterator<LogProb> IterVal;
  S& setTrellDat ( S& s, const H::ArrayIterator<LogProb>& h ) const {
    s.setVal(h.second);
    return s;
  }
  R setBackDat ( const H::ArrayIterator<LogProb>& h ) const {
    R r;
    r.setVal(h.first);
    return r;
  }
  LogProb setIterProb ( H::ArrayIterator<LogProb>& h, const S& sP, int& a ) const {
    const RModel& mR = getM1();
    const SModel& mS = getM2();
    R::ArrayIterator<LogProb>& r = h.first;
    S::ArrayIterator<LogProb>& s = h.second;

    LogProb pr;

    pr  = mR.setIterProb(r,sP,a);
    //#ifdef STAN
    //cerr<<" Pr(r) = "<<pr<<endl;
    //#endif
    //if ( LogProb()==pr ) return pr;
    pr *= mS.setIterProb(s,r,sP,a);
    //#ifdef STAN
    //cerr<<" Pr(s) = "<<pr<<endl;
    //#endif

    //#ifdef STAN
    //cerr<<" AFTER : "<<endl;
    //cerr<<"      r: "<<r<<endl;
    //cerr<<"      s: "<<s<<endl;
    //#endif

    return pr;
  }

  void clear ( ) {
    if (VERBOSE) cerr<<"\nfinished sentence, clearing EModels and ECodes"<<endl;
    ErModel::mE_COPY.clear();
    ErModel::mEComposed.clear();
    mCodebook.clear();
    EsModel::mE_COPY.clear();
    EFModel::mEAdjusted.clear();
    RModel::mE_WORD.clear();
    domECode.clear();
  }

  void init ( ) {
    // with models loaded, re-initialize all values
    El_NONE = Eleft(NONE_string);
    El_UNIF = Eleft(UNIF_string);
    El_TOP  = Eleft(TOP_string);
    Er_NONE = Eright(NONE_string);
    Er_UNIF = Eright(UNIF_string);
    Er_TOP  = Eright(TOP_string);
    E_NONE  = E(El_NONE,Er_NONE);
    E_UNIF  = E(El_UNIF,Er_UNIF);
    E_TOP   = E(El_TOP,Er_TOP);
    ECode_NONE = ECode(E_NONE);
    ECode_UNIF = ECode(E_UNIF);
    ECode_TOP  = ECode(E_TOP);

    EsModel::mE_UNIF = HidVarCPT1DModel<ECode,LogProb>(ECode_UNIF);
    EsModel::mE_NONE = HidVarCPT1DModel<ECode,LogProb>(ECode_NONE);
    SModel::mE_NONE  = HidVarCPT1DModel<ECode,LogProb>(ECode_NONE);
    SModel::mE_TOP   = HidVarCPT1DModel<ECode,LogProb>(ECode_TOP);
  }

};
bool& HModel::F_ROOT_OBS = FModel::F_ROOT_OBS;


////////////////////////////////////////////////////////////////////////////////
