///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. //
//                                                                           //
//    ModelBlocks is free software: you can redistribute it and/or modify    //
//    it under the terms of the GNU General Public License as published by   //
//    the Free Software Foundation, either version 3 of the License, or      //
//    (at your option) any later version.                                    //
//                                                                           //
//    ModelBlocks is distributed in the hope that it will be useful,         //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          //
//    GNU General Public License for more details.                           //
//                                                                           //
//    You should have received a copy of the GNU General Public License      //
//    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include "nl-cpt.h"
#include <string>
#include <vector>
#include <iostream>
#include <cstdio>
#include <sstream>
using namespace std;

char psX[]="";
char psSlash[]="/";
char psVetical[]="|";
char psComma[]=",";
char psSemi[]=";";
char psSemiSemi[]=";;";
char psDashDiamondDash[]="-<>-";
char psTilde[]="~";
//char psBar[]="|";
//char psOpenBrace[]="{";
//char psCloseBrace[]="}";
char psLangle[]="<";
char psRangle[]=">";
char psLbrack[]="[";
char psRbrack[]="]";
const char* OLD = "old";
const char* NEW = "NEW";
const char* COPY = "copy";
const std::string delimiters = "_";
const unsigned int maxlen = 6;
//const string& underline = "_";
//const char* COPY = "COPY";
/* G;OP */
/* CR;POS;OP */
/* IND/GEN;POS;OP */
/* 0/0;0;0 */

//my BEG_STATE and END_STATE is based on the model,
//H is equal to S and S is composed of OP,CR and POS
//CR is composed of Ind, Gen,Num and Syn
//Therefore, I have the following:
//const char* BEG_STATE = "-;-|-|-|-;-";
//const char* END_STATE = "-;-|-|-|-;-";

const char* BEG_STATE = "-;-,-|-,-|-,-|-,-;-";
const char* END_STATE = "-;-,-|-,-|-,-|-,-;-";

//const char* BEG_STATE = "S/end;-/-;-/-/-;-/-;-;;0/0;0;0";
//const char* END_STATE = "S/end;-/-;-/-/-;-/-;-;;0/0;0;0";

void Tokenize(const string& str,
		vector<string>& tokens,
		const string& delimiters)
{
	// Skip delimiters at beginning.
	string::size_type lastPos = str.find_first_not_of(delimiters, 0);
	// Find first "non-delimiter".
	string::size_type pos     = str.find_first_of(delimiters, lastPos);

	while (string::npos != pos || string::npos != lastPos)
	{
		// Found a token, add it to the vector.
		tokens.push_back(str.substr(lastPos, pos - lastPos));
		// Skip delimiters.  Note the "not_of"
		lastPos = str.find_first_not_of(delimiters, pos);
		// Find next "non-delimiter"
		pos = str.find_first_of(delimiters, lastPos);
	}
}


////////////////////////////////////////////////////////////////////////////////
//
//  Random Variables
//
////////////////////////////////////////////////////////////////////////////////

//const Pos Pos_0("-");
DiscreteDomain<int> domOP;
typedef DiscreteDomainRV<int,domOP> OP;
const OP Op_BOT("-");
const OP Op_COPY(COPY);
const OP Op_OLD(OLD);
const OP Op_NEW(NEW);


//// I: Index
//// Index is different from Ind. The former refers to things from the model
//// file. The index model file now looks like Ind OLD size_6 : pos_6_3 = 0.23 which means
//// that the size is 6 and previous third index is replaced. Ind in this model should be
//// an string cluster which looks like: 0_1_2_3_4_5

DiscreteDomain<int> domOldInd;
typedef DiscreteDomainRV<int,domOldInd> OldInd; 

DiscreteDomain<int> domLoc;
typedef DiscreteDomainRV<int,domLoc> Loc;
const Loc Loc_BOT("-");

DiscreteDomain<int> domSize;
typedef DiscreteDomainRV<int,domSize> Size;

//// II: Ind
DiscreteDomain<int> domInd;
typedef DiscreteDomainRV<int,domInd> Ind;
const Ind Ind_BOT("-");

class JointInd : public DelimitedJoint2DRV<psX,Ind,psComma,Loc,psX> {
public:
	JointInd ( )                                                  : DelimitedJoint2DRV<psX,Ind,psComma,Loc, psX> ( )    { }
	JointInd ( char* ps )                                         : DelimitedJoint2DRV<psX,Ind,psComma,Loc,psX> ( ps ) { }
	JointInd ( const Ind & ind, const Loc & loc)            : DelimitedJoint2DRV<psX,Ind,psComma,Loc,psX> ( ind,loc) { }
	bool compareFinal ( const JointInd & jointInd ) const { return(*this==jointInd); }
};


DiscreteDomain<int> domNewGen;
typedef DiscreteDomainRV<int,domNewGen> NewGen; 
const NewGen NewGen_BOT("-");

DiscreteDomain<int> domGen;
typedef DiscreteDomainRV<int,domGen> Gen; 
const Gen Gen_BOT("-");

class JointGen : public DelimitedJoint2DRV<psX,Gen,psComma,NewGen,psX> {
public:
	JointGen ( )                                                  : DelimitedJoint2DRV<psX,Gen,psComma,NewGen, psX> ( )    { }
	JointGen ( char* ps )                                         : DelimitedJoint2DRV<psX,Gen,psComma,NewGen,psX> ( ps ) { }
	JointGen ( const Gen & gen, const NewGen & newGen)            : DelimitedJoint2DRV<psX,Gen,psComma,NewGen,psX> ( gen,newGen) { }
	bool compareFinal ( const JointGen& jointGen ) const { return(*this==jointGen); }
};

DiscreteDomain<int> domNewNum;
typedef DiscreteDomainRV<int,domNewNum> NewNum;
const NewNum NewNum_BOT("-");

DiscreteDomain<int> domNum;
typedef DiscreteDomainRV<int,domNum> Num;
const Num Num_BOT("-");

class JointNum : public DelimitedJoint2DRV<psX,Num,psComma,NewNum,psX> {
public:
	JointNum ( )                                                  : DelimitedJoint2DRV<psX,Num,psComma,NewNum, psX> ( )    { }
	JointNum ( char* ps )                                         : DelimitedJoint2DRV<psX,Num,psComma,NewNum,psX> ( ps ) { }
	JointNum ( const Num & num, const NewNum & newNum)            : DelimitedJoint2DRV<psX,Num,psComma,NewNum,psX> ( num,newNum) { }
	bool compareFinal ( const JointNum& jointNum ) const { return(*this==jointNum); }
};


DiscreteDomain<int> domNewSyn;
typedef DiscreteDomainRV<int,domNewSyn> NewSyn;
const NewSyn NewSyn_BOT("-");

DiscreteDomain<int> domSyn;
typedef DiscreteDomainRV<int,domSyn> Syn;
const Syn Syn_BOT("-");

class JointSyn : public DelimitedJoint2DRV<psX,Syn,psComma,NewSyn,psX> {
public:
	JointSyn ( )                                                  : DelimitedJoint2DRV<psX,Syn,psComma,NewSyn, psX> ( )    { }
	JointSyn ( char* ps )                                         : DelimitedJoint2DRV<psX,Syn,psComma,NewSyn,psX> ( ps ) { }
	JointSyn ( const Syn & syn, const NewSyn & newSyn)            : DelimitedJoint2DRV<psX,Syn,psComma,NewSyn,psX> (syn,newSyn) { }
	bool compareFinal ( const JointSyn& jointSyn ) const { return(*this==jointSyn); }
};

DiscreteDomain<int> domPos;
typedef DiscreteDomainRV<int,domPos> Pos;
const Pos Pos_BOT("-");



//#define OP_NONE OP("-");
//const OP OP_0("-");
//DiscreteDomain<int> domCR;

//class CR : public DelimitedJoint4DRV<psX,Ind,psSlash,Gen,psSlash,Num,psSlash, Syn,psX> {
//public:
//	CR ( )                                                  : DelimitedJoint4DRV<psX,Ind,psSlash,Gen,psSlash,Num,psSlash,Syn,psX> ( )    { }
//	CR ( char* ps )                                         : DelimitedJoint4DRV<psX,Ind,psSlash,Gen,psSlash,Num,psSlash,Syn,psX> ( ps ) { }
//	CR ( const Ind& ind, const Gen& gen, const Num & num,const Syn & syn )                  : DelimitedJoint4DRV<psX,Ind,psSlash,Gen,psSlash,Num,psSlash,Syn,psX> ( ind, gen,num,syn ) { }
//};

class CR : public DelimitedJoint4DRV<psX,JointInd,psVetical,JointGen,psVetical, JointNum,psVetical,JointSyn,psX> {
public:
	CR ( )                                                  : DelimitedJoint4DRV<psX,JointInd,psVetical,JointGen,psVetical,JointNum,psVetical,JointSyn,psX> ( )    { }
	CR ( char* ps )                                         : DelimitedJoint4DRV<psX,JointInd,psVetical,JointGen,psVetical,JointNum,psVetical,JointSyn,psX> ( ps ) { }
	CR ( const JointInd& joint_ind, const JointGen& joint_gen, const JointNum & joint_num, const JointSyn & joint_syn )                  : DelimitedJoint4DRV<psX,JointInd,psVetical,JointGen,psVetical,JointNum,psVetical,JointSyn,psX> (joint_ind, joint_gen,joint_num,joint_syn ) { }
};

//// H: the set of all (marginalized) reduce and (modeled) shift variables in the HHMM...

class G : public DelimitedJoint2DRV<psX,CR,psSemi,Pos,psX> {
public:
	G ( )                                                  : DelimitedJoint2DRV<psX,CR,psSemi,Pos, psX> ( )    { }
	G ( char* ps )                                         : DelimitedJoint2DRV<psX,CR,psSemi,Pos,psX> ( ps ) { }
	G ( const CR & cr, const Pos & pos)                    : DelimitedJoint2DRV<psX,CR,psSemi,Pos,psX> ( cr,pos) { }
	bool compareFinal ( const G& g ) const { return(*this==g); }
};



class S : public DelimitedJoint2DRV<psX,OP,psSemi,G,psX> {
public:
	S ( )                                                  : DelimitedJoint2DRV<psX,OP,psSemi, G, psX> ( )    { }
	S ( char* ps )                                         : DelimitedJoint2DRV<psX,OP,psSemi, G, psX> ( ps ) { }
	S ( const OP & op, const G g)                  : DelimitedJoint2DRV<psX,OP,psSemi,G, psX> ( op, g ) { }
	operator OP() const {return first;}
	//this following is for convenience to store Observed Model into a simplehash<Pos, prob> defined in TextObsModel-corefS;
	operator G() const {return second;}
	operator Pos() const {return second.second;}

	bool compareFinal ( const S& s ) const { return(*this==s); }
};

typedef S H;

//// L: letter...
DiscreteDomain<char> domainLt;
typedef DiscreteDomainRV<char,domainLt> Lt;

//// W: word (array of letters, arranged last to first)...
//typedef StaticSafeArray<5,Lt> W;
DiscreteDomain<int> domainW;
class W : public DiscreteDomainRV<int,domainW>, public StaticSafeArray<5,Lt> {
public:
	W ( ) { }
	W ( const char* ps ) : DiscreteDomainRV<int,domainW>(ps) {
		char psTemp[2]="-"; int n=strlen(ps);
		for(int i=0;i<5;i++) {
			psTemp[0]=(i<n)?ps[n-i-1]:'_';
			//cout<<"!!!!!!!!!!!!!!!!!!"<<psTemp<<endl;
			StaticSafeArray<5,Lt>::set(i)=Lt(psTemp);
		}
	}
	friend pair<StringInput,W*> operator>> ( const StringInput ps, W& rv ) { return pair<StringInput,W*>(ps,&rv); }
	friend StringInput operator>> ( pair<StringInput,W*> si_x, const char* psDlm ) {

		if(si_x.first==NULL)return si_x.first; String s; StringInput si=si_x.first>>s>>psDlm; *si_x.second=s.c_array(); return si; }
	bool   operator== ( const W& w ) const { return DiscreteDomainRV<int,domainW>::operator==(w); }
	size_t getHashKey ( )            const { return DiscreteDomainRV<int,domainW>::getHashKey();  }
};

//// C: same as , since no role labels...
typedef Pos C;

////////////////////////////////////////////////////////////////////////////////
//
//  Models
//
////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////// "Wrapper" models for individual RVs...

class OpModel{
private:
	//HidVarCPT4DModel<OP,Syn,OP,Pos,LogProb> mOp_full;
	HidVarCPT3DModel<OP,OP,Pos,LogProb> mOp_full;
	//const HidVarCPT1DModel<OP,LogProb> mOp_start; //Fixed Gen_ZERO model
	//static const HidVarCPT1DModel<OP,LogProb> mOp_BOT; //Fixed Op_ZERO model
public:
	LogProb setIterProb(OP::ArrayIterator<LogProb>& op, const OP & opP, const Pos & posP,int& a) const {
		LogProb pr,p;
		//cerr << "   Before op model... op : "<<op<<" opP: "<<opP << " posP: "<<posP << pr<< endl;
		pr=p=mOp_full.setIterProb(op,opP,posP,a);
		//cerr << "   After op model...op: "<<op<<" opP: "<<opP << " posP: "<<posP << pr << endl;
		// Report error...
		if ( a<-1 && pr==LogProb() ) cerr<<"\nERROR: no condition mOp_full op: "<<op<<" opP: "<<opP<<" posP: "<<posP<<"\n\n";
		// Iterate again if result doesn't match root observation...
		//if ( a>=-1 ) pr=LogProb();
		////cerr<<"    F "<<d<<" "<<fD<<" "<<qP<<" "<<qU<<" : "<<f<<" = "<<pr<<" ("<<a<<")\n";
		return pr;
	}
	friend pair<StringInput,OpModel*> operator>> ( StringInput si, OpModel& m) { return pair<StringInput,OpModel*>(si,&m); }
	friend StringInput operator>> ( pair<StringInput,OpModel*> si_m, const char* psD ) {
		StringInput si;
		return ( (si=si_m.first>>"Op " >>si_m.second->mOp_full >>psD)!=NULL ) ? si : StringInput(NULL);
	}
} ;
//const HidVarCPT1DModel<OP,LogProb> OpModel::mOp_BOT(Op_BOT);


class IndModel {
private:
	static HidVarCPT3DModel<Ind,OP,Ind,LogProb> mInd_Copy; //model when oper is COPY, then the probablity is 1
	static HidVarCPT3DModel<Ind,OP,Ind,LogProb>	 mInd_New;
	static HidVarCPT3DModel<Ind,OP,Ind,LogProb> mInd_End;
	//it is interesting here, the first OldInd is the size and the second OldInd is the position.
	HidVarCPT3DModel<Loc,OP,Size, LogProb> mInd_Input;
	static const HidVarCPT1DModel<Loc,LogProb> mLoc_BOT;
	static HidVarCPT4DModel<Ind,OP,Ind,Loc,LogProb> mInd_Old;
	static const HidVarCPT1DModel<Ind,LogProb> mInd_BOT; //Fixed Ind_ZERO model
	//I don't quite understand why if we use static const, I must initialize it outside the class for it to compile successfully
	//and I am not sure if only if const, there may be troubles. Probably since static aims at keeping it unchanged.
	//const HidVarCPT1DModel<Ind,LogProb> mInd_start;
	//static const HidVarCPT1DModel<Ind,LogProb> mInd_start;    // Fixed Ind_ZERO model.
public:
	LogProb setIterProb(JointInd::ArrayIterator<LogProb>& jointInd, const OP & op, const JointInd& jointIndP, int& a) const {
		//cout<<" op: "<<op<<endl;
		LogProb pr,p;
		const Ind indP = jointIndP.first;
		vector<std::string> indPTokens;
		const string indPStr = indP.getString();
		Tokenize(indPStr,indPTokens,delimiters);
		//the first if is the terminate condition
		if(op==Op_BOT && indP!=Ind_BOT){
			pr=p=mLoc_BOT.setIterProb(jointInd.second,a);
			if(!mInd_End.contains(op,indP)){
				mInd_End.setProb(Ind_BOT,op,indP)=1.0;
			}
			pr*=p=mInd_End.setIterProb(jointInd.first,op,indP,a);
		}else if(op==Op_COPY){
			if(indP==Ind_BOT){
				//in fact, the following value is always 1;
				pr=p=mLoc_BOT.setIterProb(jointInd.second,a);
				//	cout<<" pr: "<<pr<<" jointInd when indP == Ind_BOT and op is copy 1 "<<jointInd<<" a: "<<a<<endl;
				pr*=p=mInd_BOT.setIterProb(jointInd.first,a);
				//	cout<<" pr: "<<pr<<" jointInd when indP == Ind_BOT and op is copy 2"<<jointInd<<" a: "<<a<<endl;
			}
			else{
				pr=p=mLoc_BOT.setIterProb(jointInd.second,a);
				//				if(pr==LogProb()){
				//					pr=1.0;
				//				}
				std::stringstream out;
				std::string indexStr;
				for(unsigned int i = 0; i < indPTokens.size()-1; ++i ) {
					out<<i<<"_";
				}
				out<<indPTokens.size()-1;
				indexStr = out.str();
				//cout<<"\n"<<indexStr<<endl;
				Ind newIndP(indexStr.c_str());
				if (!mInd_Copy.contains(op,newIndP) ){
					mInd_Copy.setProb(newIndP,op,newIndP)=1.0;
				}
				//here, the logic is based on the fact that only ind = newIndP, the probability is 1
				//and otherwise, it is 0; thus, it is in fact, deterministic. right?

				pr *=p= mInd_Copy.setIterProb(jointInd.first,op,newIndP,a);
				if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mInd_Copy "<<jointInd<<" "<<op<<" "<<newIndP<<"\n\n";	
			}
		}else if(op==Op_NEW){
			if(indP==Ind_BOT){
				pr=p=mLoc_BOT.setIterProb(jointInd.second,a);
				Ind ind = Ind("0");
				if(!mInd_New.contains(op,indP)){
					mInd_New.setProb(ind,op,indP)=1.0;
				}
				pr*=p=mInd_New.setIterProb(jointInd.first,op,indP,a);
				if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mInd_New "<<jointInd<<" "<<op<<"\n\n";
			}else{
				pr=p=mLoc_BOT.setIterProb(jointInd.second,a);
				if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mInd_Input "<<jointInd.second<<" "<<op<<"\n\n";
				//const string indPStr = indP.getString();
				//Tokenize(indPStr,indPTokens,delimiters);
				std::stringstream out1;
				std::string indexStr1;
				std::stringstream out2;
				std::string indexStr2;
				for(unsigned int i = 0; i < indPTokens.size()-1; ++i ) {
					out1<<i<<"_";
				}
				for(unsigned int i = 0; i < indPTokens.size()-1; ++i ) {
					out2<<i<<"_";
				}
				out1<<indPTokens.size()-1;
				//cout<<" out1 in the first: "<<out1.str()<<" out2 in the first: "<<out2.str()<<endl;

				out2<<indPTokens.size()-1<<"_";
				//cout<<" out1 in the first: "<<out1.str()<<"out2 in the second: "<<out2.str()<<endl;
				indexStr1 = out1.str();
				Ind newIndP(indexStr1.c_str());
				out2<<indPTokens.size();
				indexStr2 = out2.str();
				//Good, setProb methods has set new Ind into mInd_New, so we can
				//safely call mInd_New.setIterProb to loop through the new Ind as well.
				if(indPTokens.size()<maxlen){
					if(!mInd_New.contains(op,newIndP)){
						mInd_New.setProb(Ind(indexStr2.c_str()),op,newIndP)=1.0;
					}
					//cout<<" out2 when size is shorer than maxlen: "<<indexStr2<<endl;
				}else if(indPTokens.size()==maxlen){
					indexStr2=indexStr2.substr(2);
					if(!mInd_New.contains(op,newIndP)){
						mInd_New.setProb(Ind(indexStr2.c_str()),op,newIndP)=1.0;
					}
					//cout<<" out2 when size is longer than maxlen: "<<indexStr2<<endl;
				}

				pr*=p = mInd_New.setIterProb(jointInd.first,op,newIndP,a);
				//cerr<<"\njointInd: "<<jointInd<<" indP: "<<indP<<" op: "<<op<<" newIndP: "<<newIndP<<" pr "<<pr<<"\n\n";
				if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mInd_New "<<jointInd<<" "<<op<<" "<<newIndP<<"\n\n";
			}
		}else{
			//cerr<<"indP in indModel: "<<indP<<endl;
			std::stringstream out3;
			out3<<indPTokens.size();
			std::string sizeStr;
			sizeStr=out3.str();
			//loop through the indmodel.txt to find the suitable input.
			//when indPTokens.size is 1, no old dependencies as at all
			if(indPTokens.size()==1){
				pr=p=mLoc_BOT.setIterProb(jointInd.second,a);
				if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mInd_Bot "<<jointInd.second<<" "<<op<<"\n\n";
			}else{
				pr = p = mInd_Input.setIterProb(jointInd.second,op,Size(sizeStr.c_str()),a);
				if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mInd_Input "<<jointInd.second<<" "<<op<<"\n\n";
			}
			//const string indPStr = indP.getString();
			//Tokenize(indPStr,indPTokens,delimiters);
			std::stringstream out1;
			std::stringstream out2;
			std::string indexStr1;
			std::string indexStr2;
			Loc loc=jointInd.second;
			unsigned int position = atoi(loc.getString().c_str());
			if(indPTokens.size()==1){
				out1<<indPTokens.size();
				out2<<indPTokens.size();
			}else{
				for(unsigned int i=0;i<indPTokens.size()-1;i++){
					out1<<i<<"_";
					if(i<position){
						out2<<i<<"_";
						//indexStr+=to_string(i)+"_";
					}else{
						out2<<i+1<<"_";
						//indexStr+=to_string(i+1)+"_";
					}
				}
				out1<<indPTokens.size()-1;
				out2<<indPTokens.size();
			}
			indexStr1 = out1.str();
			indexStr2 = out2.str();
			//cout<<"out1 in old: "<<out1.str()<<" out2 in Old: "<<out2.str()<<" indP: "<<indP<<endl;
			Ind newIndP(indexStr1.c_str());
			//cerr<<"\njointInd in old 1: "<<jointInd<<" indP: "<<indP<<" op: "<<op<<" newIndP: "<<newIndP<<" pr "<<pr<<"\n\n";
			//I think that I should not use a if-clause here since if-clause call contains only consider key x, but not y
			//then it will miss some values. It seems that there is no way to check if genericCptModel contain all keys.
			//not so sure. Now, things improve, we can check it since we only need to check K rather than both K and Y
			if(!mInd_Old.contains(op,newIndP,loc)){
				mInd_Old.setProb(Ind(indexStr2.c_str()),op,newIndP,loc)=1.0;
			}
			//cerr<<"indexStr2: "<<indexStr2<<endl;
			//here, mInd_Old.setProb set Ind(indexStr2.c_str()) into mInd_Old, thus, the setIterProb will
			//loop through the new added Ind.
			pr*=p=mInd_Old.setIterProb(jointInd.first,op,newIndP,Loc(jointInd.second),a);
			if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mInd_Old "<<jointInd<<" "<<op<<" "<<newIndP<<"\n\n";
		}
		return pr;
	}
	friend pair<StringInput,IndModel*> operator>> ( StringInput si, IndModel& m) { return pair<StringInput,IndModel*>(si,&m); }
	friend StringInput operator>> ( pair<StringInput,IndModel*> si_m, const char* psD ) {
		StringInput si;
		return ( (si=si_m.first>>"Ind " >>si_m.second->mInd_Input >>psD)!=NULL ) ? si : StringInput(NULL);
	}
};
HidVarCPT3DModel<Ind,OP,Ind,LogProb> IndModel::mInd_Copy;
HidVarCPT3DModel<Ind,OP,Ind,LogProb> IndModel::mInd_New;
HidVarCPT3DModel<Ind,OP,Ind,LogProb> IndModel::mInd_End;
HidVarCPT4DModel<Ind,OP,Ind,Loc,LogProb> IndModel::mInd_Old;
const HidVarCPT1DModel<Ind,LogProb> IndModel::mInd_BOT(Ind_BOT); //Fixed Ind_ZERO model
const HidVarCPT1DModel<Loc,LogProb> IndModel::mLoc_BOT(Loc_BOT);


class GenModel{
private:
	static HidVarCPT3DModel<Gen,OP,Gen,LogProb> mGen_Copy; //model when oper is COPY, then the probablity is 1
	//static HidVarCPT3DModel<Gen,OP,Gen,LogProb> mGen_Old;
	static HidVarCPT3DModel<Gen,OP,Gen,LogProb> mGen_End;
	//what is the meaning for the following cpt, it seems that NewGen is useless.
	//static HidVarCPT4DModel<Gen,OP,Gen,NewGen,LogProb> mGen_New;
	static HidVarCPT4DModel<Gen,OP,Gen,NewGen,LogProb> mGen_New;
	static HidVarCPT4DModel<Gen,OP,Gen,Ind, LogProb> mGen_Old;
	HidVarCPT2DModel<NewGen,OP,LogProb> mNewGen;
	static const HidVarCPT1DModel<NewGen,LogProb> mNewGen_BOT; //Fixed Gen_ZERO model
	static const HidVarCPT1DModel<Gen,LogProb> mGen_BOT; //Fixed Gen_ZERO model
public:
	LogProb setIterProb(JointGen::ArrayIterator<LogProb>& jointGen, const OP & op,  const Ind & ind,const JointGen & jointGenP, int& a) const {
		LogProb pr,p;
		vector<std::string> indTokens;
		vector<std::string> genPTokens;
		const Gen genP = jointGenP.first;
		const string indStr = ind.getString();
		const string genPStr = genP.getString();
		Tokenize(indStr,indTokens,delimiters);
		Tokenize(genPStr,genPTokens,delimiters);
		//const string genPStr = genP.getString();
		//Tokenize(genPStr,genPTokens,delimiters);
		//string sentence = "Something_in_the_way_she_moves";
		//the following code works now. remember that the function is also a constant, then any function called here must be constant as well.
		//Tokenize(sentence,indTokens,delimiters);
		if(op==Op_BOT && genP!=Gen_BOT){
			pr=p=mNewGen_BOT.setIterProb(jointGen.second,a);
			if(!mGen_End.contains(op,genP)){
				mGen_End.setProb(Gen_BOT,op,genP)=1.0;
			}
			pr*=p=mGen_End.setIterProb(jointGen.first,op,genP,a);
		}
		else if(op==Op_COPY){
			if(genP==Gen_BOT){
				pr=p=mNewGen_BOT.setIterProb(jointGen.second,a);
				//cout<<" pr: "<<pr<<" ind: "<<ind<<" jointGen is in genP == Gen_BOT and op is copy 1 "<<jointGen<<" a: "<<a<<endl;
				pr*=p=mGen_BOT.setIterProb(jointGen.first,a);
				//cout<<" pr: "<<pr<<" jointGen is in genP == Gen_BOT and op is copy 2"<<jointGen<<" a: "<<a<<endl;
			}else{
				pr=p=mNewGen_BOT.setIterProb(jointGen.second,a);
				//cout<<" pr: "<<pr<<" ind: "<<ind<<" op is copy 1 "<<jointGen<<" a: "<<a<<endl;
				if ( !mGen_Copy.contains(op,genP)) mGen_Copy.setProb(genP,op,genP)=1.0;
				pr *=p= mGen_Copy.setIterProb(jointGen.first,op,genP,a);
				//cerr<<" mGen_Copy size: "<<mGen_Copy.size()<<endl;
				//cout<<" pr: "<<pr<<" op is copy 2"<<jointGen<<" a: "<<a<<endl;
				if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mGen_Copy "<<jointGen<<" "<<op<<" "<<ind<<" "<<genP<<"\n\n";
			}
		}else if(op==Op_NEW){
			if(genP==Gen_BOT){
				//read prob models from model file, so, jointGen.second has values now.
				pr=p=mNewGen.setIterProb(jointGen.second,op,a);
				//	cerr<<" jointGen when op is new and genP is Gen_BOT "<<jointGen<<" p: "<<p<<" op: "<<op<<" genP: "<<genP<<endl;
				if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mNewGen "<<jointGen<<" "<<op<<" "<<ind<<"\n\n";
				std::stringstream out;
				std::string newGenStr;
				out<<jointGen.second;
				newGenStr=out.str();
				Gen gen = Gen(newGenStr.c_str());
				//				if(mGen_New.contains(op,genP,NewGen(jointGen.second))){
				//					mGen_New.setProb(gen,op,genP,NewGen(jointGen.second))=1.0;
				//				}
				//cerr<<" new GenStr: "<<newGenStr<<endl;
				if(!mGen_New.contains(op,genP,NewGen(newGenStr.c_str()))){
					mGen_New.setProb(gen,op,genP,NewGen(newGenStr.c_str()))=1.0;
				}
				//cerr<<" jointGen when op is new and genP is Gen_BOT "<<jointGen<<" gen: "<<gen<<" p: "<<p<<" op: "<<op<<" genP: "<<genP<<endl;
				//values of jointGen.first comes from mGen_New.setProb.
				//I see, here jointGen.first will loop through all values set for mGen_New added at each loop.
				pr*=p=mGen_New.setIterProb(jointGen.first,op,genP,NewGen(newGenStr.c_str()), a);
				if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mGen_New "<<jointGen<<" "<<op<<" genP: "<<genP<<"\n\n";
			}else{
				//const string indStr = ind.getString();
				//Tokenize(indStr,indTokens,delimiters);
				pr=p=mNewGen.setIterProb(jointGen.second,op,a);
				//cerr<<" jointGen when op is new and genP is Gen_BOT "<<jointGen<<" p: "<<p<<" op: "<<op<<" genP: "<<genP<<endl;
				if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mNewGen "<<jointGen.second<<" "<<op<<" "<<ind<<"\n\n";
				std::stringstream out;
				std::string newGenStr;
				int firstDelim = genPStr.find_first_of(delimiters);
				if(genPTokens.size()<maxlen){
					out<<genPStr<<"_"<<jointGen.second;
				}else if(genPTokens.size()==maxlen){
					out<<genPStr.substr(firstDelim+1)<<"_"<<jointGen.second;
				}
				newGenStr=out.str();
				//cerr<<"genPStr: "<<genPStr<<"newGenStr: "<<newGenStr<<endl;

				//genFromNewGen(s);
				//gen = new Gen(newGen.getString(),genP.getString());
				//the fowlloing code update gender string and its probability
				if(!mGen_New.contains(op,genP,NewGen(jointGen.second))){
					mGen_New.setProb(Gen(newGenStr.c_str()),op,genP,NewGen(jointGen.second))=1.0;
				}

				//			if(!mGen_New.contains(op,genP)){
				//				mGen_New.setProb(Gen(s.c_str()),op,genP)=1.0;
				//			}
				pr*=p = mGen_New.setIterProb(jointGen.first,op,genP,NewGen(jointGen.second),a);
				//cerr<<" jointGen when op is new and genP is Gen_BOT "<<jointGen<<" p: "<<p<<" op: "<<op<<" genP: "<<genP<<endl;
				if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mGen_New "<<jointGen<<" "<<op<<" "<<ind<<" "<<genP<<"\n\n";
			}
		}else{
			//if op==OLD, then the size of genP should be idential to that of ind
			//we use ind to know which one should be replaced.
			//const string indStr = ind.getString();
			//Tokenize(indStr,indTokens,delimiters);	
			pr=p=mNewGen_BOT.setIterProb(jointGen.second,a);
			int replace = 0;
			for(unsigned int i = 0; i < indTokens.size(); ++i ) {
				unsigned int intVal = atoi(indTokens[i].c_str());
				//cout<<intVal<<" "<<endl;
				if(intVal!=i){
					replace = i;
					//cout<<replace<<endl;
					break;
				}
			}
			string swap = genPTokens.at(replace);
			vector<string>::iterator iter = genPTokens.begin();
			int count = 0;
			while( iter != genPTokens.end() )
			{
				if (*iter == genPTokens.at(replace) && count==replace){
					iter = genPTokens.erase( iter );
					break;
				}
				else{
					++iter;
				}
				count++;
			}
			genPTokens.push_back(swap);
			string newGenStr;
			//cout<<" genPTokens size: "<<genPTokens.size()<<endl;
			if(genPTokens.size()==1){
				newGenStr+=genPTokens.at(genPTokens.size()-1);
			}else{
				for(unsigned int i = 0; i < genPTokens.size()-1; ++i ) {
					newGenStr+=genPTokens.at(i)+delimiters;
				}
				newGenStr+=genPTokens.at(genPTokens.size()-1);
			}

			//cerr<<"the curgen string: "<<newGenStr<<" genP: "<<genP<<endl;
			//the fowlloing code update gender string and its probability
			if(!mGen_Old.contains(op,genP,ind)){
				mGen_Old.setProb(Gen(newGenStr.c_str()),op,genP,ind)=1.0;
			}
			pr*=p=mGen_Old.setIterProb(jointGen.first,op,genP,ind,a);
			if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mGen_Old "<<jointGen<<" "<<op<<" "<<ind<<" "<<genP<<"\n\n";
		}
		// Report error...
		//if ( a<-1 && pr==LogProb() ) cerr<<"\nERROR: no condition mGen_full "<<" op: "<<op<<" genP: "<<genP<<"\n\n";
		// Iterate again if result doesn't match root observation...
		//if ( a>=-1 ) pr=LogProb();
		////cerr<<"    F "<<d<<" "<<fD<<" "<<qP<<" "<<qU<<" : "<<f<<" = "<<pr<<" ("<<a<<")\n";
		return pr;
	}
	friend pair<StringInput,GenModel*> operator>> ( StringInput si, GenModel& m) { return pair<StringInput,GenModel*>(si,&m); }
	friend StringInput operator>> ( pair<StringInput,GenModel*> si_m, const char* psD ) {
		StringInput si;
		return ( (si=si_m.first>>"Gen " >>si_m.second->mNewGen >>psD)!=NULL ) ? si : StringInput(NULL);
	}
};
//const HidVarCPT1DModel<Gen,LogProb> GenModel::mGen_start(Gen_0);
HidVarCPT3DModel<Gen,OP,Gen,LogProb> GenModel::mGen_Copy;
HidVarCPT4DModel<Gen,OP,Gen,Ind,LogProb> GenModel::mGen_Old;
HidVarCPT3DModel<Gen,OP,Gen,LogProb> GenModel::mGen_End;
HidVarCPT4DModel<Gen,OP,Gen,NewGen,LogProb> GenModel::mGen_New;
const HidVarCPT1DModel<Gen,LogProb> GenModel::mGen_BOT(Gen_BOT); //Fixed Gen_ZERO model
const HidVarCPT1DModel<NewGen,LogProb> GenModel::mNewGen_BOT(NewGen_BOT); //Fixed Gen_ZERO model

class NumModel{
private:
	static HidVarCPT3DModel<Num,OP,Num,LogProb> mNum_Copy; //model when oper is COPY, then the probablity is 1
	//static HidVarCPT3DModel<Num,OP,Num,LogProb> mNum_Old;
	static HidVarCPT3DModel<Num,OP,Num,LogProb> mNum_End;
	//what is the meaning for the following cpt, it seems that NewNum is useless.
	//static HidVarCPT4DModel<Num,OP,Num,NewNum,LogProb> mNum_New;
	static HidVarCPT4DModel<Num,OP,Num,NewNum,LogProb> mNum_New;
	//static HidVarCPT4DModel<Num,OP,Num,NewNum,LogProb> mNum_Old;
	static HidVarCPT4DModel<Num,OP,Num,Ind,LogProb> mNum_Old;
	HidVarCPT2DModel<NewNum,OP,LogProb> mNewNum;
	static const HidVarCPT1DModel<NewNum,LogProb> mNewNum_BOT; //Fixed Num_ZERO model
	static const HidVarCPT1DModel<Num,LogProb> mNum_BOT; //Fixed Num_ZERO model

public:
	LogProb setIterProb(JointNum::ArrayIterator<LogProb>& jointNum, const OP & op,  const Ind & ind,const JointNum & jointNumP, int& a) const {
		LogProb pr,p;
		vector<std::string> indTokens;
		vector<std::string> numPTokens;
		const Num numP = jointNumP.first;
		const string indStr = ind.getString();
		const string numPStr = numP.getString();
		Tokenize(indStr,indTokens,delimiters);
		Tokenize(numPStr,numPTokens,delimiters);
		//the following code works now. remember that the function is also a constant, then any function called here must be constant as well.
		//Tokenize(sentence,indTokens,delimiters);
		//the first if is the terminal condition,
		if(op==Op_BOT && numP!=Num_BOT){
			pr=p=mNewNum_BOT.setIterProb(jointNum.second,a);
			if(!mNum_End.contains(op,numP)){
				mNum_End.setProb(Num_BOT,op,numP)=1.0;
			}
			pr*=p=mNum_End.setIterProb(jointNum.first,op,numP,a);
		}
		else if(op==Op_COPY){
			if(numP==Num_BOT){
				pr=p=mNewNum_BOT.setIterProb(jointNum.second,a);
				//cout<<" pr: "<<pr<<" jointNum in numP==Num_BOT and op is copy 1 "<<jointNum<<" a: "<<a<<endl;
				pr*=p=mNum_BOT.setIterProb(jointNum.first,a);
				//cout<<" pr: "<<pr<<" jointNum in numP==Num_BOT and op is copy 2 "<<jointNum<<" a: "<<a<<endl;
			}else{
				pr=p=mNewNum_BOT.setIterProb(jointNum.second,a);
				//cout<<" pr: "<<pr<<" jointNum in numP==Num_BOT and op is copy 2 "<<jointNum<<" a: "<<a<<endl;
				if ( !mNum_Copy.contains(op,numP)) mNum_Copy.setProb(numP,op,numP)=1.0;
				pr *=p= mNum_Copy.setIterProb(jointNum.first,op,numP,a);
				//cout<<" pr: "<<pr<<" jointNum in numP==Num_BOT and op is copy 2 "<<jointNum<<" a: "<<a<<endl;
				if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mNum_Copy "<<jointNum.first<<" "<<op<<" "<<ind<<" "<<numP<<"\n\n";
			}
		}else if(op==Op_NEW){
			if(numP==Num_BOT){
				pr=p=mNewNum.setIterProb(jointNum.second,op,a);
				//cout<<" pr: "<<pr<<" jointNum in numP==Num_BOT and op is copy 2 "<<jointNum<<" a: "<<a<<endl;
				if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mNewNum "<<jointNum.second<<" "<<op<<" "<<ind<<"\n\n";
				std::stringstream out;
				std::string newNumStr;
				out<<jointNum.second;
				newNumStr=out.str();
				Num num = Num(newNumStr.c_str());
				if(!mNum_New.contains(op,numP,NewNum(jointNum.second))){
					mNum_New.setProb(num,op,numP,NewNum(jointNum.second))=1.0;
				}
				//

				pr*=p=mNum_New.setIterProb(jointNum.first,op,numP,NewNum(jointNum.second),a);
				//cerr<<" jointNum when op is NEW and numP is Num_BOT "<<jointNum<<" op: "<<op<<" num: "<<num<<" numP: "<<numP<<" P: "<<p<<endl;
				if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mNum_New "<<jointNum<<" "<<op<<"\n\n";
			}else{
				//const string indStr = ind.getString();
				//Tokenize(indStr,indTokens,delimiters);
				pr=p=mNewNum.setIterProb(jointNum.second,op,a);
				//cerr<<" jointNum when op is NEW and numP is Num_BOT "<<jointNum<<" op: "<<op<<" numP: "<<numP<<" P: "<<p<<endl;
				if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mNewNum "<<jointNum.second<<" "<<op<<" "<<ind<<"\n\n";
				std::stringstream out;
				std::string newNumStr;
				int firstDelim = numPStr.find_first_of(delimiters);
				if(numPTokens.size()<maxlen){
					//if(jointNum.second)
					out<<numPStr<<"_"<<jointNum.second;
				}else if(numPTokens.size()==maxlen){
					out<<numPStr.substr(firstDelim+1)<<"_"<<jointNum.second;
				}
				newNumStr=out.str();
				//cerr<<"numPStr: "<<numPStr<<"newNumStr: "<<newNumStr<<endl;

				//the fowlloing code update num string and its probability
				if(!mNum_New.contains(op,numP,NewNum(jointNum.second))){
					mNum_New.setProb(Num(newNumStr.c_str()),op,numP,NewNum(jointNum.second))=1.0;
				}
				//cout<<newNumStr<<" newNumStr + jointNum: "<<jointNum<<endl;
				//			if(!mNum_New.contains(op,numP)){
				//				mNum_New.setProb(Num(s.c_str()),op,numP)=1.0;
				//			}
				pr*=p = mNum_New.setIterProb(jointNum.first,op,numP,NewNum(jointNum.second),a);
				//cerr<<" jointNum when op is NEW and numP is Num_BOT "<<jointNum<<" op: "<<op<<" numP: "<<numP<<" P: "<<p<<endl;
				if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mNum_New "<<jointNum<<" "<<op<<" "<<ind<<" "<<numP<<"\n\n";
			}

		}else{

			//if op==OLD, then the size of numP should be idential to that of ind
			//we use ind to know which one should be replaced.
			//const string indStr = ind.getString();
			//Tokenize(indStr,indTokens,delimiters);
			pr=p=mNewNum_BOT.setIterProb(jointNum.second,a);
			int replace = 0;
			for(unsigned int i = 0; i < indTokens.size(); ++i ) {
				unsigned int intVal = atoi(indTokens[i].c_str());
				//	cout<<intVal<<" "<<endl;
				if(intVal!=i){
					replace = i;
					//cout<<replace<<endl;
					break;
				}
			}
			string swap = numPTokens.at(replace);
			vector<string>::iterator iter = numPTokens.begin();
			int count = 0;
			while( iter != numPTokens.end() )
			{
				if (*iter == numPTokens.at(replace) && count==replace){
					iter = numPTokens.erase( iter );
					break;
				}
				else{
					++iter;
				}
				count++;
			}
			numPTokens.push_back(swap);
			string newNumStr;

			//cout<<" genPTokens size: "<<genPTokens.size()<<endl;
			if(numPTokens.size()==1){
				newNumStr+=numPTokens.at(numPTokens.size()-1);
			}else{
				for(unsigned int i = 0; i < numPTokens.size()-1; ++i ) {
					newNumStr+=numPTokens.at(i)+delimiters;
				}
				newNumStr+=numPTokens.at(numPTokens.size()-1);
			}
			//			if(replace==0){
			//				cerr<<"replace: "<<replace<<" swap in numModel: "<<swap<<" numP: "<<numP<<endl;
			//cerr<<"ind: "<<ind<<"the curnum string: "<<newNumStr<<" numP: "<<numP<<endl;
			//			}
			//the fowlloing code update number string and its probability
			if(!mNum_Old.contains(op,numP,ind)){
				//cerr<<" newNumStr in contain methods: "<<newNumStr<<endl;
				mNum_Old.setProb(Num(newNumStr.c_str()),op,numP,ind)=1.0;
			}
			//mNum_Old.setProb(Num(newNumStr.c_str()),op,numP,NewNum(jointNum.second))=1.0;
			pr*=p=mNum_Old.setIterProb(jointNum.first,op,numP,ind,a);
			//cerr<<" jointNum.first: "<<jointNum.first<<endl;
			if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mNum_Old "<<jointNum.first<<" "<<op<<" "<<ind<<" "<<numP<<"\n\n";
		}

		// Report error...
		//if ( a<-1 && pr==LogProb() ) cerr<<"\nERROR: no condition mNum_full "<<" op: "<<op<<" numP: "<<numP<<"\n\n";
		// Iterate again if result doesn't match root observation...
		//if ( a>=-1 ) pr=LogProb();
		////cerr<<"    F "<<d<<" "<<fD<<" "<<qP<<" "<<qU<<" : "<<f<<" = "<<pr<<" ("<<a<<")\n";
		return pr;
	}
	friend pair<StringInput,NumModel*> operator>> ( StringInput si, NumModel& m) { return pair<StringInput,NumModel*>(si,&m); }
	friend StringInput operator>> ( pair<StringInput,NumModel*> si_m, const char* psD ) {
		StringInput si;
		return ( (si=si_m.first>>"Num " >>si_m.second->mNewNum >>psD)!=NULL ) ? si : StringInput(NULL);
	}
};
//const HidVarCPT1DModel<Num,LogProb> NumModel::mNum_start(Num_0);
HidVarCPT3DModel<Num,OP,Num,LogProb> NumModel::mNum_Copy;
//HidVarCPT4DModel<Num,OP,Num,NewNum,LogProb> NumModel::mNum_Old;
HidVarCPT4DModel<Num,OP,Num,Ind,LogProb> NumModel::mNum_Old;
HidVarCPT3DModel<Num,OP,Num,LogProb> NumModel::mNum_End;
HidVarCPT4DModel<Num,OP,Num,NewNum,LogProb> NumModel::mNum_New;
const HidVarCPT1DModel<Num,LogProb> NumModel::mNum_BOT(Num_BOT); //Fixed Num_ZERO model
const HidVarCPT1DModel<NewNum,LogProb> NumModel::mNewNum_BOT(NewNum_BOT); //Fixed Num_ZERO model

class SynModel{
private:
	static HidVarCPT3DModel<Syn,OP,Syn,LogProb> mSyn_Copy; //model when oper is COPY, then the probablity is 1
	//static HidVarCPT3DModel<Syn,OP,Syn,LogProb> mSyn_Old;
	static HidVarCPT3DModel<Syn,OP,Syn,LogProb> mSyn_End;
	//what is the meaning for the following cpt, it seems that NewSyn is useless.
	//static HidVarCPT4DModel<Syn,OP,Syn,NewSyn,LogProb> mSyn_New;
	static HidVarCPT4DModel<Syn,OP,Syn,NewSyn,LogProb> mSyn_New;
	static HidVarCPT4DModel<Syn,OP,Syn,NewSyn,LogProb> mSyn_Old;
	HidVarCPT2DModel<NewSyn,OP,LogProb> mNewSyn;
	RandAccCPT4DModel<NewSyn,OP,Loc,NewSyn,LogProb> mSyn_Dep;
	static const HidVarCPT1DModel<NewSyn,LogProb> mNewSyn_BOT; //Fixed Syn_ZERO model
	static const HidVarCPT1DModel<Syn,LogProb> mSyn_BOT; //Fixed Syn_ZERO model

public:
	LogProb setIterProb(JointSyn::ArrayIterator<LogProb>& jointSyn, const OP & op,  const Ind & ind, const Loc & reploc,const JointSyn & jointSynP, int& a) const {
		LogProb pr,p;
		vector<std::string> indTokens;
		vector<std::string> synPTokens;
		Syn synP = jointSynP.first;
		const string indStr = ind.getString();
		const string synPStr = synP.getString();
		Tokenize(indStr,indTokens,delimiters);
		Tokenize(synPStr,synPTokens,delimiters);

		//const string synPStr = synP.getString();
		//Tokenize(synPStr,synPTokens,delimiters);
		//string sentence = "Something_in_the_way_she_moves";
		//the following code works now. remember that the function is also a constant, then any function called here must be constant as well.
		//Tokenize(sentence,indTokens,delimiters);
		if(op==Op_BOT && synP!=Syn_BOT){
			pr=p=mNewSyn_BOT.setIterProb(jointSyn.second,a);
			if(!mSyn_End.contains(op,synP)){
				mSyn_End.setProb(Syn_BOT,op,synP)=1.0;
			}
			pr*=p=mSyn_End.setIterProb(jointSyn.first,op,synP,a);
		}
		else if(op==Op_COPY){
			if(synP==Syn_BOT){
				pr=p=mNewSyn_BOT.setIterProb(jointSyn.second,a);
				//cout<<" pr: "<<pr<<" jointSyn in synP==Syn_BOT and op is copy 1 "<<jointSyn<<" a: "<<a<<endl;
				pr*=p=mSyn_BOT.setIterProb(jointSyn.first,a);
				//cout<<" pr: "<<pr<<" jointSyn in synP==Syn_BOT and op is copy 2 "<<jointSyn<<" a: "<<a<<endl;
			}else{
				pr=p=mNewSyn_BOT.setIterProb(jointSyn.second,a);
				//cout<<" pr: "<<pr<<" jointSyn op is copy 1 "<<jointSyn<<" a: "<<a<<endl;
				if ( !mSyn_Copy.contains(op,synP)) mSyn_Copy.setProb(synP,op,synP)=1.0;
				pr *=p=mSyn_Copy.setIterProb(jointSyn.first,op,synP,a);
				//cout<<" pr: "<<pr<<" jointSyn op is copy 1 "<<jointSyn<<" a: "<<a<<endl;
				if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mSyn_Copy "<<jointSyn<<" "<<op<<" "<<ind<<" "<<synP<<" a: "<<a<<"\n\n";
			}
		}else if(op==Op_NEW){
			if(synP==Syn_BOT){
				pr=p=mNewSyn.setIterProb(jointSyn.second,op,a);
				//cerr<<" jointSyn when op is NEW and synP is Syn_BOT "<<jointSyn<<" op: "<<op<<" synP: "<<synP<<endl;
				if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mNewSyn in New and Syn_BOT "<<jointSyn<<" "<<op<<" "<<ind<<"\n\n";
				std::stringstream out;
				std::string newSynStr;
				out<<jointSyn.second;
				newSynStr=out.str();
				Syn syn = Syn(newSynStr.c_str());
				if(!mSyn_New.contains(op,synP,NewSyn(jointSyn.second))){
					mSyn_New.setProb(syn,op,synP,NewSyn(jointSyn.second))=1.0;
				}
				pr*=p=mSyn_New.setIterProb(jointSyn.first,op,synP,NewSyn(jointSyn.second),a);
				if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mSyn_New "<<jointSyn.first<<" "<<op<<"\n\n";
			}else{
				//const string indStr = ind.getString();
				//Tokenize(indStr,indTokens,delimiters);
				pr=p=mNewSyn.setIterProb(jointSyn.second,op,a);
				//cout<<" pr: "<<pr<<" jointSyn op is new 1 "<<jointSyn<<" a: "<<a<<endl;
				if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mNewSyn in other cases "<<jointSyn.second<<" "<<op<<" "<<ind<<"\n\n";
				std::stringstream out;
				std::string newSynStr;
				int firstDelim = synPStr.find_first_of(delimiters);
				if(synPTokens.size()<maxlen){
					out<<synPStr<<"_"<<jointSyn.second;
				}else if(synPTokens.size()==maxlen){
					out<<synPStr.substr(firstDelim+1)<<"_"<<jointSyn.second;
				}
				newSynStr=out.str();
				//cerr<<"synPStr: "<<synPStr<<"newSynStr: "<<newSynStr<<endl;
				//SynFromNewSyn(s);
				//Syn = new Syn(newSyn.getString(),synP.getString());
				//the fowlloing code update Synder string and its probability
				if(!mSyn_New.contains(op,synP,NewSyn(jointSyn.second))){
					mSyn_New.setProb(Syn(newSynStr.c_str()),op,synP,NewSyn(jointSyn.second))=1.0;
				}
				pr*=p = mSyn_New.setIterProb(jointSyn.first,op,synP,NewSyn(jointSyn.second),a);
				//cout<<" pr: "<<pr<<" jointSyn op is new 1 "<<jointSyn<<" a: "<<a<<endl;
				if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mSyn_New "<<jointSyn.first<<" "<<op<<" "<<ind<<" "<<synP<<"\n\n";
			}
		}else{
			//cerr<<"synPStr: "<<synPStr<<" indStr: "<<indStr<<endl;
			//if op==OLD, then the size of synP should be idential to that of ind
			//we use ind to know which one should be replaced.
			//const string indStr = ind.getString();
			//Tokenize(indStr,indTokens,delimiters);
			//pr=p=mNewSyn_BOT.setIterProb(jointSyn.second,a);

			//loop through the indmodel.txt to find the suitable input.
			//when synPTokens.size()==1, different from indModel which is determined by both size and location
			//So, we don't need to consider this special case.
			pr = p = mNewSyn.setIterProb(jointSyn.second,op,a);
			if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mNewSyn when in OLD"<<jointSyn.second<<" "<<op<<"\n\n";
			int replace = 0;
			//in fact, it seems that I don't need to bother doing the following since if I pass NewInd in, replace is known then.
			//I will try to change then.
			for(unsigned int i = 0; i < indTokens.size(); ++i ) {
				unsigned int intVal = atoi(indTokens[i].c_str());
				//cerr<<"intVal for i: "<<intVal<<" "<<endl;
				if(intVal!=i){
					replace = i;
					//cerr<<"replace: "<<replace<<endl;
					break;
				}
			}
			string swap = synPTokens.at(replace);
			//cerr<<"swap: "<<swap<<endl;
			//the following code is wrong since it says that as long as iter is
			//equal to synPTokens.at(replace), it will be erased
			//then in example as synP: A_P_P_SUBJ_A_P and replace = 4, so, swap=A
			//then the first A will be replaced and curSyn will be P_P_SUBJ_A_P_CC (NewSyn=CC)
			//this is wrong, the correct should be A_P_P_SUBJ_P_CC
			vector<string>::iterator iter = synPTokens.begin();
			int count = 0;
			while( iter != synPTokens.end() )
			{
				if (*iter == synPTokens.at(replace) && count ==replace){
					iter = synPTokens.erase( iter );
					break;
				}
				else{
					++iter;
				}
				count++;
			}

			std::stringstream outOld;
			std::string newSynStrOld;
			outOld<<jointSyn.second;
			newSynStrOld=outOld.str();
			//synPTokens.push_back(swap);
			synPTokens.push_back(newSynStrOld);
			string newSynStr;
			//c++ cannot print array directly
			//cerr<<"synPTokens: "<<synPTokens<<" synPTokens size: "<<synPTokens.size()<<endl;
			if(synPTokens.size()==1){
				newSynStr+=synPTokens.at(synPTokens.size()-1);
			}else{
				for(unsigned int i = 0; i < synPTokens.size()-1; ++i ) {
					newSynStr+=synPTokens.at(i)+delimiters;
				}
				newSynStr+=synPTokens.at(synPTokens.size()-1);
			}
			//cerr<<"ind: "<<ind<<" the curSyn string: "<<newSynStr<<" synP: "<<synP<<endl;
			//the fowlloing code update Synder string and its probability
			if(!mSyn_Old.contains(op,synP,NewSyn(jointSyn.second))){
				//cerr<<" new SynStr: "<<newSynStr<<endl;
				if(mSyn_Dep.contains(NewSyn(jointSyn.second),op,reploc,NewSyn(swap.c_str()))){
					mSyn_Old.setProb(Syn(newSynStr.c_str()),op,synP,NewSyn(jointSyn.second))=mSyn_Dep.getProb(NewSyn(jointSyn.second),op,reploc,NewSyn(swap.c_str()));
				}else{
					mSyn_Old.setProb(Syn(newSynStr.c_str()),op,synP,NewSyn(jointSyn.second))=LogProb(0.000001);
				}

			}


			pr*=p=mSyn_Old.setIterProb(jointSyn.first,op,synP,NewSyn(jointSyn.second),a);
			if ( a<-1 && p==LogProb() ) cerr<<"\nERROR: no condition mSyn_Old "<<jointSyn.first<<" "<<op<<" "<<ind<<" "<<synP<<"\n\n";
		}

		// Report error...
		//if ( a<-1 && pr==LogProb() ) cerr<<"\nERROR: no condition mSyn_full "<<" op: "<<op<<" synP: "<<synP<<"\n\n";
		// Iterate again if result doesn't match root observation...
		//if ( a>=-1 ) pr=LogProb();
		////cerr<<"    F "<<d<<" "<<fD<<" "<<qP<<" "<<qU<<" : "<<f<<" = "<<pr<<" ("<<a<<")\n";
		return pr;
	}
	friend pair<StringInput,SynModel*> operator>> ( StringInput si, SynModel& m) { return pair<StringInput,SynModel*>(si,&m); }
	friend StringInput operator>> ( pair<StringInput,SynModel*> si_m, const char* psD ) {
		StringInput si;
		return ( (si=si_m.first>>"Syn " >>si_m.second->mNewSyn >>psD)!=NULL ||
				(si=si_m.first>>"SynDep " >>si_m.second->mSyn_Dep >>psD)!=NULL ) ? si : StringInput(NULL);
	}
};
//const HidVarCPT1DModel<Syn,LogProb> SynModel::mSyn_start(Syn_0);
HidVarCPT3DModel<Syn,OP,Syn,LogProb> SynModel::mSyn_Copy;
HidVarCPT4DModel<Syn,OP,Syn,NewSyn,LogProb> SynModel::mSyn_Old;
HidVarCPT3DModel<Syn,OP,Syn,LogProb> SynModel::mSyn_End;
HidVarCPT4DModel<Syn,OP,Syn,NewSyn,LogProb> SynModel::mSyn_New;
const HidVarCPT1DModel<Syn,LogProb> SynModel::mSyn_BOT(Syn_BOT); //Fixed Syn_ZERO model
const HidVarCPT1DModel<NewSyn,LogProb> SynModel::mNewSyn_BOT(NewSyn_BOT); //Fixed Syn_ZERO model


class PosModel{
private:
	//static HidVarCPT3DModel<Pos,OP,Pos,LogProb> mPos_Copy;
	HidVarCPT3DModel<Pos,OP,Pos,LogProb> mPos_full;
	//	static const HidVarCPT1DModel<Pos,LogProb> mPos_BOT; //Fixed Pos_ZERO model
public:
	LogProb setIterProb(Pos::ArrayIterator<LogProb>& pos, const OP & op, const Pos & posP,int& a) const {
		LogProb pr,p;
		//		if(posP==Pos_BOT){
		//			pr=p=mPos_BOT.setIterProb(pos,a);
		//
		//		}else{
		pr=p = mPos_full.setIterProb(pos,op,posP,a);
		//cerr<<"posP: "<<posP<<" pos: "<<pos<<" pr: "<<pr<<endl;
		//		}
		// Report error...
		if ( a<-1 && pr==LogProb() ) cerr<<"\nERROR: no condition mPos_full "<<" pos: "<<Pos(pos)<<" posP: "<<posP<<" op: "<<op<<"\n\n";
		// Iterate again if result doesn't match root observation...
		//if ( a>=-1 ) pr=LogProb();
		////cerr<<"    F "<<d<<" "<<fD<<" "<<qP<<" "<<qU<<" : "<<f<<" = "<<pr<<" ("<<a<<")\n";
		return pr;
	}
	friend pair<StringInput,PosModel*> operator>> ( StringInput si, PosModel& m) { return pair<StringInput,PosModel*>(si,&m); }
	friend StringInput operator>> ( pair<StringInput,PosModel*> si_m, const char* psD ) {
		StringInput si;
		return ( (si=si_m.first>>"Pos " >>si_m.second->mPos_full >>psD)!=NULL ) ? si : StringInput(NULL);
	}
} ;
//HidVarCPT3DModel<Pos,OP, Pos,LogProb> PosModel::mPos_Copy;
//const HidVarCPT1DModel<Pos,LogProb> PosModel::mPos_BOT(Pos_BOT); //Fixed Pos_ZERO model

//////Model of Cr 
class CrModel :public QuadrupleFactoredModel<IndModel,GenModel,NumModel,SynModel>{
private:
	static const HidVarCPT1DModel<Ind,LogProb>   mInd_BOT;
	static const HidVarCPT1DModel<Gen,LogProb>   mGen_BOT;
	static const HidVarCPT1DModel<Num,LogProb>   mNum_BOT;
	static const HidVarCPT1DModel<Syn,LogProb>   mSyn_BOT;

public:
	LogProb setIterProb ( CR::ArrayIterator<LogProb>& cr, const OP & op, const CR& crP, int& a ) const {
		const IndModel& mInd = getM1();
		const GenModel& mGen = getM2();
		const NumModel& mNum = getM3();
		const SynModel& mSyn = getM4();
		LogProb pr;
		pr  = mInd.setIterProb ( cr.first, op, crP.first, a) ;
		//pr = (crP.first.first == Ind_BOT && op == Op_COPY)? 
		//mInd_BOT.setIterProb(cr.first.first,a): mInd.setIterProb (cr.first, op, crP.first, a );
		//if ( LogProb()==pr ) return pr;
		CR().setVal(cr);
		JointInd().setVal(cr.first);
		pr *= mGen.setIterProb(cr.second, op, Ind(cr.first.first), crP.second,a);
		pr *= mNum.setIterProb(cr.third, op, Ind(cr.first.first), crP.third,a);
		pr *= mSyn.setIterProb(cr.fourth, op,Ind(cr.first.first),Loc(cr.first.second), crP.fourth,a);
		return pr;
	}
};
const HidVarCPT1DModel<Ind,LogProb> CrModel::mInd_BOT(Ind_BOT);
const HidVarCPT1DModel<Gen,LogProb> CrModel::mGen_BOT(Gen_BOT);
const HidVarCPT1DModel<Num,LogProb> CrModel::mNum_BOT(Num_BOT);
const HidVarCPT1DModel<Syn,LogProb> CrModel::mSyn_BOT(Syn_BOT);


//class RModel{
//	LogProb setIterProb( R::ArrayIterator < LogProb > & r, const R rP, int & a){
//		const FModel& mF = getM1();
//		LogProb pr;
//		return pr;
//		}
//};


class SModel:public TripleFactoredModel<OpModel,CrModel,PosModel>{

public:
	LogProb setIterProb ( S::ArrayIterator<LogProb>& s, const S& sP, int& a ) const {
		const OpModel& mOp = getM1();
		const CrModel& mCr = getM2();
		const PosModel& mPos = getM3();
		LogProb pr;
		int old_a = a;
		//cerr<<" a starts in SModel:"<<a<<endl;
		pr = mOp.setIterProb ( s.first, sP.first, sP.second.second, a );
		if(((old_a-a) != 1)) cerr << "ERROR: a has wrong value in mOP!"<<a<<" a-old_a: "<<old_a-a<<endl;
		old_a = a;
		//the following works since s.first returns a DilimitedJoint2DRV CR which is composed of
		//Ind and Syn. That is right what CRModel's setIterProb is looking for
		//pr = (sP.first != Op_BOT)? mOp.setIterProb ( s.first, sP.first, sP.second.first, sP.second.second, a )
		//:mOp_BOT.setIterProb(s.first,a);
		pr *= mCr.setIterProb ( s.second.first, OP(s.first), CR(sP.second.first), a );
		if(!((old_a-a) == 8)) cerr << "ERROR: a has wrong value in mCR!"<<a<<" a-old_a: "<<old_a-a<<endl;
		old_a = a;
		//if ( LogProb()==pr ) return pr;
		//cout<<"pr, before mPos if op is copy, should be the same, right????????????????????? :"<<pr<<endl;
		pr *= mPos.setIterProb ( s.second.second,OP(s.first), Pos(sP.second.second),  a );
		if(!((old_a-a)== 1)) cerr << "ERROR: a has wrong value in mPos!"<<a<<" a-old_a: "<<old_a-a<<endl;
		old_a = a;
		//cout<<"pr at the end of Smodel "<<pr<<endl;
		return pr;
	}
};


//
//
////////////////////// Overall...
//
////// Model of H=R,S given S
class HModel : public SingleFactoredModel<SModel> {
public:
	static W WORD;
	typedef H::ArrayIterator<LogProb> IterVal;
	S& setTrellDat (S& s, const H::ArrayIterator<LogProb>& h ) const {
		//h.setVal(h.second);
		s.setVal(h);
		return s;
	}
	S setBackDat ( const H::ArrayIterator<LogProb>& h ) const {
		//R r;
		S s;
		//for(int i=0;i<4;i++)
		//r.set(i)=F(h.first.get(i));
		s.setVal(h);
		return s;
	}
	LogProb setIterProb ( H::ArrayIterator<LogProb>& h, const S & sP, int& a ) const {
		//const RModel& mR = getM1();
		const SModel& mS = getM1();
		LogProb pr;
		//pr  = mR.setIterProb ( h.first, sP, a );
		//pr  = mR.setIterProb ( h.first, sP, a );
		//if ( LogProb()==pr ) return pr;
		pr = mS.setIterProb (h,sP, a );
		//cout << " h = " << h<<" sP: "<< sP <<" pr: "<<pr<< " and a ends in HModel = " << a << endl;
		return pr;
	}
	void update ( ) const { }
};
W     HModel::WORD;

