/*
 * Decompiled with CFR 0.152.
 */
package main.phrases;

import babel.content.eqclasses.phrases.Phrase;
import babel.content.eqclasses.phrases.PhrasePair;
import babel.content.eqclasses.phrases.PhraseTable;
import babel.ranking.scorers.Scorer;
import babel.util.dict.SimpleDictionary;
import babel.util.misc.EditDistance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FeatureEstimator {
    protected static final Log LOG = LogFactory.getLog(FeatureEstimator.class);
    protected static final int NUM_PAIRS_TO_GIVE = 1000;
    protected static final int PERCENT_REPORT = 5;
    protected PhraseTable m_phraseTable;
    protected HashMap<String, Phrase> m_srcToks;
    protected HashMap<String, Phrase> m_trgToks;
    protected Scorer m_contextScorer;
    protected Scorer m_timeScorer;
    protected SimpleDictionary m_translitDict;
    protected boolean m_collectPhraseFeats;
    protected boolean m_collectLexFeats;
    protected int m_numThreads;
    protected List<Integer> m_workerIds;
    protected LinkedList<PhrasePair> m_phrasePairsToProcess;
    protected int m_percentComplete;
    protected int m_percentThreshold;
    protected double m_completePairs;
    protected double m_totalPairs;

    protected FeatureEstimator(int numThreads, Scorer contextScorer, Scorer timeScorer, SimpleDictionary translitDict, boolean collectPhraseFeats, boolean collectLexFeats) {
        if (numThreads < 1) {
            throw new IllegalArgumentException("Must request at least one thread");
        }
        this.m_numThreads = numThreads;
        this.m_contextScorer = contextScorer;
        this.m_timeScorer = timeScorer;
        this.m_translitDict = translitDict;
        this.m_collectPhraseFeats = collectPhraseFeats;
        this.m_collectLexFeats = collectLexFeats;
        this.m_workerIds = new ArrayList<Integer>(this.m_numThreads);
        this.m_phrasePairsToProcess = new LinkedList();
        this.m_srcToks = new HashMap();
        this.m_trgToks = new HashMap();
    }

    public FeatureEstimator(PhraseTable phraseTable, int numThreads, Scorer contextScorer, Scorer timeScorer, SimpleDictionary translitDict, boolean collectPhraseFeats, boolean collectLexFeats) {
        this(numThreads, contextScorer, timeScorer, translitDict, collectPhraseFeats, collectLexFeats);
        this.m_phraseTable = phraseTable;
        if (collectLexFeats) {
            for (Phrase srcPhrase : phraseTable.getAllSrcPhrases()) {
                if (srcPhrase.numTokens() != 1) continue;
                this.m_srcToks.put(srcPhrase.toString(), srcPhrase);
            }
            for (Phrase trgPhrase : phraseTable.getAllTrgPhrases()) {
                if (trgPhrase.numTokens() != 1) continue;
                this.m_trgToks.put(trgPhrase.toString(), trgPhrase);
            }
        }
    }

    public FeatureEstimator(PhraseTable phraseTable, Set<Phrase> srcSingleTokenPhrases, Set<Phrase> trgSingleTokenPhrases, int numThreads, Scorer contextScorer, Scorer timeScorer, SimpleDictionary translitDict, boolean collectPhraseFeats, boolean collectLexFeats) {
        this(numThreads, contextScorer, timeScorer, translitDict, collectPhraseFeats, collectLexFeats);
        this.m_phraseTable = phraseTable;
        if (collectLexFeats) {
            for (Phrase srcPhrase : srcSingleTokenPhrases) {
                this.m_srcToks.put(srcPhrase.toString(), srcPhrase);
            }
            for (Phrase trgPhrase : trgSingleTokenPhrases) {
                this.m_trgToks.put(trgPhrase.toString(), trgPhrase);
            }
        }
    }

    public synchronized void estimateFeatures(Set<Phrase> srcPhrases) throws Exception {
        this.m_workerIds.clear();
        this.m_percentComplete = 0;
        this.m_completePairs = 0.0;
        this.m_percentThreshold = 5;
        this.m_phrasePairsToProcess.clear();
        for (Phrase srcPhrase : srcPhrases) {
            for (Phrase trgPhrase : this.m_phraseTable.getTrgPhrases(srcPhrase)) {
                this.m_phrasePairsToProcess.add(new PhrasePair(srcPhrase, trgPhrase));
            }
        }
        this.m_totalPairs = this.m_phrasePairsToProcess.size();
        LOG.info((Object)(" - Estimating monolingual features for " + (int)this.m_totalPairs + " phrase pairs."));
        int threadNum = 0;
        while (threadNum < this.m_numThreads) {
            this.m_workerIds.add(threadNum);
            new Thread(new FeatureWorker(this, this.m_collectPhraseFeats, this.m_collectLexFeats, threadNum)).start();
            ++threadNum;
        }
        while (this.m_workerIds.size() > 0) {
            this.wait();
        }
    }

    protected synchronized List<PhrasePair> getPhrasePairsToProcess() {
        ArrayList<PhrasePair> pairsToProcess = null;
        if (this.m_phrasePairsToProcess.size() > 0) {
            pairsToProcess = new ArrayList<PhrasePair>(1000);
            int i = 0;
            while (this.m_phrasePairsToProcess.size() > 0 && i < 1000) {
                pairsToProcess.add(this.m_phrasePairsToProcess.remove());
                ++i;
            }
        }
        return pairsToProcess;
    }

    protected synchronized void estimationDone(int numComplete) {
        this.m_completePairs += (double)numComplete;
        this.m_percentComplete = (int)(100.0 * this.m_completePairs / this.m_totalPairs);
        if (this.m_percentComplete >= this.m_percentThreshold) {
            LOG.info((Object)(" - " + this.m_percentComplete + "% done."));
            this.m_percentThreshold += 5;
        }
    }

    protected synchronized void workerDone(int workerID) {
        this.m_workerIds.remove(new Integer(workerID));
        this.notify();
    }

    protected void estimateFeatures(Phrase srcPhrase, Phrase trgPhrase, boolean collectPhraseFeats, boolean collectLexFeats) {
        PhraseTable.PairProps props = this.m_phraseTable.getProps(srcPhrase, trgPhrase);
        if (collectPhraseFeats) {
            props.setPairFeatVal(PhraseTable.PairFeat.PH_CONTEXT, this.m_contextScorer.score(srcPhrase, trgPhrase));
            props.setPairFeatVal(PhraseTable.PairFeat.PH_TIME, this.m_timeScorer.score(srcPhrase, trgPhrase));
        }
        if (collectLexFeats) {
            double[] scores = this.scoreAverage(srcPhrase, trgPhrase, props, new Scorer[]{this.m_contextScorer, this.m_timeScorer});
            props.setPairFeatVal(PhraseTable.PairFeat.LEX_CONTEXT, scores[0]);
            props.setPairFeatVal(PhraseTable.PairFeat.LEX_TIME, scores[1]);
            props.setPairFeatVal(PhraseTable.PairFeat.LEX_EDIT, this.scoreEdit(srcPhrase, trgPhrase, props, this.m_translitDict));
        }
    }

    protected double scoreEdit(Phrase srcPhrase, Phrase trgPhrase, PhraseTable.PairProps props, SimpleDictionary translitDict) {
        int j;
        String[] srcWords = srcPhrase.getWord().split(" ");
        String[] trgWords = trgPhrase.getWord().split(" ");
        if (translitDict != null) {
            this.translitWords(srcWords, translitDict);
        }
        double letterCount = 0.0;
        double numEdits = 0.0;
        double unAlignedSrcLetters = 0.0;
        double unAlignedTrgLetters = 0.0;
        int[][] aligns = props.getForwardAligns();
        int i = 0;
        while (i < aligns.length) {
            if (aligns[i] != null) {
                j = 0;
                while (j < aligns[i].length) {
                    numEdits += (double)EditDistance.distance(srcWords[i], trgWords[aligns[i][j]]);
                    letterCount += (double)(srcWords[i].length() + trgWords[aligns[i][j]].length()) / 2.0;
                    ++j;
                }
            } else {
                unAlignedSrcLetters += (double)srcWords[i].length();
            }
            ++i;
        }
        aligns = props.getBackwardAligns();
        i = 0;
        while (i < aligns.length) {
            if (aligns[i] != null) {
                j = 0;
                while (j < aligns[i].length) {
                    numEdits += (double)EditDistance.distance(trgWords[i], srcWords[aligns[i][j]]);
                    letterCount += (double)(trgWords[i].length() + srcWords[aligns[i][j]].length()) / 2.0;
                    ++j;
                }
            } else {
                unAlignedTrgLetters += (double)trgWords[i].length();
            }
            ++i;
        }
        return (numEdits += Math.max(unAlignedSrcLetters, unAlignedTrgLetters)) / (letterCount += (unAlignedSrcLetters + unAlignedTrgLetters) / 2.0);
    }

    protected void translitWords(String[] words, SimpleDictionary translitDict) {
        int i = 0;
        while (i < words.length) {
            Set<String> translits = translitDict.getTrg(words[i]);
            if (translits != null) {
                words[i] = translits.iterator().next();
            }
            ++i;
        }
    }

    protected double[] scoreAverage(Phrase srcPhrase, Phrase trgPhrase, PhraseTable.PairProps props, Scorer[] scorers) {
        int s;
        Phrase trgTok;
        int j;
        Phrase srcTok;
        String[] srcWords = srcPhrase.getWord().split(" ");
        String[] trgWords = trgPhrase.getWord().split(" ");
        double numAligns = 0.0;
        double[] scores = new double[scorers.length];
        double alignedToks = 0.0;
        int[][] aligns = props.getForwardAligns();
        int i = 0;
        while (i < aligns.length) {
            if (aligns[i] != null) {
                alignedToks += 1.0;
            }
            if ((srcTok = this.m_srcToks.get(srcWords[i])) != null && aligns[i] != null) {
                j = 0;
                while (j < aligns[i].length) {
                    trgTok = this.m_trgToks.get(trgWords[aligns[i][j]]);
                    if (trgTok != null) {
                        s = 0;
                        while (s < scorers.length) {
                            int n = s;
                            scores[n] = scores[n] + scorers[s].score(srcTok, trgTok);
                            ++s;
                        }
                        numAligns += 1.0;
                    }
                    ++j;
                }
            }
            ++i;
        }
        aligns = props.getBackwardAligns();
        i = 0;
        while (i < aligns.length) {
            if (aligns[i] != null) {
                alignedToks += 1.0;
            }
            if ((trgTok = this.m_trgToks.get(trgWords[i])) != null && aligns[i] != null) {
                j = 0;
                while (j < aligns[i].length) {
                    srcTok = this.m_srcToks.get(srcWords[aligns[i][j]]);
                    if (srcTok != null) {
                        s = 0;
                        while (s < scorers.length) {
                            int n = s;
                            scores[n] = scores[n] + scorers[s].score(trgTok, srcTok);
                            ++s;
                        }
                        numAligns += 1.0;
                    }
                    ++j;
                }
            }
            ++i;
        }
        double penalty = alignedToks / (double)(srcWords.length + trgWords.length);
        s = 0;
        while (s < scorers.length) {
            int n = s;
            scores[n] = scores[n] / numAligns;
            int n2 = s++;
            scores[n2] = scores[n2] * penalty;
        }
        return scores;
    }

    class FeatureWorker
    implements Runnable {
        protected int m_workerId;
        protected FeatureEstimator m_estimator;
        protected boolean m_collectPhraseFeats;
        protected boolean m_collectLexFeats;

        public FeatureWorker(FeatureEstimator estimator, boolean collectPhraseFeats, boolean collectLexFeats, int workerId) {
            this.m_workerId = workerId;
            this.m_estimator = estimator;
            this.m_collectPhraseFeats = collectPhraseFeats;
            this.m_collectLexFeats = collectLexFeats;
        }

        @Override
        public void run() {
            List<PhrasePair> phrasePairs;
            LOG.info((Object)(" - Worker " + this.m_workerId + " started estimating monolingual features."));
            while ((phrasePairs = this.m_estimator.getPhrasePairsToProcess()) != null) {
                for (PhrasePair pair : phrasePairs) {
                    this.m_estimator.estimateFeatures(pair.srcPhrase(), pair.trgPhrase(), this.m_collectPhraseFeats, this.m_collectLexFeats);
                }
                this.m_estimator.estimationDone(phrasePairs.size());
            }
            LOG.info((Object)(" - Worker " + this.m_workerId + " finished."));
            this.m_estimator.workerDone(this.m_workerId);
        }
    }
}

