/*
 * Decompiled with CFR 0.152.
 */
package babel.reordering.scorers;

import babel.content.eqclasses.phrases.Phrase;
import babel.content.eqclasses.phrases.PhraseTable;
import babel.content.eqclasses.properties.order.PhraseContext;
import babel.reordering.scorers.ReorderingScorer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MonoScorer
extends ReorderingScorer {
    protected static final Log LOG = LogFactory.getLog(MonoScorer.class);
    protected PhraseTable m_phraseTable;

    public MonoScorer(PhraseTable phraseTable) {
        this.m_phraseTable = phraseTable;
    }

    @Override
    public ReorderingScorer.OrderTriple scoreBefore(Phrase srcPhrase, Phrase trgPhrase) {
        PhraseContext srcPhraseContext = (PhraseContext)srcPhrase.getProperty(PhraseContext.class.getName());
        PhraseContext trgPhraseContext = (PhraseContext)trgPhrase.getProperty(PhraseContext.class.getName());
        if (srcPhraseContext == null || trgPhraseContext == null) {
            return null;
        }
        int logCount = 0;
        Map<Phrase, Integer> beforeSrcPhrases = srcPhraseContext.getBefore();
        double numBeforeMono = 0.0;
        double numBeforeSwap = 0.0;
        double numBeforeOutOfOrder = 0.0;
        int count = 0;
        for (Phrase beforeSrcPhrase : beforeSrcPhrases.keySet()) {
            if (count++ >= 1000) break;
            for (Phrase transTrgPhrase : this.m_phraseTable.getTrgPhrases(beforeSrcPhrase)) {
                if (!trgPhraseContext.hasAnywhere(transTrgPhrase)) continue;
                double weight = 1.0;
                double numMono = trgPhraseContext.beforeCount(transTrgPhrase);
                numBeforeMono += weight * numMono;
                double numSwap = trgPhraseContext.afterCount(transTrgPhrase);
                numBeforeSwap += weight * numSwap;
                double numDiscont = trgPhraseContext.outOfOrderCount(transTrgPhrase);
                numBeforeOutOfOrder += weight * numDiscont;
                if (logCount <= 0) continue;
                StringBuilder strBldLog = new StringBuilder();
                if (numMono > 0.0) {
                    strBldLog.append("Mono (" + numMono + ") : ");
                } else if (numSwap > 0.0) {
                    strBldLog.append("Swap (" + numSwap + ") : ");
                } else {
                    strBldLog.append("Discontinuous (" + numDiscont + ") : ");
                }
                strBldLog.append(" phrase pair: (" + srcPhrase.toString() + "|" + trgPhrase.toString() + ")");
                strBldLog.append(", context phrase translations: (" + beforeSrcPhrase.toString() + "->" + transTrgPhrase.toString() + ")");
                strBldLog.append(", phrase table weight: " + weight);
                LOG.info((Object)strBldLog.toString());
                --logCount;
            }
        }
        double totalBefore = numBeforeMono + numBeforeSwap + numBeforeOutOfOrder;
        return totalBefore == 0.0 ? null : new ReorderingScorer.OrderTriple(numBeforeMono / totalBefore, numBeforeSwap / totalBefore, numBeforeOutOfOrder / totalBefore);
    }

    @Override
    public ReorderingScorer.OrderTriple scoreAfter(Phrase srcPhrase, Phrase trgPhrase) {
        PhraseContext srcPhraseContext = (PhraseContext)srcPhrase.getProperty(PhraseContext.class.getName());
        PhraseContext trgPhraseContext = (PhraseContext)trgPhrase.getProperty(PhraseContext.class.getName());
        if (srcPhraseContext == null || trgPhraseContext == null) {
            return null;
        }
        int logCount = 0;
        Map<Phrase, Integer> afterSrcPhrases = srcPhraseContext.getAfter();
        double numAfterMono = 0.0;
        double numAfterSwap = 0.0;
        double numAfterOutOfOrder = 0.0;
        int count = 0;
        for (Phrase afterSrcPhrase : afterSrcPhrases.keySet()) {
            if (count++ >= 1000) break;
            for (Phrase transTrgPhrase : this.m_phraseTable.getTrgPhrases(afterSrcPhrase)) {
                if (!trgPhraseContext.hasAnywhere(transTrgPhrase)) continue;
                double weight = 1.0;
                double numMono = trgPhraseContext.afterCount(transTrgPhrase);
                numAfterMono += weight * numMono;
                double numSwap = trgPhraseContext.beforeCount(transTrgPhrase);
                numAfterSwap += weight * numSwap;
                double numDiscont = trgPhraseContext.outOfOrderCount(transTrgPhrase);
                numAfterOutOfOrder += weight * numDiscont;
                if (logCount <= 0) continue;
                StringBuilder strBldLog = new StringBuilder();
                if (numMono > 0.0) {
                    strBldLog.append("Mono (" + numMono + ") : ");
                } else if (numSwap > 0.0) {
                    strBldLog.append("Swap (" + numSwap + ") : ");
                } else {
                    strBldLog.append("Discontinuous (" + numDiscont + ") : ");
                }
                strBldLog.append(" phrase pair: (" + srcPhrase.toString() + "|" + trgPhrase.toString() + ")");
                strBldLog.append(", context phrase translations: (" + afterSrcPhrase.toString() + "->" + transTrgPhrase.toString() + ")");
                strBldLog.append(", phrase table weight: " + weight);
                LOG.info((Object)strBldLog.toString());
                --logCount;
            }
        }
        double totalAfter = numAfterMono + numAfterSwap + numAfterOutOfOrder;
        return totalAfter == 0.0 ? null : new ReorderingScorer.OrderTriple(numAfterMono / totalAfter, numAfterSwap / totalAfter, numAfterOutOfOrder / totalAfter);
    }
}

