/*
 * Decompiled with CFR 0.152.
 */
package babel.ranking.scorers.lsh;

import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.properties.LSHProperty;
import babel.ranking.scorers.Scorer;
import babel.util.jerboa.LSH;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LSHScorer
extends Scorer {
    protected static final Log LOG = LogFactory.getLog(LSHScorer.class);
    protected Class<? extends LSHProperty> m_propClass;

    public LSHScorer(Class<? extends LSHProperty> propClass) {
        this.m_propClass = propClass;
    }

    @Override
    public double score(EquivalenceClass srcEq, EquivalenceClass trgEq) {
        LSHProperty srcProp = (LSHProperty)srcEq.getProperty(this.m_propClass.getName());
        LSHProperty trgProp = (LSHProperty)trgEq.getProperty(this.m_propClass.getName());
        if (srcProp == null || trgProp == null) {
            throw new IllegalArgumentException("At least one of the classes has no property " + this.m_propClass.getName() + ".");
        }
        return Math.max(0.0, LSH.scoreSignatures(srcProp.getSignature(), trgProp.getSignature()));
    }

    @Override
    public void prepare(EquivalenceClass eq) {
    }

    @Override
    public boolean smallerScoresAreBetter() {
        return false;
    }
}

