/*
 * Decompiled with CFR 0.152.
 */
package babel.prep.corpus;

import babel.content.pages.Page;
import babel.prep.corpus.CorpusGenerator;
import babel.util.language.Language;
import babel.util.persistence.XMLObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.MultipleOutputFormat;
import org.apache.hadoop.util.Progressable;

class MultipleXMLLangFileOutputFormat
extends MultipleOutputFormat<Text, Page> {
    static final Log LOG = LogFactory.getLog(MultipleXMLLangFileOutputFormat.class);

    MultipleXMLLangFileOutputFormat() {
    }

    protected String generateFileNameForKeyValue(Text key, Page page, String name) {
        String strLang;
        Language lang = page.getLanguage();
        String string = strLang = lang == null ? "none" : lang.toString();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Language " + strLang + " for page " + page.pageURL()));
        }
        CorpusGenerator.Stats.incLangPageCount(strLang);
        return String.valueOf(strLang) + "." + super.generateFileNameForKeyValue((Object)key, (Object)page, name);
    }

    public RecordWriter<Text, Page> getBaseRecordWriter(FileSystem fs, JobConf job, String name, Progressable progress) throws IOException {
        XMLObjectWriter xmlWriter;
        Path dumpFile = new Path(FileOutputFormat.getOutputPath((JobConf)job), name);
        if (fs.exists(dumpFile)) {
            fs.delete(dumpFile, true);
        }
        try {
            xmlWriter = new XMLObjectWriter((OutputStream)fs.create(dumpFile), false);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate XMLObjectWriter.");
        }
        return new RecordWriter<Text, Page>(){

            public synchronized void write(Text key, Page page) throws IOException {
                try {
                    xmlWriter.write(page);
                }
                catch (XMLStreamException e) {
                    throw new RuntimeException("Error writing page XML.");
                }
            }

            public synchronized void close(Reporter reporter) throws IOException {
                try {
                    xmlWriter.close();
                }
                catch (XMLStreamException e) {
                    throw new RuntimeException("Error closing XMLObjectWriter.");
                }
            }
        };
    }
}

