/*
 * Decompiled with CFR 0.152.
 */
package babel.prep.corpus;

import babel.content.pages.Page;
import babel.prep.PrepStep;
import babel.prep.corpus.CorpusGenMapper;
import babel.prep.corpus.MultipleLangFileOutputFormat;
import babel.prep.corpus.MultipleXMLLangFileOutputFormat;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileInputFormat;

public class CorpusGenerator
extends PrepStep {
    protected static final Log LOG = LogFactory.getLog(CorpusGenerator.class);
    public static final String PARAM_XML = "xml";
    protected static final String CORPUS_SUBDIR = "corpus";

    protected JobConf createJobConf(String crawlDir, String pagesSubDir, boolean xmlOut) throws IOException {
        JobConf job = new JobConf(this.getConf());
        job.setJobName("create " + (xmlOut ? "xml formatted" : "") + " dataset from " + pagesSubDir);
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(CorpusGenMapper.class);
        job.setOutputFormat(xmlOut ? MultipleXMLLangFileOutputFormat.class : MultipleLangFileOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Page.class);
        FileInputFormat.addInputPath((JobConf)job, (Path)new Path(crawlDir, pagesSubDir));
        Path outDir = new Path(new Path(crawlDir, CORPUS_SUBDIR), "corpus." + (xmlOut ? "xml." : "") + this.getCurTimeStamp());
        this.m_fs.delete(outDir, true);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outDir);
        this.setUniqueTempDir(job);
        return job;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2 || args.length > 3) {
            CorpusGenerator.usage();
            return;
        }
        CorpusGenerator gen = new CorpusGenerator();
        JobConf job = gen.createJobConf(args[0], args[1], args.length == 3 && PARAM_XML.equals(args[2]));
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("DatedCorpusGenerator: " + job.getJobName()));
        }
        gen.runPrepStep(job);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(String.valueOf(Stats.dumpStats()) + "\n"));
            LOG.info((Object)("Output: " + FileOutputFormat.getOutputPath((JobConf)job)));
            LOG.info((Object)"DatedCorpusGenerator: done");
        }
    }

    protected static void usage() {
        System.err.println("Usage: DatedCorpusGenerator crawl_dir pages_subdir [xml]\n");
    }

    static class Stats {
        private static HashMap<String, Integer> langCounts = new HashMap();

        Stats() {
        }

        public static synchronized void incLangPageCount(String lang) {
            int curCount = langCounts.containsKey(lang) ? langCounts.get(lang) + 1 : 1;
            langCounts.put(lang, curCount);
        }

        public static String dumpStats() {
            StringBuilder strBld = new StringBuilder();
            int totalCount = 0;
            for (String lang : langCounts.keySet()) {
                int count = langCounts.get(lang);
                strBld.append(String.valueOf(lang) + " : " + count + "\n");
                totalCount += count;
            }
            strBld.append("Total = " + totalCount);
            return strBld.toString();
        }
    }
}

