/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses.filters;

import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.filters.EquivalenceClassFilter;
import java.util.HashSet;
import java.util.Set;

public class StopWordsFilter
implements EquivalenceClassFilter {
    protected Set<String> m_stopWords = new HashSet<String>();

    public StopWordsFilter(Set<? extends EquivalenceClass> stopEqs) {
        for (EquivalenceClass equivalenceClass : stopEqs) {
            for (String word : equivalenceClass.getAllWords()) {
                this.m_stopWords.add(word);
            }
        }
    }

    @Override
    public boolean acceptEquivalenceClass(EquivalenceClass eqClass) {
        boolean accept = false;
        if (eqClass != null) {
            boolean found = false;
            for (String word : eqClass.getAllWords()) {
                found = this.m_stopWords.contains(word);
                if (found) break;
            }
            accept = !found;
        }
        return accept;
    }
}

