/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses;

import babel.content.eqclasses.properties.Property;
import java.util.Collection;
import java.util.HashMap;

public abstract class EquivalenceClass
implements Comparable<EquivalenceClass> {
    protected static final boolean DEF_CASE_SENSITIVE = false;
    protected static final long NO_ID = -1L;
    protected static int CURRENT_EQCLASS_ID;
    protected long m_id = -1L;
    protected boolean m_initialized = false;
    protected boolean m_caseSensitive = false;
    protected HashMap<String, Property> m_properties = new HashMap();

    public void init(String word, boolean caseSensitive) {
        if (word == null) {
            throw new IllegalArgumentException();
        }
        this.m_initialized = true;
        this.m_caseSensitive = caseSensitive;
        this.m_properties.clear();
    }

    public synchronized void assignId() {
        if (this.m_id != -1L) {
            throw new IllegalStateException("Class has already been assigned id: " + this.m_id);
        }
        this.m_id = CURRENT_EQCLASS_ID++;
    }

    public long getId() {
        return this.m_id;
    }

    public abstract boolean isInEqClass(String var1);

    public abstract boolean addMorph(String var1);

    public abstract Collection<String> getAllWords();

    public abstract String getStem();

    public abstract String persistToString();

    public abstract void unpersistFromString(String var1) throws Exception;

    public boolean sameEqClass(EquivalenceClass eq) {
        return this.equals(eq);
    }

    public abstract boolean merge(EquivalenceClass var1);

    public boolean isCaseSensitive() {
        return this.m_caseSensitive;
    }

    public int hashCode() {
        return this.getStem().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof EquivalenceClass && this.compareTo((EquivalenceClass)obj) == 0;
    }

    @Override
    public int compareTo(EquivalenceClass eq) {
        if (eq == null) {
            throw new NullPointerException();
        }
        if (!(this.getClass().equals(eq.getClass()) && this.m_initialized && eq.m_initialized && this.m_caseSensitive == eq.m_caseSensitive)) {
            throw new RuntimeException();
        }
        return this.getStem().compareTo(eq.getStem());
    }

    public Property getProperty(String propId) {
        return propId != null ? this.m_properties.get(propId) : null;
    }

    public void setProperty(Property prop) {
        if (prop != null) {
            this.m_properties.put(prop.getPropertyId(), prop);
        }
    }

    public boolean removeProperty(String propId) {
        boolean removed = this.m_properties.containsKey(propId);
        if (removed) {
            this.m_properties.remove(propId);
        }
        return removed;
    }

    protected void checkInitialized() {
        if (!this.m_initialized) {
            throw new IllegalStateException("Must be initialized first.");
        }
    }

    public static String getWordOfAppropriateForm(String word, boolean caseSensitive) {
        return caseSensitive ? word.trim() : (word == null ? null : word.toLowerCase().trim());
    }

    public static void test() {
    }
}

