lang = { 'english', 'portuguese', ...
		'spanish', 'swedish', 'chinese', 'dutch', ...
		'japanese', 'bulgarian', 'czech', 'german', 'turkish', 'italian07', ...
		'greek07', 'hungarian07', 'catalan07', 'basque07', 'arabic07' };
lang = sort(lang);
lang = char(lang);
nlang = size(lang, 1);

%sourceLang = {'spanish', 'hungarian07', 'italian07',...
%		'portuguese', 'bulgarian', 'bulgarian', 'portuguese', 'swedish', 'english', 'spanish',...
%		'dutch', 'portuguese', 'dutch', 'italian07', 'catalan07', 'dutch', 'hungarian07'};
sourceLang = {'portuguese', 'turkish', 'czech',...
		'portuguese', 'swedish', 'bulgarian', 'greek07', 'swedish', 'dutch', 'dutch',...
		'dutch', 'portuguese', 'turkish', 'catalan07', 'catalan07', 'bulgarian', 'hungarian07'};

sourceLang = char(sourceLang);

seed=2;
rand('seed',seed)
lambdas = 10.^[-5:2:-1];
niter = 30;

% read obj weight
fid = fopen('../../MSTparser/data/matobjweight.txt');
nw = 4;
objweight = fscanf(fid, '%f', [nw, nlang]); % nw * nlang
fclose(fid);

%set the weight manually
%objweight(1, ll) = 0;
%objweight(2, ll) = 0;
%objweight(3, ll) = 0;
%objweight(4, ll) = 0.02;

%for ll = 1:nlang
%target = 'catalan07';
target = strtrim(lang(ll, :));
target

% read target matrix
fid_t = fopen(strcat('../../MSTparser/data/', target, '/', target, '.mat'),'r');
n = fscanf(fid_t, '%d', [1 3]);
nfine_t = n(1);
ncoarse_t = n(2);
ncluster_t = n(3);
At = fscanf(fid_t, '%d', [nfine_t, ncoarse_t]);
At = At';
Act = fscanf(fid_t, '%d', [nfine_t, ncluster_t]);
Act = Act';
Aclu2coa_t = fscanf(fid_t, '%d', [ncluster_t, ncoarse_t]);
Aclu2coa_t = Aclu2coa_t';
pfine_token_t = fscanf(fid_t, '%f', [nfine_t, 1]);
pfine_type_t = fscanf(fid_t, '%f', [nfine_t, 1]);
pfine_bi_t = fscanf(fid_t, '%f', [nfine_t, nfine_t]);
pfine_bi_t = pfine_bi_t';
nsent_t = fscanf(fid_t, '%d', [1, 1]);
pfine_sent_t = fscanf(fid_t, '%f', [nfine_t, nsent_t]);
verbpos_t = fscanf(fid_t, '%f', [4, nfine_t]);
if (strcmp(target, 'arabic07') == 1)
    verbpos_t = verbpos_t(1:2, :);
elseif (strcmp(target, 'japanese') == 1)
    verbpos_t = verbpos_t(3:4, :);
else
    verbpos_t = zeros(2, nfine_t);
end
       
fclose(fid_t);

% get close lang init

fid_t = fopen(strcat('../../MSTparser/data/', target, '/', target, '.mat.init.close2'),'r');
nSource = fscanf(fid_t, '%d', [1 1]);
sourceLangID = zeros(nSource, 1);
numInit = 6;
initAclu2coa_t = zeros(ncoarse_t, ncluster_t, nSource, numInit);
for z = 1:nSource;
    sourceLangID(z) = fscanf(fid_t, '%d', [1 1]);
    sourceLangID(z) = sourceLangID(z) + 1;
    for i = 1:numInit
        tmp = fscanf(fid_t, '%d', [ncluster_t, ncoarse_t]);
        initAclu2coa_t(:, :, z, i) = tmp';
    end
end
fclose(fid_t);

% build the complement
seq = 1:nlang;
mask = 1 - ismember(seq, sourceLangID);
mask(ll) = 0;

% for verb dev
pcluster_sent_t = Act * pfine_sent_t;
pcluster_avgsent_t = mean(pcluster_sent_t, 2);
pcluster_csfcsf_t = zeros(ncluster_t, ncluster_t);
pcluster_csfavgf_t = zeros(ncluster_t, ncluster_t);
pcluster_avgfavgf_t = zeros(ncluster_t, ncluster_t);
for f1 = 1:ncluster_t
    for f2 = 1:ncluster_t
        pcluster_csfcsf_t(f1, f2) = sum(pcluster_sent_t(f1, :) .* pcluster_sent_t(f2, :));
        pcluster_csfavgf_t(f1, f2) = sum(pcluster_sent_t(f1, :) * pcluster_avgsent_t(f2));
        pcluster_avgfavgf_t(f1, f2) = nsent_t * pcluster_avgsent_t(f1) * pcluster_avgsent_t(f2);
    end
end
pcluster_sentmat_t = (pcluster_csfcsf_t - 2 * pcluster_csfavgf_t + pcluster_avgfavgf_t) / nsent_t;
%wsent = 0;
%if (strcmp(target, 'portuguese') == 0)
    wsent = 1;
%end
wDevVerb = 0.02;
%wDevVerb = 0.005;
%if (strcmp(target, 'chinese') == 1)
%    wDevVerb = 0.05;
%end
asent = 100;
devVerbThresh = 4.5;
if (strcmp(target, 'italian07') == 1 || strcmp(target, 'turkish') == 1 || strcmp(target, 'english') == 1)
    devVerbThresh = 6.0;
end
%if (strcmp(target, 'arabic07') == 1)
%    devVerbThresh = 4;
%end
%if (strcmp(target, 'german') == 1)
%    devVerbThresh = 3;
%end
if (strcmp(target, 'chinese') == 1)
    devVerbThresh = 1.5;
end
%if (strcmp(target, 'japanese') == 1)
%    devVerbThresh = 4.6;
%end

% for verb freq lower bound
sentWordCount_t = sum(pcluster_sent_t, 1);
nToken = sum(sentWordCount_t);
longSent_t = (sentWordCount_t > 0) + 0;
nLongSent_t = sum(longSent_t);
longClusterCount_t = pcluster_sent_t * longSent_t' / nLongSent_t;
%longClusterSent_t = pcluster_sent_t * diag(longSent_t);
%verbRatio = Aclu2coa_t(6, :) * longClusterCount_t
verbLowerBoundRatio = 1.9;
if (strcmp(target, 'chinese') == 1)
    verbLowerBoundRatio = 1.4;
end
%if (strcmp(target, 'english') == 1)
%    verbLowerBoundRatio = 2.0;
%end
%if (strcmp(target, 'japanese') == 1)
%    verbLowerBoundRatio = 1.6;
%end
%if (strcmp(target, 'swedish') == 1)
%    verbLowerBoundRatio = 2.3;
%end
%if (strcmp(target, 'german') == 1)
%    verbLowerBoundRatio = 2.3;
%end
%if (strcmp(target, 'bulgarian') == 1)
%    verbLowerBoundRatio = 0;
%end
verbLowerBoundTokenRatio = verbLowerBoundRatio * nLongSent_t / nToken;
wVerbLowerBound = 100;

% build target matrix
%wbi_t = 1;
%if (strcmp(target, 'bulgarian') == 1 || strcmp(target, 'german') == 1)
    wbi_t = 10;
%end
pcluster_bi_t = Act * pfine_bi_t * Act';
pcluster_bi_sum2_t = sum(pcluster_bi_t, 2);
pcluster_bi_sum1_t = sum(pcluster_bi_t, 1);
bads = find(pcluster_bi_sum2_t==0 | pcluster_bi_sum1_t'==0);
if (sum(bads) ~= 0)
    error('bad cluster');
end

pcluster_token_t = Act * pfine_token_t;
pcluster_type_t = Act * pfine_type_t;


% gram freq constraint
numThresh = 0.001;
if (strcmp(target, 'chinese') == 1 || strcmp(target, 'turkish') == 1)
    numThresh = -0.001;
end
wNum = 100;

% for det typo
wDetTypo = 100;
%approxRatioDetTypo = 2.5;
%detTypoMat = Aclu2coa_t(1, :) + Aclu2coa_t(3, :) + Aclu2coa_t(4, :) + Aclu2coa_t(6, :);     % NOUN, ADJ, NUM, VERB, 1 * nclu
detSumVec = [1 0 1 1 0 1 0 0 0 0 0 0];
detTypoThresh = 0.8;
if (strcmp(target, 'arabic07') == 1 || strcmp(target, 'chinese') == 1 || strcmp(target, 'bulgarian') || strcmp(target, 'swedish'))
    detTypoThresh = 0.6;
end

if (strcmp(target, 'basque07') == 1 || strcmp(target, 'japanese'))
    detTypoThresh = 0;
end

% for adp typo
wPrepTypo = 100 * [1	0	1	1	0	1	1	1	1	1	0	1	0	1	1	1	0];
wPostpTypo = 100 * [0	1	0	0	0	0	0	0	0	0	1	0	1	0	0	0	1];
prepSumVec = [1 0 1 1 0 0 0 0 0 1 1 0];
postpSumVec = [1 0 0 1 0 0 0 0 0 1 0 0];
%approxRatioAdpTypo = 1.65;
adpTypoThresh = 0.87;
if (wPostpTypo(ll) > 0)
    adpTypoThresh = 0.7;
end

% for svo typo
svoTypoThresh = [0 0];
haveSVOTypo = 0;
%if (strcmp(target, 'arabic07') == 1)
%    svoTypoThresh = [0.93 0.45];
%    haveSVOTypo = 1;
%elseif (strcmp(target, 'japanese') == 1)
%    svoTypoThresh = [0.75 0.20];
%    haveSVOTypo = 1;
%end
pcluster_verbpos_t = Act * verbpos_t';   % ncluster * 2
wSVOTypo = 0 * [-1 1];

%minObj = 1e30;
minLang = '';

for l = 1:nlang
    
minObj = 1e30;
minUnroundObj = 1e30;

%source = strtrim(sourceLang(ll, :));
%source = 'portuguese';
%if (mask(l) == 0)
%    continue;
%end
if (ll == l)
    continue;
end
source = strtrim(lang(l, :));
%if (strcmp(source, 'bulgarian') ~= 1)
%   continue;
%end
%if (strcmp(source, strtrim(sourceLang(ll, :))) ~= 1)
%    continue;
%end
source

%if (strcmp(source, 'japanese') == 1 || strcmp(source, 'arabic07') == 1 ...
%    || strcmp(source, 'chinese') == 1 || strcmp(source, 'turkish') == 1 || strcmp(source, 'basque07')== 1)
%    continue;
%end
% read source matrix
fid_s = fopen(strcat('../../MSTparser/data/', source, '/', source, '.mat'),'r');
n = fscanf(fid_s, '%d', [1 3]);
nfine_s = n(1);
ncoarse_s = n(2);
ncluster_s = n(3);
As = fscanf(fid_s, '%d', [nfine_s, ncoarse_s]);
As = As';
Acs = fscanf(fid_s, '%d', [nfine_s, ncluster_s]);
Acs = Acs';
Aclu2coa_s = fscanf(fid_s, '%d', [ncluster_s, ncoarse_s]);
Aclu2coa_s = Aclu2coa_s';
pfine_token_s = fscanf(fid_s, '%f', [nfine_s, 1]);
pfine_type_s = fscanf(fid_s, '%f', [nfine_s, 1]);
pfine_bi_s = fscanf(fid_s, '%f', [nfine_s, nfine_s]);
pfine_bi_s = pfine_bi_s';
fclose(fid_s);
fid_s = fopen(strcat('../../MSTparser/data/', source, '/', source, '.mat.init.close2'),'r');
initAclu2coa_s = fscanf(fid_s, '%d', [ncluster_s, ncoarse_s]);
initAclu2coa_s = initAclu2coa_s';
fclose(fid_s);

% build source matrix
%As = Aclu2coa_s * Acs;
ini_eps = 5e-3;
    
pcoarse_bi_s = smooth(As*pfine_bi_s*As', ini_eps / 10);
pcoarse_token_s = smooth(As*pfine_token_s, ini_eps);
pcoarse_type_s = smooth(As*pfine_type_s, ini_eps);

%pcoarse_bi_ss = 0.5*(As*sum(pfine_bi_s, 2)*ones(1, ncoarse_s) + ones(ncoarse_s, 1)*sum(pfine_bi_s, 1)*As');
%pcoarse_type_ss = pcoarse_type_s;
%pcoarse_token_ss = pcoarse_token_s;
%pcoarse_ss


% get best ans
ent = 0;
for f=1:ncluster_t
    ent = ent+my_entropy(Aclu2coa_t(:,f));
end
%sum(sum((Aclu2coa_t*pcluster_bi_t*Aclu2coa_t'-pcoarse_bi_s).^2))

%pcoarse_bi_t = smooth(Aclu2coa_t * pcluster_bi_t * Aclu2coa_t', ini_eps / 10);
%pcoarse_token_t = smooth(Aclu2coa_t*pcluster_token_t, ini_eps);
%pcoarse_type_t = smooth(Aclu2coa_t*pcluster_type_t, ini_eps);

pcoarse_bi_t = smooth(At * pfine_bi_t * At', ini_eps / 10);
pcoarse_token_t = smooth(At*pfine_token_t, ini_eps);
pcoarse_type_t = smooth(At*pfine_type_t, ini_eps);

bestObj = -objweight(1, ll) * my_kl(pcoarse_bi_s(:),pcoarse_bi_t(:))...
            - max(0, asent * (Aclu2coa_t(6, :) * pcluster_sentmat_t * Aclu2coa_t(6, :)' - devVerbThresh))...
            - objweight(4, ll) * Aclu2coa_t(6, :) * pcluster_sentmat_t * Aclu2coa_t(6, :)'...
            - max(0, -wVerbLowerBound * (Aclu2coa_t(6, :) * longClusterCount_t - verbLowerBoundRatio))... % verb lower bound
            - sum(max(0, (Aclu2coa_t(6, :) * pcluster_verbpos_t - svoTypoThresh) .* wSVOTypo))...    %svo typo
            - max(0, -wDetTypo * (Aclu2coa_t(11, :) * pcluster_bi_t * (detSumVec * Aclu2coa_t)' - detTypoThresh * Aclu2coa_t(11, :) * pcluster_bi_sum2_t))...
            - max(0, -wPrepTypo(ll) * (Aclu2coa_t(2, :) * pcluster_bi_t * (prepSumVec * Aclu2coa_t)' - adpTypoThresh * Aclu2coa_t(2, :) * pcluster_bi_sum2_t))... %prep typo
            - max(0, -wPostpTypo(ll) * ((postpSumVec * Aclu2coa_t) * pcluster_bi_t * Aclu2coa_t(2, :)' - adpTypoThresh * Aclu2coa_t(2, :) * pcluster_bi_sum1_t'))... %postp typo
            -objweight(2, ll) * my_kl(pcoarse_token_s(:), pcoarse_token_t)...
            -objweight(3, ll) * my_kl(pcoarse_type_s(:), pcoarse_type_t);
%sum(sum((0.5*(Aclu2coa_t*sum(pcluster_bi_t, 2)*ones(1, ncoarse_t) + ones(ncoarse_t, 1)*sum(pcluster_bi_t, 1)*Aclu2coa_t')-pcoarse_bi_ss).^2))    
%bestApproxObj = sum(sum(marg_to_1.*log(A)))+sum(sum(marg_to_2.*log(A)));

bestObj
%end % of lang
%bestApproxObj

div_token = 0;
div_type = 0;
for i = 1:ncoarse_t
%    if (mid_token(i) > 1e-10)
        div_token = div_token + pcoarse_token_s(i) * log(pcoarse_token_s(i) / pcoarse_token_t(i));
%    end
%    if (mid_type(i) > 1e-10)
        div_type = div_type + pcoarse_type_s(i) * log(pcoarse_type_s(i) / pcoarse_type_t(i));
%    end
end
div_bi = sum(sum(pcoarse_bi_s .* log(pcoarse_bi_s ./ pcoarse_bi_t)))
div_token
div_type
Aclu2coa_t(6, :) * pcluster_verbpos_t
[Aclu2coa_t(2, :) * pcluster_bi_t * (prepSumVec * Aclu2coa_t)' Aclu2coa_t(2, :) * pcluster_bi_sum2_t]
[(postpSumVec * Aclu2coa_t) * pcluster_bi_t * Aclu2coa_t(2, :)' Aclu2coa_t(2, :) * pcluster_bi_sum1_t']
[Aclu2coa_t(11, :) * pcluster_bi_t * (detSumVec * Aclu2coa_t)'  Aclu2coa_t(11, :) * pcluster_bi_sum2_t]
%sentVerb = Aclu2coa_t(6, :) * pcluster_sent_t;
%sentVerb = sentVerb > 0 + 0;
%[sum(sentVerb * longSent_t') / nLongSent_t,  0.5 * Aclu2coa_t(6, :) * longClusterCount_t - 0.5 * sum(abs(Aclu2coa_t(6, :) * longClusterSent_t - 1)) / nLongSent_t + 0.5 * nsent_t / nLongSent_t]

bi = sum(sum((Aclu2coa_t*pcluster_bi_t*Aclu2coa_t'-pcoarse_bi_s).^2))
token = sum((Aclu2coa_t*pcluster_token_t-pcoarse_token_s).^2)
type = sum((Aclu2coa_t*pcluster_type_t-pcoarse_type_s).^2)
dev = Aclu2coa_t(6, :) * pcluster_sentmat_t * Aclu2coa_t(6, :)'
freq = Aclu2coa_t(6, :) * longClusterCount_t
%sum(sum((Aclu2coa_t*pcluster_bi_t*Aclu2coa_t'-pcoarse_bi_s).^2))
%sum((Aclu2coa_t*pcluster_token_t-pcoarse_token_s).^2)
%sum((Aclu2coa_t*pcluster_type_t-pcoarse_type_s).^2)
%sum(sum((0.5*(Aclu2coa_t*sum(pcluster_bi_t, 2)*ones(1, ncoarse_t) + ones(ncoarse_t, 1)*sum(pcluster_bi_t, 1)*Aclu2coa_t')-pcoarse_bi_ss).^2))

for t = 1:numInit
fprintf('t=%d\n', t);

%currA = ones(ncoarse_t,ncluster_t);
%currA = currA*diag(1./sum(currA,1));
currA = initAclu2coa_t(:, :, 1, t) + ini_eps;
%for i = 1:4
    %coarse_idx = ceil(ncoarse_t * rand(1, 1));
%    cluster_idx = ceil(ncluster_t * rand(1, 1));
    %col = zeros(ncoarse_t, 1); col(coarse_idx) = 1;
%    currA(: , cluster_idx) = ones(ncoarse_t, 1);
%    currA = rand(ncoarse_t,ncluster_t);
    %currA = ones(ncoarse_t,ncluster_t)+(rand(ncoarse_t, ncluster_t)-0.5)*0.1;
%end
for f=1:ncluster_t
    currA(:,f) = currA(:,f)/sum(currA(:,f));
end
%currA = ones(ncoarse_t,ncluster_t);
%currA = currA*diag(1./sum(currA,1));

for li=1:length(lambdas)
    
   lambda = lambdas(li);

obj=[];
%A_t = currA; %ones(ncoarse,nfine)/ncoarse;
A_t = currA;
pr_const = 1;
for it=1:niter
    %pfine_t = pfine_t;    
    % Address constraints on p(c1,c2). We want to find a distribution r(c1,c2)
    % that is close to the current p estimate, but satisfies our constraints
    % maybe try another kind of contraints r(11, :) * detSumVec' >= A_t(11,
    % :) * pcluster_token_t
    cvx_begin quiet
        variables r(ncoarse_t,ncoarse_t)
        curr_pc_bi = smooth(A_t*pcluster_bi_t*A_t', 0);
        
        maximize sum(sum(r.*log(curr_pc_bi)))+sum(entr(r(:)));
        r>=0;
        sum(r(:))==1;
        %det typo
        r(11, :) * (detSumVec - detTypoThresh)' >= 0;
        %prep typo
        wPrepTypo(ll) / 100 * r(2, :) * (prepSumVec - adpTypoThresh)' >= 0;
        %postp typo
        wPostpTypo(ll) / 100 * (postpSumVec - adpTypoThresh) * r(:, 2) >= 0;
        %verb occurrence constraint
        sum(r(6, :)) >= verbLowerBoundTokenRatio;
    cvx_end

    %r
    %curr_pc_bi
    % for em
    cvx_begin quiet
    variables A(ncoarse_t,ncluster_t)
    %unigram
    curr_joint_token = A_t*diag(pcluster_token_t);
    curr_pfgc_token = make_cond_dist(curr_joint_token,0);
    curr_joint_token = diag(pcoarse_token_s)*curr_pfgc_token;
    
    curr_joint_type = A_t*diag(pcluster_type_t);
    curr_pfgc_type = make_cond_dist(curr_joint_type,0);
    curr_joint_type = diag(pcoarse_type_s)*curr_pfgc_type;
    %bigram
    pfour = zeros(ncoarse_t,ncoarse_t,ncluster_t,ncluster_t);
    for c1=1:ncoarse_t
        for c2=1:ncoarse_t
            M = (A_t(c1,:)'*A_t(c2,:)).*pcluster_bi_t;
            M = M/sum(M(:));
            pfour(c1,c2,:,:) = (pcoarse_bi_s(c1,c2)+pr_const*r(c1,c2))*M;
        end
    end
    marg_to_1 = sum(sum(pfour,2),4);
    marg_to_1 = squeeze(marg_to_1);
    marg_to_2 = sum(sum(pfour,1),3);
    marg_to_2 = squeeze(marg_to_2);
    
    matrix_sum = objweight(1, ll) * (marg_to_1 + marg_to_2) + objweight(2, ll) * (curr_joint_token) + objweight(3, ll) * (curr_joint_type);
%    maximize sum(sum(marg_to_1.*log(A)))+sum(sum(marg_to_2.*log(A)))...
%        + sum(sum(curr_joint_token.*log(A)))...
%        + sum(sum(curr_joint_type.*log(A)))...
%        + lambda*sum(sum(A.*log(A_t)));
    optobj = sum(sum(matrix_sum.*log(A)))...
        - max(0, asent * (A(6, :) * pcluster_sentmat_t * A(6, :)' - devVerbThresh))...
        - objweight(4, ll) * (A(6, :) * pcluster_sentmat_t * A(6, :)')...
        + lambda*sum(sum(A.*log(A_t)));
    if (haveSVOTypo == 1)
        optobj = optobj - sum(max(0, (A(6, :) * pcluster_verbpos_t - svoTypoThresh) .* wSVOTypo));
    end
    maximize optobj;
    sum(A)==ones(1,ncluster_t);
    A>=0;
    cvx_end
    if max(abs(sum(A)-ones(1,ncluster_t)))>1e-3
        sum(A)
    end
    A_t = max(A, 0);
    A_t = make_cond_dist(A_t,1);
    
    ent = 0;
    for f=1:ncluster_t
        ent = ent+my_entropy(A_t(:,f));
    end
    curr_pc_bi = smooth(A_t*pcluster_bi_t*A_t', 0);
    curr_pc_token = smooth(A_t*pcluster_token_t, 0);
    curr_pc_type = smooth(A_t*pcluster_type_t, 0);

    obj(it) = - objweight(1, ll) * my_kl(pcoarse_bi_s(:),curr_pc_bi(:))...
               - objweight(2, ll) * my_kl(pcoarse_token_s(:), curr_pc_token(:))...
               - objweight(3, ll) * my_kl(pcoarse_type_s(:), curr_pc_type(:))...
               - max(0, asent * (A(6, :) * pcluster_sentmat_t * A(6, :)' - devVerbThresh))...
                - objweight(4, ll) * A(6, :) * pcluster_sentmat_t * A(6, :)'...
                - sum(max(0, (A(6, :) * pcluster_verbpos_t - svoTypoThresh) .* wSVOTypo))...    %svo typo
                - pr_const*my_kl(r(:),curr_pc_bi)...
              - lambda*ent;
    unrounded = objweight(1, ll) * my_kl(pcoarse_bi_s(:),curr_pc_bi(:))...
                + objweight(2, ll) * my_kl(pcoarse_token_s(:), curr_pc_token(:))...
                + objweight(3, ll) * my_kl(pcoarse_type_s(:), curr_pc_type(:))...
                + max(0, asent * (A(6, :) * pcluster_sentmat_t * A(6, :)' - devVerbThresh))...
                + objweight(4, ll) * A(6, :) * pcluster_sentmat_t * A(6, :)'...
                + sum(max(0, (A(6, :) * pcluster_verbpos_t - svoTypoThresh) .* wSVOTypo))...    %svo typo
                + pr_const*my_kl(r(:),curr_pc_bi);
    % Do rounding
%     tmpAround = zeros(size(A_t));
%     for f=1:ncluster_t
%         [vv,ii] = max(A(:,f));
%         tmpAround(ii,f)=1;
%     end
%     Around = tmpAround;
    Around = A;
    for change = 1:10
        isChanged = false;
        for cl = 1:ncluster_t
            minVal = 1e30;
            minC = -1;
            for co = 1:ncoarse_t
                tmpA = Around;
                tmpA(:, cl) = zeros(ncoarse_t, 1);
                tmpA(co, cl) = 1;
                curr_pc_bi = smooth(tmpA*pcluster_bi_t*tmpA', ini_eps / 10);
                curr_pc_token = smooth(tmpA*pcluster_token_t, ini_eps);
                curr_pc_type = smooth(tmpA*pcluster_type_t, ini_eps);
                val = objweight(1, ll) * my_kl(pcoarse_bi_s(:),curr_pc_bi(:))...
                    + objweight(2, ll) * my_kl(pcoarse_token_s(:), curr_pc_token(:))...
                    + objweight(3, ll) * my_kl(pcoarse_type_s(:), curr_pc_type(:))...
                    + max(0, asent * (tmpA(6, :) * pcluster_sentmat_t * tmpA(6, :)' - devVerbThresh))...
                    + max(0, -wVerbLowerBound * (tmpA(6, :) * longClusterCount_t - verbLowerBoundRatio))... % verb lower bound
                    + sum(max(0, (tmpA(6, :) * pcluster_verbpos_t - svoTypoThresh) .* wSVOTypo))...    %svo typo
                    + max(0, -wDetTypo * (tmpA(11, :) * pcluster_bi_t * (detSumVec * tmpA)' - detTypoThresh * tmpA(11, :) * pcluster_bi_sum2_t))... %det typo
                    + max(0, -wPrepTypo(ll) * (tmpA(2, :) * pcluster_bi_t * (prepSumVec * tmpA)' - adpTypoThresh * tmpA(2, :) * pcluster_bi_sum2_t))... %prep typo
                    + max(0, -wPostpTypo(ll) * ((postpSumVec * tmpA) * pcluster_bi_t * tmpA(2, :)' - adpTypoThresh * tmpA(2, :) * pcluster_bi_sum1_t'))... %postp typo
                   + objweight(4, ll) * tmpA(6, :) * pcluster_sentmat_t * tmpA(6, :)';
                if (val < minVal)
                    minVal = val;
                    minC = co;
                end
            end
            if (minC == -1)
                val
                continue;
            end
            if (Around(minC, cl) ~= 1)
                isChanged = true;
            end
            Around(:, cl) = zeros(ncoarse_t, 1);
            Around(minC, cl) = 1;
        end
        if (~isChanged)
            break;
        end
    end
    %sum(sum((Around*pcluster_bi_t*Around'-pcoarse_bi_s).^2))...
    
    origAround = Around;
    
    curr_pc_bi = smooth(Around*pcluster_bi_t*Around', ini_eps / 10);
    curr_pc_token = smooth(Around*pcluster_token_t, ini_eps);
    curr_pc_type = smooth(Around*pcluster_type_t, ini_eps);
    
    rounded = objweight(1, ll) * my_kl(pcoarse_bi_s(:),curr_pc_bi(:))...
                + objweight(2, ll) * my_kl(pcoarse_token_s(:), curr_pc_token(:))...
                + objweight(3, ll) * my_kl(pcoarse_type_s(:), curr_pc_type(:))...
                + max(0, asent * (Around(6, :) * pcluster_sentmat_t * Around(6, :)' - devVerbThresh))...
                + objweight(4, ll) * Around(6, :) * pcluster_sentmat_t * Around(6, :)'...
                + sum(max(0, (Around(6, :) * pcluster_verbpos_t - svoTypoThresh) .* wSVOTypo))...    %svo typo
                + max(0, -wDetTypo * (Around(11, :) * pcluster_bi_t * (detSumVec * Around)' - detTypoThresh * Around(11, :) * pcluster_bi_sum2_t))... %det typo
                + max(0, -wPrepTypo(ll) * (Around(2, :) * pcluster_bi_t * (prepSumVec * Around)' - adpTypoThresh * Around(2, :) * pcluster_bi_sum2_t))... %prep typo
                + max(0, -wPostpTypo(ll) * ((postpSumVec * Around) * pcluster_bi_t * Around(2, :)' - adpTypoThresh * Around(2, :) * pcluster_bi_sum1_t'))... %postp typo
                + max(0, -wVerbLowerBound * (Around(6, :) * longClusterCount_t - verbLowerBoundRatio)); % verb lower bound
    fprintf('Iter=%d Obj=%g UnRound=%g RoundObj=%g\n',it,obj(it),unrounded,rounded);

    if (rounded < minObj || (abs(rounded - minObj) < 1e-10 && unrounded < minUnroundObj))
        minObj = rounded;
        minUnroundObj = unrounded;
        minLang = source;
        minA = origAround;
        minFracA = A;
        minFineA = minA * Act;
        output;
    end
    if it>1 & obj(it)-obj(it-1)<1e-5
        break;
    end

end % of iter

end % of  lambda
% Show approximation of pcoarse and true (source) value
%A
%Aans = Around * Act;
%At-Aans
%Aclu2coa_t - Around
%[pcoarse_token_s pcoarse_type_s]
%[Around * pcluster_token_t Around * pcluster_type_t]
%Around*pfine_t*Around' 
%pcoarse_s
%sum(sum((Around*pcluster_bi_t*Around'-pcoarse_bi_s).^2))
%sum((Around*pcluster_token_t-pcoarse_token_s).^2)
%sum((Around*pcluster_type_t-pcoarse_type_s).^2)
%sum(sum((0.5*(Around*sum(pcluster_bi_t, 2)*ones(1, ncoarse_t) + ones(ncoarse_t, 1)*sum(pcluster_bi_t, 1)*Around')-pcoarse_bi_ss).^2))
end % of t

end % of source
bestObj
minObj
Aclu2coa_t - minA 
minFracA
% verb
minA(6, :) * pcluster_sentmat_t * minA(6, :)'

% gram
sum(sum((minA*pcluster_bi_t*minA'-pcoarse_bi_s).^2))
sum((minA*pcluster_token_t-pcoarse_token_s).^2)
sum((minA*pcluster_type_t-pcoarse_type_s).^2)
minFineA = minA * Act;
%output;
%end %for target
