/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.classify;

import com.aliasi.classify.Classification;
import com.aliasi.classify.Classified;
import com.aliasi.classify.RankedClassifierEvaluator;
import com.aliasi.classify.ScoredClassification;
import com.aliasi.classify.ScoredClassifier;
import com.aliasi.classify.ScoredPrecisionRecallEvaluation;
import com.aliasi.util.Scored;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScoredClassifierEvaluator<E>
extends RankedClassifierEvaluator<E> {
    private final List<ScoreOutcome>[] mScoreOutcomeLists;
    boolean mDefectiveScoring = false;

    public ScoredClassifierEvaluator(ScoredClassifier<E> classifier, String[] categories, boolean storeInputs) {
        super(classifier, categories, storeInputs);
        ArrayList[] scoreOutcomeLists = new ArrayList[this.numCategories()];
        this.mScoreOutcomeLists = scoreOutcomeLists;
        for (int i = 0; i < this.mScoreOutcomeLists.length; ++i) {
            this.mScoreOutcomeLists[i] = new ArrayList<ScoreOutcome>();
        }
    }

    @Override
    public void setClassifier(ScoredClassifier<E> classifier) {
        this.setClassifier(classifier, ScoredClassifierEvaluator.class);
    }

    @Override
    public ScoredClassifier<E> classifier() {
        ScoredClassifier result = (ScoredClassifier)super.classifier();
        return result;
    }

    @Override
    public void handle(Classified<E> classified) {
        E input = classified.getObject();
        Classification refClassification = classified.getClassification();
        String refCategory = refClassification.bestCategory();
        this.validateCategory(refCategory);
        ScoredClassification classification = this.classifier().classify(input);
        this.addClassification(refCategory, classification, input);
        this.addRanking(refCategory, classification);
        this.addScoring(refCategory, classification);
    }

    public ScoredPrecisionRecallEvaluation scoredOneVersusAll(String refCategory) {
        this.validateCategory(refCategory);
        return this.scoredOneVersusAll(this.mScoreOutcomeLists, this.categoryToIndex(refCategory));
    }

    public double averageScore(String refCategory, String responseCategory) {
        this.validateCategory(refCategory);
        this.validateCategory(responseCategory);
        double sum = 0.0;
        int count = 0;
        block0: for (int i = 0; i < this.mReferenceCategories.size(); ++i) {
            if (!((String)this.mReferenceCategories.get(i)).equals(refCategory)) continue;
            ScoredClassification c = (ScoredClassification)this.mClassifications.get(i);
            for (int rank = 0; rank < c.size(); ++rank) {
                if (!c.category(rank).equals(responseCategory)) continue;
                sum += c.score(rank);
                ++count;
                continue block0;
            }
        }
        return sum / (double)count;
    }

    public double averageScoreReference() {
        double sum = 0.0;
        block0: for (int i = 0; i < this.mReferenceCategories.size(); ++i) {
            String refCategory = ((String)this.mReferenceCategories.get(i)).toString();
            ScoredClassification c = (ScoredClassification)this.mClassifications.get(i);
            for (int rank = 0; rank < c.size(); ++rank) {
                if (!c.category(rank).equals(refCategory)) continue;
                sum += c.score(rank);
                continue block0;
            }
        }
        return sum / (double)this.mReferenceCategories.size();
    }

    ScoredPrecisionRecallEvaluation scoredOneVersusAll(List<ScoreOutcome>[] outcomeLists, int categoryIndex) {
        ScoredPrecisionRecallEvaluation eval = new ScoredPrecisionRecallEvaluation();
        for (ScoreOutcome outcome : outcomeLists[categoryIndex]) {
            eval.addCase(outcome.mOutcome, outcome.mScore);
        }
        return eval;
    }

    void addScoring(String refCategory, ScoredClassification scoring) {
        if (scoring.size() < this.numCategories()) {
            this.mDefectiveScoring = true;
        }
        for (int rank = 0; rank < this.numCategories() && rank < scoring.size(); ++rank) {
            double score = scoring.score(rank);
            String category = scoring.category(rank);
            int categoryIndex = this.categoryToIndex(category);
            boolean match = category.equals(refCategory);
            ScoreOutcome outcome = new ScoreOutcome(score, match, rank == 0);
            this.mScoreOutcomeLists[categoryIndex].add(outcome);
        }
    }

    @Override
    void baseToString(StringBuilder sb) {
        super.baseToString(sb);
        sb.append("Average Score Reference=" + this.averageScoreReference() + "\n");
    }

    @Override
    void oneVsAllToString(StringBuilder sb, String category, int i) {
        super.oneVsAllToString(sb, category, i);
        sb.append("Scored One Versus All\n");
        sb.append(this.scoredOneVersusAll(category) + "\n");
        sb.append("Average Score Histogram=\n");
        this.appendCategoryLine(sb);
        for (int j = 0; j < this.numCategories(); ++j) {
            if (j > 0) {
                sb.append(',');
            }
            sb.append(this.averageScore(category, this.categories()[j]));
        }
        sb.append("\n");
    }

    static class ScoreOutcome
    implements Scored {
        private final double mScore;
        private final boolean mOutcome;
        private final boolean mFirstBest;

        public ScoreOutcome(double score, boolean outcome, boolean firstBest) {
            this.mOutcome = outcome;
            this.mScore = score;
            this.mFirstBest = firstBest;
        }

        public double score() {
            return this.mScore;
        }

        public String toString() {
            return "(" + this.mScore + ": " + this.mOutcome + "firstBest=" + this.mFirstBest + ")";
        }
    }
}

