/*
 * Decompiled with CFR 0.152.
 */
package similarity;

import com.aliasi.matrix.SparseFloatVector;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;
import segmenter.IDataSource;
import similarity.DfDictionary;
import similarity.SentTokenVector;
import similarity.TokenDictionary;

public class Document {
    private ArrayList<SentTokenVector> sentVectors = null;
    private TokenDictionary tokenDict = null;
    private TreeMap<Integer, Double> tfDictionary = null;
    private TreeMap<Integer, Double> tfIdf = null;
    private DfDictionary docFreqs = null;
    int numDocsInCorpus = -1;
    IDataSource dataSource = null;

    public DfDictionary getDocFreqs() {
        return this.docFreqs;
    }

    public void setDocFreqs(DfDictionary dfDictionary) {
        this.docFreqs = dfDictionary;
    }

    public Document(TokenDictionary tokenDictionary, int n, IDataSource iDataSource) {
        this.tokenDict = tokenDictionary;
        this.tfDictionary = new TreeMap();
        this.sentVectors = new ArrayList();
        this.tfIdf = new TreeMap();
        for (Integer n2 : this.tokenDict.GetAllTokenIds()) {
            this.tfDictionary.put(n2, new Double(0.0));
            this.tfIdf.put(n2, new Double(0.0));
        }
        this.numDocsInCorpus = n;
        this.dataSource = iDataSource;
    }

    public void Init() {
        try {
            int n = this.dataSource.GetNumChunks();
            for (int i = 0; i < n; ++i) {
                String string = this.dataSource.GetChunk(i);
                SentTokenVector sentTokenVector = new SentTokenVector(string, this.tokenDict, i, true);
                this.AddSent(sentTokenVector);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void AddSent(SentTokenVector sentTokenVector) {
        int[] nArray;
        this.sentVectors.add(sentTokenVector);
        SparseFloatVector sparseFloatVector = sentTokenVector.getFreqVector();
        for (int n : nArray = sparseFloatVector.nonZeroDimensions()) {
            int n2 = (int)sparseFloatVector.value(n);
            Double d = this.tfDictionary.get(new Integer(n));
            this.tfDictionary.put(n, new Double(d.intValue() + n2));
        }
    }

    public void ComputeTfIdf() {
        for (Integer n : this.tokenDict.GetAllTokenIds()) {
            String string = this.tokenDict.GetTokenString(n);
            try {
                Integer n2 = this.docFreqs.GetTokenId(string);
                if (n2 == null) {
                    System.out.println("Warning in Document.ComputeTfIdf. Token not found in this.docFreqs:\t" + string);
                    continue;
                }
                Double d = this.tfDictionary.get(n);
                Double d2 = this.docFreqs.getDfDictionary().get(n2);
                Double d3 = 0.0;
                if (d2 == 0.0) {
                    System.out.println("Warning in ComputeTfIdf: df is 0 for " + string);
                } else if (d != 0.0) {
                    double d4 = Math.log((double)this.numDocsInCorpus / d2);
                    double d5 = 1.0 + Math.log(d);
                    d3 = new Double(d5 * d4);
                }
                this.tfIdf.put(n, d3);
            }
            catch (Exception exception) {
                this.tfIdf.put(n, 0.0);
                System.out.println("Warning: in ComputeTfIdf. Recorded 0 for " + string);
                System.out.println(exception.getMessage());
            }
        }
    }

    public void PrintFreqs() {
        System.out.println("id\ttoken\ttf\tdf\tidf:");
        Set<Integer> set = this.tokenDict.GetAllTokenIds();
        for (Integer n : set) {
            String string = this.tokenDict.GetTokenString(n);
            Integer n2 = this.docFreqs.GetTokenId(string);
            if (n2 == null) {
                System.out.println("Warning in Document.PrintFreqs. Token not found in this.docFreqs:\t" + string);
                continue;
            }
            String string2 = String.valueOf(this.tfDictionary.get(n));
            String string3 = String.valueOf(this.docFreqs.getDfDictionary().get(n2));
            String string4 = String.valueOf(this.tfIdf.get(n));
            System.out.println(n.toString() + "\t" + string + "\t" + string2 + "\t" + string3 + "\t" + string4);
            if (n <= 40) continue;
            break;
        }
    }

    public void PrintTfIdf() {
        System.out.println("TfIdf:");
        Set<Integer> set = this.tokenDict.GetAllTokenIds();
        for (Integer n : set) {
            String string = this.tokenDict.GetTokenString(n);
            System.out.println(n.toString() + "\t" + string + ":\t" + String.valueOf(this.tfIdf.get(n)));
            if (n <= 40) continue;
            break;
        }
    }

    public void PrintTf() {
        System.out.println("Tf:");
        Set<Integer> set = this.tokenDict.GetAllTokenIds();
        for (Integer n : set) {
            String string = this.tokenDict.GetTokenString(n);
            System.out.println(n.toString() + "\t" + string + ":\t" + String.valueOf(this.tfDictionary.get(n)));
            if (n <= 40) continue;
            break;
        }
    }

    public void SmoothSentCounts(int n, double d) {
        ArrayList<SentTokenVector> arrayList = new ArrayList<SentTokenVector>(this.sentVectors);
        int n2 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            SparseFloatVector sparseFloatVector = this.sentVectors.get(i).getFreqVector();
            TreeMap<Integer, Double> treeMap = new TreeMap<Integer, Double>();
            int[] nArray = sparseFloatVector.nonZeroDimensions();
            for (int n3 : nArray) {
                treeMap.put(new Integer(n3), new Double(sparseFloatVector.value(n3)));
            }
            for (n2 = i + 1; n2 <= i + n && n2 < arrayList.size(); ++n2) {
                object = arrayList.get(n2).getFreqVector();
                double d2 = Math.pow(Math.E, -d * (double)(n2 - i));
                int[] nArray2 = ((SparseFloatVector)object).nonZeroDimensions();
                for (int j = 0; j < nArray2.length; ++j) {
                    Integer n4 = new Integer(nArray2[j]);
                    Double d3 = 0.0;
                    if (treeMap.containsKey(n4)) {
                        d3 = (Double)treeMap.get(n4);
                    }
                    Double d4 = ((SparseFloatVector)object).value(n4) * d2;
                    treeMap.put(n4, d3 + d4);
                }
            }
            object = new SparseFloatVector(treeMap, sparseFloatVector.numDimensions());
            this.sentVectors.get(i).setFreqVector((SparseFloatVector)object);
        }
    }

    public void ApplyTfIdfWeighting() {
        for (SentTokenVector sentTokenVector : this.sentVectors) {
            TreeMap<Integer, Double> treeMap = new TreeMap<Integer, Double>();
            int[] nArray = sentTokenVector.getFreqVector().nonZeroDimensions();
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                Double d = this.tfIdf.get(new Integer(n));
                Double d2 = new Double(sentTokenVector.getFreqVector().value(n));
                Double d3 = d * d2;
                treeMap.put(new Integer(n), d3);
            }
            SparseFloatVector sparseFloatVector = new SparseFloatVector(treeMap, sentTokenVector.getFreqVector().numDimensions());
            sentTokenVector.setFreqVector(sparseFloatVector);
        }
    }

    public void PrintSentVectors(int n, int n2) {
        System.out.println("sentence vectors:");
        if (n >= this.sentVectors.size()) {
            return;
        }
        for (int i = n; i <= n2 && i < this.sentVectors.size(); ++i) {
            SentTokenVector sentTokenVector = this.sentVectors.get(i);
            sentTokenVector.PrintVector();
        }
    }

    public ArrayList<SentTokenVector> getSentVectors() {
        return this.sentVectors;
    }
}

