/*
 * Decompiled with CFR 0.152.
 */
package segmenter;

import segmenter.IDataSource;

public class LinearEvaluator {
    int[] refIndices;
    int[] hypoIndices;
    IDataSource dataSource;

    public void Init(IDataSource iDataSource, Integer[] integerArray) {
        int n;
        Integer[] integerArray2 = iDataSource.GetReferenceSegmentBreaks();
        this.refIndices = new int[integerArray2.length];
        this.hypoIndices = new int[integerArray.length];
        this.dataSource = iDataSource;
        for (n = 0; n < integerArray2.length; ++n) {
            this.refIndices[n] = integerArray2[n];
        }
        for (n = 0; n < integerArray.length; ++n) {
            this.hypoIndices[n] = integerArray[n];
        }
    }

    public void PrintBreaks() {
        System.out.println("REference breaks:");
        for (int n : this.refIndices) {
            System.out.print(String.valueOf(n) + ", ");
        }
        System.out.println("\nHypothetical breaks:");
        for (int n : this.hypoIndices) {
            System.out.print(String.valueOf(n) + ", ");
        }
    }

    public String evaluate() {
        if (this.refIndices == null || this.refIndices.length <= 0) {
            System.out.println("Error: reference indices are invalid.");
            return "unable to evaluate";
        }
        if (this.hypoIndices == null || this.hypoIndices.length <= 0) {
            System.out.println("Error: no hypothetical indices are provided.");
            return "unable to evaluate";
        }
        float f = this.ComputeWinDiff(WINDIFF_MODE.REGULAR);
        float f2 = this.ComputeWinDiff(WINDIFF_MODE.FP);
        float f3 = this.ComputeWinDiff(WINDIFF_MODE.FN);
        String string = "Regular WinDiff: " + String.valueOf(f);
        string = string + "\nFalse positives only WinDIff: " + String.valueOf(f2);
        string = string + "\nFalse negatives only WinDIff: " + String.valueOf(f3);
        return string;
    }

    public float ComputeWinDiff(WINDIFF_MODE wINDIFF_MODE) {
        int n;
        int n2;
        double d = 0.0;
        if (this.refIndices == null || this.refIndices.length <= 0) {
            System.out.println("No reference indices");
            return 0.0f;
        }
        if (this.hypoIndices == null || this.hypoIndices.length <= 0) {
            System.out.println("No hypo indices");
            return 0.0f;
        }
        d = Math.floor(this.dataSource.GetNumChunks() / this.refIndices.length);
        double d2 = Math.floor(d / 2.0);
        int n3 = new Double(d2).intValue();
        int n4 = 0;
        for (n2 = 0; n2 < this.dataSource.GetNumChunks() - n3 + 1; ++n2) {
            int n5;
            int n6;
            n = n2 + n3 - 1;
            int n7 = 0;
            int n8 = 0;
            for (n6 = 0; n6 < this.refIndices.length - 1; ++n6) {
                n5 = this.refIndices[n6];
                if (n5 >= n2 && n5 < n) {
                    ++n7;
                    continue;
                }
                if (n5 > n) break;
            }
            for (n6 = 0; n6 < this.hypoIndices.length - 1; ++n6) {
                n5 = this.hypoIndices[n6];
                if (n5 >= n2 && n5 < n) {
                    ++n8;
                    continue;
                }
                if (n5 > n) break;
            }
            if ((n6 = (int)(this.CompareNumberOfBreaks(n7, n8, wINDIFF_MODE) ? 1 : 0)) == 0) continue;
            ++n4;
        }
        n2 = this.dataSource.GetNumChunks();
        n = n2 - n3;
        float f = (float)n4 / (float)n;
        return f;
    }

    private boolean CompareNumberOfBreaks(int n, int n2, WINDIFF_MODE wINDIFF_MODE) {
        if (wINDIFF_MODE == WINDIFF_MODE.REGULAR) {
            return n != n2;
        }
        if (wINDIFF_MODE == WINDIFF_MODE.FP) {
            return n < n2;
        }
        if (wINDIFF_MODE == WINDIFF_MODE.FN) {
            return n > n2;
        }
        System.out.println("ERROR: INVALID WINDIFF_MODE");
        return false;
    }

    public static enum WINDIFF_MODE {
        REGULAR,
        FN,
        FP;

    }
}

