/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.symbol;

import com.aliasi.symbol.CompiledSymbolTable;
import com.aliasi.symbol.MapSymbolTable;
import com.aliasi.symbol.SymbolTable;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Compilable;
import com.aliasi.util.Strings;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SymbolTableCompiler
implements Compilable,
SymbolTable {
    private final Set<String> mSymbolSet = new HashSet<String>();
    private CompiledSymbolTable mSymbolTable;

    public static SymbolTable asSymbolTable(String[] symbols) {
        HashSet<String> symbolSet = new HashSet<String>();
        for (String symbol : symbols) {
            if (symbolSet.add(symbol)) continue;
            String msg = "Duplicate symbol=" + symbol + " Symbols=" + Arrays.asList(symbols);
            throw new IllegalArgumentException(msg);
        }
        MapSymbolTable table = new MapSymbolTable(0);
        for (String symbol : symbols) {
            table.getOrAddSymbolInteger(symbol);
        }
        return MapSymbolTable.unmodifiableView(table);
    }

    @Deprecated
    public void compileTo(DataOutputStream out) throws IOException {
        this.compile().write(out);
    }

    public void compileTo(ObjectOutput objOut) throws IOException {
        objOut.writeObject(new Externalizer(this));
    }

    @Deprecated
    public static SymbolTable read(DataInputStream in) throws IOException {
        String[] symbols = new String[in.readInt()];
        for (int i = 0; i < symbols.length; ++i) {
            StringBuilder sb = new StringBuilder();
            int length = in.readShort();
            for (int j = 0; j < length; ++j) {
                sb.append(in.readChar());
            }
            symbols[i] = sb.toString();
        }
        return new CompiledSymbolTable(symbols);
    }

    public int symbolToID(String symbol) {
        if (this.mSymbolTable == null) {
            return -1;
        }
        return this.mSymbolTable.symbolToID(symbol);
    }

    public String[] symbols() {
        return this.mSymbolSet.toArray(Strings.EMPTY_STRING_ARRAY);
    }

    public String idToSymbol(int id) {
        if (this.mSymbolTable == null) {
            throw new IndexOutOfBoundsException("Symbol table not compiled");
        }
        return this.mSymbolTable.idToSymbol(id);
    }

    public int numSymbols() {
        if (this.mSymbolTable == null) {
            return -1;
        }
        return this.mSymbolTable.numSymbols();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public int getOrAddSymbol(String symbol) {
        throw new UnsupportedOperationException();
    }

    public boolean addSymbol(String symbol) {
        if (symbol.length() > Short.MAX_VALUE) {
            String msg = "Symbol=" + symbol + " too long; max length=" + Short.MAX_VALUE;
            throw new IllegalArgumentException(msg);
        }
        return this.mSymbolSet.add(symbol);
    }

    public int removeSymbol(String symbol) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.compile().toString();
    }

    private CompiledSymbolTable compile() {
        if (this.mSymbolTable != null) {
            return this.mSymbolTable;
        }
        String[] symbols = new String[this.mSymbolSet.size()];
        Iterator<String> symbolIterator = this.mSymbolSet.iterator();
        int id = 0;
        while (symbolIterator.hasNext()) {
            symbols[id] = symbolIterator.next();
            ++id;
        }
        this.mSymbolTable = new CompiledSymbolTable(symbols);
        return this.mSymbolTable;
    }

    private static class Externalizer
    extends AbstractExternalizable {
        private static final long serialVersionUID = 1065202374901852230L;
        final SymbolTableCompiler mCompiler;

        public Externalizer() {
            this(null);
        }

        public Externalizer(SymbolTableCompiler compiler) {
            this.mCompiler = compiler;
        }

        public void writeExternal(ObjectOutput objOut) throws IOException {
            this.mCompiler.compile().writeObj(objOut);
        }

        public Object read(ObjectInput objIn) throws IOException {
            String[] symbols = new String[objIn.readInt()];
            for (int i = 0; i < symbols.length; ++i) {
                StringBuilder sb = new StringBuilder();
                int length = objIn.readShort();
                for (int j = 0; j < length; ++j) {
                    sb.append(objIn.readChar());
                }
                symbols[i] = sb.toString();
            }
            return new CompiledSymbolTable(symbols);
        }
    }
}

