/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.classify;

import com.aliasi.classify.Classification;
import com.aliasi.corpus.ClassificationHandler;
import com.aliasi.corpus.Corpus;
import com.aliasi.corpus.Parser;
import com.aliasi.stats.Statistics;
import com.aliasi.util.Strings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class XValidatingClassificationCorpus<E>
extends Corpus<ClassificationHandler<E, Classification>>
implements ClassificationHandler<E, Classification> {
    private final List<E> mInputList = new ArrayList();
    private final List<Classification> mClassificationList = new ArrayList<Classification>();
    private int mNumFolds;
    private int mFold = 0;

    public XValidatingClassificationCorpus(XValidatingClassificationCorpus<E> corpus) {
        this.mInputList.addAll(corpus.mInputList);
        this.mClassificationList.addAll(corpus.mClassificationList);
        this.mNumFolds = corpus.mNumFolds;
        this.mFold = corpus.mFold;
    }

    public XValidatingClassificationCorpus(List<E> inputList, List<Classification> classificationList, int numFolds) {
        this(numFolds);
        if (inputList.size() != classificationList.size()) {
            String msg = "Input and classification list must be same length. inputList.size()=" + inputList.size() + " classificationList.size()=" + classificationList.size();
            throw new IllegalArgumentException(msg);
        }
        this.mInputList.addAll(inputList);
        this.mClassificationList.addAll(classificationList);
    }

    @Deprecated
    public XValidatingClassificationCorpus(Parser<ClassificationHandler<E, Classification>> parser, File[] dataFiles, int numFolds) throws IOException {
        this(numFolds);
        parser.setHandler(this);
        for (File dataFile : dataFiles) {
            parser.parse(dataFile);
        }
        this.mNumFolds = numFolds;
    }

    public XValidatingClassificationCorpus(int numFolds) {
        XValidatingClassificationCorpus.verifyNumFolds(numFolds);
        this.mNumFolds = numFolds;
    }

    public String[] categories() {
        TreeSet<String> catSet = new TreeSet<String>();
        for (Classification c : this.mClassificationList) {
            catSet.add(c.bestCategory());
        }
        return catSet.toArray(Strings.EMPTY_STRING_ARRAY);
    }

    @Override
    public void handle(E e, Classification c) {
        this.mInputList.add(e);
        this.mClassificationList.add(c);
    }

    public void permuteCorpus(Random random) {
        int i;
        int numInstances = this.mInputList.size();
        int[] permutation = Statistics.permutation(numInstances, random);
        ArrayList<E> permInputList = new ArrayList<E>(numInstances);
        ArrayList<Classification> permClassificationList = new ArrayList<Classification>(numInstances);
        for (i = 0; i < numInstances; ++i) {
            permInputList.add(this.mInputList.get(permutation[i]));
            permClassificationList.add(this.mClassificationList.get(permutation[i]));
        }
        for (i = 0; i < numInstances; ++i) {
            this.mInputList.set(i, permInputList.get(i));
            this.mClassificationList.set(i, (Classification)permClassificationList.get(i));
        }
    }

    public int numInstances() {
        return this.mInputList.size();
    }

    public int numFolds() {
        return this.mNumFolds;
    }

    public int fold() {
        return this.mFold;
    }

    public void setFold(int fold) {
        if (fold >= this.mNumFolds || fold < 0) {
            String msg = "Fold must be between 0 and numFolds=" + this.mNumFolds + " Found fold=" + fold;
            throw new IllegalArgumentException(msg);
        }
        this.mFold = fold;
    }

    @Override
    @Deprecated
    public void visitTest(ClassificationHandler<E, Classification> handler) {
        this.handle(handler, this.startTestFold(), this.endTestFold());
    }

    @Override
    @Deprecated
    public void visitTrain(ClassificationHandler<E, Classification> handler) {
        this.handle(handler, 0, this.startTestFold());
        this.handle(handler, this.endTestFold(), this.numInstances());
    }

    public String toString() {
        return "XValidatingClassificationCorpus. numInstances=" + this.numInstances() + " numFolds=" + this.numFolds() + " fold=" + this.fold();
    }

    @Deprecated
    private void handle(ClassificationHandler<E, Classification> handler, int start, int end) {
        for (int i = start; i < end; ++i) {
            handler.handle(this.mInputList.get(i), this.mClassificationList.get(i));
        }
    }

    private int startTestFold() {
        return (int)((double)this.numInstances() * ((double)this.mFold / (double)this.mNumFolds));
    }

    private int endTestFold() {
        if (this.mFold == this.mNumFolds - 1) {
            return this.numInstances();
        }
        return (int)((double)this.numInstances() * (((double)this.mFold + 1.0) / (double)this.mNumFolds));
    }

    private static void verifyNumFolds(int numFolds) {
        if (numFolds < 1) {
            String msg = "Require at least one fold. Found numFolds=" + numFolds;
            throw new IllegalArgumentException(msg);
        }
    }
}

