/*
 * Decompiled with CFR 0.152.
 */
package tsg.kernels;

import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Scanner;
import java.util.TreeSet;
import java.util.Vector;
import util.FileUtil;
import util.PrintProgress;

public class SortAndMergeFragmentFiles {
    PrintProgress progress;

    public SortAndMergeFragmentFiles(File fileDir, File outputFile, String unsortedFilePrefix, String sortedFilePrefix, String tmpFilePrefix) {
        String outputPath = String.valueOf(fileDir.getAbsolutePath()) + "/";
        Object[] fileList = fileDir.listFiles();
        Arrays.sort(fileList);
        Vector<Object> ouputSortedFile = new Vector<Object>();
        File mergingDoneFile = new File(String.valueOf(outputPath) + ".mergingDone");
        if (mergingDoneFile.exists()) {
            System.out.println("Merged file already exists!");
            return;
        }
        this.progress = new PrintProgress("Sorting File ");
        Object[] objectArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            Object inputFile = objectArray[n2];
            this.progress.next();
            String fileName = ((File)inputFile).getName();
            if (fileName.startsWith(sortedFilePrefix)) {
                ouputSortedFile.add(inputFile);
            } else if (fileName.startsWith(unsortedFilePrefix)) {
                File sortedFile = new File(String.valueOf(outputPath) + sortedFilePrefix + fileName);
                File sortedFileTmp = new File(String.valueOf(outputPath) + tmpFilePrefix + sortedFilePrefix + fileName);
                SortAndMergeFragmentFiles.sortFile((File)inputFile, sortedFileTmp, sortedFile);
                ouputSortedFile.add(sortedFile);
            }
            ++n2;
        }
        this.progress.end();
        File[] ouputSortedFileArray = ouputSortedFile.toArray(new File[0]);
        System.out.println("Merging Files.");
        SortAndMergeFragmentFiles.mergeSortedFiles(ouputSortedFileArray, outputFile);
        FileUtil.appendReturn("merging done!", mergingDoneFile);
    }

    private static void sortFile(File inputFile, File outputFileTmp, File outputFile) {
        FileUtil.countNonEmptyLines(inputFile);
        int linesNumber = FileUtil.countNonEmptyLines(inputFile);
        Scanner scan = FileUtil.getScanner(inputFile);
        Object[] lines = new String[linesNumber];
        int i = 0;
        while (scan.hasNextLine()) {
            lines[i] = scan.nextLine();
            ++i;
        }
        Arrays.sort(lines);
        PrintWriter pw = FileUtil.getPrintWriter(outputFileTmp);
        Object[] objectArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            pw.println((String)l);
            ++n2;
        }
        pw.close();
        outputFileTmp.renameTo(outputFile);
    }

    private static void mergeSortedFiles(File[] sortedFiles, File outputFile) {
        int filesNumber = sortedFiles.length;
        Scanner[] filesScanners = new Scanner[filesNumber];
        PrintWriter ouputWriter = FileUtil.getPrintWriter(outputFile);
        int i = 0;
        while (i < filesNumber) {
            filesScanners[i] = FileUtil.getScanner(sortedFiles[i]);
            ++i;
        }
        TreeSet<FragmentFreqFileIndex> queue = new TreeSet<FragmentFreqFileIndex>();
        int i2 = 0;
        while (i2 < filesNumber) {
            FragmentFreqFileIndex fileLine = new FragmentFreqFileIndex(filesScanners[i2].nextLine(), i2);
            queue.add(fileLine);
            ++i2;
        }
        FragmentFreqFileIndex pendingFragment = (FragmentFreqFileIndex)queue.pollFirst();
        int fileIndex = pendingFragment.fileIndex;
        FragmentFreqFileIndex fileLine = new FragmentFreqFileIndex(filesScanners[fileIndex].nextLine(), fileIndex);
        queue.add(fileLine);
        do {
            FragmentFreqFileIndex topOfTheQueue = (FragmentFreqFileIndex)queue.pollFirst();
            fileIndex = topOfTheQueue.fileIndex;
            if (filesScanners[fileIndex].hasNextLine()) {
                fileLine = new FragmentFreqFileIndex(filesScanners[fileIndex].nextLine(), fileIndex);
                queue.add(fileLine);
            }
            if (topOfTheQueue.sameFragment(pendingFragment)) {
                pendingFragment.freq += topOfTheQueue.freq;
                continue;
            }
            ouputWriter.println(String.valueOf(pendingFragment.fragment) + "\t" + pendingFragment.freq);
            pendingFragment = topOfTheQueue;
        } while (!queue.isEmpty());
        ouputWriter.println(String.valueOf(pendingFragment.fragment) + "\t" + pendingFragment.freq);
        ouputWriter.close();
    }

    public static void main(String[] args) {
        File file1 = new File(args[0]);
        File file2 = new File(args[1]);
        File outputFile = new File(args[2]);
        SortAndMergeFragmentFiles.mergeSortedFiles(new File[]{file1, file2}, outputFile);
    }

    private static class FragmentFreqFileIndex
    implements Comparable<FragmentFreqFileIndex> {
        String fragment;
        int freq;
        int fileIndex;

        public FragmentFreqFileIndex(String line, int fileIndex) {
            String[] treeFreq = line.split("\t");
            this.fragment = treeFreq[0];
            this.freq = Integer.parseInt(treeFreq[1]);
            this.fileIndex = fileIndex;
        }

        @Override
        public int compareTo(FragmentFreqFileIndex o) {
            int cmp = this.fragment.compareTo(o.fragment);
            if (cmp != 0) {
                return cmp;
            }
            cmp = new Integer(this.freq).compareTo(new Integer(o.freq));
            if (cmp != 0) {
                return cmp;
            }
            return new Integer(this.fileIndex).compareTo(new Integer(o.fileIndex));
        }

        public boolean equals(Object o) {
            if (o instanceof FragmentFreqFileIndex) {
                FragmentFreqFileIndex otherLineFileIndex = (FragmentFreqFileIndex)o;
                return this.fragment.equals(otherLineFileIndex.fragment) && this.freq == otherLineFileIndex.freq && this.fileIndex == otherLineFileIndex.fileIndex;
            }
            return false;
        }

        public boolean sameFragment(FragmentFreqFileIndex o) {
            return this.fragment.equals(o.fragment);
        }
    }
}

