import numpy as np


def hex_to_rgb(value):
    """
    Calculates rgb values from a hex color code.

    :param (string) value: Hex color string

    :rtype (tuple) (r_value, g_value, b_value): tuple of rgb values
    """
    value = value.lstrip("#")
    hex_total_length = len(value)
    rgb_section_length = hex_total_length // 3
    return tuple(
        int(value[i : i + rgb_section_length], 16)
        for i in range(0, hex_total_length, rgb_section_length)
    )


viridis = [
    [0, "#440154"],
    [0.06274509803921569, "#48186a"],
    [0.12549019607843137, "#472d7b"],
    [0.18823529411764706, "#424086"],
    [0.25098039215686274, "#3b528b"],
    [0.3137254901960784, "#33638d"],
    [0.3764705882352941, "#2c728e"],
    [0.4392156862745098, "#26828e"],
    [0.5019607843137255, "#21918c"],
    [0.5647058823529412, "#1fa088"],
    [0.6274509803921569, "#28ae80"],
    [0.6901960784313725, "#3fbc73"],
    [0.7529411764705882, "#5ec962"],
    [0.8156862745098039, "#84d44b"],
    [0.8784313725490196, "#addc30"],
    [0.9411764705882353, "#d8e219"],
    [1, "#fde725"],
]
# Define the power parameter for the transformation
power = 0.23  # You can adjust this value as needed

# Apply the power transformation to the values in the colorscale
for i in range(len(viridis)):
    viridis[i][0] = np.power(viridis[i][0], power)

# Normalize the transformed values to [0, 1]
max_value = max(v[0] for v in viridis)
for i in range(len(viridis)):
    viridis[i][0] /= max_value

# Sort the colorscale by the normalized values
viridis.sort(key=lambda x: x[0])
viridis_rgb = [[x[0], "rgb" + str(hex_to_rgb(x[1]))] for x in viridis]

# reverse the colorscale
viridis_rgb = [[x[0], y[1]] for x, y in zip(viridis_rgb, viridis_rgb[::-1])]
