# Notebooks for train runtime calculation

The notebooks in this directory contain short scripts for training and comparing **ELECTRA model with an adapter** and **full ELECTRA model**. Each notebook contains code for one of the three datasets:
1) [AG News](https://huggingface.co/datasets/ag_news)
2) [Banking77](https://huggingface.co/datasets/banking77)
3) [Amazon Massive, English set](https://huggingface.co/datasets/AmazonScience/massive/viewer/en-US)

This runtime calculation is performed on one **NVIDIA GeForce RTX 3090 24GB**.

The set of hyperparameters for two kinds of models is kept unchaged, except for the learning rate:
- full model: __2e-5__
- adapter model: __1e-4__

The code is based on the [official adapter trainer quickstart notebook](https://colab.research.google.com/github/Adapter-Hub/adapters/blob/main/notebooks/01_Adapter_Training.ipynb) by [AdapterHub](https://docs.adapterhub.ml/quickstart.html).