import json
import random
import streamlit as st
import pickle
import os
import jsonlines




class variable():
    def __init__(self):
        if os.path.exists("record.jsonl"):
            with open("record.jsonl",'r') as reader:
                self.record = [json.loads(line) for line in reader]
                self.count = len(self.record)
        else:

            self.count = 0
            self.record = []

    def add(self):
        self.count += 1
        self.record.append(0)
        with open("record.jsonl",'w') as f:
            for item in self.record:
                f.write(json.dumps(item))
                f.write('\n')

    def annotate(self, img_idx):
        if os.path.exists("annotate.jsonl"):
            with open("annotate.jsonl", 'r') as reader:
                annotate = [json.loads(line) for line in reader]
                annotate = [item['Image ID'] for item in annotate]
        else:
            annotate = []
        if img_idx not in annotate:
            annotate.append(img_idx)
        with open("annotate.jsonl",'w') as f:
            for item in annotate:
                line = img_map[item]
                line['Image ID'] = item
                f.write(json.dumps(line) + "\n")
        print("Length of Annotation: ", len(annotate), 'Total: ', self.count+1)
        print("Success rate: ", len(annotate)/(self.count+1))



    def get(self):
        return self.count


with open("/home/user/llavafinetune/filtered_output_new_new.jsonl", "r") as f:
    data = [json.loads(line) for line in f]



# create a map from image name to other information
img_map = {}
for i, item in enumerate(data):
    img_file = item['Image ID']
    type = item['Question Type']
    question = item['Question']
    img_map[img_file] = {
        'Question Type': type,
        'Question': question,
    }


img_names = list(img_map.keys())



var = variable()

a = st.button("Next")
b = st.button('Record')


if a:
    var.add()
    img_idx = var.get()
elif b:
    img_idx = var.get()
    var.annotate(list(img_map.keys())[img_idx])
else:
    img_idx = var.count



# Creat a way to select the image from the list
img_name = st.selectbox(
    "Select an image",
    list(img_map.keys()), index=img_idx
)


# Display the image

image_path = '/home/user/llavafinetune/images/' + img_names[img_idx] + '.jpg'
st.image(image_path)


st.markdown(f"**Question Type**: {img_map[img_names[img_idx]]['Question Type']}")
st.markdown(f"**Question**: {img_map[img_names[img_idx]]['Question']}")

