import os
from PIL import Image
from io import BytesIO
import base64
import json

image_directory = {image_dir}
json_file_path = {json_file_path}
tsv_file_path = {tsv_file_path}

with open(json_file_path, 'r') as json_file:
    data = json.load(json_file)

with open(tsv_file_path, 'w') as tsv_file:

    for index, entry in enumerate(data):
        id = index
        image_id = os.path.splitext(entry["image"].split("/")[-1])[0]
        captions = "&&".join(entry["caption"])

        image_file_path = os.path.join(image_directory, f"{image_id}.jpg")

        try:
            img = Image.open(image_file_path)
            img_buffer = BytesIO()
            img.save(img_buffer, format=img.format)
            byte_data = img_buffer.getvalue()
            base64_str = base64.b64encode(byte_data).decode("utf-8")
        except Exception as e:
            print(f"Error processing image {image_id}: {e}")
            base64_str = ""

        tsv_file.write(f"{id}\t{image_id}\t{captions}\t\t{base64_str}\n")
print(f"TSV file created at: {tsv_file_path}")
