import pandas as pd


gpt_3_5_answers = pd.read_csv("./z_dataset_eval/answer_1_predictions_openai_3_5.csv")
gpt_4_answers = pd.read_csv("./z_dataset_eval/answer_1_predictions_openai.csv")
gemini_answers = pd.read_csv("./predictions/answer_1_predictions.csv")

gpt_3_5_answers.rename(columns={"Relevance": "GPT_3_5_Relevance", "Coherence": "GPT_3_5_Coherence", "Plausibility": "GPT_3_5_Plausibility", "Fluency": "GPT_3_5_Fluency"}, inplace=True)
gpt_4_answers.rename(columns={"Relevance": "GPT_4_Relevance", "Coherence": "GPT_4_Coherence", "Plausibility": "GPT_4_Plausibility", "Fluency": "GPT_4_Fluency"}, inplace=True)
gemini_answers.rename(columns={"Relevance": "Gemini_Relevance", "Coherence": "Gemini_Coherence", "Plausibility": "Gemini_Plausibility", "Fluency": "Gemini_Fluency"}, inplace=True)

openai_merged = pd.merge(gpt_3_5_answers, gpt_4_answers, on="answer_1")
openai_merged_gemini = pd.merge(openai_merged, gemini_answers, on="answer_1")

relevance = openai_merged_gemini[["GPT_3_5_Relevance", "GPT_4_Relevance", "Gemini_Relevance"]]
coherence = openai_merged_gemini[["GPT_3_5_Coherence", "GPT_4_Coherence", "Gemini_Coherence"]]
plausibility = openai_merged_gemini[["GPT_3_5_Plausibility", "GPT_4_Plausibility", "Gemini_Plausibility"]]
fluency = openai_merged_gemini[["GPT_3_5_Fluency", "GPT_4_Fluency", "Gemini_Fluency"]]

relevance.to_csv("./plot_data/relevance.csv", sep=";", decimal=",")
coherence.to_csv("./plot_data/coherence.csv", sep=";", decimal=",")
plausibility.to_csv("./plot_data/plausibility.csv", sep=";", decimal=",")
fluency.to_csv("./plot_data/fluency.csv", sep=";", decimal=",")


x = 1