import logging
import os
import random
import torch
from args import finetune_args
from utils import *
from bart import BART

logging.disable(logging.WARNING)


def set_seed_everywhere(seed, cuda):
    """ Set seed for reproduce """
    random.seed(seed)
    torch.manual_seed(seed)
    if cuda:
        torch.cuda.manual_seed_all(seed)


set_seed_everywhere(666, True)


def load_data(filepath):
    """ Json data, {'text': ..., 'summary': ...}"""
    data = read_jsonlines_to_list(filepath)
    src_texts, tgt_texts = [], []
    for obj in data:
        src_texts.append(obj.get('text').strip())
        tgt_texts.append(obj.get('summary').strip())
    return src_texts, tgt_texts


def main(args):
    save_dir = args.save_dir
    os.makedirs(save_dir, exist_ok=True)

    bart = BART(args)
    src_texts, tgt_texts = load_data('data/parabank2.json')
    bart.load_data(src_texts, tgt_texts)

    n_epochs = args.n_epochs
    train_steps = n_epochs * (len(bart.data) // args.batch_size + 1)

    bart.get_optimizer(
        lr=args.lr,
        train_steps=train_steps,
        warmup_steps=args.warmup_steps,
        weight_decay=args.weight_decay,
        adam_epsilon=args.adam_epsilon
    )

    for epoch in range(n_epochs):
        print(f'On epoch {epoch}')
        bart.train_epoch(batch_size=args.batch_size)


if __name__ == '__main__':
    args = finetune_args()
    main(args)
